/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2017-03-06 02:51:59 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=807 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2285 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2017-02-25 14:43:35", "2017-02-25 14:43:35", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "post-trashed", "", "", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20170306_lumbinikapilvastu", "58bccec53403f7614170306025149", "20", "2017-03-06 02:51:59", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-06 02:51:49\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.21\";s:10:\"VersionPHP\";s:5:\"5.6.3\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:26:\"20170306_lumbinikapilvastu\";s:4:\"Hash\";s:29:\"58bccec53403f7614170306025149\";s:8:\"NameHash\";s:56:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/Applications/XAMPP/xamppfiles/htdocs/lumbini/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://localhost/lumbini/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:68:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/Applications/XAMPP/xamppfiles/htdocs/lumbini\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-06 02:51:49\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.21\";s:10:\"VersionPHP\";s:5:\"5.6.3\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20170306_lumbinikapilvastu\";s:4:\"Hash\";s:29:\"58bccec53403f7614170306025149\";s:8:\"NameHash\";s:56:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/Applications/XAMPP/xamppfiles/htdocs/lumbini/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://localhost/lumbini/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:70:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://localhost/lumbini", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://localhost/lumbini", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Lumbini - Kapilvastu", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Global Campaign, Belgium  v.w.z", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "rehsma@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "5", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "9", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%category%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:127:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:38:\"index.php?event=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:32:\"index.php?event=$matches[1]&tb=1\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&cpage=$matches[2]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?event=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=10&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:31:\".+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\".+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\".+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"(.+?)/([^/]+)/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:26:\"(.+?)/([^/]+)/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:46:\"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:41:\"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:34:\"(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:41:\"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:30:\"(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:20:\".+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\".+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\".+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:14:\"(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:26:\"(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:33:\"(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:8:\"(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:6:{i:0;s:34:\"advanced-custom-fields-pro/acf.php\";i:1;s:79:\"automatic-featured-images-from-videos/automatic-featured-images-from-videos.php\";i:2;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:37:\"paypal-donations/paypal-donations.php\";i:5;s:27:\"wp-pagenavi/wp-pagenavi.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "lumbini-theme", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "lumbini-theme", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:27:\"wp-pagenavi/wp-pagenavi.php\";s:14:\"__return_false\";s:37:\"paypal-donations/paypal-donations.php\";a:2:{i:0;s:15:\"PayPalDonations\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "10", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wp_options` VALUES("92", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:84:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:57:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:14:\"publish_events\";b:1;s:20:\"delete_others_events\";b:1;s:18:\"edit_others_events\";b:1;s:22:\"manage_others_bookings\";b:1;s:24:\"publish_recurring_events\";b:1;s:30:\"delete_others_recurring_events\";b:1;s:28:\"edit_others_recurring_events\";b:1;s:17:\"publish_locations\";b:1;s:23:\"delete_others_locations\";b:1;s:16:\"delete_locations\";b:1;s:21:\"edit_others_locations\";b:1;s:23:\"delete_event_categories\";b:1;s:21:\"edit_event_categories\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:15:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:12:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:15:\"manage_bookings\";b:1;s:19:\"upload_event_images\";b:1;s:13:\"delete_events\";b:1;s:11:\"edit_events\";b:1;s:19:\"read_private_events\";b:1;s:23:\"delete_recurring_events\";b:1;s:21:\"edit_recurring_events\";b:1;s:14:\"edit_locations\";b:1;s:22:\"read_private_locations\";b:1;s:21:\"read_others_locations\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("94", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("95", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("96", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:7:\"Archive\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "sidebars_widgets", "a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:10:\"archives-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:5:{i:1488771812;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"9a6b1af1cd637f825e0e4a2b33f54de3\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:206;}}}}i:1488811416;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1488811441;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1488811668;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("105", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1488033845;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("109", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.7.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.7.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.7.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.7.2\";s:7:\"version\";s:5:\"4.7.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1488768280;s:15:\"version_checked\";s:5:\"4.7.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("114", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1488768300;s:7:\"checked\";a:4:{s:13:\"lumbini-theme\";s:5:\"1.0.0\";s:13:\"twentyfifteen\";s:3:\"1.7\";s:15:\"twentyseventeen\";s:3:\"1.1\";s:13:\"twentysixteen\";s:3:\"1.3\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("117", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("124", "current_theme", "Lumbini Theme", "yes");
INSERT INTO `wp_options` VALUES("125", "theme_mods_lumbini-theme", "a:7:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:5;s:12:\"bolgsubtitle\";s:57:\"World Peace through love, passion and reinforced approach\";s:12:\"header_image\";s:66:\"http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:7;s:3:\"url\";s:66:\"http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1.jpg\";s:13:\"thumbnail_url\";s:66:\"http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1.jpg\";s:6:\"height\";i:300;s:5:\"width\";i:1720;}s:18:\"nav_menu_locations\";a:2:{s:3:\"top\";i:2;s:6:\"social\";i:8;}}", "yes");
INSERT INTO `wp_options` VALUES("126", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("149", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("151", "widget_em_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("152", "widget_em_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("478", "acf_version", "5.5.8", "yes");
INSERT INTO `wp_options` VALUES("479", "widget_em_locations_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("480", "options_slider_0_image", "21", "no");
INSERT INTO `wp_options` VALUES("481", "_options_slider_0_image", "field_58b199d31a429", "no");
INSERT INTO `wp_options` VALUES("482", "options_slider_0_title", "Welcome to Lumbini Nepal Birth Place of Buddha", "no");
INSERT INTO `wp_options` VALUES("483", "_options_slider_0_title", "field_58b199e31a42a", "no");
INSERT INTO `wp_options` VALUES("484", "options_slider_1_image", "127", "no");
INSERT INTO `wp_options` VALUES("485", "_options_slider_1_image", "field_58b199d31a429", "no");
INSERT INTO `wp_options` VALUES("486", "options_slider_1_title", "International Conference 2017", "no");
INSERT INTO `wp_options` VALUES("487", "_options_slider_1_title", "field_58b199e31a42a", "no");
INSERT INTO `wp_options` VALUES("488", "options_slider", "5", "no");
INSERT INTO `wp_options` VALUES("489", "_options_slider", "field_58b199c11a428", "no");
INSERT INTO `wp_options` VALUES("492", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("501", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("545", "cptui_new_install", "false", "yes");
INSERT INTO `wp_options` VALUES("546", "cptui_post_types", "a:2:{s:5:\"event\";a:28:{s:4:\"name\";s:5:\"event\";s:5:\"label\";s:6:\"Events\";s:14:\"singular_label\";s:5:\"Event\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:22:\"dashicons-calendar-alt\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:6:\"author\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:23:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:11:\"testimonial\";a:28:{s:4:\"name\";s:11:\"testimonial\";s:5:\"label\";s:12:\"Testimonials\";s:14:\"singular_label\";s:11:\"Testimonial\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:22:\"dashicons-format-quote\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:23:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("611", "options_slider_2_image", "128", "no");
INSERT INTO `wp_options` VALUES("612", "_options_slider_2_image", "field_58b199d31a429", "no");
INSERT INTO `wp_options` VALUES("613", "options_slider_2_title", "Presenting a letter to the director of UNESCO Benelux Salvatore Mineo", "no");
INSERT INTO `wp_options` VALUES("614", "_options_slider_2_title", "field_58b199e31a42a", "no");
INSERT INTO `wp_options` VALUES("615", "options_slider_3_image", "129", "no");
INSERT INTO `wp_options` VALUES("616", "_options_slider_3_image", "field_58b199d31a429", "no");
INSERT INTO `wp_options` VALUES("617", "options_slider_3_title", "Presenting memorandum letter to that time Prime Minister Sushil Koirala", "no");
INSERT INTO `wp_options` VALUES("618", "_options_slider_3_title", "field_58b199e31a42a", "no");
INSERT INTO `wp_options` VALUES("619", "options_slider_4_image", "130", "no");
INSERT INTO `wp_options` VALUES("620", "_options_slider_4_image", "field_58b199d31a429", "no");
INSERT INTO `wp_options` VALUES("621", "options_slider_4_title", "Presenting Buddha-statue to the director of Norwegian Nobel Institute", "no");
INSERT INTO `wp_options` VALUES("622", "_options_slider_4_title", "field_58b199e31a42a", "no");
INSERT INTO `wp_options` VALUES("623", "options_message_from_president_page_link", "29", "no");
INSERT INTO `wp_options` VALUES("624", "_options_message_from_president_page_link", "field_58b1a76d53157", "no");
INSERT INTO `wp_options` VALUES("636", "options_message", "29", "no");
INSERT INTO `wp_options` VALUES("637", "_options_message", "field_58b1a76d53157", "no");
INSERT INTO `wp_options` VALUES("638", "options_image_caption", "<strong>Mr. Damodar Prasad Acharya</strong> <br> President <br> LKGC", "no");
INSERT INTO `wp_options` VALUES("639", "_options_image_caption", "field_58b4748644190", "no");
INSERT INTO `wp_options` VALUES("687", "_transient_timeout_plugin_slugs", "1488851868", "no");
INSERT INTO `wp_options` VALUES("688", "_transient_plugin_slugs", "a:9:{i:0;s:34:\"advanced-custom-fields-pro/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:79:\"automatic-featured-images-from-videos/automatic-featured-images-from-videos.php\";i:3;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:9:\"hello.php\";i:6;s:37:\"paypal-donations/paypal-donations.php\";i:7;s:35:\"wordpress-reset/wordpress-reset.php\";i:8;s:27:\"wp-pagenavi/wp-pagenavi.php\";}", "no");
INSERT INTO `wp_options` VALUES("694", "options_donate_now_text", "Donate for the good cause of the Lumbini and help develop the area.", "no");
INSERT INTO `wp_options` VALUES("695", "_options_donate_now_text", "field_58ba3bebe3168", "no");
INSERT INTO `wp_options` VALUES("696", "options_donate_now_link", "", "no");
INSERT INTO `wp_options` VALUES("697", "_options_donate_now_link", "field_58ba3bf7e3169", "no");
INSERT INTO `wp_options` VALUES("699", "options_", "THis link will take you to the paypal for donating money through paypal account.", "no");
INSERT INTO `wp_options` VALUES("700", "_options_", "field_58ba50d331754", "no");
INSERT INTO `wp_options` VALUES("701", "options_donate_now_subtext", "THis link will take you to the paypal for donating money through paypal account.", "no");
INSERT INTO `wp_options` VALUES("702", "_options_donate_now_subtext", "field_58ba50d331754", "no");
INSERT INTO `wp_options` VALUES("723", "_transient_timeout_acf_get_remote_plugin_info", "1488770947", "no");
INSERT INTO `wp_options` VALUES("724", "_transient_acf_get_remote_plugin_info", "a:12:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:8:\"homepage\";s:37:\"https://www.advancedcustomfields.com/\";s:7:\"version\";s:5:\"5.5.9\";s:6:\"author\";s:13:\"Elliot Condon\";s:10:\"author_url\";s:28:\"http://www.elliotcondon.com/\";s:12:\"contributors\";s:12:\"elliotcondon\";s:8:\"requires\";s:5:\"3.6.0\";s:6:\"tested\";s:5:\"4.7.0\";s:6:\"tagged\";s:123:\"acf, advanced, custom, field, fields, custom field, custom fields, simple fields, magic fields, more fields, repeater, edit\";s:9:\"changelog\";s:120:\"<h4>5.5.9</h4><ul><li>Core: Fixed bug causing ACF4 PHP field groups to be ignored if missing ‘key’ setting</li></ul>\";s:14:\"upgrade_notice\";s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("734", "pagenavi_options", "a:15:{s:10:\"pages_text\";s:0:\"\";s:12:\"current_text\";s:13:\"%PAGE_NUMBER%\";s:9:\"page_text\";s:13:\"%PAGE_NUMBER%\";s:10:\"first_text\";s:8:\"« First\";s:9:\"last_text\";s:7:\"Last »\";s:9:\"prev_text\";s:2:\"«\";s:9:\"next_text\";s:2:\"»\";s:12:\"dotleft_text\";s:3:\"...\";s:13:\"dotright_text\";s:3:\"...\";s:9:\"num_pages\";i:5;s:23:\"num_larger_page_numbers\";i:3;s:28:\"larger_page_numbers_multiple\";i:10;s:11:\"always_show\";i:0;s:16:\"use_pagenavi_css\";i:1;s:5:\"style\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("745", "_site_transient_timeout_browser_cc5d8203ce9b96784a0bea9c5a67de54", "1489308660", "no");
INSERT INTO `wp_options` VALUES("746", "_site_transient_browser_cc5d8203ce9b96784a0bea9c5a67de54", "a:9:{s:8:\"platform\";s:9:\"Macintosh\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"56.0.2924.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("749", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1488747065", "no");
INSERT INTO `wp_options` VALUES("750", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Feb 2017 15:58:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.8-alpha-40147\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 4.7.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jan 2017 19:34:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4676\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 4.7.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7.1 and earlier are affected by three security issues: The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2142:\"<p>WordPress 4.7.2 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7.1 and earlier are affected by three security issues:</p>\n<ol>\n<li>The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. Reported by David Herrera of <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a>.</li>\n<li><code>WP_Query</code> is vulnerable to a SQL injection (SQLi) when passing unsafe data. WordPress core is not directly vulnerable to this issue, but we&#8217;ve added hardening to prevent plugins and themes from accidentally causing a vulnerability. Reported by <a href=\"https://github.com/mjangda\">Mo Jangda</a> (batmoo).</li>\n<li>A cross-site scripting (XSS) vulnerability was discovered in the posts list table. Reported by <a href=\"https://iandunn.name/\">Ian Dunn</a> of the WordPress Security Team.</li>\n<li>An unauthenticated privilege escalation vulnerability was discovered in a REST API endpoint. Reported by <a href=\"https://twitter.com/MarcS0h\">Marc-Alexandre Montpas</a> of Sucuri Security. *</li>\n</ol>\n<p>Thank you to the reporters of these issues for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.2.</p>\n<p>Thanks to everyone who contributed to 4.7.2.</p>\n<p>* Update: An additional serious vulnerability was fixed in this release and public disclosure was delayed. For more information on this vulnerability, additional mitigation steps taken, and an explanation for why disclosure was delayed, please read <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\">Disclosure of Additional Security Fix in WordPress 4.7.2</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.7.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2017/01/wordpress-4-7-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jan 2017 03:53:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.7 has been downloaded over 10 million times since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7 and earlier are affected by eight security issues: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6520:\"<p>WordPress 4.7 has been <a href=\"https://wordpress.org/download/counter/\">downloaded over 10 million times</a> since its release on December 6, 2016 and we are pleased to announce the immediate availability of WordPress 4.7.1. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.7 and earlier are affected by eight security issues:</p>\n<ol>\n<li>Remote code execution (RCE) in PHPMailer &#8211; <em>No specific issue appears to affect WordPress</em> or any of the major plugins we investigated but, out of an abundance of caution, we updated PHPMailer in this release. This issue was fixed in PHPMailer thanks to <a href=\"https://legalhackers.com/\">Dawid Golunski</a> and <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>\n<li>The REST API exposed user data for all users who had authored a post of a public post type. WordPress 4.7.1 limits this to only post types which have specified that they should be shown within the REST API. Reported by <a href=\"https://poststatus.com/\">Krogsgard</a> and <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>\n<li>Cross-site scripting (XSS) via the plugin name or version header on <code>update-core.php</code>. Reported by <a href=\"https://dominikschilling.de/\">Dominik Schilling</a> of the WordPress Security Team.</li>\n<li>Cross-site request forgery (CSRF) bypass via uploading a Flash file. Reported by <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>\n<li>Cross-site scripting (XSS) via theme name fallback. Reported by <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>\n<li>Post via email checks <code>mail.example.com</code> if default settings aren&#8217;t changed. Reported by John Blackbourn of the WordPress Security Team.</li>\n<li>A cross-site request forgery (CSRF) was discovered in the accessibility mode of widget editing. Reported by <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>\n<li>Weak cryptographic security for multisite activation key. Reported by <a href=\"https://itsjack.cc/\">Jack</a>.</li>\n</ol>\n<p>Thank you to the reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.7.1 fixes 62 bugs from 4.7. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.7.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.1.</p>\n<p>Thanks to everyone who contributed to 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/christian1012/\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hristo-sg/\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, and <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n	\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 4.7 “Vaughan”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2016/12/vaughan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 19:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4596\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah \"Sassy\" Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2016/12/starter-content.mp4\";s:6:\"length\";s:7:\"3736020\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\";s:6:\"length\";s:7:\"1127483\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://wordpress.org/news/files/2016/12/video-headers.mp4\";s:6:\"length\";s:7:\"1549803\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45502:\"<p>Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah &#8220;Sassy&#8221; Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.</p>\n<div id=\"v-AHz0Ca46-1\" class=\"video-player\"><video id=\"v-AHz0Ca46-1-video\" width=\"632\" height=\"354\" poster=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg\" controls=\"true\" preload=\"metadata\" dir=\"ltr\" lang=\"en\"><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_dvd.mp4\" type=\"video/mp4; codecs=&quot;avc1.64001E, mp4a.40.2&quot;\" /><source src=\"https://videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_fmt1.ogv\" type=\"video/ogg; codecs=&quot;theora, vorbis&quot;\" /><div><img alt=\"Introducing WordPress 4.7\" src=\"https://i1.wp.com/videos.files.wordpress.com/AHz0Ca46/wp4-7-vaughan-r8-mastered_scruberthumbnail_0.jpg?resize=632%2C354&#038;ssl=1\" data-recalc-dims=\"1\" /></div><p>Introducing WordPress 4.7</p></video></div>\n<hr />\n<h2 style=\"text-align:center\">Presenting Twenty Seventeen</h2>\n<p>A brand new default theme brings your site to life with immersive featured images and video headers.</p>\n<p><img class=\"alignnone wp-image-4618 size-large\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=632%2C356&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1600&amp;ssl=1 1600w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Twenty-Seventeen-1.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Twenty Seventeen focuses on business sites and features a customizable front page with multiple sections. Personalize it with widgets, navigation, social menus, a logo, custom colors, and more. Our default theme for 2017 works great in many languages, on any device, and for a wide range of users.</p>\n<hr />\n<h2 style=\"text-align:center\">Your Site, Your Way</h2>\n<p>WordPress 4.7 adds new features to the customizer to help take you through the initial setup of a theme, with non-destructive live previews of all your changes in one uninterrupted workflow.</p>\n<h3>Theme Starter Content</h3>\n<div style=\"width: 632px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-4596-1\" width=\"632\" height=\"346\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/starter-content.mp4?_=1\" /><a href=\"https://wordpress.org/news/files/2016/12/starter-content.mp4\">https://wordpress.org/news/files/2016/12/starter-content.mp4</a></video></div>\n<p>To help give you a solid base to build from, individual themes can provide starter content that appears when you go to customize your brand new site. This can range from placing a business information widget in the best location to providing a sample menu with social icon links to a static front page complete with beautiful images. Don’t worry &#8211; nothing new will appear on the live site until you’re ready to save and publish your initial theme setup.</p>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Edit Shortcuts</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-2\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Edit-Shortcuts.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4?_=2\" /><a href=\"https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4\">https://wordpress.org/news/files/2016/12/edit-shortcuts.mp4</a></video></div>\n<p>Visible icons appear to show you which parts of your site can be customized while live previewing. Click on a shortcut and get straight to editing. Paired with starter content, getting started with customizing your site is faster than ever.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Video Headers</h3>\n<div style=\"width: 300px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-4596-3\" width=\"300\" height=\"173\" poster=\"https://wordpress.org/news/files/2016/12/4.7-—-Header-Video.jpg\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://wordpress.org/news/files/2016/12/video-headers.mp4?_=3\" /><a href=\"https://wordpress.org/news/files/2016/12/video-headers.mp4\">https://wordpress.org/news/files/2016/12/video-headers.mp4</a></video></div>\n<p>Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</p>\n</div>\n<div style=\"clear: both\"></div>\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>Smoother Menu Building</h3>\n<p><img class=\"wp-image-4606 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-Nav.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Many menus for sites contain links to the pages of your site, but what happens when you don’t have any pages yet? Now you can add new pages while building menus instead of leaving the customizer and abandoning your changes. Once you’ve published your customizations, you’ll have new pages ready for you to fill with content.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Custom CSS</h3>\n<p><img class=\"wp-image-4607 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-CSS.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Sometimes you just need a few visual tweaks to make your site perfect. WordPress 4.7 allows you to add custom CSS and instantly see how your changes affect your site. The live preview allows you to work quickly without page refreshes slowing you down.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<div style=\"float: left;width: 48%;margin: 0\">\n<h3>PDF Thumbnail Previews</h3>\n<p><img class=\"wp-image-4609 size-medium alignright\" src=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?resize=300%2C158&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2016/12/4.7-—-PDF.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Managing your document collection is easier with WordPress 4.7. Uploading PDFs will generate thumbnail images so you can more easily distinguish between all your documents.</p>\n</div>\n<div style=\"float: right;width: 48%;margin: 0\">\n<h3>Dashboard in your language</h3>\n<p><img class=\"wp-image-4608 size-medium alignright\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&#038;ssl=1\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?resize=300%2C158&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-Language.jpg?w=760&amp;ssl=1 760w\" sizes=\"(max-width: 300px) 100vw, 300px\" data-recalc-dims=\"1\" /></p>\n<p>Just because your site is in one language doesn’t mean that everybody helping manage it prefers that language for their admin. Add more languages to your site and a user language option will show up in your user’s profiles.</p>\n</div>\n<div style=\"clear: both\"></div>\n<hr />\n<h2 style=\"text-align:center\">Introducing REST API Content Endpoints</h2>\n<p>WordPress 4.7 comes with REST API endpoints for posts, comments, terms, users, meta, and settings.</p>\n<p><img class=\"size-large wp-image-4600 alignnone\" src=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=632%2C205&#038;ssl=1\" alt=\"\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=1024%2C332&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=300%2C97&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?resize=768%2C249&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2016/12/4.7-—-API.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>Content endpoints provide machine-readable external access to your WordPress site with a clear, standards-driven interface, paving the way for new and innovative methods of interacting with sites through plugins, themes, apps, and beyond. Ready to get started with development? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Check out the REST API reference.</a></p>\n<hr />\n<h2 style=\"text-align:center\">Even More Developer Happiness <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post Type Templates</a></h3>\n<p>By opening up the page template functionality to all post types, theme developers have even more flexibility with the WordPress template hierarchy.</p>\n<h3>More Theme API Goodies</h3>\n<p>WordPress 4.7 includes <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">new functions, hooks, and behavior</a> for theme developers.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Custom Bulk Actions</a></h3>\n<p>List tables, now with more than bulk edit and delete.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>The code that lies beneath actions and filters has been overhauled and modernized, fixing bugs along the way.</p>\n<h3>Settings Registration API</h3>\n<p>register_setting() <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">has been enhanced</a> to include type, description, and REST API visibility.</p>\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Customize Changesets</a></h3>\n<p>Customize changesets make changes in the customizer persistent, like autosave drafts. They also make exciting new features like starter content possible.</p>\n<hr />\n<h2 style=\"text-align:center\">The Squad</h2>\n<p>This release was led by <a href=\"https://helen.blog\">Helen Hou-Sandí</a>, backed up by <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a> and <a href=\"http://aaron.jorb.in/\">Aaron Jorbin</a> as Release Deputies, and with the help of these fine individuals. There are 482 contributors with props in this release—the most ever—with 205 of them contributing for the first time. Pull up some sassy Sarah Vaughan on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/abrightclearweb\">abrightclearweb</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/achbed\">achbed</a>, <a href=\"https://profiles.wordpress.org/acmethemes\">Acme Themes</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adammacias\">adammacias</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airesvsg\">airesvsg</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/akshayvinchurkar\">akshayvinchurkar</a>, <a href=\"https://profiles.wordpress.org/schlessera\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/ironpaperweight\">Alex Hon</a>, <a href=\"https://profiles.wordpress.org/alex27\">alex27</a>, <a href=\"https://profiles.wordpress.org/allancole\">allancole</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrewp-2\">Andreas Panag</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/aniketpant\">Aniket Pant</a>, <a href=\"https://profiles.wordpress.org/anilbasnet\">Anil Basnet</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antisilent\">antisilent</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/zuige\">Antti Kuosmanen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/artoliukkonen\">artoliukkonen</a>, <a href=\"https://profiles.wordpress.org/ideag\">Arunas Liuiza</a>, <a href=\"https://profiles.wordpress.org/attitude\">attitude</a>, <a href=\"https://profiles.wordpress.org/backermann\">backermann</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/binarymoon\">BinaryMoon</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boboudreau\">boboudreau</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Brainstorm Force</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianhogg\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\">Casey Driscoll</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chaos-engine\">Chaos Engine</a>, <a href=\"https://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"https://profiles.wordpress.org/chesio\">chesio</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chredd\">chredd</a>, <a href=\"https://profiles.wordpress.org/chrisjean\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/chris_d2d\">Chris Smith</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriswiegman\">Chris Wiegman</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/cwpnolen\">Christian Nolen</a>, <a href=\"https://profiles.wordpress.org/needle\">Christian Wach</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/clarionwpdeveloper\">Clarion Technologies</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiosmweb\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiolabarbera\">ClaudioLaBarbera</a>, <a href=\"https://profiles.wordpress.org/codemovementpk\">codemovement.pk</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/codfish\">codfish</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/curdin\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber </a>, <a href=\"https://profiles.wordpress.org/danielkanchev\">Daniel Kanchev</a>, <a href=\"https://profiles.wordpress.org/danielpietrasik\">Daniel Pietrasik</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/goto10\">Dave Romsey (goto10)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dglingren\">David Lingren</a>, <a href=\"https://profiles.wordpress.org/davidmosterd\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/davidbhayes\">davidbhayes</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/deeptiboddapati\">deeptiboddapati</a>, <a href=\"https://profiles.wordpress.org/delphinus\">delphinus</a>, <a href=\"https://profiles.wordpress.org/deltafactory\">deltafactory</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/derrickkoo\">Derrick Koo</a>, <a href=\"https://profiles.wordpress.org/dimchik\">dimchik</a>, <a href=\"https://profiles.wordpress.org/dineshc\">Dinesh Chouhan</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipeshkakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/doughamlin\">doughamlin</a>, <a href=\"https://profiles.wordpress.org/dreamon11\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duncanjbrown\">duncanjbrown</a>, <a href=\"https://profiles.wordpress.org/dungengronovius\">dungengronovius</a>, <a href=\"https://profiles.wordpress.org/dylanauty\">DylanAuty</a>, <a href=\"https://profiles.wordpress.org/hurtige\">Eddie Hurtig</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elyobo\">elyobo</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/pushred\">Eric Lanehart</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fencer04\">Fencer04</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/foliovision\">FolioVision</a>, <a href=\"https://profiles.wordpress.org/fomenkoandrey\">fomenkoandrey</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/frankiet\">frankiet</a>, <a href=\"https://profiles.wordpress.org/akeif\">Fred</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fuscata\">fuscata</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekysoft\">Geeky Software</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/goranseric\">Goran &#352;erić</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/grantderepas\">Grant Derepas</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hiddenpearls\">hiddenpearls</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hristo-sg\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianedington\">Ian Edington</a>, <a href=\"https://profiles.wordpress.org/idealien\">idealien</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/imnok\">Imnok</a>, <a href=\"https://profiles.wordpress.org/implenton\">implenton</a>, <a href=\"https://profiles.wordpress.org/ionutst\">Ionut Stanciu</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/krstarica\">Ivan</a>, <a href=\"https://profiles.wordpress.org/ivdimova\">ivdimova</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesacero\">jamesacero</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaredcobb\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jayarjo\">jayarjo</a>, <a href=\"https://profiles.wordpress.org/jdolan\">jdolan</a>, <a href=\"https://profiles.wordpress.org/jdoubleu\">jdoubleu</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jimt\">jimt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jmusal\">jmusal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelcj91\">Joel James</a>, <a href=\"https://profiles.wordpress.org/johanmynhardt\">johanmynhardt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/zyphonic\">John Dittmar</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/johnregan3\">John Regan</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/kenshino\">Jon (Kenshino)</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/daggerhart\">Jonathan Daggerhart</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>, <a href=\"https://profiles.wordpress.org/jorritschippers\">JorritSchippers</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshcummingsdesign\">joshcummingsdesign</a>, <a href=\"https://profiles.wordpress.org/joshkadis\">joshkadis</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jrgould\">JRGould</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinbusa\">Justin Busa</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kacperszurek\">kacperszurek</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/kellbot\">kellbot</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/koenschipper\">koenschipper</a>, <a href=\"https://profiles.wordpress.org/kokarn\">kokarn</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/kuchenundkakao\">kuchenundkakao</a>, <a href=\"https://profiles.wordpress.org/kuldipem\">kuldipem</a>, <a href=\"https://profiles.wordpress.org/laurelfulford\">Laurel Fulford</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leobaiano\">Leo Baiano</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">LittleBigThings (Csaba)</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">lukepettway</a>, <a href=\"https://profiles.wordpress.org/lyubomir_popov\">lyubomir_popov</a>, <a href=\"https://profiles.wordpress.org/mageshp\">mageshp</a>, <a href=\"https://profiles.wordpress.org/mahesh901122\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mangeshp\">Mangesh Parte</a>, <a href=\"https://profiles.wordpress.org/manishsongirkar36\">Manish Songirkar</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">Mario Valney</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep\">markshep</a>, <a href=\"https://profiles.wordpress.org/matrixik\">matrixik</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/jaworskimatt\">Matt Jaworski</a>, <a href=\"https://profiles.wordpress.org/mattking5000\">Matt King</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mbelchev\">mbelchev</a>, <a href=\"https://profiles.wordpress.org/mckernanin\">mckernanin</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mhowell\">mhowell</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeviele\">Mike Viele</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/modemlooper\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/deremohan\">Mohan Dere</a>, <a href=\"https://profiles.wordpress.org/monikarao\">monikarao</a>, <a href=\"https://profiles.wordpress.org/morettigeorgiev\">morettigeorgiev</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/mrbobbybryant\">mrbobbybryant</a>, <a href=\"https://profiles.wordpress.org/nnaimov\">Naim Naimov</a>, <a href=\"https://profiles.wordpress.org/natereist\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/natewr\">NateWr</a>, <a href=\"https://profiles.wordpress.org/nathanrice\">nathanrice</a>, <a href=\"https://profiles.wordpress.org/nazgul\">Nazgul</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey </a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nullvariable\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/odie2\">odie2</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/orvils\">orvils</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/ottok\">Otto Kek&#228;l&#228;inen</a>, <a href=\"https://profiles.wordpress.org/ovann86\">ovann86</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patilvikasj\">patilvikasj</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/sirbrillig\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/pdufour\">pdufour</a>, <a href=\"https://profiles.wordpress.org/piewp\">Perdaan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phh\">phh</a>, <a href=\"https://profiles.wordpress.org/php\">php</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pippinsplugins\">pippinsplugins</a>, <a href=\"https://profiles.wordpress.org/pjgalbraith\">pjgalbraith</a>, <a href=\"https://profiles.wordpress.org/pkevan\">pkevan</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pressionate\">Pressionate</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/procodewp\">procodewp</a>, <a href=\"https://profiles.wordpress.org/quasel\">quasel</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/superpoincare\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/ranh\">ranh</a>, <a href=\"https://profiles.wordpress.org/redsand\">Red Sand Media Group</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rpayne7264\">Robert D Payne</a>, <a href=\"https://profiles.wordpress.org/iamjolly\">Robert Jolly</a>, <a href=\"https://profiles.wordpress.org/rnoakes3rd\">Robert Noakes</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">Rocco Aliberti</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/fronaldaraujo\">Ronald Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/guavaworks\">Roy Sivan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/sandesh055\">Sandesh</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/pollyplummer\">Sarah Gooding</a>, <a href=\"https://profiles.wordpress.org/sayedwp\">Sayed Taqui</a>, <a href=\"https://profiles.wordpress.org/schrapel\">schrapel</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scrappyhuborg\">scrappy@hub.org</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seancjones\">seancjones</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/sfpt\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shayanys\">shayanys</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/shprink\">shprink</a>, <a href=\"https://profiles.wordpress.org/simonlampen\">simonlampen</a>, <a href=\"https://profiles.wordpress.org/skippy\">skippy</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snacking\">snacking</a>, <a href=\"https://profiles.wordpress.org/soean\">Soeren Wrede</a>, <a href=\"https://profiles.wordpress.org/solal\">solal</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/sharkomatic\">Steph</a>, <a href=\"https://profiles.wordpress.org/sswells\">Steph Wells</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/stubgo\">stubgo</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/patilswapnilv\">Swapnil V. Patil</a>, <a href=\"https://profiles.wordpress.org/swapnild\">swapnild</a>, <a href=\"https://profiles.wordpress.org/szaqal21\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tapsboy\">tapsboy</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/team\">team</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/the\">the</a>, <a href=\"https://profiles.wordpress.org/themeshaper\">themeshaper</a>, <a href=\"https://profiles.wordpress.org/thenbrent\">thenbrent</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tierra\">tierra</a>, <a href=\"https://profiles.wordpress.org/tnash\">Tim Nash</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph\">timph</a>, <a href=\"https://profiles.wordpress.org/tkama\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tnegri\">tnegri</a>, <a href=\"https://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomdxw\">tomdxw</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/traversal\">traversal</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/nmt90\">Triet Minh</a>, <a href=\"https://profiles.wordpress.org/trishasalas\">Trisha Salas</a>, <a href=\"https://profiles.wordpress.org/tristangemus\">tristangemus</a>, <a href=\"https://profiles.wordpress.org/truongwp\">Truong Giang</a>, <a href=\"https://profiles.wordpress.org/tsl143\">tsl143</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/valeriutihai\">Valeriu Tihai</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/vrundakansara-1\">Vrunda Kansara</a>, <a href=\"https://profiles.wordpress.org/webbgaraget\">webbgaraget</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wolly\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/wraithkenny\">WraithKenny</a>, <a href=\"https://profiles.wordpress.org/yale01\">yale01</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yogasukma\">Yoga Sukma</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"https://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>, <a href=\"https://profiles.wordpress.org/zhildzik\">zhildzik</a>, and <a href=\"https://profiles.wordpress.org/zsusag\">zsusag</a>.\n<p>&nbsp;<br />\nSpecial thanks go to <a href=\"https://ramiabraham.com/\">Rami Abraham</a> for producing the release video and the many fine haiku we saw in the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">beta</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\">RC</a> announcement posts.</p>\n<p>Finally, thanks to all the community translators who worked on WordPress 4.7. Their efforts bring WordPress 4.7 fully translated to 52 languages at release time with more on the way. Additionally, the WordPress 4.7 release video has been captioned into 44 languages.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress &#8211; we hope you enjoy!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Moving Toward SSL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2016/12/moving-toward-ssl/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Dec 2016 17:20:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4588\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:327:\"We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1627:\"<p>We’re at a turning point: 2017 is going to be the year that we’re going to see features in WordPress which require hosts to have HTTPS available. Just as JavaScript is a near necessity for smoother user experiences and more modern PHP versions are critical for performance, SSL just makes sense as the next hurdle our users are going to face.</p>\n<p>SSL basically means the link between your browser and the server is encrypted. SSL used to be difficult to implement, and often expensive or slow. Modern browsers, and the incredible success of projects like <a href=\"https://letsencrypt.org/\">Let&#8217;s Encrypt</a> have made getting a certificate to secure your site fast, free, and something we think every host should support by default, especially in a post-Snowden era. Google also weighs <a href=\"https://security.googleblog.com/2014/08/https-as-ranking-signal_6.html\">SSL as a search engine ranking factor</a> and will begin <a href=\"http://motherboard.vice.com/read/google-will-soon-shame-all-websites-that-are-unencrypted-chrome-https\">flagging unencrypted sites in Chrome</a>.</p>\n<p>First, early in 2017, we will only promote hosting partners that provide a SSL certificate by default in their accounts. Later we will begin to assess which features, such as API authentication, would benefit the most from SSL and make them only enabled when SSL is there.</p>\n<p>Separately, I also think the performance improvements in PHP7 are particularly impressive, and major kudos to everyone who worked on that. We will consider whether hosts use PHP7 by default for new accounts next year as well.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4588\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.7 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/11/wordpress-4-7-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Nov 2016 04:26:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"The release candidate for WordPress 4.7 is now available. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on Tuesday, December 6, but we need your help to get there. If you haven’t tested 4.7 yet, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4331:\"<p>The release candidate for WordPress 4.7 is now available.</p>\n<p>RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.7 on <strong>Tuesday, December 6</strong>, but we need <em>your</em> help to get there. If you haven’t tested 4.7 yet, now is the time! To test WordPress 4.7, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.7-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>WordPress 4.7 is a jam-packed release, with a number of features focused on getting a theme set up for the first time. Highlights include a <a href=\"http://2017.wordpress.net/\">new default theme</a>, video headers, custom CSS, customizer edit shortcuts, PDF thumbnail previews, user admin languages, REST API content endpoints, post type templates, and more.</p>\n<p>We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39353&amp;stop_rev=39263&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">quite a few refinements</a> since releasing Beta 4 a week ago, including usability and accessibility enhancements for video headers, media and page template support in starter content, and polishing of how custom CSS can be migrated to and extended by plugins and themes. The REST API endpoints saw a number of bugfixes and notably now have anonymous comment off by default.</p>\n<p>Not sure where to start with testing? Try setting up a fresh site on a new installation with Twenty Seventeen (hint: head into customizing your site before touching any pages or widgets) and taking notes on what you enjoyed and what got you stuck. For more details about what&#8217;s new in version 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Think you’ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you’ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.7 and update your plugin’s <em>Tested up to</em> version in the readme to 4.7. If you find compatibility problems please be sure to post to the support forums so we can figure those out before the final release – we work hard to avoid breaking things. An in-depth field guide to developer-focused changes is coming soon on the <a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> And if you haven&#8217;t yet done so, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and send it on to your friends.</p>\n<p>Happy testing! And now for another <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a> haiku break.</p>\n<p><em>Select your language</em><br />\n<em>Then let your users choose theirs</em><br />\n<em><code>get_user_locale()</code></em></p>\n<p><em>Theme authors rejoice</em><br />\n<em>Any option may employ</em><br />\n<em>Selective refresh</em></p>\n<p><em>Custom header video</em><br />\n<em>Make sure to <code>add_theme_support</code></em><br />\n<em>Bling above the fold</em></p>\n<p><em>A new template dawns</em><br />\n<em>A hierarchy member</em><br />\n<em>Post-type templates live</em></p>\n<p><em>PDF updates</em><br />\n<em>Pack a parade of polish</em><br />\n<em>Prettier previews</em></p>\n<p><em>Template Post Type: New</em><br />\n<em>Template Post Type: And Useful</em><br />\n<em>Template Post Type: Thing</em></p>\n<p><em>Let lists live lively</em><br />\n<em>Laud <code>wp_list_sort()</code></em><br />\n<em>Less laconic lists</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 16 Nov 2016 01:51:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4576\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2019:\"<p>WordPress 4.7 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1,</a> <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth developer guides on make/core</a>. We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39262&amp;stop_rev=39201&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">about 60 changes</a> in the last few days for beta 4, including tweaks to Twenty Seventeen, custom CSS, and the REST API content endpoints.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>We are almost there<br />\nPlease test your plugins and themes<br />\nRC coming soon<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4576\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordCamp US 2017-2018 in Nashville\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/11/wordcamp-us-2017-2018-in-nashville/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Nov 2016 23:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4571\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:330:\"The title says it all. We had some great applications for cities to host WordCamp US after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is Nashville, Tennessee. Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1022:\"<p><img class=\"aligncenter\" src=\"https://i0.wp.com/wpdotorg.files.wordpress.com/2008/07/27492741871_c6fcebcad3_k-e1479248587522.jpg?resize=632%2C253&#038;ssl=1\" data-recalc-dims=\"1\" /></p>\n<p>The title says it all. We had some great applications for cities to host <a href=\"http://us.wordcamp.org/\">WordCamp US</a> after we finish up in Philadelphia this year, and the city chosen for 2017-2018 is <strong>Nashville, Tennessee</strong>.</p>\n<p>Based on the other great applications we got I&#8217;m also excited about the pipeline of communities that could host it in future years as WordCamp US travels across the United States and gives us an opportunity to learn and love a new city, as we have with Philadelphia.</p>\n<p>By the way, if you haven&#8217;t yet, now is a great time to <a href=\"https://wordpressdotorg.polldaddy.com/s/wordpress-2016-survey\">take the Annual WordPress Survey</a> and ask your friends to as well.</p>\n<p><a href=\"https://www.flickr.com/photos/143951935@N07/27492741871\">Photo Credit</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Nov 2016 03:30:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4566\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3120:\"<p>WordPress 4.7 Beta 3 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more information on what’s new in 4.7, check out the <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-7+dev-notes/\">in-depth field guides on make/core</a>. Some of the changes in Beta 3 include:</p>\n<ul>\n<li><strong>REST API:</strong> The <code>unfiltered_html</code> capability is now respected and <code>rest_base</code> has been added to response objects of <code>wp/v2/taxonomies</code> and <code>wp/v2/types</code>, while <code>get_allowed_query_vars()</code> and the <code>rest_get_post</code> filter have been removed.</li>\n<li><strong>Roles/Capabilities:</strong> Added meta-caps for comment, term, and user meta, which are currently only used in the REST API.</li>\n<li><strong>I18N:</strong> Added the ability to change user&#8217;s locale back to site&#8217;s locale. (<a href=\"https://core.trac.wordpress.org/ticket/38632\">#38632</a>)</li>\n<li><strong>Custom CSS:</strong> Renamed the <code>unfiltered_css</code> meta capability to <code>edit_css</code> and added revisions support to the <code>custom_css</code> post type.</li>\n<li><strong>Edit shortcuts:</strong> Theme authors should take a look at <a href=\"https://make.wordpress.org/core/2016/11/10/visible-edit-shortcuts-in-the-customizer-preview/\">the developer guide to the customizer preview&#8217;s visible edit shortcuts</a> and update their themes to take advantage of them if not already implementing selective refresh.</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39200&amp;stop_rev=39143&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">over 50 changes</a> in the last week.</li>\n</ul>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p><em>Building the future</em><br />\n<em>A global community</em><br />\n<em>Stronger together</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4566\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/11/wordpress-4-7-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 04 Nov 2016 17:39:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4552\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"<p>WordPress 4.7 Beta 2 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta2.zip\">download the beta here</a> (zip).</p>\n<p>Notable changes since WordPress 4.7 Beta 1:</p>\n<ul>\n<li><strong>Twenty Seventeen:</strong> The theme wasn&#8217;t being installed on upgrades &#8211; sorry about that! Now you should see it if you&#8217;re upgrading an existing site. There are also plenty of fixes, especially for the header and small screen views.</li>\n<li><strong>Edit shortcuts:</strong> These are always visible while editing (hide them on bigger screens by collapsing the controls) and should now work properly in Firefox. (<a href=\"https://core.trac.wordpress.org/ticket/27403\">#27403</a> and <a href=\"https://core.trac.wordpress.org/ticket/38532\">#38532</a>)</li>\n<li><strong>REST API endpoints:</strong> There have been a number of changes over the past week; your attention is requested on the following:\n<ul>\n<li>The <code>DELETE</code> response format has changed and may need to be accounted for. (<a href=\"https://core.trac.wordpress.org/ticket/38494\">#38494</a>)</li>\n<li>Enabled querying by multiple post statuses. (<a href=\"https://core.trac.wordpress.org/ticket/38420\">#38420</a>)</li>\n<li>Return an error when JSON decoding fails. (<a href=\"https://core.trac.wordpress.org/ticket/38547\">#38547</a>)</li>\n</ul>\n</li>\n<li><strong>More developer notes</strong>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2016/10/28/fine-grained-capabilities-for-taxonomy-terms-in-4-7/\">Fine grained capabilities for taxonomy terms</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/29/wp_taxonomy-in-4-7/\"><code>WP_Taxonomy</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/02/wp_list_sort-and-wp_list_util-in-4-7/\"><code>wp_list_sort()</code> and <code>WP_List_Util</code></a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Post type templates</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/new-post-type-labels-in-4-7/\">New post type labels</a></li>\n<li><a href=\"https://make.wordpress.org/core/2016/11/03/attributes-for-resource-hints-in-4-7/\">Attributes for resource hints</a></li>\n</ul>\n</li>\n<li><strong>Various bug fixes:</strong> We’ve made <a href=\"https://core.trac.wordpress.org/log/trunk/src?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=39142&amp;stop_rev=38995&amp;limit=200&amp;verbose=on&amp;sfp_email=&amp;sfph_mail=\">almost 150 changes</a> in the last week.</li>\n</ul>\n<p>For more of what’s new in version 4.7, <a href=\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\">check out the Beta 1 blog post</a>.</p>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing!</p>\n<p><em>Ya es la hora</em><br />\n<em> Time for another beta</em><br />\n请您帮下忙!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4552\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.7 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/10/wordpress-4-7-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Oct 2016 04:30:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4535\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.7 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Helen Hou-Sandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6895:\"<p>WordPress 4.7 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.7, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.7-beta1.zip\">download the beta here</a> (zip).</p>\n<p>WordPress 4.7 is slated for release on <a href=\"https://make.wordpress.org/core/4-7/\">December 6</a>, but we need your help to get there. We&#8217;ve been working on a lot of things, many of them to make getting your site set up the way you want it much easier. Here are some of the bigger items to test and help us find as many bugs as possible in the coming weeks:</p>\n<ul>\n<li><a href=\"http://2017.wordpress.net/\"><strong>Twenty Seventeen</strong></a> &#8211; A brand new default theme brings your site to life with immersive featured images, video headers, and subtle animations. With a focus on business sites, it features multiple sections on the front page as well as widgets, navigation and social menus, a logo, and more. Personalize its asymmetrical grid with a custom color scheme and showcase your multimedia content with post formats. Our default theme for 2017 works great in many languages, for any abilities, and on any device.</li>\n<li><strong>Video Headers</strong> &#8211; Sometimes a big atmospheric video as a moving header image is just what you need to showcase your wares; go ahead and try it out with Twenty Seventeen. Need some video inspiration? Try searching for sites with video headers available for download and use.</li>\n<li><strong>Set up your site in one flow</strong> &#8211; From finding and installing themes right inside the customizer, to automatically staged theme-specific starter content, to clickable shortcuts that jump directly to editing an item from the preview pane, to adding pages while you&#8217;re building a nav menu or setting a static front page: getting a new site spun up and ready to share with a friend or a coworker is faster and easier than it&#8217;s ever been. Note: starter content appears when live previewing brand new sites and is currently only available in Twenty Seventeen. We&#8217;ll be expanding this to other bundled themes very soon, and perhaps to sites with existing content in future releases of WordPress.</li>\n<li><strong>Custom CSS with live previews</strong> &#8211; Ever needed to hide or tweak the look of something in your theme or from a plugin? Now you can do it with CSS and live preview the results while customizing your site. CSS can be a powerful tool; you may find that you won&#8217;t need the theme editor or child themes anymore.</li>\n<li><strong>User admin languages</strong> &#8211; Just because your site is in one language doesn&#8217;t mean that everybody helping manage it prefers that language for their admin. To try this out, you&#8217;ll need to have more than one language installed, which will make a user language option available in your profile.</li>\n<li><strong>PDF thumbnail previews</strong> &#8211; Uploading PDFs will now generate thumbnail images so you can more easily distinguish between all your documents.</li>\n</ul>\n<p>As always, there have been exciting changes for developers to explore as well, such as:</p>\n<ul>\n<li><strong>REST API content endpoints</strong> &#8211; If you only test one thing as a developer, please test these. This phase is particularly helpful for people building plugins, themes, and in-admin interfaces. Can you build the things you need? Are these ready for release, and is the world ready for them? (<a href=\"https://core.trac.wordpress.org/ticket/38373\">#38373</a>)</li>\n<li><strong><code>WP_Hook</code></strong> &#8211; The code that lies beneath actions and filters has been overhauled. You likely aren&#8217;t affected, but if you&#8217;ve done things to the <code>$wp_filter</code> global or experienced funky recursion bugs in the past, <a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\">please take a moment to read the dev note</a> and test your code.</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\"><strong>Custom bulk actions</strong></a> &#8211; List tables, now with more than bulk edit and delete.</li>\n<li>Expanded <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\"><strong>Settings Registration API</strong></a> via <code>register_setting()</code>.</li>\n<li>For theme developers: <strong>Post type templates</strong> (<a href=\"https://core.trac.wordpress.org/ticket/18375\">#18375</a>)</li>\n<li><strong><a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">More goodies for theme developers!</a></strong></li>\n<li><strong>Locale switching</strong> (<a href=\"https://core.trac.wordpress.org/ticket/26511\">#26511</a>)</li>\n<li><a href=\"https://make.wordpress.org/core/2016/10/11/comment-allowed-checks-in-wordpress-4-7/\"><strong>Comment allowed checks</strong></a> have the potential for a back-compat break.</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.7, <a href=\"https://make.wordpress.org/core/tag/4-7/\">check out posts tagged with 4.7 on the main development blog</a>, or look at a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.7&amp;group=component&amp;order=priority\">list of everything</a> that’s changed. There will be more developer notes to come, so keep an eye out for those as well.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</p>\n<p>Happy testing, and please enjoy this extended haiku break, courtesy of <a href=\"https://profiles.wordpress.org/ramiabraham\">Rami Abraham</a><em>.</em></p>\n<p><em>Exquisite endpoints</em><br />\n<em>Extol epic exabytes</em><br />\n<em>Enabling earthlings</em></p>\n<p><em>Careful interfaces</em><br />\n<em>Considerately conjured</em><br />\n<em>Customizer chic</em></p>\n<p><em>Ring in the new year</em><br />\n<em>With elegance and balance</em><br />\n<em>Twenty Seventeen</em></p>\n<p><em>Hooks hook healthily</em><br />\n<em>17817</em><br />\n<em>Sane iterations</em></p>\n<p><em>Admin in your tongue<br />\nOne site, many languages<br />\nWe all speak WordPress</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"4535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 05 Mar 2017 08:51:03 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 01 Feb 2017 15:58:56 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}}s:5:\"build\";s:14:\"20130910221710\";}", "no");
INSERT INTO `wp_options` VALUES("751", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1488747065", "no");
INSERT INTO `wp_options` VALUES("752", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1488703865", "no");
INSERT INTO `wp_options` VALUES("753", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1488747069", "no");
INSERT INTO `wp_options` VALUES("754", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: Web Annotations are Now a W3C Standard, Paving the Way for Decentralized Annotation Infrastructure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66802\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://wptavern.com/web-annotations-are-now-a-w3c-standard-paving-the-way-for-decentralized-annotation-infrastructure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13734:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/02/writing.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/8Y0EDX4VP9\">Green Chameleon</a>\n<p><a href=\"https://www.w3.org/blog/news/archives/6156\" target=\"_blank\">Web annotations</a> became a W3C standard last week but the world hardly noticed. For years, most conversations on the web have happened in the form of comments. Annotations are different in that they usually reference specific parts of a document and add context. They are often critical or explanatory in nature.</p>\n<p>One of the key differences between comments and web annotations, according to the new standard, is that annotations were designed to be decentralized, creating &#8220;a new layer of interactivity and linking on top of the Web.&#8221; Comments are published by the publisher at the same location as the original content, but web annotation content is owned by the reader. Annotations don&#8217;t have to be published on the original content. The reader has the choice to publish using an &#8220;annotation service&#8221; or their own website.</p>\n<p>Doug Schepers, former Developer Relations Lead at W3C, described the difference between annotating and commenting on an <a href=\"http://thewebahead.net/60\" target=\"_blank\">episode on The Web Ahead podcast</a>:</p>\n<blockquote><p>When a comment is at the bottom of a page, it&#8217;s so abstracted out from the rest. They get off track, they start talking about other things that have nothing to do with the original article. If it&#8217;s an even vaguely political topic, you&#8217;ve got the partisans jumping in, yelling at one another, how they&#8217;re all idiots. You lose track with the content of the article. There&#8217;s this viscerality, this immediacy, of actually commenting on something in its context.</p></blockquote>\n<p>Do people want to annotate the web? Popular implementations of this concept, such as <a href=\"https://genius.com/web-annotator\" target=\"_blank\">Genius Web Annotator</a> and Medium&#8217;s annotation-style commenting, show that people enjoy interacting on the web in this way. The W3C Web Annotation Working Group&#8217;s goal in standardizing the technology behind web annotations was to produce a set of specifications for &#8220;interoperable, sharable, distributed Web Annotation architecture,&#8221; enabling healthy competition between services and discouraging publisher lock-in.</p>\n<p>Decentralization is critical to unlocking the full potential of annotations on the web. If commenters have control of their own content, they have the freedom to publish it wherever they like. Open comments sections can sometimes offer the illusion of discourse, but are ultimately under the control of the publisher. This is obvious if you&#8217;ve ever seen a controversial blog post, which should undoubtedly have comments with varying viewpoints, but the only comments published are those in agreement with the author.</p>\n<p>&#8220;This notion that whoever controls the original source also controls the dialog &#8211; that&#8217;s dangerous,&#8221; Schepers said. &#8220;This is why I like the idea of annotations. It&#8217;s inherent in the idea of annotations, this indie web aspect of, &#8216;I want to control what I say, what channels it goes out to.&#8217; I can&#8217;t control who puts it into a different channel but I can control what channels I try to put it out into. I can actively publish in multiple channels.&#8221;</p>\n<h3>Hypothesis Plugin Brings Web Annotations to WordPress</h3>\n<p><a href=\"https://hypothes.is\" target=\"_blank\">Hypothesis</a> is a non-profit organization that is building an open platform for annotation on the web, based on the <a href=\"http://annotatorjs.org/\" target=\"_blank\">Annotator.js</a> library. It allows readers to highlight text and select whether they want to annotate it or highlight it.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/03/hypothesis-annotations.png?ssl=1\"><img /></a></p>\n<p>The Hypothes.is community has an ecosystem of <a href=\"https://hypothes.is/tools-plug-ins-and-integrations/\" target=\"_blank\">tools and integrations</a> for various technologies and publishing platforms, including WordPress. The <a href=\"https://wordpress.org/plugins/hypothesis/\" target=\"_blank\">Hypothesis plugin on WordPress.org</a> offers the same functionality that you see on the Hypothesis website with the ability to select text and have a sidebar slide out for taking notes. Annotation requires an account with Hypothesis. You can test it by pasting any link into the tool on the <a href=\"https://hypothes.is/\" target=\"_blank\">Hypothesis</a> homepage.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/03/annotating.png?ssl=1\"><img /></a></p>\n<p>The mission of the Hypothesis project is &#8220;to bring a new layer to the web&#8221; that enables conversations on top of the world&#8217;s collected knowledge. The project also allows you to publish annotations privately, creating your own personal notebook of observations as you surf the web.</p>\n<p>The Hypothesis plugin allows users to customize the defaults and behavior and control where it&#8217;s loaded (front page, blog page, posts, pages, etc.) Highlights can be on or off by default and the sidebar can be collapsed or open. Annotations can also be enabled on PDFs in the Media Library. Hypotheses can be allowed/disallowed on a list of specific posts or pages, which is helpful for sites where the author may only want annotation on scholarly material.</p>\n<p><a href=\"https://github.com/kshaffer/hypothesis_aggregator\" target=\"_blank\">Hypothesis Aggregator</a> is another plugin for WordPress that offers a shortcode with different parameters for displaying annotations from the service. It allows site owners to display a collection of annotations from a certain user or topic.</p>\n<p><code>[hypothesis user = \'kris.shaffer\']</p>\n<p>[hypothesis tags = \'IndieWeb\']</p>\n<p>[hypothesis text = \"Domain of One\'s Own\"]</p>\n<p>[hypothesis user = \'kris.shaffer\' tags = \'IndieEdTech\']</code></p>\n<p>The output includes a link to the original content, the highlighted text, the annotation, and the person who curated it.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/03/hypothesis-aggregator.png?ssl=1\"><img /></a></p>\n<p>Kris Shaffer, the plugin&#8217;s author, is considering adding support for multiple tags (in both AND and OR configurations) as well as the ability to embed a single annotation in a post, like users can with a tweet.</p>\n<p>The Hypothesis network of annotators is growing, along with the vast collection of knowledge that is getting linked and added every day. The service just completed a record month with nearly 6,000 annotators contributing content.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">A record month <a href=\"https://twitter.com/hypothes_is\">@hypothes_is</a> in February: almost 6K active annotators made 112,385 <a href=\"https://twitter.com/hashtag/annotations?src=hash\">#annotations</a>. Did you help? <a href=\"https://t.co/R2DZaf6D7i\">https://t.co/R2DZaf6D7i</a> <a href=\"https://t.co/HWNVUXUS9s\">pic.twitter.com/HWNVUXUS9s</a></p>\n<p>&mdash; Hypothes.is (@hypothes_is) <a href=\"https://twitter.com/hypothes_is/status/836993180486684672\">March 1, 2017</a></p></blockquote>\n<p></p>\n<p>Members of the Hypothesis team are principal contributors to the Annotator project and the organization was also deeply involved in the effort to make web annotations a W3C standard. The Hypothesis community tools are quite frequently used in the context of scholarly or academic dialogue, but the app aims to bring annotation to all types of websites, including news, blogs, scientific articles, books, terms of service, ballot initiatives, legislation, and more.</p>\n<p>In a <a href=\"https://www.youtube.com/watch?v=2jTctBbX_kw\" target=\"_blank\">presentation</a> at the Personal Democracy Forum in 2013, Dan Whaley, founder and CEO of Hypothesis, described the organization&#8217;s motivation behind annotating all of the web&#8217;s collective knowledge:</p>\n<blockquote><p>Think back 1,000 years, reflect on the key documents produced over that time, like the Magna Carta in 1215 or the Declaration of Independence, for which we only have the document itself. What we&#8217;re missing are the notes passed between co-authors in the drafting, the reviews by others providing feedback on early versions. We lack the perception by the public immediately after and most of the fine-grained citations, quotations, and reuse in the intervening years. Those incessant arguments about why the founding fathers chose this or that particular phrasing &#8211; what if we had a much better idea, the direct record of their internal deliberations? There&#8217;s no shortage of things to annotate, and there&#8217;s more knowledge being created per minute now than ever before &#8211; laws, scientific articles, news, books, tweets, data &#8230;but our tools are crude, balkanized, ill-preserved, and even then only available on a small minority of what&#8217;s important.</p></blockquote>\n<p>The idea of web annotations is to capture the surrounding conversation that doesn&#8217;t necessarily fit into traditional comments, preserving it in a way that is open, sharable, and cooperates nicely with other technologies using the web&#8217;s standard.</p>\n<h3>What Does the W3C Standard Mean for the Future of Annotations?</h3>\n<p>Web annotation seems to promote more critical thinking and collaboration but it&#8217;s doubtful that it would ever fully replace commenting systems. The two serve different purposes and it&#8217;s more likely that annotations will serve to supplement conversations on the web. Not everyone is fond of the current implementations of annotation UI, which require visitors to keep clicking on things as they are reading.</p>\n<p>Despite being first being introduced to the web in the Mosaic browser prototype in 1993, annotation tools are still in their infancy. In a <a href=\"https://genius.com/Marc-andreessen-why-andreessen-horowitz-is-investing-in-rap-genius-annotated\" target=\"_blank\">post</a> announcing Andreessen Horowitz&#8217;s $15 million investment in Rap Genius, Marc Andreesen describes how the technology was almost built into the first web browser:</p>\n<p>&#8220;Only a handful of people know that the big missing feature from the web browser – the feature that was supposed to be in from the start but didn&#8217;t make it – is the ability to annotate any page on the Internet with commentary and additional information.&#8221;</p>\n<p>The implementation was pulled not too long after, because they didn&#8217;t have the capabilities required to host all the annotations and have it scale. For the past 24 years, various companies and organizations have taken a stab at bringing this feature back to the web &#8211; all with varying approaches that don&#8217;t necessarily play well together. That&#8217;s why the W3C standard is an important development.</p>\n<p>&#8220;While Hypothesis and others are already enabling annotation to take place over any page on the Web, a standard means that there is additional incentive for browser vendors to include this functionality natively,&#8221; Dan Whaley <a href=\"https://hypothes.is/blog/annotation-is-now-a-web-standard/\" target=\"_blank\">said</a>. &#8220;The more that these new collaborative layers are present without any additional action on the part of the user, the more their use will grow.&#8221;</p>\n<p>Whaley also said the new W3C standard should send a strong signal to those who have developed proprietary annotation implementations, such as Genius, Readcube, Medium, and Amazon (Kindle).</p>\n<p>&#8220;These technical recommendations have the weight of the web community behind them and can be relied upon,&#8221; Whaley said. &#8220;Our hope is that the standard will not only encourage others to adopt its technical approach, but also ultimately to open their platforms.&#8221;</p>\n<p>In an ideal world, Doug Schepers sees annotation as a feature that is &#8220;baked straight into the web,&#8221; where all users can choose where their content is published. Annotation services would then offer the ability for users to choose which syndicators and aggregators the content is going out to. Publishers in turn would have the ability to consume annotation content and bring it back through their commenting system if they feel it adds value.</p>\n<p>&#8220;We can refine things over time,&#8221; Schepers said. &#8220;We can improve our culture over time. It sounds kind of lofty and maybe sort of abstract, but I think that&#8217;s what annotations can help us do. It can actually increase the growth of ideas and not the suppression of ideas. It can improve how we create our culture in a more conscious way, in a way that includes more critical thinking.&#8221;</p>\n<p>Schepers said it&#8217;s too soon to know how the future will unfold for web annotations and whether or not browsers will be interested in supporting them natively. Annotations may be relegated to live in script libraries forever if they don&#8217;t catch on with browsers. Like any new layer of interaction on the web, it&#8217;s worth building to see how the initial idea evolves based on where the users take it.</p>\n<p>&#8220;I don&#8217;t know what&#8217;s going to happen with annotations,&#8221; Schepers said. &#8220;That&#8217;s what I&#8217;m excited by. I can think of all sorts of things that might happen with annotations if we truly enable this, but I&#8217;m more looking forward to the things that I didn&#8217;t see coming at all.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Mar 2017 23:02:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WPCampus 2017 to Take Place July 14-15 in Buffalo, NY\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/wpcampus-2017-to-take-place-july-14-15-in-buffalo-ny\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6398:\"<img />WPCampus Date\n<p><span class=\"st\">After the inaugural </span> WPCampus concluded <a href=\"https://2016.wpcampus.org/\">in 2016</a>, organizers <a href=\"https://wptavern.com/wpcampus-is-accepting-applications-to-host-the-event-in-2017\">put out a call</a> for campuses across the country to host the event in 2017. The WPCampus planning committee has <a href=\"https://2017.wpcampus.org/2017/02/23/announcing-second-annual-wpcampus-conference/\">announced</a> that <a href=\"https://2017.wpcampus.org/\">WPCampus 2017</a> will be held July 14-15, at <a href=\"https://2017.wpcampus.org/venue/\">Canisius College</a> in Buffalo, New York.</p>\n<p>In addition to announcing the date, the committee is accepting <a href=\"https://2017.wpcampus.org/call-for-speakers/\">speaker submissions</a> and <a href=\"https://2017.wpcampus.org/sponsors/\">looking for sponsors</a>. Speaker submissions will be accepted until March 24th, 2017.</p>\n<p>Rachel Carden, a Senior Software Engineer for Disney Interactive, came up with the idea for WPCampus in a Tweet published in August, 2015. Since then, the community has grown to more than 500 members.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Ooh. Dream with me: \"<a href=\"https://twitter.com/hashtag/WordCampus?src=hash\">#WordCampus</a>: A WordCamp for folks using <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> in Higher Education.\" I like it. <a href=\"https://twitter.com/hashtag/heweb?src=hash\">#heweb</a> <a href=\"https://t.co/m1zEkpkP4B\">https://t.co/m1zEkpkP4B</a></p>\n<p>&mdash; Rachel Carden (@bamadesigner) <a href=\"https://twitter.com/bamadesigner/status/628324358126235648\">August 3, 2015</a></p></blockquote>\n<p></p>\n<h2>Interview With Rachel Carden</h2>\n<p><strong>What did you learn from organizing the first WPCampus that will improve the second event?</strong></p>\n<p>Most of the lessons learned from WPCampus 2016 involved logistics. A brand new community planning a brand new event with very minimal people &#8216;on the ground&#8217; was challenging but, clearly, not impossible.</p>\n<p>Most of the changes we’ve implemented have been on how to make the time we spend planning more efficient, especially since we are an entirely volunteer-driven organization spread out all over the world.</p>\n<p>Overall, our first event was a success but there’s always little notes you take away for the next go round, like &#8216;make sure we take the group photo BEFORE everyone leaves&#8217; and highlighted at the top of the list: &#8216;make sure we have candy again.&#8217;</p>\n<p>Ultimately, our main priority is to ensure attendees aren’t worrying about the &#8216;where&#8217;, &#8216;what&#8217;, and &#8216;how&#8217; so they can instead focus on learning, networking, and making the most out of our short time together. This means taking notice of how we can improve communication, signage, etc.</p>\n<p>&#8216;The secret of all victory lies in the organization of the non-obvious&#8217; could not be more true. The biggest question we asked ourselves after WPCampus 2016 was &#8216;how can we create more opportunities for diverse interaction and discussion?&#8217;</p>\n<p>Our planning team has some great ideas and we’re excited to experiment a little, to see how a conference might be able to drive development outside the usual sessions and lightning talks. We’re really excited for what’s in store for our next event.</p>\n<p><strong>Will there be another WordPress in higher education survey?</strong></p>\n<p>I hope so! If not, it won’t be for lack of desire. Last <a href=\"https://wptavern.com/wpcampus-survey-results-indicate-misconceptions-of-wordpress-are-slowing-its-growth-in-higher-education\">year’s survey</a> offered an incredible amount of insight and data into how WordPress is being used in higher education. It would be great to see what has changed. Stay tuned!</p>\n<p><strong>Why was Canisius College chosen for the event?</strong></p>\n<p>We had some amazing universities apply and invite us all to their campus. An honor for which we are most grateful and appreciative. As was the case with WPCampus 2016, it was really hard to pick just one but ultimately, it comes down to what we believe is best overall for our attendees.</p>\n<p>We even have a grading matrix because, of course we do, we’re in higher education. Canisius College is a beautiful campus in a great location, especially since a majority of the WPCampus community is located in the eastern U.S. and Canada.</p>\n<p>The team at Canisius has also been extremely supportive and is working hard to make sure we have a great time in their top-notch facilities. Buffalo is also a great city with amazing architecture, food, and scenery that we’re excited to explore.</p>\n<h2>WPCampus Is Aiming for Sessions With a Variety of Perspectives</h2>\n<p>For a glimpse into what WPCampus <a href=\"https://2017.wpcampus.org/about/\">is all about</a>, check out these recaps from those who attended the event in 2016. You can also watch most of the sessions from the event via the <a href=\"https://2016.wpcampus.org/schedule/\">schedule page</a>.</p>\n<ul>\n<li><a href=\"https://calderawp.com/2016/07/wpcampus-2016-recap/\">WPCampus 2016 Recap</a></li>\n<li><a href=\"https://www.thewpcrowd.com/wordpress/wordcamps/wpcampus-2016/\">WPCampus 2016: WordPress in Higher Education</a></li>\n<li><a href=\"https://wpdistrict.sitelock.com/blog/wp-campus-a-wordpress-event-focused-on-higher-education/\">WPCampus – A WordPress Event Focused on Higher Education</a></li>\n<li><a href=\"http://davidbisset.com/wpcampus-review/\">WPCampus Review</a></li>\n</ul>\n<p>Registration is not yet available but will open soon.</p>\n<p>&#8220;We aim for our session topics to be a good mix of WordPress in higher ed as well as solely higher ed and solely WordPress,&#8221; Carden said.</p>\n<p>&#8220;We recognize the value and inspiration in all perspectives. We hope the general WordPress community, and other higher ed communities, will see the value in investing in WPCampus and its mission to advance higher education by lending their time, knowledge and experience.&#8221;</p>\n<p>To receive updates related to the event, you can follow <a href=\"https://twitter.com/wpcampusorg\">WPCampus</a> on Twitter or keep an eye on the <a href=\"https://2017.wpcampus.org/announcements/\">announcements page</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Mar 2017 17:24:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Henry Crown Fellowship\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://ma.tt/2017/03/henry-crown-fellowship/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:645:\"<p>I&#8217;m very excited to have been selected to join the <a href=\"http://agln.aspeninstitute.org/fellowships/henrycrown/classes/XXI\">Henry Crown Fellowship Class of 2017</a>. Many, many folks I admire including Reed Hastings, Kim Polese, Cory Booker, Aileen Lee, Stephen DeBerry, Deven Parekh, Chris Sacca, Tim Ferriss, Reid Hoffman, Scott Heiferman, Troy Carter, Bre Pettis, Lupe Fiasco, and Alexa von Tobel have been through the program in previous years, and several of those people have spoken highly of it to me. I&#8217;m excited to meet and get to know the rest of the 2017 class, and embark on a learning journey alongside them.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Mar 2017 16:27:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Do You Enjoy WordPress Meetups? Let the Community Marketing Team Know Why\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66806\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/do-you-enjoy-wordpress-meetups-let-the-community-marketing-team-know-why\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2722:\"<p>When Matt Mullenweg, co-founder of the WordPress project, delivers his annual <a href=\"https://ma.tt/2016/12/state-of-the-word-2016/\">State of The Word presentation</a>, he always gives props to meetup organizers and attendees. In 2016, there were 3,193 meetup events in 58 countries attended by 62,566 people. <a href=\"https://www.meetup.com/topics/wordpress/\">Meetups</a> are one of the cornerstones of the community and for many are the gateway to discovering WordPress.</p>\n<p>In an effort to raise awareness of the project and its community, the Community Marketing team, a subgroup of the <a href=\"https://make.wordpress.org/marketing/\">Marketing team</a>, is asking volunteers to <a href=\"https://make.wordpress.org/community/2017/03/01/meetup-video-testimonials-we-need-your-help/\">record video testimonials</a> at WordCamps and meetups in March and April. The team wants to hear stories from users on why they use WordPress and how they&#8217;ve benefited from attending meetups.</p>\n<p>Other questions to consider asking include:</p>\n<ul>\n<li>How long have you been using WordPress.</li>\n<li>What brought you to the Meetup?</li>\n<li>How has coming to this Meetup affected you?</li>\n</ul>\n<p>Videos should be 1-5 minutes in length and <a href=\"http://wordpress.tv/submit-video/\">uploaded to WordPress.tv</a> under the Testimonies category. Ideal recording conditions are a quiet room with decent lighting and good audio. Recordings can be planned or spontaneous and minimal post production editing is encouraged. Also consider making the videos more accessible by adding <a href=\"https://wordpress.tv/using-amara-org-to-caption-or-subtitle-a-wordpress-tv-video/\">captions and translations</a>.</p>\n<p>The idea has received positive feedback with meetup attendees and organizers stating their <a href=\"https://make.wordpress.org/community/2017/03/01/meetup-video-testimonials-we-need-your-help/#comment-23138\">intention to participate</a>. For an example on how to record WordPress testimonials, check out this video by Troy Dean where he interviews attendees at <a href=\"http://wordpress.tv/event/wordcamp-sunshine-coast-2016/\">WordCamp Sunshine Coast</a> 2016.</p>\n<div class=\"embed-wrap\"></div>\n<p>If there&#8217;s not a <a href=\"https://www.meetup.com/topics/wordpress/\">WordPress meetup</a> in your area, consider organizing one yourself using <a href=\"https://wptavern.com/guide-to-starting-and-maintaining-a-wordpress-meetup\">our guide</a>. For additional advice, I recommend this <a href=\"http://ithemes.com/publishing/run-wordpress-meetup/\">free ebook by iThemes</a> that includes interviews with several organizers who share their experience managing meetups.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Mar 2017 23:56:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WordPress.com Announces New Importer for Medium Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66836\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/wordpress-com-announces-new-importer-for-medium-posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6732:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/08/typewriter.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/4OURRGDU7Z\">Sergey Zolkin</a>\n<p>Medium started 2017 on uncertain footing, <a href=\"https://blog.medium.com/renewing-mediums-focus-98f374a960be#.xij39212w\" target=\"_blank\">laying off a third of its staff</a> in January after admitting that its ad-based business model was not working.</p>\n<p>&#8220;We had started scaling up the teams to sell and support products that were, at best, incremental improvements on the ad-driven publishing model, not the transformative model we were aiming for,&#8221; Medium CEO Ev Williams said. &#8220;To continue on this trajectory put us at risk — even if we were successful, business-wise — of becoming an extension of a broken system. Upon further reflection, it’s clear that the broken system is ad-driven media on the internet.&#8221;</p>\n<p>Williams said that Medium will be taking &#8220;a different, bolder approach&#8221; to this problem of driving payment for quality content but that &#8220;it is too soon to say exactly what this will look like.&#8221; Medium may be <a href=\"https://twitter.com/rrhoover/status/827340315681923072\" target=\"_blank\">experimenting with paid subscriptions</a> in the future, but the company has yet to articulate its next strategy for monetization.</p>\n<h3>WordPress.com Now Offers an Importer Tool for Medium</h3>\n<p>Publishers that don&#8217;t want to stick around for Medium&#8217;s next round of experimentation can now easily migrate to WordPress. Automattic <a href=\"https://en.blog.wordpress.com/2017/03/02/import-your-medium-posts-to-wordpress-com/\" target=\"_blank\">announced</a> a new Medium importer for WordPress.com today and the company also plans to make it available to self-hosted WordPress sites through Jetpack.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/03/wordpressdotcom-medium-importer.png?ssl=1\"><img /></a></p>\n<p>Medium users can export content to a zip file and then upload it into WordPress.com&#8217;s import tool. The import includes posts, tags, images, and videos and takes approximately 15 minutes to complete. Previously, Medium sites could be imported into WordPress using an RSS importer plugin, but there were significant drawbacks to this approach. WordPress.com&#8217;s importer tool takes this into account.</p>\n<p>&#8220;Using the provided RSS file from Medium&#8217;s export archive was not sufficient, because some of the post data, like embeds, is missing,&#8221; Automattic developer Marko Andrijašević said. &#8220;Because of that, we are combining the data available in RSS and exported HTML files to accurately reproduce the post&#8217;s content.&#8221;</p>\n<p>Medium hasn&#8217;t made it easy for publishers to leave with their full content and has changed the format of its exports multiple times in the past. Andrijašević said this is one of the reasons it took WordPress.com so long to add an importer, along with the fact that the provided data in the exported archive was not sufficient to import everything correctly.</p>\n<p>&#8220;We’ll have Jetpack support coming soon for self-hosted sites,&#8221; Andrijašević said. &#8220;One other workaround for self-hosted site owners would be to use the Medium importer on WordPress.com, and then generate a WXR (WordPress eXtended RSS) file with our exporter. The WXR can then be used with WordPress importer on any self-hosted site.&#8221;</p>\n<p>In addition to its uncertain future and unsightly permalinks, Medium gives users plenty of other reasons to be wary of the platform. <a href=\"https://www.buzzfeed.com/charliewarzel/when-you-launch-your-publication-the-same-day-medium-changes\" target=\"_blank\">Publishers were not notified in advance</a> about the company&#8217;s &#8220;renewed focus&#8221; and its plan to abandon the advertising model. Medium&#8217;s product is its users&#8217; content and the company&#8217;s <a href=\"https://medium.com/policy/medium-terms-of-service-9db0094a1e0f#.c309bw63n\" target=\"_blank\">terms of service</a> state that it can use that content to promote its own products and services, enable advertising, and &#8220;remove any content you post for any reason.&#8221;</p>\n<p>Part of the appeal of Medium is that it removes the burden of site management. Publishers are now expected to navigate things like AMP, FB Instant Articles, social networks, and SEO to drive traffic to their websites. With Medium, publishers are trading site ownership for convenience. If the company is not able to find a workable way to monetize users&#8217; content, it has a very real chance of joining the hundreds of <a href=\"https://indieweb.org/site-deaths\" target=\"_blank\">blogging silos that have died</a> or been bought by a competitor simply to be shut down and have their technology reabsorbed.</p>\n<p>Medium&#8217;s publishing experience is entirely geared towards making the company successful by monetizing the efforts of publishers on its network. In a post titled <a href=\"http://practicaltypography.com/billionaires-typewriter.html\" target=\"_blank\">The Billionaire&#8217;s Typewriter</a>, Matthew But­t­er­ick writes about how the platform&#8217;s limitations on features and customization are designed to &#8220;let Medium extract value from the talent and labor of others.&#8221; He describes digital sharecropping in its shiniest form:</p>\n<blockquote><p>Be­cause in re­turn for that snazzy de­sign, Medium needs you to relinquish con­trol of how your work gets to readers.</p>\n<p>Tempt­ing per­haps. But where does it lead? I fear that writ­ers who limit them­selves to pro­vid­ing “con­tent” for some­one else’s “branded plat­form” are go­ing to end up with as much lever­age as cows on a dairy farm.</p>\n<p>Medium is a new kind of type­writer—the bil­lion­aire’s type­writer. It’s not the only bil­lion­aire’s type­writer. So is the Kin­dle. So is iBooks. So is Twit­ter. <strong>What dis­tin­guishes these new type­writ­ers is not the pos­si­bil­i­ties they make available to writers, but what they take away.</strong></p></blockquote>\n<p>Publishers who want to determine the trajectory and reach of their own work need to migrate to a more stable platform where they have full control of their content. It&#8217;s not yet clear how Medium plans to monetize in the future, but the company will undoubtedly continue reaping the economic rewards of its publishers&#8217; work. Whether you choose open source software or some other avenue, it&#8217;s worth leaving Medium&#8217;s grand experiment in order to own your own work.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Mar 2017 22:10:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WPWeekly Episode 265 – Interview with Matt Medeiros\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=66822&preview=true&preview_id=66822\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wptavern.com/wpweekly-episode-265-interview-with-matt-medeiros\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3596:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://craftedbymatt.com/\">Matt Medeiros</a>, co-founder of <a href=\"http://slocumstudio.com/\">Slocum Studio</a>. Medeiros developed <a href=\"https://conductorplugin.com/\">Conductor</a>, a WordPress plugin that enables people to display content in blocks, similar to the approach that <a href=\"https://wptavern.com/wordpress-core-editor-team-publishes-ui-prototype-for-gutenberg-an-experimental-block-based-editor\">WordPress core is taking</a>. He shares his thoughts and opinions on core&#8217;s approach and how it might impact the content builder market.</p>\n<p>Since Medeiros co-founded Slocum Studio with his father, Mark Medeiros, we discover what it&#8217;s like to operate a web development agency with a family dynamic. Last but not least, he shares his experience in the <a href=\"https://slocumthemes.com/\">commercial theme market</a> and gives us a first-hand account of what it was like to go through the <a href=\"https://make.wordpress.org/themes/handbook/review/\">theme review process</a>. Based on the experience, Medeiros says he will not submit new themes to the directory.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/nextgen-gallery-patches-critical-sql-injection-vulnerability\">NextGEN Gallery Patches Critical SQL Injection Vulnerability</a><br />\n<a href=\"https://wptavern.com/amazon-s3-outage-hits-wordpress-businesses-disrupting-service-and-support\">Amazon S3 Outage Hits WordPress Businesses, Disrupting Services and Support</a><br />\n<a href=\"https://wptavern.com/freemius-launches-insights-for-wordpress-themes\">Freemius Launches Insights for WordPress Themes</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/woo-simple-ads-server/\">WooCommerce Simple Ads Server</a> lets you create ads and campaigns for selling your own WooCommerce products on other websites. It lists all of your WooCommerce products on the back-end with options to create and assign banners for each product. It also provides all the scripts and embed codes necessary for your banners.</p>\n<p><a href=\"https://wordpress.org/plugins/wp-keyword-monitor/\">WP Keyword Monitor</a> uses the official API from Google to track your organic keyword rankings. You can track up to 100 keywords per day. This plugin provides full reports and displays a running graph of your rankings and statistics over time.</p>\n<p><a href=\"https://wordpress.org/plugins/private-uploads/\">Private Uploads</a> protects sensitive uploaded files so that only logged-in users can access them. This plugin moves your designated private files to a separate folder and configures the web server to ask WordPress to authenticate access to files in that folder. It&#8217;s more efficient than similar plugins because it only rubs when serving files in the private folders.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, March 8th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #265:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Mar 2017 23:28:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"HeroPress: WordPress Opened Up a Whole New World\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1620\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://heropress.com/essays/wordpress-opened-whole-new-world/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10833:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/03/030117-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: If it hadn\'t been for WordPress, I would never have experience being part of an open-source community.\" /><h3>Before WordPress</h3>\n<p>Several years ago, I went through a tough time in my life. I lost my job and I was desperately in need of a career change. Because of the economic climate in Zimbabwe, I didn&#8217;t see many options, but I felt that IT held the most promising future.</p>\n<p>So I completed an A+ course and obtained a CCNA certification. Unfortunately, in Zimbabwe, skills and certifications were not enough to secure meaningful employment. Being a college drop-out, I didn&#8217;t have the required diploma or degree that employers were looking for.</p>\n<p>That&#8217;s when I enrolled in a diploma in management of information systems. In this course, there was a module called “Programming and Web Design”. I was introduced to HTML, CSS and Javascript, among other programming languages. But it was only an introduction… it wasn&#8217;t enough to be able to create my own website.</p>\n<p>After graduating, I studied online tutorials and learned how to create a website. That was the beginning of my personal website, franksweb.org, a static HTML website that I created from scratch.</p>\n<p>Not long after that, I was hired by an an online design and marketing firm that was looking for a web developer. To my surprise, I found that they only used content management systems (CMS) to create websites. No one was making static HTML websites!</p>\n<p>Joomla! was the preferred CMS at this company. It wasn&#8217;t until I was assigned to create a website for a local recording artist that I discovered WordPress. I was searching for templates that suited the client&#8217;s needs and discovered a template that just happened to be WordPress!</p>\n<p>I had heard of WordPress, even though they didn&#8217;t teach us about content management systems in my diploma course. All I knew was that WordPress was a free blogging service.</p>\n<blockquote><p>I had no idea how much more was possible using WordPress.</p></blockquote>\n<p>I soon discovered the numerous advantages of using WordPress over Joomla! (There&#8217;s a reason why 27% of the web uses WordPress, whereas Joomla! is used by only 3%!) Soon after, I re-designed franksweb.org using WordPress. So began my love affair with WordPress.</p>\n<h3>Freelancing</h3>\n<p>After having worked for my employer for a little over one and a half years, receiving a very small salary, the time came for me to move on. My employer had been failing to pay our salaries and owed me a lot of money in back pay (which has never been paid to me to this day). So I had no choice but to leave and I started freelancing.</p>\n<p>Since I started freelancing, all the websites I&#8217;ve created for my clients (except for one) have been WordPress sites. WordPress has empowered me to make a living from creating functional websites that are easy to manage for my clients.</p>\n<p>Here in Zimbabwe, very few web designers and web developers create static HTML websites. The majority use content management systems, and for good reason. Of course, the overwhelming majority are WordPress sites. This is just a testament to how WordPress makes our jobs easier and the potential to make money using WordPress.</p>\n<h3>The WordPress Community</h3>\n<p>One thing that we were taught in my diploma course was the importance of continuous professional development (CPD). That, and the fact that I had a genuine passion for all things WordPress, led me to soak up anything WordPress-related that I could get my hands on. I watched a lot of Morten Rand-Hendriksen&#8217;s tutorials on lynda.com to advance my skills. The WordPress.org website became a permanent tab on my desktop whenever you opened my web browser (my “WordPress Bible”). I also made sure the “WordPress News” box was always open in all my Dashboards so I could keep up with the latest in WordPress.</p>\n<p>One day I saw a <a href=\"https://wptavern.com/\" target=\"_blank\">WPTavern</a> article in my Dashboard calling for applications to participate in the first WordCamp incubator program. I was very interested since Zimbabwe had never had a WordCamp before. I didn’t know of anyone else in Harare who had the same desire but I applied anyway.</p>\n<p>More than a hundred cities applied so I honestly wasn’t expecting my application to be chosen, especially because of the challenges that my country is facing.</p>\n<blockquote><p>I was shocked when I got an email from Rocio Valdivia and Hugh Lashbrooke saying they wanted to interview me for the incubator program.</p></blockquote>\n<p>Later on, I received an email from Andrea Middleton saying my application to be a WordCamp organizer had been accepted! This was a very exciting time for me. It was now going to be possible to experience the things I had read about the WordPress Community here in Zimbabwe, too.</p>\n<a href=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/03/meetup_at_CSZ-min.jpeg\"><img class=\"size-large wp-image-1627\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/03/meetup_at_CSZ-min-1024x576.jpeg\" alt=\"First meetup at the Computer Society of Zimbabwe, August 20, 2016\" width=\"960\" height=\"540\" /></a>First meetup at the Computer Society of Zimbabwe, August 20, 2016\n<p>The first thing that I needed to do was start a monthly WordPress meetup group in Harare because there was no regular meetup that I was aware of, and therefore no real WordPress Community. It was a struggle but thanks to the guidance and support of WordCamp Central, and the support of the <a href=\"http://www.csz.org.zw/\" target=\"_blank\">Computer Society of Zimbabwe</a>, we were able to have meetups and the membership grew.</p>\n<blockquote><p>Months later, we hosted the very first WordCamp in Zimbabwe: WordCamp Harare 2016.</p></blockquote>\n<p>It was a success and much better than I thought it would be. Along with our monthly meetups, WordCamp did a lot to promote awareness of the WordPress Community. Since then, quite a number of local WordPress users have become active in the WordPress Community. I absolutely love hosting meetups and sharing knowledge about something which I am passionate about.</p>\n<a href=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/03/wordcamp_at_harare_city_library-min.jpg\"><img class=\"size-large wp-image-1628\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/03/wordcamp_at_harare_city_library-min-1024x678.jpg\" alt=\"First WordCamp Harare at Harare City Library\" width=\"960\" height=\"636\" /></a>First WordCamp Harare at Harare City Library\n<p>On a personal level, working with the WordPress Community opened up a world that I didn&#8217;t know existed within WordPress. I got to know so many amazing people and everyone has been helpful and kind. The WordPress Community is made up of people who are generous and willing to give their time and share knowledge with others. For me, it is very fulfilling to be able to give back to something which I have benefited from so much.</p>\n<p>One of the highlights of WordCamp for me was meeting Job Thomas and Herman Kok, two of our speakers who came from South Africa. They both work for <a href=\"https://automattic.com/\" target=\"_blank\">Automattic</a>, the company that owns WordPress.com, WooCommerce, Jetpack and other WordPress-related products. (Before I became active in the WordPress Community, I had no idea Automattic had an office in South Africa!) Talking to them, I got a strong sense that they were passionate, not only about what they do, but about sharing their knowledge and experience with others.</p>\n<p>I was encouraged and inspired to apply to work for Automattic. The position that I wish to apply for is called “Happiness Engineer”. Basically, your job is customer support. For me, this is a dream job: getting paid to do something that I have a passion for which is share my knowledge of WordPress with others. They say that if you find something that you love to do, you&#8217;ll never work another day in your life. So currently, I spend time helping other users in Automattic product forums in order to gain more direct experience before I apply.</p>\n<p>This past year has been an awesome journey for me. If it wasn&#8217;t for WordPress, I would never have experienced being part of an open-source community and the doors that have opened for me. There are so many awesome people that I never would have gotten to know. WordPress truly changed my life.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: WordPress Opened Up a Whole New World\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=WordPress%20Opened%20Up%20a%20Whole%20New%20World&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-opened-whole-new-world%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: WordPress Opened Up a Whole New World\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-opened-whole-new-world%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fwordpress-opened-whole-new-world%2F&title=WordPress+Opened+Up+a+Whole+New+World\" rel=\"nofollow\" target=\"_blank\" title=\"Share: WordPress Opened Up a Whole New World\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/wordpress-opened-whole-new-world/&media=https://heropress.com/wp-content/uploads/2017/03/030117-150x150.jpg&description=WordPress Opened Up a Whole New World\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: WordPress Opened Up a Whole New World\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/wordpress-opened-whole-new-world/\" title=\"WordPress Opened Up a Whole New World\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/wordpress-opened-whole-new-world/\">WordPress Opened Up a Whole New World</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Mar 2017 12:00:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Thabo Tswana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: HackerOne Launches Free Community Edition for Non-Commercial Open Source Projects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66592\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/hackerone-launches-free-community-edition-for-non-commercial-open-source-projects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5076:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/hackerone-logo.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://www.hackerone.com\" target=\"_blank\">HackerOne</a>, the vulnerability coordination and bug bounty platform, has launched a new <a href=\"https://www.hackerone.com/product/community\" target=\"_blank\">Community Edition</a> for open source projects. The company is built around the notion that, &#8220;given enough eyeballs, all vulnerabilities are shallow.&#8221; HackerOne announced a <a href=\"https://www.hackerone.com/blog/The-best-security-initiative-you-can-take-in-2017\" target=\"_blank\">$40 million round of funding</a> earlier this month, which allows the company to expand its market and add new features to the platform.</p>\n<p>Open source projects are one area where HackerOne is expanding its reach. The company participates in the <a href=\"https://internetbugbounty.org/\" target=\"_blank\">Internet Bug Bounty</a> program, which helps secure core internet infrastructure and open source software, but HackerOne is now opening up its own platform.</p>\n<p>&#8220;One of the goals I have had in my work with HackerOne is to build an even closer bridge between HackerOne and the open source community,&#8221; community strategy consultant Jono Bacon said. Bacon <a href=\"http://www.jonobacon.org/2017/02/09/hackerone-professional-free-open-source-projects/\" target=\"_blank\">announced</a> the availability of HackerOne&#8217;s new <a href=\"https://www.hackerone.com/product/community\" target=\"_blank\">Community Edition</a>, which has not yet been formally announced but is already open for applicants.</p>\n<p>The Community Edition has all the same features as HackerOne&#8217;s Professional Edition, including vulnerability submission/coordination, duplicate detection, hacker reputation, analytics, and more. The only difference is that it doesn&#8217;t include paid customer support and program assistance. It also integrates with many popular issue tracking tools, such as JIRA, GitHub, Bugzilla, Zendesk, Track, and others.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/hackerone-community-edition.png?ssl=1\"><img /></a></p>\n<p>Although the name &#8220;Community Edition&#8221; might suggest to some that it is self-hosted, HackerOne actually provides it as a SaaS offering with no setup or deployment required.</p>\n<p>Open source projects are eligible if they meet a few requirements:</p>\n<ul>\n<li>Must be open source projects covered by an <a href=\"https://opensource.org/licenses\" target=\"_blank\">OSI license</a></li>\n<li>Be active and at least 3 months old (age is defined by shipped releases/code contributions)</li>\n<li>Include a SECURITY.md in the project root that provides details for how to submit vulnerabilities (<a href=\"https://github.com/discourse/discourse/blob/master/docs/SECURITY.md\" target=\"_blank\">example</a>)</li>\n<li>Display a link to your HackerOne profile from either the primary or secondary navigation on the project&#8217;s website</li>\n<li>Maintain an initial response to new reports of less than a week</li>\n</ul>\n<p>WordPress doesn&#8217;t have its own listing in the HackerOne directory but <a href=\"https://hackerone.com/automattic\" target=\"_blank\">Automattic&#8217;s page</a> says the company also welcomes reports for WordPress, BuddyPress, and bbPress. Automattic has had 446 bugs resolved through its program on HackerOne, which it has maintained for the past three years. A handful of other WordPress-related projects are also listed in the directory, including the <a href=\"https://hackerone.com/wordpoints\" target=\"_blank\">WordPoints</a> plugin, <a href=\"https://hackerone.com/iandunn-projects\" target=\"_blank\">Ian Dunn&#8217;s projects</a>, and <a href=\"https://hackerone.com/flox\" target=\"_blank\">Flox</a>.</p>\n<p>Having a crowd-sourced security program in place is becoming more critical, as breeches are costing companies billions of dollars every year. The World Economic Forum&#8217;s <a href=\"http://www3.weforum.org/docs/GRR/WEF_GRR16.pdf\" target=\"_blank\">2016 Global Risks Report</a> estimated that &#8220;crimes in cyberspace cost the global economy an estimated $445 billion.&#8221;</p>\n<p>Not all organizations listed on HackerOne offer bug bounties, but bounties are a proven method of attracting security talent. Since HackerOne launched, its customers have resolved more than 37,000 vulnerabilities and have paid out more than $13 million in bug bounties. By the end of 2016, HackerOne&#8217;s community of hackers had grown to nearly 100,000.</p>\n<p>The new <a href=\"https://www.hackerone.com/product/community\" target=\"_blank\">Community Edition</a> gives smaller open source projects and organizations exposure to HackerOne&#8217;s network of thousands of security researchers and the tools for managing communication about vulnerabilities. Projects applying for the Community Edition must be non-commercial and able to run an effective security program. Applications are usually answered within one business week.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Mar 2017 04:56:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: Freemius Launches Insights for WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66740\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/freemius-launches-insights-for-wordpress-themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8722:\"<p>Freemius Insights <a href=\"https://freemius.com/blog/freemius-insights-wordpress-themes/\">has announced</a> that its <a href=\"https://freemius.com/\">analytics service</a> that was previously <a href=\"https://wptavern.com/freemius-insights-enables-plugin-developers-to-make-data-driven-decisions\">only available to WordPress plugins</a> is now available for themes. The company was founded in 2015 by <a href=\"https://twitter.com/vovafeldman\">Vova Feldman</a> and his team after discovering how much information is not available to developers who host plugins and themes on the official WordPress directories and marketplaces.</p>\n<img />Freemius Insights for Themes\n<p>Freemius Insights for themes gives developers an opportunity to collect a large variety of data, including, email addresses, PHP, plugin, WordPress version distribution, and more. When a user installs a theme that uses Freemius, an opt-in prompt is displayed that notifies them that data will be sent to Freemius.com to help improve the product. Selecting Skip prevents data from reaching Freemius.com.</p>\n<img />Freemius Opt-in Prompt\n<p>Feldman says that he and his team have worked closely with the <a href=\"https://make.wordpress.org/themes/\">WordPress Theme Review Team</a> to ensure that Freemius Insights does not violate the theme directory <a href=\"https://make.wordpress.org/themes/handbook/review/required/\">requirements.</a> One of the most informative features that Freemius Insights provides is the ability for users to provide feedback if they decide to switch to a different theme.</p>\n<p>When a user switches away from a product using Freemius, a prompt is shown with randomly displayed questions asking for feedback. These responses are saved and can be viewed at a later time in the Freemius dashboard. If a user switches themes because it doesn&#8217;t have a specific feature and it&#8217;s added at some point, a developer can go back and notify them that the feature exists.</p>\n<h2>Data Collection Leads to Description, Settings, and Documentation Improvements for FooBox</h2>\n<p>Adam Warner, Co-founder of <a href=\"https://fooplugins.com\">FooPlugins.com</a>, added Freemius Insights to <a href=\"https://wordpress.org/plugins/foobox-image-lightbox/\">FooBox</a>, an image lightbox plugin after noticing that other plugins were collecting opt-in usage data. His team realized they needed the data but didn&#8217;t have the resources to build a custom solution in a reasonable amount of time.</p>\n<p>Warner shares what he discovered with the data collected by Freemius. &#8220;Install, uninstall, deactivation, and feedback data is some of the most important data we&#8217;ve obtained,&#8221; he responded.</p>\n<p>&#8220;Not long after we discovered that of those who deactivated the plugin, the two top reasons were &#8216;expected something else&#8217; and &#8216;didn&#8217;t understand how it works.&#8217; That is valuable insight that we might not have had otherwise and allowed us to revamp our plugin description on .org and in the plugin settings.&#8221;</p>\n<p>One of the main reasons for collecting data is to improve the product. Based on the data collected, improvements to FooBox were geared towards documentation and the plugin&#8217;s settings pages, &#8220;After learning from the insights that Freemius provided us, we wrote longer explanations of various settings and what they do, as well as putting in links to documentation and video walkthroughs,&#8221; he said.</p>\n<h2>Freemius Usage Data Ramps Up Priority for NextGEN Gallery Wizard</h2>\n<p>NextGEN Gallery is Freemius&#8217; most popular plugin tracked so I asked Erick Danzer, Founder and CEO of Imagely, makers of NextGEN Gallery, what his team has learned and if any improvements are a direct result of the data collected.</p>\n<p>Since adding Freemius to NextGEN Gallery, the opt-in form has been exposed to about 200K new users. Out of these, 37.5% or 75K users have opted to submit data.</p>\n<p>&#8220;We&#8217;ve learned that 21% of users deactivate or uninstall the plugin entirely,&#8221; Danzer said. &#8220;Conversely, that means we have about a 79% retention rate. It&#8217;s hard to know how that compares to the WordPress ecosystem as a whole, but our sense is that retention rate is not bad (even if we&#8217;d like it to be better). I&#8217;d love to see comparative data across other plugins at some point.&#8221;</p>\n<p>Of those who uninstall the plugin, 20% which is the largest share, do so because they don&#8217;t understand how it works, &#8220;This wasn&#8217;t a surprise. We know that NextGEN Gallery is powerful and thus overwhelming to some users,&#8221; Danzer said. &#8220;But this is the first time we&#8217;ve been able to put actual numbers on that behavior.&#8221;</p>\n<p>Some of the biggest improvements to NextGEN Gallery that are a result of the data that&#8217;s been collected deal with the user interface. &#8220;We now know that 21% of users uninstall and that the biggest reason is too much complexity getting started,&#8221; Danzer said. &#8220;That tells us that if we want to improve our retention rate, we need to make it easier to start.&#8221;</p>\n<p>&#8220;To that end, we&#8217;ve done two things. First, we just released a start-up Gallery Wizard late last fall that walks new users through the process of setting up their first gallery. Second, we&#8217;re about 70% done with an overhaul of the interface to simplify the presentation of options. These are both things we probably would have done anyways, but we upped their priority based on Freemius data.&#8221;</p>\n<h2>Data From Freemius Insights Points to a Common Dead-end With Plugins</h2>\n<p>For more than a year, Freemius Insights has been collecting mountains of data for plugins. Feldman was gracious enough to supply the Tavern with some interesting data. There are more than 750 developers registered to the site and more than 400K users have opted-in to usage tracking. <a href=\"https://wordpress.org/plugins/nextgen-gallery/\">NextGEN Gallery</a> is the service&#8217;s most popular tracked plugin active on more than 1.5M sites.</p>\n<p>Out of the plugins tracked, there have been 114K feedback responses on why users deactivated a plugin. The top five reasons plugins were deactivated are:</p>\n<ul>\n<ul>\n<li>23% Expected something else / didn&#8217;t work as expected</li>\n<li>21% Didn&#8217;t understand how it works</li>\n<li>20% No longer needed</li>\n<li>13% Found a better alternative</li>\n<li>6% Didn’t work</li>\n</ul>\n</ul>\n<p>The most interesting aspect of this data is the second most popular reason why users deactivate a plugin. When users activate a plugin, many don&#8217;t know what the next step is. It could be searching for a link to the settings page or not doing anything at all. Most of the time, users have no idea because the plugin doesn&#8217;t tell them.</p>\n<p><a href=\"https://wordpress.org/plugins/woocommerce/\">WooCommerce</a> is a good example of a plugin that bucks this trend with an <a href=\"https://docs.woocommerce.com/document/woocommerce-onboarding-wizard/\">onboarding wizard</a> that when completed, puts users in a place where they can immediately start selling products.</p>\n<img />WooCommerce Onboarding Wizard\n<p>Not every plugin is as complex as WooCommerce and doesn&#8217;t need a onboarding wizard. For these use cases, developers might consider using <a href=\"https://code.tutsplus.com/articles/integrating-with-wordpress-ui-admin-pointers--wp-26853\">Admin Pointers</a>, a feature that was added in WordPress 3.3. With Admin Pointers you can inform users about a new feature or provide further instructions after a plugin is activated.</p>\n<p>Insights for Themes is free for non-commercial themes however, only two weeks of historical aggregated metrics and the 100 most recent user emails will be collected. In exchange for aggregating the data, Freemius asks that a symbolic attribution that &#8216;freemius&#8217; is a contributor be added to the theme&#8217;s readme.txt file. No email exports or webhooks are included with the free plan.</p>\n<p>Freemius is an example of a service that is filling a huge void of nonexistent data from WordPress.org for plugin and theme authors. A void that <a href=\"https://wptavern.com/solving-the-mystery-of-how-people-actually-use-wordpress\">doesn&#8217;t appear likely</a> to be filled anytime soon. As noted above, the data that is collected, especially direct feedback from users, has surfaced issues that may not have otherwise been discovered.</p>\n<p>If you use Freemius Insights in your plugins or themes, please tell us about your experience and what you&#8217;ve learned from the collected data.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Feb 2017 22:43:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Amazon S3 Outage Hits WordPress Businesses, Disrupting Services and Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66751\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/amazon-s3-outage-hits-wordpress-businesses-disrupting-service-and-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5853:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/Amazon_Web_Services_logo_AWS.jpg?ssl=1\"><img /></a></p>\n<p>Amazon is currently experiencing &#8220;high error rates with S3 in US-EAST-1,&#8221; causing a massive outage for sites, apps, and services across the web. The <a href=\"https://status.aws.amazon.com/\" target=\"_blank\">AWS service health dashboard</a> was also temporarily affected by the outage. Amazon says it is working at repairing S3 and that they believe they have identified the root cause.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/awscloud\">@awscloud</a> Care to share the architecture of this status page as an anti-pattern?</p>\n<p>&mdash; Thorben Heins (@thorbenheins) <a href=\"https://twitter.com/thorbenheins/status/836657580382502912\">February 28, 2017</a></p></blockquote>\n<p></p>\n<p>The outage is affecting many popular sites, such as Quora, Netflix, Splitwise, Business Insider, Giphy, Trello, IFTTT, many publishers&#8217; image hosting, filesharing in Slack, and the Docker Registry Hub.</p>\n<p>WordPress businesses are also currently affected, especially those that host customer downloads. WooCommerce customers are currently unable to access downloads they purchased. Similarly Envato customers are having difficulty accessing downloads and content.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Yes, we are affected by <a href=\"https://twitter.com/hashtag/AWS?src=hash\">#AWS</a> <a href=\"https://twitter.com/hashtag/S3?src=hash\">#S3</a> outage too. S3 is having a snag right now&#8230;. Quora, Slack, Envato and millions more are suffering&#8230;</p>\n<p>&mdash; WPBakery (@wpbakery) <a href=\"https://twitter.com/wpbakery/status/836663834437955584\">February 28, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">We\'re aware of issues with functionality of the <a href=\"https://t.co/dGuVluPt9A\">https://t.co/dGuVluPt9A</a> site, such as My Downloads. This is related to the <a href=\"https://twitter.com/awscloud\">@awscloud</a> outage</p>\n<p>&mdash; WooCommerce (@WooCommerce) <a href=\"https://twitter.com/WooCommerce/status/836663491805216768\">February 28, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Amazon S3 has identified high error rate issue that\'s impacting the Envato Market specifically our downloads and content. We are monitoring!</p>\n<p>&mdash; Envato Help (@envato_help) <a href=\"https://twitter.com/envato_help/status/836653583428771840\">February 28, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Downloading and updating our premium plugins is possible again, after a short downtime due to problems at S3. Sorry for the inconvenience!</p>\n<p>&mdash; Yoast (@yoast) <a href=\"https://twitter.com/yoast/status/836684468513558529\">February 28, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Due to the AWS outage, we are experiencing problems with sales, support, and development.  Please accept our apologies&#8230;we\'ll be back soon!</p>\n<p>&mdash; WP Ninjas, LLC (@wpninjas) <a href=\"https://twitter.com/wpninjas/status/836662320088539136\">February 28, 2017</a></p></blockquote>\n<p></p>\n<p>Joost de Valk, CEO and founder of <a href=\"https://yoast.com/\" target=\"_blank\">Yoast</a>, said the company experienced minor effects from the outage but has already been planning on switching from S3 to a new storage provider.</p>\n<p>“The outage doesn’t seem to have affected our revenue much,&#8221; de Valk said. &#8220;It was slightly annoying and led to some images not working and people not being able to download their plugins for a while, which is always a shame. However, not directly related to this, we’re already looking at ditching S3. That&#8217;s because our new hosting setup at SiteGround combined with CDN from MaxCDN actually negates the need for S3 entirely.&#8221;</p>\n<p>Other companies that have AWS integrated into their support services experienced more disruption due to customers not being able to receive help.</p>\n<p>&#8220;Obviously our website is hosted using AWS technology through Pagely,&#8221; <a href=\"http://wpninjas.com/\" target=\"_blank\">WP Ninjas</a> co-founder James Laws said. &#8220;I’m not sure how they’ve been affected directly, but we have noticed intermittent downtime. Perhaps the biggest impact is that our support service is built on AWS and with it down we are completely unable to provide any support to our users.&#8221;</p>\n<p>Laws said the company has had fairly decent uptime with AWS in the past and that the idea of switching services because of an outage would not be worth the effort.</p>\n<p>&#8220;The truth is that 100% uptime is more a fantasy than anything,&#8221; Laws said. &#8220;The idea of having to move a website or change a support system temporarily or even permanently for a short period of downtime would be pretty daunting. You probably could create contingency plans for something like this, but the technical and administrative costs are not generally worth it in my opinion.&#8221;</p>\n<p>The outage serves as a painful reminder of how dependent the web is on cloud storage providers and how few services have a backup plan for instances like these.</p>\n<p>At 12:52 PM PST Amazon released an update, promising improvements for customers within the hour: &#8220;We are seeing recovery for S3 object retrievals, listing and deletions. We continue to work on recovery for adding new objects to S3 and expect to start seeing improved error rates within the hour.&#8221; The ability to retrieve, list, and delete was fully recovered within half an hour and Amazon continues to work on fixing the ability to add new objects to S3.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Feb 2017 21:54:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Donncha: Coming up in WP Super Cache 1.5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://odd.blog/?p=89500157\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://odd.blog/2017/02/28/coming-up-in-wp-super-cache-1-5-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5618:\"<p>The next version of WP Super Cache will be one with some big changes! There are many small bug fixes and improvements but the one I&#8217;m most excited about is moving the legacy cache files into the supercache directory.</p>\n<p>The legacy cache files were the files created by the old WP-Cache plugin upon which this plugin is based. They&#8217;re really useful as they store the headers sent from the server as well as the page contents. If you&#8217;re serving pages that aren&#8217;t regular html, such as JSON or XML you don&#8217;t want to tell the browser they&#8217;re text/html documents. This caching method is also used for anyone who is logged into your site, or left a comment.<br />\nThere is a problem however. They&#8217;re stored in one directory. If you have many thousands of visitors interacting with your site you may end up with a directory containing thousands of files. The names of the cache files are a hash of the URL, gzip support and browser cookies so one file can match one user, or one file can be used by thousands of anonymous users. In the event that someone left a comment on a popular post the plugin has to search through all those files looking for the pages cached for other users who were also looking at that page. On a busy server that can cause problems.</p>\n<p>So, in <a href=\"https://github.com/Automattic/wp-super-cache/pull/177\">#177</a> I added code that moves the legacy cache files into the supercache directory. That means the files are stored in directories that reflect the URL of the page that was served which makes it very easy to delete the cached files belonging to that page as they&#8217;re all in the same directory!</p>\n<p>The new code will look in the old location for legacy files first as some sites will have a large collection of cached files, but any new cache files will be created in the supercache directory.</p>\n<p>Ian Dunn <a href=\"https://github.com/Automattic/wp-super-cache/pull/121\">submitted code</a> to cache the REST API. It&#8217;s not yet complete but we&#8217;ll be able to build on the changes to the legacy cache to make caching the API more efficient than it would have been before.</p>\n<p>I really need people to help test this. The latest code is running on this site so I&#8217;m very confident in how well it works but just because it works on my odd little server doesn&#8217;t mean it will work right everywhere. If you want to give it a spin, visit <a href=\"https://github.com/Automattic/wp-super-cache\">the plugin Github repository</a> and click on the &#8220;Clone or download&#8221; button. If you don&#8217;t know how to clone a Git respository just grab the zip file and install it on your server, overwriting the files in the plugins/wp-super-cache/ directory. If the changes to where cache files go doesn&#8217;t interest you, some of the changes in this list might:</p>\n<ul>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/commit/b654bcf6d75655e386f22c2fcbad19272b0d75cd\">Don’t output broken warning in robots.txt</li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/commit/8b63d5d97f246ba4d442e7b5d32a4d08fce4fd22\">Use get_home_url() instead of siteurl because some sites have different homepages</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/176\">Remove most calls to get_all_supercache_filenames()</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/145\">Fix bottom border in admin</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/199\">Use plugins_url() so https links work</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/55\">Preload from the newest post</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/101\">Stop caching of wp-admin visits sooner</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/177\">Store legacy cache files in the supercache directories</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/100\">Make the headers more informative to tell how a page was served</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/90\">Properly serve 304 requests</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/188\">Apply realpath to filenames because of Windows oddities</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/127\">Don&#8217;t flush(), output buffers don&#8217;t like it</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/194\">Add more file checks around wp_cache_rebuild_or_delete()</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/191\">If HTTP_HOST is not defined then disable caching</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/190\">Only show html comments on html pages</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/issues/184\">Fix caching of mobile requests</a></li>\n<li><a href=\"https://github.com/Automattic/wp-super-cache/pull/61\">Clear the cache for private posts</a></li>\n</ul>\n\n<p><strong>Related Posts</strong><ul><li> <a href=\"https://odd.blog/2008/10/24/wp-super-cache-084-the-garbage-collector/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.8.4, the garbage collector\">WP Super Cache 0.8.4, the garbage collector</a></li><li> <a href=\"https://odd.blog/2009/01/09/wp-super-cache-087/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.8.7\">WP Super Cache 0.8.7</a></li><li> <a href=\"https://odd.blog/2010/02/08/wp-super-cache-099/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.9.9\">WP Super Cache 0.9.9</a></li></ul></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Feb 2017 15:05:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Donncha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: NextGEN Gallery Patches Critical SQL Injection Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66611\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/nextgen-gallery-patches-critical-sql-injection-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2804:\"<p><a href=\"https://blog.sucuri.net/author/slavco/\">Slavco Mihajloski</a>, security researcher at <a href=\"https://sucuri.net/\">Sucuri</a>, <a href=\"https://blog.sucuri.net/2017/02/sql-injection-vulnerability-nextgen-gallery-wordpress.html\">has discovered</a> a critical SQL injection vulnerability in <a href=\"https://wordpress.org/plugins/nextgen-gallery/\">NextGEN Gallery</a>, a popular WordPress plugin that&#8217;s active on more than a million sites.</p>\n<p>Mihajloski gives the vulnerability a 9 out of 10 on Sucuri&#8217;s DREAD scale. Dread stands for Damage, Reproducibility, Exploitability, Affected Users, and Discoverability.</p>\n<p>Each category receives a score between 0 and 10. The <a href=\"https://blog.sucuri.net/2015/03/understanding-wordpress-plugin-vulnerabilities.html\">DREAD score</a> is obtained by adding the totals from each category and then dividing by five. The higher the score, the more severe the vulnerability.</p>\n<p>The SQL injection vulnerability affects NextGEN Gallery versions 2.1.77 and below. Version 2.1.79 is patched and was released four days ago. Those who use NextGEN basic tagcloud gallery or allow visitors to submit posts to be reviewed by contributors are especially at risk.</p>\n<p>&#8220;This vulnerability allows an unauthenticated user to grab data from the victim’s website database, including sensitive user information,&#8221; Mihajloski said.</p>\n<p>&#8220;This issue existed because NextGEN Gallery allowed improperly sanitized user input in a WordPress prepared SQL query, which is basically the same as adding user input inside a raw SQL query. Using this attack vector, an attacker could leak hashed passwords and WordPress secret keys, in certain configurations.&#8221;</p>\n<p>Although 2.1.79 patches the vulnerability, the <a href=\"https://wordpress.org/plugins/nextgen-gallery/changelog/\">plugin&#8217;s changelog</a> doesn&#8217;t indicate a critical security issue was fixed. Eric Danzer, Founder and CEO of Imagely, makers of NextGEN Gallery, <a href=\"https://twitter.com/ErickDanzer/status/836315264002232321\">explained on Twitter</a> why it&#8217;s not mentioned in the changelog.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/perezbox\">@perezbox</a> <a href=\"https://twitter.com/jeffr0\">@jeffr0</a> We just wanted updates underway before drawing attention. We\'ll update changelog for accuracy in a subsequent release.</p>\n<p>&mdash; Erick Danzer (@ErickDanzer) <a href=\"https://twitter.com/ErickDanzer/status/836315264002232321\">February 27, 2017</a></p></blockquote>\n<p></p>\n<p>Users are strongly encouraged to update <a href=\"https://wordpress.org/plugins/nextgen-gallery/\">NextGEN Gallery</a> to version 2.1.79 as soon as possible.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Feb 2017 23:05:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"WPTavern: Linus Torvalds Shares Lessons from 25 Years of Open Source Project Maintainership, Decries Tech Innovation Hype\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66408\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"https://wptavern.com/linus-torvalds-shares-lessons-from-25-years-of-open-source-project-maintainership-decries-tech-innovation-hype\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6230:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/linus-torvalds-open-source-summit.png?ssl=1\"><img /></a></p>\n<p>Linux creator Linus Torvalds joined Jim Zemlin, executive director of the Linux Foundation, on stage at the <a href=\"http://events.linuxfoundation.org/events/open-source-leadership-summit\" target=\"_blank\">Open Source Leadership Summit</a> for a candid conversation on maintaining open source projects. After 25 years of maintaining the Linux kernal, Torvalds has developed a network of trust that enables the project to iterate quickly with its 2.5 month release cycle.</p>\n<p>The current pace of Linux development sees 10K lines of code added, 8K lines subtracted, and 1800 lines modified every single day. Torvalds described how Linux contributors learned to modularize the code and development model so they can accomplish more in parallel, while working independently. He used to read through all the patches but quickly found himself becoming a bottleneck to progress. Ensuring code quality on the project is no longer about micromanaging all the patches but about finding the people Torvalds can trust.</p>\n<p>&#8220;We have a very strong network and that&#8217;s why we can have 1,000 people involved in every release,&#8221; Torvalds said. &#8220;There&#8217;s this whole human potential there that we use very extensively to make sure the process works. And it&#8217;s taken 25 years to get to where we are on a process level, too.&#8221;</p>\n<p>Torvalds described how the project revolves around individual contributors building a trusted reputation with maintainers and how one moves from casual contributor status to become part of the network of trust.</p>\n<p>&#8220;When people move between companies, the trust does not stay with the company,&#8221; Torvalds said. &#8220;The trust stays with the person. Obviously people do not stay around forever. People come and go. One of the reasons people sometimes think it&#8217;s hard to get into the kernel, is because you think you can just come in and shoot off a patch and go away, but that&#8217;s not how it works. What really takes time is to shoot off a lot of small patches until you reach the point where the maintainers trust you and at that point you have become something more than the guy who sends patches. You&#8217;ve become part of the whole network of trust.&#8221;</p>\n<p>Increasing levels of trust among contributors allows maintainers to oversee a rapid pace of development. Ten years ago, when Torvalds wanted to move an 8-week release schedule, he said everyone knew he was pushing for something unrealistically short. They have been cranking out releases every 2.5 months since then and Torvalds said it &#8220;solved so many things we didn&#8217;t even know needed to be solved.&#8221; Linux maintainers found their way to a successful development model by experimenting until it clicked.</p>\n<p>&#8220;If you want to do something new, something that is really pushing the envelope, nobody can really say &#8216;This is the way to do it,\'&#8221; Torvalds said. &#8220;What you need to do is a lot of trial and error. I often compare software development to biological processes where really it is evolution. It is not intelligent design. I&#8217;m there in the middle of the thing and I can tell you, it is absolutely not intelligent design. You have a lot of people with ideas of where things need to go and then you need to have a marketplace where you can try them out. And that&#8217;s what open source allows &#8211; all these different groups to go off, do their own thing, and then come back and say I did this, and it actually worked.&#8221;</p>\n<p>Zemlin asked him if he ever experienced an &#8220;a-ha moment&#8221; where he realized that Linux was much bigger than what he thought he started. Torvalds said that although a couple of moments have taken him by surprise, the biggest moment was six months after releasing it when it went past being a personal project. He suddenly didn&#8217;t even know the people sending him patches. Twenty five years later, it&#8217;s the people doing the work who still inspire him.</p>\n<p>&#8220;I&#8217;m a huge believer in the 99% perspiration, 1% inspiration thing,&#8221; Torvalds said. &#8220;The innovation that this industry talks about so much is bullshit. Anybody can innovate. Don&#8217;t do this big, &#8216;Think different&#8217; innovation thing. Screw that; it&#8217;s meaningless. 99% of it is &#8216;Get the work done.&#8217; That&#8217;s my least favorite part of the technology news cycle: the constant innovation and new ideas, &#8216;<em>This will revolutionize</em>,&#8217; all that hype &#8211; that&#8217;s not where the real work is. The real work is in the details.&#8221;</p>\n<p>Not all open source projects could be successful with the same model and leadership that Torvalds has brought to Linux development, but the kernel is arguably one of the most active and successful GPL-licensed projects. Zemlin noted that nearly 900 organizations participate in all the different Linux Foundation programs, creating code in almost every aspect of computing from mobile phones to cars to home appliances. It wouldn&#8217;t be possible without Torvalds&#8217; laser focus on continuing the work he started.</p>\n<p>&#8220;I&#8217;m obviously one of those people who likes to concentrate on one project,&#8221; Torvalds said. &#8220;I don&#8217;t like flitting from one idea to another. You need the people who just flutter about and come up with ideas, but they&#8217;re not the really useful ones. They end up being the ones who maybe give the ideas to the ones doing the work. What anybody should take away from this talk &#8211; the people who actually do the work are the ones you should really listen to. These days I don&#8217;t actually do the work anymore &#8211; I merge other people&#8217;s work. But I would like conferences, too, to be less about the visionary innovation thing and more about the day-to-day what are my problems and how do I want to solve them.&#8221;</p>\n<p>Check out the video below to watch the full session with Linus Torvalds and Jim Zemlin:</p>\n<div class=\"embed-wrap\"></div>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Feb 2017 20:15:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Learn How to Find and Exploit XSS Vulnerabilities with Google’s XSS Game\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/learn-how-to-find-and-exploit-xss-vulnerabilities-with-googles-xss-game\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3105:\"<p>In 2016, Acunetix, a UK-based security firm, found that <a href=\"http://www.acunetix.com/blog/articles/33-websites-webapps-vulnerable-xss/\" target=\"_blank\">33% of websites and web apps are vulnerable to XSS</a>. This number is down 5% from the company&#8217;s findings for the previous year, but it&#8217;s still one of the most common vulnerabilities. In fact, every WordPress security release for the past year has included patches for <a href=\"https://en.wikipedia.org/wiki/Cross-site_scripting\" target=\"_blank\">cross-site scripting</a> (XSS) vulnerabilities, including 4.5.2, 4.5.3, 4.6.1, 4.7.1, 4.7.2, and many other previous releases.</p>\n<p>Google has created a fun and educational <a href=\"https://xss-game.appspot.com/\" target=\"_blank\">XSS game</a> that teaches new bug hunters how to find and exploit XSS vulnerabilities. Each challenge teaches students how to inject a script to pop up an alert() within the training application. The first few levels are fairly easy and it gets progressively more difficult.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/xss-game-level-1.png?ssl=1\"><img /></a></p>\n<p>It was designed for developers who work on web apps but do not specialize in security. Google&#8217;s goal with the game is to help developers get better at recognizing the vulnerabilities in their own code:</p>\n<blockquote><p>This security game consists of several levels resembling real-world applications which are vulnerable to XSS &#8211; your task will be to find the problem and attack the apps, similar to what an evil hacker might do. </p>\n<p>XSS bugs are common because they have a nasty habit of popping up wherever a webapp deals with untrusted input. Our motivation is to highlight common coding patterns which lead to XSS to help you spot them in your code.</p></blockquote>\n<p>The intro to the game tempts new recruits to hone their skills with promises to pay mercenaries up to <a href=\"https://www.google.com/about/appsecurity/reward-program/index.html#rewards\" target=\"_blank\">$7,500 for discovering XSS bugs</a> in the Google&#8217;s most sensitive products. It gives a nice introduction to common attack vectors for XSS vulnerabilities and congratulates winners with a cake and a <a href=\"http://Google\'s application security resource\" target=\"_blank\">link to more in-depth XSS documentation</a> from Google&#8217;s collection of application security resources.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/xss-game-cake-complete.png?ssl=1\"><img /></a></p>\n<p>The <a href=\"https://xss-game.appspot.com/\" target=\"_blank\">XSS game</a> has been around for a few years and provides a fun way to start your XSS learning if you have a few minutes over the weekend. With the constant stream of security updates for WordPress core, plugins, and themes, it&#8217;s good to get a basic understanding of what many of these patches are for. After a little bit of study and practice, you may be able to find XSS vulnerabilities in applications and help make the internet more secure.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Feb 2017 19:31:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Post Status: Running a successful regional agency, with Ben May\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=34480\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://poststatus.com/running-successful-regional-agency-ben-may/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1736:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher.</p>\n<p><span>In this episode, Brian interviews Ben May to talk about running <a href=\"https://thecode.co/\">The Code Company</a>, a semi-remote agency based in Queensland, Australia. The Code Company works primarily with long term clients and repeat work, and they’ve grown from just Ben to a team of 11 almost entirely by referrals for new customers.</span></p>\n<p><!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/61169.mp3\">https://audio.simplecast.com/61169.mp3</a><br />\n<a href=\"https://audio.simplecast.com/61169.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://thecode.co/\">The Code Company</a></li>\n</ul>\n<h3>Sponsor: WooCommerce</h3>\n<p><span>This episode of the Draft podcast is sponsored by <a href=\"https://woocommerce.com/\">WooCommerce</a>. WooCommerce makes the most widely used eCommerce platform on the web, and has the power and flexibility you need to power your store. For more information on how to run your store with WordPress and WooCommerce, check out <a href=\"https://woocommerce.com/\">their website</a> and thank you to WooCommerce for being a Post Status partner. </span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Feb 2017 18:41:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: FOSSA Raises $2.2M to Automate Open Source License Compliance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66487\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/fossa-raises-2-2m-to-automate-open-source-license-compliance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4631:\"<p>Kevin Wang and his team at <a href=\"http://fossa.io/\" target=\"_blank\">FOSSA</a> have carved out a niche for themselves in the open source product space with the launch of their license compliance and dependency analysis tool. The company <a href=\"https://medium.com/fossa/announcing-fossa-public-beta-funding-8cf56cf8ebc6#.3titvmvwe\" target=\"_blank\">announced a $2.2 million seed round</a> this week after completing a year-long private beta period with Fortune 500 companies. FOSSA continuously scans dependencies and offers reports at each commit to help companies meet the legal obligations of compliance as they are incorporating open source libraries.</p>\n<p>The <a href=\"http://fossa.io/pricing/\" target=\"_blank\">public beta</a> is now free and open to anyone, offering support for up to 5 public/private repos and scanning three levels deep with open source reports. A $499/repo per month commercial option is also available with unlimited scan depth and customizable open source reports.</p>\n<p>&#8220;It’s mind-boggling that in 2017, software companies don’t really know what’s in their code,&#8221; Wang said. &#8220;90% of it now comes from third parties like open source (OSS) codebases. Although it sounds trivial, it’s actually really difficult to keep track of what your developers use. Most of this code isn’t explicitly included — instead it’s brought in automatically by complex tool behavior or one of the million ways developers <a href=\"https://medium.com/fossa/you-cant-get-around-code-scanning-if-you-care-about-open-source-licenses-2db1fde43fb5#.pb9mtykaf\" target=\"_blank\">casually share code</a>.&#8221;</p>\n<p>FOSSA can detect license and policy violations and unlicensed dependencies before an expensive mistake is fully integrated into a project. The real-time feedback forces developers to consider how they are using the libraries they are building into their software.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/fossa-example.jpeg?ssl=1\"><img /></a></p>\n<p>Competitors like <a href=\"https://www.whitesourcesoftware.com/\" target=\"_blank\">WhiteSource</a> and <a href=\"https://www.blackducksoftware.com\" target=\"_blank\">Black Duck Software</a>, which offer open source risk management tools, detect and display licenses for components and dependencies for applications but seem more focused on bugs and vulnerability reporting. FOSSA is solely focused on OSS license compliance and automating disclosure and attribution.</p>\n<p>Compliance is becoming increasingly difficult as developers can easily execute a few commands and import dozens of npm modules that inherit licensing obligations from a myriad of different sources. Even governments and large companies with plenty of resources struggle to keep track of all the open source requirements of the software they are using.</p>\n<p>In 2013, <a href=\"https://www.techdirt.com/articles/20131018/13291924928/healthcaregov-violates-open-source-license.shtml\" target=\"_blank\">Healthcare.gov violated an open source license</a> when it used the DataTables jQuery plugin without the required attribution. Last year, <a href=\"http://venturebeat.com/2016/05/10/oracle-vs-google-in-9-billion-retrial-over-use-of-java-in-android/\" target=\"_blank\">Google was embroiled in a court battle with Oracle</a> over the use of Java in Android.</p>\n<p>A tool like FOSSA could have helped Wix catch its <a href=\"https://wptavern.com/wix-removes-gpl-licensed-wordpress-code-from-mobile-app-forks-original-mit-library\" target=\"_blank\">violation of the GPL in 2016</a> when the company used GPL-licensed code from the WordPress mobile app and distributed it in its proprietary app. FOSSA aims to catch licensing issues before they become expensive problems for developers to rework and lawyers to settle.</p>\n<p>A few years before beginning work on FOSSA, Wang built <a href=\"https://tldrlegal.com/\" target=\"_blank\">tl;drLegal</a>, a site that explains software licenses in plain English. The free resource received backing from the Open Source Initiative and has been used by more than a million developers. Wang said he &#8220;sees FOSSA as an attempt to tackle similar problems in a commercial scenario.&#8221;</p>\n<p>FOSSA will be expanding its pricing options later this year. At the moment, the free beta and the $499/month commercial options leave a gaping hole that excludes smaller organizations. Wang replied to pricing questions on ProductHunt, saying that they are targeting enterprise customers first but plan to introduce more options for small teams and individuals.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 25 Feb 2017 00:21:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: Discourse Creates Encouragement Fund to Pay Contributors for Mission Critical Work\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/discourse-creates-encouragement-fund-to-pay-contributors-for-mission-critical-work\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2486:\"<p><a href=\"https://www.discourse.org\">Discourse</a> is free, open-source discussion software created by Jeff Atwood in 2013.&nbsp;In addition to celebrating its fourth birthday, the team <a href=\"https://blog.discourse.org/2017/02/the-discourse-encouragement-fund/\">announced</a> the Discourse Encouragement Fund. The fund allows the development team to pay contributors for critical work.</p>\n<p>In the course of a year, Discourse has paid 16 different developers a total of $17,000 to work on tasks. All of their work is open source and two of the contributors&nbsp;<a href=\"https://blog.discourse.org/2017/02/discourses-fourth-birthday/\">joined the team</a> as full-time employees.</p>\n<p>Discourse&nbsp;shared its 7-step process for rewarding contributors and the one that&nbsp;sticks out to me is number four: &#8220;We choose who, what and when.&#8221;</p>\n<p>&#8220;At first we tried to put tasks &#8216;up for grabs&#8217;, but this method didn’t work too well,&#8221; Erlend Sogge Heggen, Community Advocate at Discourse said. &#8220;You end up with multiple takers and you have to pick one and let others down.&#8221;</p>\n<p>&#8220;Instead, we approach developers individually, one at a time. Since we’re an open source project we know fairly well who’s capable of what, so we’ll tap our top prospect, present the task and &#8216;bounty&#8217;, and get a yes or no.</p>\n<p>&#8220;If no, we move on to the next good prospect. If we run out of good prospects for a specific task, we’ll either do it ourselves or put it on hold.&#8221;</p>\n<p>Heggen says the program has worked well thus far and will continue indefinitely. &#8220;As much as we’d like to, we can’t put every one of our contributors on a steady payroll,&#8221; he said.</p>\n<p>&#8220;What we can do is remind them that the work they’re doing is valuable, in every sense of the word, and that there is money to be made from specializing in Discourse.&#8221;</p>\n<p>The program is funded by customers who purchase <a href=\"https://discourse.org/buy\">hosting plans</a>, &#8220;The general idea is that paying customers help improve Discourse, both for themselves, and for the greater open source community at large,&#8221; Atwood said.</p>\n<p>Introducing money into an open source project can be <a href=\"http://david.heinemeierhansson.com/2013/the-perils-of-mixing-open-source-and-money.html\">risky </a>but so far, Discourse has found a way to make it work.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Feb 2017 19:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Cloudflare Memory Leak Exposes Private Data\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66488\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wptavern.com/cloudflare-memory-leak-exposes-private-data\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5730:\"<p><a href=\"https://www.cloudflare.com/\">Cloudflare</a>, a content distribution network used by many popular sites, <a href=\"https://blog.cloudflare.com/incident-report-on-memory-leak-caused-by-cloudflare-parser-bug/\">published detailed information</a> about a security vulnerability that leaked user information, some of which was private, including passwords, private messages, etc. The vulnerability was <a href=\"https://bugs.chromium.org/p/project-zero/issues/detail?id=1139#c19\">discovered</a> by security researcher <a href=\"https://twitter.com/taviso\">Tavis Ormandy,</a> a member of Google&#8217;s <a href=\"https://googleprojectzero.blogspot.co.uk/\">Project Zero</a> team.</p>\n<p>The issue stems from a memory leak in an HTML parser named cf-html that was created to replace an older parser based on <a href=\"https://en.wikipedia.org/wiki/Ragel\">Ragel.</a></p>\n<p>&#8220;It turned out that the underlying bug that caused the memory leak had been present in our Ragel-based parser for many years but no memory was leaked because of the way the internal NGINX buffers were used,&#8221; John Graham-Cumming, <span class=\"st\">Chief Technology Officer at Cloudflare</span> said. &#8220;Introducing cf-html subtly changed the buffering which enabled the leakage even though there were no problems in cf-html itself.&#8221;</p>\n<p>The earliest date information was leaked was September 22nd, 2016 when <a href=\"https://support.cloudflare.com/hc/en-us/articles/227227647-How-do-I-use-Automatic-HTTPS-Rewrites-\">Automatic HTTP Rewrites</a> were enabled. This was the first of three features introduced that used the parser. The other two are <a href=\"https://support.cloudflare.com/hc/en-us/articles/200170016-What-is-Email-Address-Obfuscation-\">email obfuscation</a> and <a href=\"https://support.cloudflare.com/hc/en-us/articles/200170036-What-does-Server-Side-Excludes-SSE-do-\">Server-side Excludes</a>.</p>\n<p>The greatest period of impact was between February 13th and February 17th. The leaked information ended up in publicly available cached webpages. Cloudflare worked with major search engine providers to have the cached pages scrubbed before publicly announcing details of the bug.</p>\n<p>&#8220;With the help of Google, Yahoo, Bing and others, we found 770 unique URIs that had been cached and which contained leaked memory,&#8221; Graham-Cumming said. &#8220;Those 770 unique URIs covered 161 unique domains. The leaked memory has been purged with the help of the search engines. We also undertook other search expeditions looking for potentially leaked information on sites like Pastebin and did not find anything.&#8221;</p>\n<h2>1Password is Not Affected</h2>\n<p>Earlier reports indicated that 1Password was among the sites affected. Jeffrey Goldberg, a 1Password employee, <a href=\"https://blog.agilebits.com/2017/02/23/three-layers-of-encryption-keeps-you-safe-when-ssltls-fails/\">assured users</a> that the Cloudflare data leak does not affect 1Password.</p>\n<p>&#8220;At the moment, we want to assure and remind everyone that we designed 1Password with the expectation that SSL/TLS can fail,&#8221; Goldberg said. &#8220;Indeed it is for incidents like this that we deliberately made this design.&#8221;</p>\n<p>&#8220;No secrets are transmitted between 1Password clients and 1Password.com when you sign in and use the service. Our sign-in uses <a href=\"https://en.wikipedia.org/wiki/Secure_Remote_Password_protocol\">SRP</a>, which means that server and client prove their identity to each other without transmitting any secrets. This means that users of 1Password do not need to change their Master Passwords.&#8221;</p>\n<h2>Change Your Passwords</h2>\n<p><a href=\"https://twitter.com/thesquashsh\">Nick Sweeting</a> has used a number of web scrapers to compile a list of sites that use Cloudflare. The list is available on <a href=\"https://github.com/pirate/sites-using-cloudflare\">GitHub</a> and currently contains 4,287,625 domains that are possibly affected. Popular domains in the list include:</p>\n<ul>\n<li>authy.com</li>\n<li>coinbase.com</li>\n<li>digitalocean.com</li>\n<li>patreon.com</li>\n<li>bitpay.com</li>\n<li>news.ycombinator.com</li>\n<li>producthunt.com</li>\n<li>medium.com</li>\n<li>4chan.org</li>\n<li>yelp.com</li>\n<li>okcupid.com</li>\n</ul>\n<p>The bug also affects mobile apps as HTTP header data for apps such as Discord, FitBit, and Uber have been discovered in search engine caches. NowSecure <a href=\"https://www.nowsecure.com/blog/2017/02/23/cloudflare-cloudbleed-bugs-impact-mobile-apps/\">published a list</a> that includes 200 iOS apps that use Cloudflare services.</p>\n<p>Users are strongly encouraged to change their passwords regardless if a site uses Cloudflare or not. Those who use Cloudflare should generate new API keys and consider forcing a password change to users.</p>\n<p>Two factor authentication should be enabled where possible so that the password is not the only credential needed to access an account. Mobile users should log out of mobile applications and log back in to create a new active token. To force all users on a WordPress site to logout and re-login, <a href=\"https://wpstudio.com/cloudflare-security-precaution-alert/\">WPStudio recommends</a> changing the salt keys in wp-config.php.</p>\n<p>Although major search engines are actively scrubbing cached pages, the leaks have been occurring for at least four months. There&#8217;s no telling who may have already scraped those pages and archived the data. There&#8217;s also the possibility that someone discovered the vulnerability before Ormandy and has been parsing cached pages for months. This is why it&#8217;s important that at a minimum, you change your passwords.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Feb 2017 19:03:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: Google’s New Perspective Project Filters Online Comments Based on Toxicity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/googles-new-perspective-project-filters-online-comments-based-on-toxicity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5970:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/mobile-reading.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/RY5J4XBYJV\">Martino Pietropoli</a>\n<p>Online harassment is a hot topic right now, as Twitter&#8217;s perennial battle with trolls heats up, forcing the company to develop new features to combat abuse. Technology companies are scrambling to create solutions that will make their communities safer for users and now Google is taking on the challenge of online harassment as part of its <a href=\"https://jigsaw.google.com\" target=\"_blank\">Jigsaw</a> technology incubator. Jigsaw&#8217;s engineers and researchers tackle geopolitical problems like attacks on free speech, injustice, corruption, and violent extremism.</p>\n<p><a href=\"https://www.perspectiveapi.com/\" target=\"_blank\">Perspective</a> is Jigsaw&#8217;s latest project aimed at improving the comment sections of websites, which can become hotbeds of harassment when left unmoderated. It turns out that eliminating the darker aspects of human behavior, especially when combatting those operating under the cloak of online anonymity, has proven to be an exquisite challenge best suited to the bots.</p>\n<p>The Perspective project uses machine learning to identify and filter comments for toxicity. Its API scores comments based on &#8220;the perceived impact a comment might have on a conversation.&#8221; Publishers can then use that information to offer real-time feedback to commenters and speed up moderation. The <a href=\"https://www.perspectiveapi.com/\" target=\"_blank\">live demo</a> allows readers to filter the comments based on a sliding scale of toxicity that they are willing to engage.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/google-jigsaw-perspective-project.png?ssl=1\"><img /></a></p>\n<p>The Perspective site also includes a Writing Demo that delivers real-time feedback for the toxicity level as you type. The model defines toxic as &#8220;a rude, disrespectful, or unreasonable comment that is likely to make you leave a discussion.&#8221;</p>\n<h3>Developers Can Request Access to the Perspective API and Major Publications are Already Experimenting with It</h3>\n<p>Toxic commenting and trolls are especially rampant on news sites, requiring moderators to be constantly vigilant and ready to neutralize threats to civil discourse. This is why the New York Times employs 14 full-time moderators to manually review the 11,000 comments that come in each day. Despite the efforts of this dedicated team, commenting is only available on 10% of Times articles due to the moderation load.</p>\n<p>As a partner on this project, the New York Times <a href=\"http://www.nytco.com/the-times-is-partnering-with-jigsaw-to-expand-comment-capabilities/\" target=\"_blank\">open sourced 10 years of moderated comment archives</a> to help the Jigsaw team build the machine learning models that will improve conversations on the web. The publication is currently creating an open source moderation tool to expand community discussion to other areas of the Times.</p>\n<p>The Wikimedia Foundation is also <a href=\"https://meta.wikimedia.org/wiki/Research:Detox\" target=\"_blank\">collaborating with Jigsaw</a> to develop tools for automating detection of toxic comments and analyzing their impact in discussions at scale. These tools are aimed at mitigating the personal attacks levied at volunteer editors in an effort to improve overall community health.</p>\n<p>The Perspective project is still in its early days of research and development, but developers can <a href=\"https://groups.google.com/forum/#!forum/perspective-announce/join\" target=\"_blank\">sign up</a> to request an API key. Google will be open sourcing the experiments, models, and research data gained from testing machine learning as a tool for improving online discussion.</p>\n<p>As WordPress powers more than 27% of all websites, a plugin built with the Perspective API could have a major impact on raising the standard of discourse for a large segment of comment-enabled sites. Many publications that might otherwise value thoughtful discussion, have resorted to turning comments off entirely because of the burden of moderation.</p>\n<p>Those who rattle off the tired internet maxim that says &#8220;<em>Never read the comments</em>&#8221; speak to the pervasive toxicity that has invaded online discourse, but they also betray their own fragility in engaging commenters who sabotage discussions with incivility. Readers don&#8217;t always have the emotional energy to deal with rude comments that slipped through moderation. While some may find Reddit-style wild west commenting to be spirited and amusing, there are plenty of others who find it demoralizing.</p>\n<p>One thing I appreciate about the Perspective project&#8217;s demo is that its aim isn&#8217;t to edit or change the comments to be less toxic but rather it offers the reader a way to filter based on the individual&#8217;s comfort level. With clear warnings in place and a default view set on the safer side, the publication is no longer obligated to overly-censor comments for the lowest threshold of offense.</p>\n<p>The Perspective project is experimenting with using machine learning to wrangle the human factor of interacting online. It&#8217;s come to the point that moderating comments and weeding out toxicity has become overwhelming for those trying to run a publication. The most encouraging aspect of this experiment is that Google put engineers, designers, and researchers on this problem because <a href=\"https://wptavern.com/why-comments-still-matter\" target=\"_blank\">comments still matter</a>. This new technology affirms the importance of public discourse on the web and aims to preserve comments as a safe place for conversations. I&#8217;m interested to see what WordPress developers can build with the Perspective API once it is available.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Feb 2017 04:17:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordPress Community Summit 2017 Set for June 13-14 in Paris\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66439\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/wordpress-community-summit-2017-set-for-june-13-14-in-paris\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3561:\"<p>WordPress contributor teams are getting ready for the next <a href=\"https://make.wordpress.org/core/2017/02/23/planning-for-community-summit-2017/\" target=\"_blank\">Community Summit</a>, which will be held in Paris leading up to WordCamp Europe on June 13-14. This is the first time the event will be held outside the United States, making it more accessible to European community members who may have been unable to attend previous summits.</p>\n<p>The summit provides an opportunity for those who contribute to WordPress and its surrounding community to tackle difficult topics that require in-person discussion or collaboration. This year the organizing team is <a href=\"https://wptavern.com/wordpress-community-team-proposes-new-selection-process-for-2017-summit-attendees\" target=\"_blank\">trying a new selection process for attendees</a>. Instead of the previous invitation-only system, contributor teams are identifying the challenging issues they want to discuss and then nominating attendees who will represent diverse viewpoints on these particular topics.</p>\n<p>For example, a few <a href=\"https://make.wordpress.org/core/2017/02/23/planning-for-community-summit-2017/\" target=\"_blank\">proposed topics for the core team</a> include discussions about the future of JavaScript in core, how to attract more JavaScript-first developers to build on WordPress, and technology version support policies (PHP, MySQL, browsers, etc.) Theme Review Team contributors have <a href=\"https://make.wordpress.org/themes/2017/02/18/community-submit-2017/\" target=\"_blank\">proposed</a> discussion on how to allow for more experimentation and ways to improve the leadership of the team and the theme author and reviewer experiences.</p>\n<p>Each of the 16 contributor teams tagged in the announcement has until March 3rd to create a list of topics and representatives, including contributors who are willing to help organize the event. An <a href=\"https://wceurope.polldaddy.com/s/community-summit-2017-call-for-non-active-contributors\" target=\"_blank\">application form</a> is open for those who represent other interests within the WordPress community but are not part of one of the contributor teams. The summit will be limited to 180 attendees (the capacity for the venue).</p>\n<p>The call for sponsors will be published next week, but promotional activities will not be incorporated into the event. The organizing team is also working on finding sponsors to cover travel expenses for contributors who have financial barriers to attending.</p>\n<p>&#8220;The idea of this event sponsorship is about supporting the project and the community,&#8221; summit organizer Rocio Valdivia said. &#8220;So, there aren’t levels of exposure associated with each price level other than the label that will show up in the make/summit p2 page for it and on the sidebar. We’ll add links to their sites, logos, and a huge thanks at event to all sponsors, regardless how much they’ve sponsored. The sponsorship levels are about the desire and financial ability of the companies to contribute to the summit, not about a marketing thing.&#8221;</p>\n<p>The summit is closed to the public and the press, but there is a decent level of transparency around the topics attendees plan to discuss if you peruse the make.wordpress.org blogs. If contributor teams publish notes from the discussions as they have in previous years, the wider community will be able to follow along to see if the summit precipitates meaningful progress for the project.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Feb 2017 22:05:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Akismet: Akismet WordPress Plugin 3.3 Now Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1923\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://blog.akismet.com/2017/02/23/akismet-wordpress-plugin-3-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1366:\"<p>Version 3.3 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is available.</p>\n<p><a href=\"https://akismet.files.wordpress.com/2017/02/akismet-3-3-dashboard.png\"><img /></a> In addition to a handful of bug fixes, version 3.3 refreshes the Akismet settings page design and adds an improved first-run experience. Now, when you activate Akismet for the first time, it will offer to check your current Pending queue for spam, and for especially large pending queues, it will show a progress indicator.</p>\n<p>For full details on all of the changes since version 3.2, see <a href=\"https://plugins.trac.wordpress.org/log/akismet/trunk?rev=1602266&stop_rev=1501241&verbose=on\">the changelog</a>.</p>\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins directory</a>.</p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1923/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1923/\" /></a> <img alt=\"\" border=\"0\" src=\"https://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1923&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Feb 2017 18:08:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: WPWeekly Episode 264 – REST API, Disqus, and Happy Birthday Discourse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=66421&preview=true&preview_id=66421\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/wpweekly-episode-264-rest-api-disqus-and-happy-birthday-discourse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4422:\"<p>In this episode, Marcus Couch and I discuss the news of the week. We introduce a new segment of the show called &#8220;What&#8217;s on WordPress.tv?&#8221; where we highlight three videos to check out. We also share details of <a href=\"https://central.wordcamp.org/schedule/\">upcoming WordCamps </a>in the month of March.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://halfelf.org/2017/case-rest-api/\">A Case for REST API</a><br />\n<a href=\"https://wptavern.com/buddypress-2-8-boosts-minimum-php-requirement-adds-twenty-seventeen-companion-stylesheet\">BuddyPress 2.8 Boosts Minimum PHP Requirement, Adds Twenty Seventeen Companion Stylesheet</a><br />\n<a href=\"https://wptavern.com/disqus-hits-sites-with-unwanted-advertising-plans-to-charge-large-publishers-a-monthly-fee-to-remove-ads\">Disqus Hits Sites with Unwanted Advertising, Plans to Charge Large Publishers a Monthly Fee to Remove Ads</a><br />\n<a href=\"https://wptavern.com/how-to-check-if-installed-plugins-are-no-longer-in-the-plugin-directory\">How to Check if Installed Plugins Are No Longer in the Plugin Directory</a><br />\n<a href=\"https://blog.discourse.org/2017/02/discourses-fourth-birthday/\">Happy Fourth Birthday Discourse</a></p>\n<h2>What&#8217;s On WordPress.TV?</h2>\n<h3>WordCamp Manila 2016</h3>\n<p><a href=\"http://wordpress.tv/2017/02/12/andrew-dela-serna-how-we-work-in-automattic/\">Andrew dela Serna: How We Work in Automattic</a></p>\n<p>Learn what it’s like to work at Automattic, the tools they use, our culture, the people, how to apply and what’s next for the company.</p>\n<h3>WordCamp Waukesha 2017</h3>\n<p><a href=\"http://wordpress.tv/2017/02/09/ryan-erwin-digital-marketing-strategy-and-seo/\">Ryan Erwin: Digital Marketing, Strategy and SEO</a></p>\n<p>Ryan Erwin discussed digital marketing strategy for business as it relates to on and off page SEO, content marketing, and conversion optimization. He reviews how to plan, implement, and analyze your strategic initiatives.</p>\n<h3>WordPress Community Interview Series</h3>\n<p><a href=\"http://wordpress.tv/2017/02/20/wordpress-community-interview-with-isabelle-garcia/\">WordPress Community Interview With Isabelle Garcia</a></p>\n<p>Isabelle Garcia is a front-end web developer and social media geek. She is a “Digital Nomad” and travels the world working remotely. She has no fixed base, no office. Isabel likes to frequent local libraries, not to borrow books but to take advantage of the quiet atmosphere.</p>\n<p>While other digital nomads meet at coffee shops or co-working spaces, she likes to spend entire days and even weekends in the common areas and desks of public libraries.</p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/really-simple-click-to-call/\">Really Simple Click To Call Bar</a> adds a customizable click-to-call bar to the bottom of the browser window on mobile devices. It enables users to easily call you from their phone and automatically adds events if you&#8217;re using Google Analytics Universal. Perfect for small businesses like restaurants, retail stores, or any lead generation that relies on phone calls.</p>\n<p><a href=\"https://wordpress.org/plugins/html-table/\">Responsive tables</a> lets you create and display tables easily on your website with shortcodes. HTML tables can be used to display pricing, comparisons, DBMS tables and much more.</p>\n<p><a href=\"https://wordpress.org/plugins/wp-demo-buddy/\">WP Demo Buddy</a> instantly creates a dedicated expiring Demo/Trial instance of WordPress with any WordPress Plugin and Theme to each of your website visitors. Your website visitors can test drive your plugins securely before they buy or test drive the plugins you review/sell on your website.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, March 1st 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #264:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Feb 2017 22:29:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: Zerif Lite Returns to WordPress.org after 5-Month Suspension and 63% Decline in Revenue\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64347\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://wptavern.com/zerif-lite-returns-to-wordpress-org-after-5-month-suspension-and-63-decline-in-revenue\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7365:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/09/zerif-lite.png?ssl=1\"><img /></a></p>\n<p>In October 2016, Zerif Lite was <a href=\"https://wptavern.com/zerif-lite-suspended-from-wordpress-theme-directory-300k-users-left-without-updates\">suspended from the WordPress Themes Directory</a> after failure to comply with the Theme Review Team&#8217;s guidelines. The suspension left 300,000 users (including those using Zerif Lite child themes) without maintenance and security updates.</p>\n<p>After five months of fixes and several rounds of review, <a href=\"https://wordpress.org/themes/zerif-lite/\" target=\"_blank\">Zerif Lite</a> has returned to the directory with the same functionality but a significantly altered user experience. Users are now required to install a plugin for the features that were previously deemed to be &#8220;faux custom post types,&#8221; violations of the content vs. presentation guideline for WordPress.org-hosted themes. These include small custom content blocks that appear on the homepage for things like team info and testimonials.</p>\n<p>&#8220;We will work on making sure it is all clear for people, but I still don’t understand or agree with the requirement,&#8221; ThemeIsle CEO Ionut Neagu said. &#8220;I think <a href=\"http://torstenlandsiedel.de/2017/02/21/questions/\" target=\"_blank\">Torsten phrased it better</a>: &#8216;Why do the guidelines of the Theme Review Team forbid the usage of Shortcodes/CPTs/etc. due to problems when switching themes, if, in the meantime, the Plugin Review Team explicitly allows those plugins which only work for one theme, which brings the entire idea (function remains intact after switching themes) to absurdity?\'&#8221;</p>\n<p>At the time of suspension, Neagu estimated that Zerif Lite&#8217;s unavailability on WordPress.org would diminish the company&#8217;s revenue by 50%.</p>\n<p>&#8220;What was interesting is that revenue continued to decrease for all those months and we are now at around $45k/month instead of $120k,&#8221; Neagu said. &#8220;That revenue won’t be back as the theme is live. A big part of success/sales before was that we had a great demo, a very easy-to-set-up theme, and ‘better’ upsells.&#8221;</p>\n<p>Neagu said the company has seen no significant increase in revenue during the first few days the theme has been back in the directory. His team has considered releasing the theme under a completely different name but is committed to supporting the current version for at least the next two years. Meanwhile, they have built newer themes like <a href=\"https://themeisle.com/themes/hestia/\" target=\"_blank\">Hestia</a> to be capable of importing Zerif content seamlessly into its design to avoid the lock-in effect.</p>\n<p>Neagu said the experience of losing so much revenue has not changed the company&#8217;s strategy for distribution. They will continue to add new themes to WordPress.org but Neagu said they would be lucky to add two per year, given the limitation of one theme per account and a 6-7 month waiting period in the queue.</p>\n<p>Zerif Lite&#8217;s suspension was a controversial decision. Many who commented on our first <a href=\"https://wptavern.com/zerif-lite-suspended-from-wordpress-theme-directory-300k-users-left-without-updates\" target=\"_blank\">post</a> about the issue were pleased to see the Theme Review Team finally throw the book at ThemeIsle after the company had been allowed to skirt the requirements for more than a year without resolving the issues. Others saw the situation as an opportunity to re-examine the directory&#8217;s requirements.</p>\n<p>&#8220;Perhaps the rules surrounding theme submission to the repo should be relaxed for everyone – limited only to security concerns perhaps, let the market sort out the rest,&#8221; <a href=\"https://twitter.com/bradley_kirby\" target=\"_blank\">Bradley Kirby</a>, author of the Wallace theme, said. &#8220;Is it possible that absolute data portability isn’t an expectation or desire from most end users? That they expect to do some manual porting of data when they change themes? That they prize other features like site design and built-in functionality over something like data portability?&#8221;</p>\n<p>Zerif Lite has been at the center of the Theme Review Team&#8217;s discussions regarding data portability for the past two years after the team began <a href=\"https://wptavern.com/wordpress-theme-review-team-is-cracking-down-on-violations-of-the-presentation-vs-functionality-guideline\" target=\"_blank\">cracking down on violations of the Presentation vs. Functionality guideline</a>. The spotlight shined on Zerif Lite during that discussion eventually culminated in its suspension, as Neagu was forced to comply or have his theme removed.</p>\n<p>&#8220;I think our goal should just be to provide the best experience for the users, not just to comply without thinking about what users want,&#8221; Neagu said. &#8220;At least this is my goal &#8211; to build the best products that will help people to build their sites.&#8221;</p>\n<h3>The Risks of Using WordPress.org as a Primary Distribution Channel</h3>\n<p>WordPress.org is arguably the most effective way for a theme company to reach mass quantities of users with a freemium theme. The directory lends a great deal of credibility to its listings because of the stringent guidelines and rigorous review process. Failure to comply with these guidelines ultimately ended up sinking ThemeIsle&#8217;s flagship theme and Neagu is not optimistic that the previous revenue will return.</p>\n<p>&#8220;During this whole time, a thing that caught me off guard was some of people’s comments wondering if it was even safe to use a theme that was removed from the repo in the first place,&#8221; Neagu said. &#8220;I mean, in the user’s mind, and understandably so, there must have been something wrong with the theme since it got removed, right?&#8221; He said this experience caused him to see things differently.</p>\n<p>&#8220;Being listed in the official repository doesn’t only get you downloads and/or sales, but also trust and credibility in the eyes of your potential users,&#8221; Neagu said. &#8220;Unfortunately, most of the users who install themes directly via their WP dashboards are not very experienced, and they have no reason to research the web a bit more to find out what happened to the theme they heard about. In other words, if someone types &#8216;zerif&#8217; into the search field in their dashboard and they find nothing, they just move on.&#8221;</p>\n<p>Neagu said that in spite of differences Themeisle has had with the Theme Review Team, the company will continue to contribute and be part of the community. The theme&#8217;s suspension, re-working, and re-installment is an interesting case of what can happen when a company&#8217;s sales strategy is at odds with WordPress.org&#8217;s requirements.</p>\n<p>&#8220;Our products are focused towards beginners, being super easy to setup with built-in demo content, so they are not niched products that we can distribute in different communities,&#8221; Neagu said.</p>\n<p>&#8220;It is obvious that relying on a third-party marketplace is the worst scenario, but WordPress.org is the default solution: if you want to reach a large mass of people, you need to be there.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Feb 2017 21:47:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"BuddyPress: BuddyPress 2.8.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=264058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://buddypress.org/2017/02/buddypress-2-8-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:536:\"<p>BuddyPress 2.8.1 is now available. This maintenance release fixes four bugs, including two regressions in BuddyPress 2.8.0. See the <a href=\"https://buddypress.trac.wordpress.org/milestone/2.8.1\">Trac milestone</a> or the <a href=\"https://codex.buddypress.org/releases/version-2.8.1/\">official changelog</a> for more details.</p>\n<p>Version 2.8.1 is a recommended update for all BP installations. Update via the WordPress Dashboard, or download manually from <a href=\"https://wordpress.org/plugins/buddypress/\">wordpress.org</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Feb 2017 19:41:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Boone Gorges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"WPTavern: WordPress Core Editor Team Publishes UI Prototype for “Gutenberg,” an Experimental Block Based Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65960\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://wptavern.com/wordpress-core-editor-team-publishes-ui-prototype-for-gutenberg-an-experimental-block-based-editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3690:\"<p>In the past few weeks, the WordPress Core Editor team, <a href=\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\">led by</a> Automattic employees Matías Ventura and Joen Asmussen, have been hard at work creating a new <a href=\"https://make.wordpress.org/core/2017/01/17/editor-technical-overview/\">content creation experience</a>. The team recently <a href=\"https://wordpress.github.io/gutenberg/\">published a UI prototype </a>for Gutenberg, an experimental block based editor. The editor displays content-specific toolbars when an element is selected and provides a way to move blocks up and down.</p>\n<img />Block Based Editor UI Prototype\n<p>While the goal is to reinvent WordPress&#8217; current editor, there&#8217;s no guarantee that the prototype will end up as the final product and is in a high state of flux.</p>\n<p>&#8220;The UI prototype exists mostly to serve as a non-static mockup,&#8221; Asmussen said. &#8220;It&#8217;s like a sandbox we&#8217;re building to test some of our mockups and assumptions, to see if they hold water or not. To that extent, it&#8217;s already been successful in informing us of things that worked well, and not so well.&#8221; The code that powers the editor is made up of about 90% JavaScript.</p>\n<p>One of the concerns in revamping the editor is accessibility. Joe Dolson <a href=\"https://make.wordpress.org/accessibility/2017/02/17/revising-the-wordpress-editor-gutenberg-and-accessibility/\">highlighted this concern</a> in a post on the Make WordPress Accessible site. Dolson notes that the accessibility team will work in tandem with the editor team to make the new editor as accessible as possible.</p>\n<p>&#8220;From an accessibility perspective, this is both an incredible opportunity to build a powerful and flexible experience for all users and an enormous risk that we could end up reducing the effectiveness of the editor for users with disabilities, or require them to use a 2nd-class editor without these enhanced editing capabilities,&#8221; Dolson said.</p>\n<p>&#8220;We in the WordPress accessibility community embrace the challenge of creating a great new experience, and want to assure the community that we are going to do everything we can to make sure that any new editor experience is as accessible as we can possibly make it.&#8221;</p>\n<p>Although the prototype&#8217;s functionality is limited, the team is interested to hear about your experience and expectations with using the editor. Some questions to consider during testing include:</p>\n<ul>\n<li>Talk through each step, what does this do?</li>\n<li>What does this feel like?</li>\n<li>As you use it, what is missing you feel should be there?</li>\n</ul>\n<p>Many users have already <a href=\"https://make.wordpress.org/design/2017/02/09/initial-editor-blocks-prototype-editor-testing/\">shared their experiences</a>, providing valuable insight that is fueling rapid improvements to the <a href=\"https://github.com/WordPress/gutenberg/\">project</a> on<a href=\"https://github.com/WordPress/gutenberg/\"> GitHub</a>.</p>\n<p>The best way to get involved and contribute to this project is to subscribe to the <a href=\"https://make.wordpress.org/design/\">Make WordPress Design</a> blog and provide feedback by commenting on posts. You can also submit pull requests or issues on <a href=\"https://github.com/WordPress/gutenberg/\">GitHub</a>. Weekly meetings dedicated to the Editor component are held on Wednesday at 19:00 CET on <a href=\"https://make.wordpress.org/chat/\">Slack</a> in the <a href=\"https://make.wordpress.org/design/tag/core-editor/\">#core-editor</a> channel.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Feb 2017 18:31:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"HeroPress: A Sense Of True Freedom\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1610\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://heropress.com/essays/sense-true-freedom/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9233:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/02/022217-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: At any given time, I am who I want to be, & I\'m right where I want to be.\" /><p>It’s 7:30 in the morning in Rio de Janeiro, Brazil. The hostel’s cat just came to say “Good morning” and I just finished my night shift on the WPMU DEV forum. It’s my third day in Rio after spending the last 40 days in Bogota, Colombia. Traveling is in my blood or at least, it is now.</p>\n<p>I’m a full-time digital nomad and I have been for over a year now.</p>\n<blockquote><p>I’m single, I’m female and because of WordPress, I can travel around the world and work at the same time.</p></blockquote>\n<p>I started using WordPress in 2009, but I like to think that everything started in 2011 when I attended my first WordCamp in Poland. I remember I was extremely shy, scared and bit lost on the first day of WordCamp.</p>\n<p>It was a different world to me or at least in contrast to what I had at home – a small city in South East Poland. It was different because for the first time in a long time since college, I felt like I fit in with everyone there. They were a right fit for me and so was that place.</p>\n<p>Since that first WordCamp, I also attended many more in Poland as well as in other countries. Later, I went on to be the lead organizer of WordPress meetups in Wrocław and two WordCamps in Poland. I was also a speaker for many Polish events and for one WordCamp Paris.</p>\n<p>If not for the WordPress community and the friends I met on that very first WordCamp, I wouldn’t have been able to achieve any of those accomplishments.</p>\n<blockquote><p>But how could I have become a full-time digital nomad, you ask?</p></blockquote>\n<p>In 2015, I was stuck. I had a great, steady job in Wrocław. I was working with WordPress and everything was perfect, at least, that’s what I thought at the time.</p>\n<p>I achieved almost everything that society around me was expecting: a partner, apartment, a great job and the next step would have been getting married and having kids. Suddenly, I was sinking.</p>\n<p>For a year, the only moments where I was truly happy was when I was attending WordCamps and WordPress meetups – when I was with my “tribe”, my friends.</p>\n<p>Then, in May of 2015, something incredible happened: one of my friends sent me a link to a list of 70 companies which offered positions working remotely. Three of them were related to WordPress: Automattic, OnTheGoSystems and Incsub.</p>\n<p>That same day, I feverishly filled out an application for a position as a Support Star at Incsub, the parent company to WPMU DEV.</p>\n<p>After a wait full of agonizing anticipation, I finally got the job and six months later, I bought a one-way ticket to Japan, then one to Australia.</p>\n<blockquote><p>This was just the start of my life as a digital nomad.</p></blockquote>\n<p>Working at WPMU DEV remotely with partial dedicated hours and the rest being flexible allowed me to move and work while traveling.</p>\n<p>The people I work with comprise the best team ever. My boss, Tim, is incredibly supportive and is willing to help when something bad happens. I didn’t need to be worried about my job when my plans suddenly made a turn for the worse, which did happen. When I had to fly back to Poland in the middle of the week due to family emergencies, it wasn’t a problem.</p>\n<p>I always felt safe in the WordPress community and now I’m grateful to also feel safe with the people I work with even though we’re spread out across the globe and across many cultures.</p>\n<p>Even though I’m confident in my choice of being a digital nomad now, that wasn’t always the case. This was especially true since I apparently managed to make quite the big scandal in my hometown because “good girls” don’t run away.</p>\n<p>To my dismay, I was constantly told, “Study hard and you will get a nice, steady job in an office with insurance and a guaranteed retirement.”</p>\n<p>How could I not want that? After all, that’s supposed to be the dream of every woman, right? That’s what I was constantly told, anyway.</p>\n<p>Luckily, my best friend (who I had met at a WordCamp!) was there for me and said, “Don’t let them get to you. You are far away and they can’t hurt you.”</p>\n<p>Since then, I stood with my decision to finally be free and happy.</p>\n<p>Growing up in small city and being interested in computers and IT was not easy to say the least. Those aren’t traditionally considered subjects that interest girls. It also became all the more difficult when I realized this was something I wanted to do and nothing else.</p>\n<p>There weren’t many people around me in my hometown who understood what I wanted to do and even fewer people who would support me. Unfortunately, this is still true. It became tougher when I was diagnosed with heavy bipolar disorder.</p>\n<blockquote><p>At that time, everything sucked. I was lost and hopeless.</p></blockquote>\n<p>Compounding my stress, it was around then that I realized I also suffered from the impostor syndrome – the belief that you don’t know enough about the industry you’re in to be capable of doing your job and that you never will despite anything you do.</p>\n<p>There was an ugly feeling that crept in: I wanted to be somewhere else and I want to be different.</p>\n<p>Fortunately, every time I attended a WordCamp or WordPress meetup, these thoughts would melt away because I felt completely supported.</p>\n<p>It didn’t matter that I’m a girl or that I’m delightfully weird. What did matter was that I was knowledgeable about WordPress, my skills were growing quickly and that I could contribute to the community using my organizational skills.</p>\n<p>During these meetings, I don’t ever remember someone assuming that I’m a graphic designer because I’m a girl and “girls know color.” There’s nothing wrong with being a graphic designer, but assuming someone is based solely on their gender – there’s definitely something wrong with that.</p>\n<p>In reality, I’m a theme developer and in the WordPress community, that wasn’t unusual.</p>\n<p>It helped me gain confidence in myself and my skills. With that confidence, I found courage to start a life where I’m no longer wanting to be somewhere else or be someone else.</p>\n<blockquote><p>At any given time, I am who I want to be and I’m right where I want to be.</p></blockquote>\n<p>Solo traveling isn’t always peaches and cream or sunshine, lollipops and rainbows everywhere, especially when I’m sick and inevitably alone. All things considered, I wouldn’t swap it out for what many would consider to be a “normal” life – whatever that is – and instead, I think it&#8217;s important for people to do what makes them happy and not just what others expect of them.</p>\n<p>As a digital nomad, I was able to go to WordCamps in Tokyo, Belgrade, the US, Singapore and Vienna. I have met many new people and I have collected incredible memories along the way.</p>\n<p>This year and in many more to come, while others may doubt my choices, I’ll be happy, traveling to more WordCamps and enjoying a sense of true freedom just because I can.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: A Sense Of True Freedom\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=A%20Sense%20Of%20True%20Freedom&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fsense-true-freedom%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: A Sense Of True Freedom\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fsense-true-freedom%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fsense-true-freedom%2F&title=A+Sense+Of+True+Freedom\" rel=\"nofollow\" target=\"_blank\" title=\"Share: A Sense Of True Freedom\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/sense-true-freedom/&media=https://heropress.com/wp-content/uploads/2017/02/022217-150x150.jpg&description=A Sense Of True Freedom\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: A Sense Of True Freedom\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/sense-true-freedom/\" title=\"A Sense Of True Freedom\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/sense-true-freedom/\">A Sense Of True Freedom</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Feb 2017 12:00:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Kasia Świderska\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Solving the Mystery of How People Actually Use WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65557\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/solving-the-mystery-of-how-people-actually-use-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9727:\"<p>I’m in favor of <a href=\"https://wptavern.com/wordpress-telemetry-proposal-addresses-long-standing-privacy-concerns-as-gdpr-compliance-deadline-looms#comment-208658\">WordPress collecting more anonymized usage data</a> that could help make informed decisions on changes or improvements to core, such as tracking changes to the WordPress user interface, which buttons or settings are used most often, etc.</p>\n<p>A good example of when this data could have come in handy is the recent <a href=\"https://wptavern.com/wordpress-4-7-removes-the-underline-and-justify-buttons-from-the-editor\">removal of the justify and underline buttons</a> from the editor in WordPress 4.7. During <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:82\">the discussion</a> on whether they should be removed or not, a number of people questioned if there was any user data available that would indicate how much they’re used and help gauge the impact of removing them.</p>\n<p>The only data available to help make an informed decision was provided by Mel Choyce. Choyce <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:29\">shared statistics</a> from WordPress.com and its variety of editor interfaces that indicated Bold, Italic, and Links are used the most while Lists and Blockquotes are the second most used buttons.</p>\n<p>The Center and Left alignment buttons are used often, but the data doesn’t determine if people are using them to align text or images. Information on which headings are used most was not available. The team did not have any usage data specific to the WordPress core editor.</p>\n<p>In the ticket, Andrew Ozz, who maintains the TinyMCE component, <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:103\" rel=\"nofollow\">chimed in</a> and agreed that good user data is needed.</p>\n<p>In an effort to obtain usage data before removing the buttons, Ozz <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:104\">created a small plugin</a> to perform testing with five existing and first-time users. Interestingly, he discovered that both types of users clicked on the kitchen sink button to display the second row of buttons and didn&#8217;t click the button to hide them again.</p>\n<p>Ozz also shared other results from his limited testing.</p>\n<blockquote><p>I know these test results are extremely limited and cannot be used when making a decision, but they are an indication of what &#8216;real&#8217; testing may reveal. In this case it shows that moving buttons to the bottom row will have no effect on the usage of these buttons as they will still be visible at all times.</p>\n<p>This super limited testing also indicated another (much bigger) problem: somebody mentioned this some time ago (think it was @mor10), around 20% of the WordPress users don’t even know there is a second editor toolbar, and some feel &#8216;pretty stupid&#8217; after discovering it. I think this is bad UX and something that can be fixed easily by having the second toolbar open by default, and fixing it is more important and will improve the UX for these 20% of users a lot.</p></blockquote>\n<p>Imagine how useful it would be for core developers or others if there was usage data like this on a grander scale that could fuel rapid improvements and help discover and eliminate pain points.</p>\n<p>Matt Mullenweg, co-creator of the WordPress project, has <a href=\"https://core.trac.wordpress.org/ticket/38418\">closed the ticket</a> with the Telemetry Proposal as it&#8217;s not within the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\">three project focus areas</a> for 2017.</p>\n<p>&#8220;There is no part of current or potential WP development that is being held back by the lack of this existing, as there are easy and current ways to answer questions with data to the extent it would inform our decisions,&#8221; Mullenweg said.</p>\n<p>Morten Rand-Hendriksen <a href=\"https://core.trac.wordpress.org/ticket/38418#comment:11\">responded to the closure</a> saying that the quantitative user testing falls squarely within the Customizer focus area.</p>\n<p>&#8220;I would argue since the release of the Customizer some years back, it has gone through a multi-year large-scale quantitative user test with incremental tweaks and improvements,&#8221; Rand-Hendriksen said.</p>\n<p>&#8220;This is in line with standard agile development. At this juncture, the Customizer can be considered mature, and moving a mature solution forward requires hard data on usage, use cases, and user needs. This goes beyond standard user testing to large-scale data collection, which is what this ticket aims at addressing.&#8221;</p>\n<h2>Perspective From a WordPress Release Lead</h2>\n<p>There are WordPress core developers who have shown interest in a similar system. At the start of the WordPress 4.7 development cycle, Drew Jaynes, who led the WordPress 4.2 release cycle, <a href=\"https://make.wordpress.org/core/2016/08/17/wordpress-4-7-whats-on-your-mind/#comment-30573\">expressed interest</a> in creating an opt-in data collection system.</p>\n<p>The idea received positive feedback that included people offering to help. I asked Jaynes what his thoughts are on such a system and how it could benefit core development.</p>\n<p>&#8220;There&#8217;s some discussion about what form that collection should take initially, but I think there&#8217;s consensus that it should be opt-in, and take one of two forms (or a hybrid of the two): active (surveys in the admin) or passive (anonymized usage) data collection,&#8221; Jaynes said.</p>\n<p>&#8220;Either way, I think having this data available would benefit the entire community, regardless of the obvious practicable application within core development.</p>\n<p>&#8220;All of that data can and should be used to inform decision-making in WordPress going forward. The core team really needs to hit the reset button on the concept of the 80/20 rule, including what and whom it represents.</p>\n<p>&#8220;We should be building modern WordPress for the modern WordPress user, and resting on Matt&#8217;s instincts coupled with the core team&#8217;s experience is no longer enough to maintain positive forward momentum.&#8221;</p>\n<p>Jaynes cites the editor as an example of where having the data would be helpful and that without it, pursuing an idealized &#8216;modern editor&#8217; in WordPress is premature. The data could also help provide insight into improving the new user experience.</p>\n<p>&#8220;A common complaint is that the WordPress admin can be really overwhelming to new users,&#8221; Jaynes said. &#8220;Having real data about how frequently the various core screens are used could really inform decisions about maybe paring it down, or hiding some things over time that are used less and less.&#8221;</p>\n<p>While collecting data could help with making informed decisions, he doesn&#8217;t think it should stop the core team from experimentation.</p>\n<p>&#8220;I think having real, citable data could really reduce the amount of backlash we&#8217;ve seen with a few releases in the last couple of years,&#8221; Jaynes said. &#8220;Areas where core team decisions left some group of users feeling jilted.&#8221;</p>\n<p>&#8220;It&#8217;s worth mentioning that there&#8217;s absolutely value in allowing the core team to experiment, as long as we&#8217;re careful not to latch onto something that got merged as the only way we&#8217;ll ever need to solve that problem; that&#8217;s where we get into trouble.&#8221;</p>\n<h2>Who Are The 80/20 Users of WordPress?</h2>\n<p>The most striking statement in Rand-Hendriksen&#8217;s proposal is that WordPress development is occurring without having any idea who the 80% or 20% of users are.</p>\n<p>&#8220;During the development of WordPress 4.7, I was involved in several conversations centered around <em>assumed use</em> of features,&#8221; Rand-Hendriksen said.</p>\n<p>&#8220;The general argument was that based on the 80/20 rule, certain features should be added while others should be removed. I kept bringing up the well-known fact we don’t have a clue what features 80%, or even 20%, of WordPress users actually use so any claim of validity in the 80/20 rule is guesswork at best.&#8221;</p>\n<p>Collecting usage data is standard practice. Microsoft Windows, Mozilla Firefox, Chrome, iOS, and a number of other software projects have opt-in data collection systems that are used to improve the product. They also provide insight into how customers are using their products.</p>\n<p>WordPress development on the other hand relies on the support forums, data collected from WordPress.com, limited user testing, verbal feedback at WordCamps, and other small data points. Collecting usage data from WordPress could show trends and provide evidence for changes related to the <a href=\"https://wordpress.org/about/philosophy/\">decisions not options philosophy</a> of WordPress development.</p>\n<p>Collecting usage data isn&#8217;t going to solve all of WordPress&#8217; woes but having it available to make more informed decisions is better than not having any data at all. Although an opt-in data collection system in WordPress won&#8217;t be a core focus any time soon, it&#8217;s encouraging to see the idea has merit and is something some core developers are interested in seeing become a reality.</p>\n<p>I&#8217;d gladly opt-in and share my usage data with WordPress.org as long as it was anonymized and displayed publicly in aggregate. Would you?</p>\nNote: There is a poll embedded within this post, please visit the site to participate in this post\'s poll.\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Feb 2017 02:07:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: BuddyPress 2.8 Boosts Minimum PHP Requirement, Adds Twenty Seventeen Companion Stylesheet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/buddypress-2-8-boosts-minimum-php-requirement-adds-twenty-seventeen-companion-stylesheet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2774:\"<p><a href=\"https://buddypress.org/2017/02/buddypress-2-8-0-san-matteo/\" target=\"_blank\">BuddyPress 2.8</a> “San Matteo,” was released last week, led by long-time BuddyPress contributor Slava Abakumov. The release was named for <a href=\"http://www.sanmatteopanuozzo.com/\" target=\"_blank\">San Matteo Panuozzo</a>, an NYC pizza restaurant that specializes in panuozzo, a more portable pizza-sandwich hybrid. Following suit with the previous release, 2.8 focuses on improvements for developers and site builders, the project&#8217;s new target audience as of 2016.</p>\n<p>As part of an effort to modernize the plugin&#8217;s codebase and prepare it for better integration with the BP REST API project, this release <a href=\"https://codex.buddypress.org/getting-started/buddypress-2-8-will-require-php-5-3/\" target=\"_blank\">boosts the minimum PHP requirement to 5.3</a>. In BuddyPress versions 2.7+, the plugin will display a notice in the dashboard if it detects that the server doesn&#8217;t meet the minimum requirements for running 2.8. The change is not likely to affect many BuddyPress sites as only a small sliver (5.7%) of WordPress sites are running on PHP 5.2.</p>\n<p>This release also adds a companion stylesheet for <a href=\"https://wordpress.org/themes/twentyseventeen/\" target=\"_blank\">Twenty Seventeen</a>. This stylesheet is important for providing a good first impression of BuddyPress for those who are trying try out the plugin with WordPress&#8217; latest default theme. A <a href=\"https://codex.buddypress.org/themes/bp-theme-compatibility-and-the-wordpress-default-themes/twenty-seventeen-theme/\" target=\"_blank\">new BP codex page</a> gives sample code for changing Twenty Seventeen&#8217;s default two-column layout to be a full-width layout.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/buddypress-twenty-seventeen.png?ssl=1\"><img /></a></p>\n<p>The 2.8 release brings improvements to the “Activate Pending Accounts” screen, making it easier for site managers to confirm or reject new registrants. Clicking on the username of a pending account will now display profile data that the user entered at signup.</p>\n<p>Other improvements for developers include the following:</p>\n<ul>\n<li>New filters and actions for the Messages component</li>\n<li>Support for List-Unsubscribe header in emails</li>\n<li>More flexible Group search</li>\n<li>New filter enables choice of which PHPMailer should be used when sending BuddyPress emails</li>\n</ul>\n<p>BuddyPress 2.8 was made possible by 44 volunteer contributors. For a full list of all the changes in this release, check out the official <a href=\"https://codex.buddypress.org/releases/version-2-8-0/\" target=\"_blank\">2.8.0 changelog</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Feb 2017 00:33:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Composing a WordPress Development Environment with Docker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/composing-a-wordpress-development-environment-with-docker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6432:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/petersuhm.jpeg?ssl=1\"><img /></a>This post was contributed by guest author <a href=\"http://petersuhm.com/\" target=\"_blank\">Peter Suhm</a>. Peter is a web developer from the Land of the Danes. He is the creator of <a href=\"https://wptavern.com/wp-pusher-aims-to-provide-pain-free-deployment-of-wordpress-themes-and-plugins-from-github\" target=\"_blank\">WP Pusher</a> and a huge travel addict, bringing his work along with him as he goes.<br />\n&nbsp;</p>\n<hr />\n<p>In the last few years, a wave of virtualization technologies have swept through our WordPress development environments. The one that&#8217;s sounded the most promising to me has been Docker: lightweight and flexible. Yet, until recently, getting Docker up and running was an overwhelming task &#8211; especially on a non-Linux machine. If you managed to get it up and running in a virtual machine (using Vagrant or similar), getting port-forwarding to work would make you give up and just use Vagrant instead.</p>\n<p>Now it&#8217;s different.</p>\n<p>With (a stable) Docker for Mac and Windows and <a href=\"https://docs.docker.com/compose/\" target=\"_blank\">Docker Compose</a> at hand, getting Docker up and running is easy and pain-free. With Docker Compose you can tell Docker exactly what you want your WordPress development environment to look like and it will take care of it.</p>\n<h3>What is Docker?</h3>\n<p>Docker is a technology that makes it really simple to create isolated containers for your applications and websites to run in. These containers can be combined and modified to fit the needs of your applications. Docker is utilizing the Linux Containers technology (LXC) where multiple isolated environments can share the same Linux kernel &#8211; making it very lightweight compared to something like Vagrant.</p>\n<p>The Docker ecosystem is built around containers. In the Docker Hub, you can find an endless number of containers that other people have built or you can build your own using a Dockerfile. When building your own, you can start from scratch using the base Ubuntu image or extend someone else&#8217;s image.</p>\n<p>You can share local directories with your containers and link the networks, so they can talk to each other &#8211; just like you know it from other virtualization technologies. However, this is where it gets complicated which leads me to Docker Compose:</p>\n<h3>What is Docker Compose?</h3>\n<p>Docker Compose is what makes Docker available to mortals like you and me. As the name implies, Docker Compose is a tool for composing Docker containers. That means defining your services (containers), setting up the network between them, sharing local directories with them, and a few more things.</p>\n<p>With Docker Compose you create a simple file in the root of your project that describes the setup required by your application/website. For a WordPress theme that might mean a container to run WordPress, a container to run MySQL and a container to run Gulp or Grunt. This can very easily be defined in a docker-compose.yml file that can then be shared with your team members. This means that you can now share your WordPress theme, including an isolated WordPress environment to run it in. Hurray for virtualization!</p>\n<h3>Why use Docker?</h3>\n<p>There are a few reasons why Docker is an attractive technology for me. Here are the most important requirements I have for my development environment and how Docker solves them:</p>\n<ul>\n<li><strong>Clean Mac:</strong> In an ideal world, I prefer not to install anything related to my development environment directly on my Mac. I work on so many different projects that this gets unmanageable. When one thing works, another doesn&#8217;t. I also travel a lot and should something happen to my computer, I want to be able to set up a new machine in minutes.</li>\n<li><strong>Shareable:</strong> I often work in teams, so sharing my development environment with teammates is crucial. This is possible with Vagrant, but it&#8217;s still very tricky to keep environments in sync across teams.</li>\n<li><strong>Lightweight:</strong> This is important, especially when on the road. Try running a few Vagrant boxes compared to a few Docker containers and see what I mean.</li>\n<li><strong>Extendable:</strong> Extending Docker is very easy. For example, I could extend the official WordPress container and build it with WP Pusher pre-installed, since I (obviously) always use it.</li>\n<li><strong>Mirror production:</strong> My development environment needs to be as close to production as possible. With Docker this is easy, since Docker can be used in production as well.</li>\n</ul>\n<h3>My Docker development environment</h3>\n<p>This is the very simple Docker setup I use for development of my WP Pusher plugin: A WordPress and a MySQL container. Both of them use the official Docker Hub images, so setting it up is very easy.</p>\n<p>My <code>docker-compose.yml</code> file looks like this:</p>\n<p></p>\n<p>It describes two services: a MySQL 5.7 database and WordPress running on PHP 5.6 and Apache. The database is using a volume on my local machine, so data will be persisted every time I shut off the container. My current directory (in this case a plugin) is mounted into the <code>wp-content/plugins</code> directory. This allows me to work on my plugin in a completely isolated WordPress environment &#8211; without installing anything, besides Docker, on my Mac. The WordPress container forwards port 80 to my local machine, so I can access it as &#8220;localhost&#8221; in my browser.</p>\n<p>If you want to try it for yourself, and have Docker installed on your machine, just add the file to your plugin (or theme) and run:</p>\n<p><code>$ docker-compose up -d</code></p>\n<p>In order to see which containers are running, just run:</p>\n<p><code>$ docker ps</code></p>\n<p>This a very simple setup that is easy to extend and build upon.</p>\n<p>I hope this post made you curious about Docker and WordPress. Thanks for reading along!</p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://docs.docker.com/compose/\" target=\"_blank\">Docker Compose</a></li>\n<li><a href=\"https://hub.docker.com/\" target=\"_blank\">Docker Hub</a></li>\n<li><a href=\"https://blog.wppusher.com/the-easiest-way-to-use-docker-for-wordpress-development/\" target=\"_blank\">My Docker setup for WP Pusher</a></li>\n</ul>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Feb 2017 18:23:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"WPTavern: Disqus Hits Sites with Unwanted Advertising, Plans to Charge Large Publishers a Monthly Fee to Remove Ads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66098\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/disqus-hits-sites-with-unwanted-advertising-plans-to-charge-large-publishers-a-monthly-fee-to-remove-ads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7974:\"<p>When Disqus <a href=\"https://blog.disqus.com/our-plans-for-2017\" target=\"_blank\">announced</a> it would be releasing new, subscription-based versions later this year, users didn&#8217;t expect to have the new advertising model injected into their sites without notice. Disqus CEO Daniel Ha said the company would release finalized pricing and provide more details well in advance of its planned March release, but users are reporting that the advertising has already been forced into their comments without warning.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Why did <a href=\"https://twitter.com/disqus\">@disqus</a> just add a bunch of ads to my site without my permission? <a href=\"https://t.co/CzXTTuGs67\">https://t.co/CzXTTuGs67</a> <a href=\"https://t.co/y2QbFFzM8U\">pic.twitter.com/y2QbFFzM8U</a></p>\n<p>&mdash; Harry Campbell (@TheRideShareGuy) <a href=\"https://twitter.com/TheRideShareGuy/status/826921387273052160\">February 1, 2017</a></p></blockquote>\n<p></p>\n<p>&#8220;We are one of the lucky 5% who now has to pay if we don&#8217;t want really irrelevant and horribly spammy links just plopped on our site with zero warning,&#8221; BabyCenter Social Media Manager Dina Vernon Freeman said. &#8220;Unless our users (mainly millennial parents) should care about overpaying for dentures! We&#8217;re looking for other platforms ASAP.&#8221;</p>\n<p>Brian O&#8217;Neill, who manages Slugger O&#8217;Toole, a site with more than 70,000 readers, was also hit with unwanted advertising on his site.</p>\n<p>&#8220;Disqus has started to put ads into our comments section of our site without even telling us,&#8221; O&#8217;Neill said in a <a href=\"https://sluggerotoole.com/2017/02/02/bear-with-us-as-we-try-to-remove-those-terrible-disqus-ads-from-the-comments-area/\" target=\"_blank\">post</a> explaining the new ads to the site&#8217;s readers. &#8220;As you can imagine I am extremely annoyed at this – I hate crappy online ads as much as you do. Supposedly we can remove the ads if we pay them $10 a month, but as yet there is no mechanism on their site to do this.&#8221; O&#8217;Neill said he is also exploring alternative commenting systems if he is unable to remove the advertising.</p>\n<p>Disqus responded to user complaints with a post to clarify that <a href=\"https://blog.disqus.com/advertising-will-remain-optional-for-over-95-of-sites-on-disqus\" target=\"_blank\">advertising will remain optional for more than 95% of the sites on Disqus</a>.</p>\n<p>&#8220;Larger, commercial, sites that elect to use the free version of Disqus will be supported by configurable advertising and have the option to earn revenue through the Reveal program,&#8221; Disqus Marketing Manager Mario Paganini said. &#8220;For small, non-commercial sites, advertising will be optional. These sites will be able to use Disqus’ ads-optional subscription, free of charge.&#8221;</p>\n<p>Publishers asked in the comments when the option to pay to remove ads will become available, as an option to pay isn&#8217;t currently in place.</p>\n<p>&#8220;Larger sites will be able to run a paid subscription version of Disqus that includes the ability to remove ads along with additional features,&#8221; Paganini said. &#8220;We are aiming to have this available in the next couple of months. We will be making periodic updates on our blog and talking to publishers in the meantime.&#8221;</p>\n<p>Disqus is moving to focus on its larger publishers but has already attracted angry criticism from publishers that were not properly informed of the changes. Over the years the company has experimented with different ways of monetizing the commenting platform, often frustrating users in the process of making important changes.</p>\n<p>In 2014, Disqus began experimenting with advertising in the form of &#8220;Sponsored Comments&#8221; that users could not turn off without contacting support. This move drew <a href=\"https://ma.tt/2014/11/disqus-spam-ads/\" target=\"_blank\">criticism from WordPress co-founder Matt Mullenweg</a> who essentially called out the ads as little more than comment spam. After a negative reaction from its community, Disqus quietly discontinued the Sponsored Comments and scrubbed the <a href=\"https://blog.disqus.com/heads-up-were-testing-a-new-form-of-advertising\" target=\"_blank\">announcement post</a> from the internet.</p>\n<h3>Disqus Delivers Low-Quality Ads</h3>\n<p>Disqus has struggled to land on an effective advertising model that will convince users to get on board. Its <a href=\"https://help.disqus.com/customer/portal/articles/2069645-reveal-f-a-q-\" target=\"_blank\">Reveal advertising program</a> is notorious for serving low-quality ads and has inspired little confidence in users who have tried it. The following is one of the tamer examples:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/disqus-ads.png?ssl=1\"><img /></a></p>\n<p>&#8220;I think if you had somewhat decent advertising you might convince people that it&#8217;s worth it, but I had to yank it from one of my sites because it was all &#8216;Ron Paul wants you to buy gold!&#8217; and &#8217;22 times the photos showed too much!\'&#8221; Paul King, an author who writes for multiple publications, commented on Disqus&#8217; most recent advertising announcement. &#8220;Just put in a tier of non-spam advertising that&#8217;s actually relevant or charge based on comments or something.&#8221;</p>\n<p>Twitter is filled with complaints from users who are dissatisfied with the questionable quality of Disqus&#8217; advertising. Many are searching for alternatives.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/disqus\">@disqus</a> We\'ve disabled ads straight away (they are literally ALL scams) &#8211; if you force those ads on us, we\'re dropping you like a hot potato</p>\n<p>&mdash; That\'s Nonsense (@thatsnonsense) <a href=\"https://twitter.com/thatsnonsense/status/828739990486208512\">February 6, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Why <a href=\"https://twitter.com/disqus\">@disqus</a> think it\'s acceptable to serve disgusting, misogynistic ads (OR ANY ADS) on people\'s blogs without asking is beyond me.</p>\n<p>&mdash; Rosie (@RosieLondoner) <a href=\"https://twitter.com/RosieLondoner/status/828642646478426112\">February 6, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">I\'m removing <a href=\"https://twitter.com/hashtag/disqus?src=hash\">#disqus</a> from <a href=\"https://t.co/PSlovlA6Tm\">https://t.co/PSlovlA6Tm</a> since they\'ve suddenly turned on (notably creepy) ads with no warning.</p>\n<p>&mdash; James Britt <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /> (@jamesbritt) <a href=\"https://twitter.com/jamesbritt/status/826922670407172096\">February 1, 2017</a></p></blockquote>\n<p></p>\n<p>This recent move to turn on advertising without publishers&#8217; permission is another communication blunder in the same vein as the previous attempt at Sponsored Comments. Disqus has failed to find a communication strategy that respects users&#8217; content while leading the company towards its goals at the same time. With spam-quality ads deploying network-wide, the company can certainly expect that some users will be willing to pay the $10/month to turn them off. Sadly, the experience of paying to turn off offensive ads feels more like getting mugged on your way to work than upgrading your service.</p>\n<p>The <a href=\"https://wordpress.org/plugins/disqus-comment-system/\" target=\"_blank\">Disqus Comment System</a> plugin has been hovering around 200,000 active sites for the past two years and its ratings continue to plummet on WordPress.org. Unless Disqus is able to dramatically improve its advertising network before its official March release, we may see a mass exodus to other commenting systems.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Feb 2017 00:16:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: How to Check if Installed Plugins Are No Longer in the Plugin Directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66106\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/how-to-check-if-installed-plugins-are-no-longer-in-the-plugin-directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9904:\"<p>When we wrote about <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">why plugins sometimes disappear</a> from the WordPress plugin directory, it generated a healthy discussion in the comments. One of the topics of discussion brought up is whether or not <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory#comment-209733\">users should be notified</a> when a plugin disappears and if so, how?</p>\n<p>Currently, when a plugin is hidden on the directory, users are not notified. If it&#8217;s removed due to a security vulnerability and the author chooses not to fix it or move the plugin somewhere else such as <a href=\"https://github.com/\">GitHub</a>, users are left in the dark.</p>\n<p>Donna Cavalier shared a <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/\">recent example</a> of why users should be notified. Contact Form DB is a popular plugin that saves contact form submissions from many popular Contact Forms plugins to the database. As of <a href=\"https://web.archive.org/web/20161030050515/https://wordpress.org/plugins/contact-form-7-to-database-extension/\">October 30th, 2016</a>, it was actively installed on more than 400K sites.</p>\n<p>Approximately <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/\">one month ago</a>, the plugin was hidden due to a security vulnerability. Instead of releasing a patch, Michael Simpson, creator of Contact Form DB, moved the plugin <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases\">to GitHub</a> and subsequently released a <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">new version</a> that patched the vulnerability. Simpson says the person on the plugin review team that he spoke with was condescending, unprofessional, and rubbed him the wrong way.</p>\n<p>&#8220;I’m happy to address any issues and meet any standards, but I’m at the limit of my patience,&#8221; Simpson said.</p>\n<p>&#8220;I try to be a good citizen and give back to the community. I’ve put in countless hours for close to seven years now. When I’m treated like this, it seems WordPress doesn’t value me or my contribution to its community.</p>\n<p>&#8220;Anyway, I put the code on GitHub and I will continue to support it. But at this point I’m not sure I want to deal with people like this to re-list the plugin on this site. I don’t need the frustration.&#8221;</p>\n<p><strong>If you use Contact Form DB, please <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">update to 2.10.30</a> as soon as possible as it contains the aforementioned security fix.</strong></p>\n<p>It&#8217;s impossible for Contact Form DB users to automatically install updates from GitHub without installing an <a href=\"https://wptavern.com/github-updater-4-1-to-add-remote-installation-for-wordpress-plugins-and-themes\">updater plugin</a>. This leaves thousands of sites at risk.</p>\n<h2>How to Know When Installed Plugins Are No Longer in the Directory</h2>\n<p>In the comments of <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">our article</a>, Tavern reader Central Geek <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory#comment-209776\">shared links</a> to a couple of plugins aimed at providing useful information such as, whether a <a href=\"https://wordpress.org/plugins/vendi-abandoned-plugin-check/\">plugin has been abandoned</a> and <a href=\"https://wordpress.org/plugins/better-plugin-compatibility-control/\">better plugin compatibility information</a>.</p>\n<p>One of the plugins he mentions is called <a href=\"https://wordpress.org/plugins/no-longer-in-directory/\">No Longer in Directory, </a>developed by <a href=\"https://profiles.wordpress.org/whitefirdesign/\">White Fir Design</a>. The plugin adds a page to the WordPress backend that informs users if any of the plugins that are installed are available in the plugin directory. It also separately lists installed plugins that haven&#8217;t been updated in two years or more.</p>\n<p><img /></p>\n<p>The check is performed using the plugin directory&#8217;s folder name. The author notes that this could lead to plugins that have never been in the plugin directory to be flagged if they use the same name as a plugin that was in the directory in the past. If you encounter this situation, you&#8217;re encouraged to create a new thread on the <a href=\"https://wordpress.org/support/plugin/no-longer-in-directory\">plugin&#8217;s support forum</a>.</p>\n<p>So far, No Longer in Directory is actively installed on more than 1K sites. Out of a total of <a href=\"https://wordpress.org/support/plugin/no-longer-in-directory/reviews/\">six reviews</a>, its average rating is 4.8 out of 5 stars. I tested the plugin with WordPress 4.8 alpha and didn&#8217;t encounter any issues.</p>\n<p>If this is a feature you&#8217;d like to see implemented in WordPress, consider <a href=\"https://wordpress.org/ideas/topic/alert-when-installed-plugins-have-been-removed-from-the-plugin-directory\">voting for it</a>. So far, the idea has 43 votes with a five-star average rating. <a href=\"https://profiles.wordpress.org/ipstenu\">Mika Epstein</a>, Plugin Directory Representative, <a href=\"https://wordpress.org/ideas/topic/alert-when-installed-plugins-have-been-removed-from-the-plugin-directory#post-22481\">responded to the idea</a> four years ago noting that it was being worked on.</p>\n<p>As Epstein mentioned in our previous article, explaining WHY a plugin has been closed is complex.</p>\n<p>“Obviously the last thing we want are people getting hacked, but it presents us with a few options and they all have flaws,&#8221; she said.</p>\n<p>&#8220;We’ve not been able to determine a way to tell people ‘This plugin is gone, don’t use it’ and ‘This plugin is gone, but use it if you want.’ without putting users at risk.”</p>\n<h2>If a Plugin Is Permanently Removed From the Directory, Users Should Be Notified</h2>\n<p>I believe users should be informed if a plugin is permanently removed from the directory. It doesn&#8217;t make sense to notify users if it&#8217;s temporarily hidden due to violating a guideline or a security issue. Plus, between upgrade and admin notices, users are receiving enough notifications as it is.</p>\n<p>I&#8217;m unsure if the notification should be an admin notice as we&#8217;ve <a href=\"https://wptavern.com/please-stop-abusing-wordpress-admin-notices\">already documented</a> how plugin authors are using them to advertise. Users are increasingly getting annoyed by them and they&#8217;re usefulness is in decline.</p>\n<p>There&#8217;s also the question as to who is responsible for informing users. This responsibility should fall squarely on the plugin author. If I was a plugin author and not interested in someone <a href=\"https://wptavern.com/adopt-me-plugin-tag-is-now-in-use-on-wordpress-org\">adopting my plugin</a> and wanted it removed from the directory, I&#8217;d do so by pushing out one last update.</p>\n<p>I&#8217;d explain in the plugin&#8217;s description and changelog that support and updates would no longer occur and that users should seek alternatives. I might even suggest a few that come to mind. Then, after about a month, I&#8217;d submit a request to the plugin review team to permanently remove it.</p>\n<p>This would give users a heads up and plenty of time to seek out an alternative. The Post Template plugin is a good example of this idea in action. Here is the notice it displayed on all of its settings pages before it disappeared.</p>\n<blockquote><p><strong>Since version 4.0.0, the plugin has been released under a commercial license. New features such as addition of custom fields to the templates have been added. Furthermore, this version is discontinued, which means that no further bug fixes, new features and compatibility fixes for new WordPress versions will be implemented. If you want to buy the latest version of Post Template, please visit the plugin web page.</strong></p></blockquote>\n<p>By notifying users ahead of time, the responsibility shifts to the user to find an alternative.</p>\n<p><a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/page/2/#post-8726059\">Simpon </a>said he&#8217;ll work to get the plugin re-listed but it may take some time as he&#8217;s swamped with work. At the time of publishing, <a href=\"https://wordpress.org/plugins/contact-form-7-to-database-extension/\">the plugin</a> is not available on WordPress.org.</p>\n<h2>An Unfortunate Situation for Users of Contact Form DB</h2>\n<p>While <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/page/2/\">users sympathized</a> with Simpson over his decision, I think it&#8217;s partly irresponsible. If a plugin has a security vulnerability, patching it and making it available as soon as possible should take precedence over how one feels about a situation.</p>\n<p>Instead of putting aside differences and pushing out an update to patch a security vulnerability, Simpson chose to move the plugin and the patched version to GitHub. The decision not to work with the plugin review team has put thousands of sites at risk with no easy way for users to update.</p>\n<p>Hopefully, Simpson will work with the team to get a patched version of Contact Form DB back onto the directory as soon as possible. Until then, if you use Contact Form DB, please <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">update to 2.10.30</a> manually as it patches the security vulnerability.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Feb 2017 08:52:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: WPWeekly Episode 263 – Plugins Disappearing, WordCamp Miami, and OSTraining\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=66103&preview=true&preview_id=66103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/wpweekly-episode-263-plugins-disappearing-wordcamp-miami-and-ostraining\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3129:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I discuss the news making headlines including, WordCamp Miami in its 9th year, OSTraining partnering with GoDaddy to release training videos, and why plugins sometimes disappear from the WordPress plugin directory. We also provide an update on the REST API vulnerability that is actively being exploited to deface webpages.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-exploits-continue\">WordPress REST API Vulnerability Exploits Continue</a><br />\n<a href=\"https://wptavern.com/google-changes-the-wording-of-its-wordpress-update-notifications\">Google Webmaster Tools Fixes Confusing Messages About Updating WordPress</a><br />\n<a href=\"https://wptavern.com/wordcamp-miami-2017-to-host-javascript-track-ama-spots-and-2-day-kids-camp\">WordCamp Miami 2017 to Host JavaScript Track, AMA Spots, and 2-Day Kids’ Camp</a><br />\n<a href=\"https://wptavern.com/ostraining-partners-with-godaddy-to-launch-free-wordpress-beginner-course-on-youtube\">OSTraining Partners with GoDaddy to Launch Free WordPress Beginner Course on YouTube</a><br />\n<a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">Why Plugins Sometimes Disappear From the WordPress Plugin Directory</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/mobile-featured-image/\">Mobile Featured Image</a> allows users to add a featured image specifically for mobile devices. The new image can be a resized version of your featured image or an entirely new image targeted especially at mobile viewers.</p>\n<p><a href=\"https://wordpress.org/plugins/fb-messenger-bot/\">FB Messenger Bot for WooCommerce</a> automatically messages clients from your Facebook page, WooCommerce, or Gravity Forms. The plugin creates a &#8216;send to Facebook&#8217; button at the end of the WooCommerce Sales process or on the Gravity Forms thank you page.</p>\n<p><a href=\"https://wordpress.org/plugins/restrict-new-users-by-domain/\">Restrict New Users by Domain </a>makes it easy to whitelist or blacklist email domains that new users can use when registering. If using the whitelist, only new users who enter an email domain on the whitelist will be allowed to create an account. If using the blacklist, a user who enters an email domain on the blacklist will be unable to register.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, February 22nd 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #263:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Feb 2017 23:01:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Post Status: LoopConf in review\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://poststatus.com/?post_type=poststatus_notes&p=33889\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/loopconf/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46039:\"<p><a href=\"https://loopconf.com/\">LoopConf</a> is a developer centric conference, and LoopConf &#8220;2.1&#8221; took place in Salt Lake City in early February. This second iteration of the event was a great one, with informative, diverse talks, a laid back atmosphere, and it was very well organized &#8212; which is especially impressive considering the challenges that mother nature caused. As an added bonus, you can now <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">watch all the talks for free</a>.</p>\n<p>Originally planned for Miami last year, LoopConf was postponed due to a hurricane in southern Florida &#8212; hence the &#8220;.1&#8221; above &#8212; and rescheduled closer to organizer Ryan Sullivan&#8217;s home in Salt Lake City. Despite the postponement, most attendees were still able to make it, and some folks (like me) could only go to the newly scheduled event.</p>\n<p>Salt Lake City was unseasonably warm, making it a pleasant few days, mixed with great food and company. It was also a pleasure to be able to meet more people from local companies, including the newly minted BlueHost and MOJO headquarters downtown.</p>\n<p>Post Status was at LoopConf as a media partner, and <a href=\"https://poststatus.com/profiles/brian-richards/\">Brian Richards</a> and I took a lot of pictures, as well as several video interviews.</p>\n<h3>What to know about LoopConf</h3>\n<p>In our first video interview, Ryan talked about the origins of LoopConf, and described what he hoped attendees would get out of the event:</p>\n<p></p>\n<p>I hope to see a future LoopConf 3, and I think the venue and atmosphere worked really well in Salt Lake City.</p>\n<h3>A small sampling of valuable talks</h3>\n<p>There were many great talks. I didn&#8217;t attend them all, as I was working on other stuff for much of the two days, but the feedback was pretty universally positive, and every talk I did attend, I found valuable.</p>\n<h4>The competitive landscape for WordPress</h4>\n<p><img /></p>\n<p>The first day kicked off with a great talk by Pantheon co-founder Josh Koenig, who spoke on the <a href=\"https://youtu.be/BsKkFf4vDyw?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">competitive landscape for WordPress</a>, including opportunities and risks. It was a really excellent start to the event.</p>\n<h4>Empathetic communication</h4>\n<p><img /></p>\n<p>I met Sharon Steed prior to her talk, and she spoke about <a href=\"https://www.youtube.com/watch?v=Ke9hfBKebxc\">empathetic communication</a>. And due to her own journey as a communicator, going through life with a stutter, it has impacted how she thinks about communication and how she advises her clients.</p>\n<p>There were two quotes I loved: &#8220;Technology cannot replace the social aspect of face-to-face communication.&#8221; And, &#8220;Silence kills collaboration.&#8221; I think greater empathy in our ecosystem and society in general is pivotal.</p>\n<h3>Put an &#8220;S&#8221; on it</h3>\n<p><img /></p>\n<p>I don&#8217;t know anyone who knows more about HTTPS than Zack Tollman, who directed the effort to make WIRED&#8217;s website fully HTTPS. They learned many lessons, and he <a href=\"https://youtu.be/McAzEj2iXaA?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">shares them in his outstanding talk</a>.</p>\n<h4>Bootstrapping a WordPress business</h4>\n<p><img /></p>\n<p>The <a href=\"https://poststatus.com/jason-cohen-wp-engine-founder/\">most recent podcast</a> episode featured a video interview and extended audio interview with <a href=\"https://wpengine.com\">WP Engine</a> founder and LoopConf keynote speaker Jason Cohen, which I highly recommend you check out. Jason is full of knowledge, and my interview with him pairs well with his keynote talk.</p>\n<p>Jason&#8217;s talk will certainly get you thinking about whether you should raise your prices, that&#8217;s for sure.</p>\n<h4>Watch them all!</h4>\n<p>Don&#8217;t take my word for which talks to see. I just feature these because I got a lot out of them in the moment. However, in general I found this lineup to be one of the most proficient groups of speakers I&#8217;ve seen yet at a WordPress event.</p>\n<p>Check out <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">the whole playlist</a>.</p>\n<h3>Pictures</h3>\n<p>Here are pictures from the three days of workshops and talks.</p>\n\n<a href=\"https://poststatus.com/loopconf/loopconf2-0004/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0004-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0008/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0008-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0011/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0011-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0017/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0017-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0018/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0018-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0019/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0019-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0021/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0021-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0028/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0028-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0033/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0033-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0036/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0036-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0039/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0039-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0051/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0051-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0052/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0052-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0053/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0053-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0056/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0056-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0057/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0057-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0062/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0062-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0063/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0063-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0068/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0068-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0075/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0075-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0077/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0077-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0079/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0079-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0086/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0086-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0087/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0087-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0088/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0088-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0091/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0091-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0115/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0115-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0129/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0129-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0135/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0135-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0136/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0136-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0146/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0146-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-0149/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0149-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1735/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1735-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1746/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1746-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1757/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1757-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1775/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1775-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1778/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1778-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1795/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1795-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1808/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1808-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1809/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1809-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1812/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1812-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1818/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1818-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1819/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1819-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1824/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1824-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1826/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1826-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1831/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1831-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1836/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1836-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1841/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1841-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1854/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1854-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1856/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1856-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1862/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1862-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1868/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1868-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1894/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1894-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1897/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1897-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1911/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1911-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1921/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1921-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1928/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1928-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1936/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1936-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1937/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1937-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1954/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1954-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1968/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1968-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1978/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1978-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1979/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1979-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1983/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1983-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1986/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1986-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1991/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1991-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-1996/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1996-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2005/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2005-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2015/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2015-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2030/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2030-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2042/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2042-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2043/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2043-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2049/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2049-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2062/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2062-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2079/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2079-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2080/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2080-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2093/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2093-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2103/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2103-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2106/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2106-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2119/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2119-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2151/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2151-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2163/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2163-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2172/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2172-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2180/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2180-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2194/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2194-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2215/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2215-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2240/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2240-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2253/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2253-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2290/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2290-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2291/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2291-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2293/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2293-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2311/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2311-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2330/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2330-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2334/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2334-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2370/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2370-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2377/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2377-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2380/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2380-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2390/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2390-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2413/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2413-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2447/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2447-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2466/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2466-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2487/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2487-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2511/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2511-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2515/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2515-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2517/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2517-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2521/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2521-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2528/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2528-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2531/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2531-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2532/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2532-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2533/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2533-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2536/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2536-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2538/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2538-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2541/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2541-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2542/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2542-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2546/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2546-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2561/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2561-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2570/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2570-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2590/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2590-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2597/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2597-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2599/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2599-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2615/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2615-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2617/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2617-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-2652/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2652-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9825/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9825-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9826/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9826-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9828/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9828-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9830/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9830-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9831/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9831-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9833/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9833-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9835/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9835-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9837/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9837-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9839/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9839-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9846/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9846-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9848/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9848-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9850/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9850-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9851/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9851-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9859/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9859-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9863/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9863-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9866/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9866-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9868/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9868-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9876/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9876-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9879/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9879-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9885/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9885-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9887/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9887-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9888/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9888-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9892/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9892-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9895/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9895-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9904/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9904-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9905/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9905-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9911/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9911-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9914/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9914-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9929/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9929-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9933/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9933-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9940/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9940-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9941/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9941-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9949/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9949-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9953/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9953-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9956/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9956-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9960/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9960-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9962/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9962-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9965/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9965-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9967/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9967-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9969/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9969-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9970/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9970-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9971/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9971-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9976/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9976-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9993/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9993-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9986/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9986-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n<a href=\"https://poststatus.com/loopconf/loopconf2-9981/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9981-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>\n\n<p>You are welcome to use these pictures however you wish. If you&#8217;d like to credit Brian Richards or myself, or Post Status, we&#8217;d appreciate it &#8212; but it&#8217;s not required. Pictures he took show Canon 6D in the meta description, and pictures I took show Canon 70D in the description.</p>\n<h3>More interviews from LoopConf</h3>\n<p>I&#8217;ll have more interviews from LoopConf over the coming days and weeks. I chatted with several core contributors and developers about specific experiences they&#8217;ve had with WordPress. Keep an eye out for those!</p>\n<h3>A fun, niche event with a lot of value</h3>\n<p>LoopConf was pretty laid back, and did a lot of things really well.</p>\n<p>For one, I&#8217;m super jealous of how quickly they got the videos uploaded, and they&#8217;ve generously made them available for free for everyone. Also, there were no noticeable event hiccups, and the team was always available to help with whatever attendees may need.</p>\n<p>The venue itself was really nice, as you can hopefully see in the pictures, and the whole place was laid out in a way that made both the talks and the hallway track highly accessible. And sponsors were in the center of the whole event, which was great.</p>\n<p>I found that the size of the event (I&#8217;d guess around 200 people) made it so that conversations were easy to have, and we were able to go in-depth. And because everything from breakfast to dinner to the after party were at the venue, it made everything super convenient.</p>\n<p>If and when there&#8217;s a LoopConf 3, you should go! I&#8217;ve also found this general theme to be true at other niche WordPress events &#8212; including <a href=\"https://adayofrest.hm\">A Day of REST</a> (specific to the REST API in WordPress, which you should go to next month!) and <a href=\"https://pressnomics.com\">PressNomics</a> (a WordPress business event, which you should go to in April!), and even my own <a href=\"https://poststatus.com/publish\">Publish</a> event (which may have a second iteration later this year).</p>\n<p>To learn more about LoopConf, <a href=\"https://loopconf.com/\">check out the website</a>. And definitely take advantage of all of those <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">free videos</a>!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Feb 2017 20:00:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"WPTavern: Matt Mullenweg Responds to Security Rant: Digital Signatures for WordPress Updates Are Important but Not a Priority\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66076\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"https://wptavern.com/matt-mullenweg-responds-to-security-rant-digital-signatures-for-wordpress-updates-are-important-but-not-a-priority\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8422:\"<p>Scott Arciszewski, Chief Development Officer for Paragon Initiative Enterprises, who is most widely known for his <a href=\"https://paragonie.com/blog/2017/02/cryptographically-secure-php-development\">cryptography engineering work</a>, published a post on Medium criticizing Matt Mullenweg, co-creator of the WordPress open-source software project, for not caring enough about security. Arciszewski has since retracted the post but you can <a href=\"http://web.archive.org/web/20170214062414/https://medium.com/@CiPHPerCoder/stopmullware-on-the-security-of-27-of-the-websites-on-the-internet-298a7e5b6871\">read it</a> via the Wayback Machine.</p>\n<p>Arciszewski is working on a project known as <a href=\"https://download.libsodium.org/doc/\">libsodium</a>, a core extension to PHP 7.2 which allows for encryption, decryption, signatures, password hashing and more. Its goal is to enable developers to build higher-level cryptographic tools.</p>\n<p>WordPress&#8217; automatic update system is handled through api.wordpress.org. Since updates do not have a digital signature, if api.wordpress.org were compromised, attackers could send malicious updates to thousands or millions of sites. This scenario was at the forefront of people&#8217;s minds late last year after Wordfence <a href=\"https://www.wordfence.com/blog/2016/11/hacking-27-web-via-wordpress-auto-update/\">published details</a> of a complex security vulnerability that could have compromised the update servers.</p>\n<p>Arciszewski suggests offline code signing and elliptic curve cryptography as solutions, &#8220;The key that can produce a valid signature for a file isn’t stored on the server (only the file itself and a valid signature are), so even if the server gets hacked, attackers can’t just add trojan horse malware to the file,&#8221; he said.</p>\n<p><a href=\"http://php.net/manual/en/book.openssl.php\">OpenSSL</a> is an extension of PHP and is commonly used as public-key cryptography but it only supports RSA which Arciszewski deems inadequate. Since WordPress is written in PHP and supports versions 5.2-7+, Arciszewski needed to create a solution that was as compatible. This inspired him to create <a href=\"http://web.archive.org/web/20170214062414/https://github.com/paragonie/sodium_compat\">sodium_compat</a> that adds <a href=\"https://ed25519.cr.yp.to/\">Ed25519 signature verification</a> to WordPress&#8217; automatic updater.</p>\n<p>Arciszewski submitted a number of patches to WordPress but was told by Dion Hulse, WordPress core developer, that the sodium_compat library could not be merged into core until it passed a security audit by a third-party. Audits can cost a lot of money so Arciszewski&#8217;s plan was to see if Automattic could take on some of the cost or crowd-source the funds. However, his project was put on hold after Mullenweg informed Hulse to stop working on the feature as it&#8217;s not related to the three core focus areas of the Editor, Customizer, and the REST API.</p>\n<p>Arciszewski described the decision as irresponsible and that every user has a reason to be alarmed, &#8220;The WordPress team has shown that they are not responsible enough to govern their impressive ownership of the Internet (with the exception of some folks powerless to correct the organization’s course),&#8221; he said. &#8220;This act of negligence <em class=\"markup--em markup--p-em\">will</em> put the rest of the web in harm’s way.&#8221;</p>\n<h2>Update Signing is Important but Not a Priority</h2>\n<p>Mullenweg <a href=\"https://medium.com/@photomatt/wordpress-and-update-signing-51501213e1\">responded to the post</a> on Medium.com with one of his own and reiterated the WordPress development team&#8217;s commitment to security.</p>\n<p>&#8220;Everyone involved takes their responsibility very seriously, and the growth of WordPress has meant many thoughtful, hard-working people have gotten involved and think of the security of WP sites holistically, from every angle,&#8221; he said.</p>\n<p>Mullenweg also clarified what attacks would be stopped by implementing digital signatures to WordPress updates.</p>\n<p>&#8220;It could stop a man in the middle attack, where someone modifies the update files on the network in between your blog and WordPress.org, or it could stop a situation where the part of .org that serves the update is compromised but the signing part isn’t, and someone decided to send out updates even though they know they’ll be rejected,&#8221; he said.</p>\n<p>The team is unaware of any WordPress sites that have been attacked this way. While the possibility exists, the extent of the damage would likely be limited. The update servers are monitored around the clock and since many large webhosting companies automatically scan their customer&#8217;s sites for malware, the malicious update would likely be discovered quickly.</p>\n<p>Mullenweg describes what would happen if an update server was compromised.</p>\n<p>&#8220;We would turn it off really quickly, notify the world there was an issue, fix the problem, turn it back on, and notify the specific sites or hosts as able,&#8221; he said. Although WordPress <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\">powers 27.5%</a> of the top 10 million sites tracked by Alexa, it&#8217;s highly unlikely that number of sites would be compromised.</p>\n<p>He goes on to say that there are easier ways to compromise a WordPress site and listed the biggest issues to WordPress security based on impact.</p>\n<ol class=\"postList\">\n<li id=\"6e1f\" class=\"graf graf--li graf-after--p\">Sites not updating core.</li>\n<li id=\"8121\" class=\"graf graf--li graf-after--li\">Sites not updating plugins.</li>\n<li id=\"9cf6\" class=\"graf graf--li graf-after--li\">Sites not updating themes.</li>\n<li id=\"0f5b\" class=\"graf graf--li graf-after--li\">Weak passwords, without brute-force protection or two-factor authentication.</li>\n<li id=\"9601\" class=\"graf graf--li graf-after--li\">Hosts (professional or ad-hoc) not scanning and fixing sites.</li>\n<li id=\"3b2e\" class=\"graf graf--li graf-after--li\">Hypothetical issues not seen in practice, which distract from the above existing priorities.</li>\n</ol>\n<p>Mullenweg confirms that he offered to donate to the audit of sodium_compat a day before Arciszewski published his post. Even if the library passed an audit, the code couldn&#8217;t immediately be added to core, &#8220;You would also need to do some significant work on the server-side to isolate the signing from the update server, so it’s worthwhile in the first place,&#8221; he said.</p>\n<p>And if the code were added to core, only the sites that updated to the version that has the cryptographic library and the update checking would be able to take advantage of it. WordPress.org would still need to send updates to older versions that don&#8217;t have update checking. These sites would still be vulnerable to receiving a malicious update.</p>\n<p>Mullenweg says that digital signatures and update signing will end up in WordPress eventually but it&#8217;s not a priority as there are other security issues in front of it, &#8220;We are prioritizing those issues above a nice-to-have, defense in-depth effort,&#8221; he said.</p>\n<p>&#8220;A good approach would be to build the server-side first, because doing that properly, say with an <a href=\"https://en.wikipedia.org/wiki/Hardware_security_module\">HSM</a>, is the difficult and important part; then get the packages signed; then test out verification in a plugin because we don’t want to break auto-updates; and then finally merge into core and set the client to reject non-signed updates. On the client side we need to pick a cryptography library, and get it audited.&#8221;</p>\n<p>Mullenweg ended his post explaining why he published his response on Medium instead of his <a href=\"http://ma.tt\">personal site</a>. &#8220;Seems to be the most popular place for rants like this. I also wanted to try out the famous Medium editor,&#8221; he said.</p>\n<h2>What&#8217;s Next For sodium_compat</h2>\n<p>While the prospects don&#8217;t look good for his library being added to WordPress in 2017, Arciszewski says there are plenty of other PHP projects that could benefit from it, &#8220;For their sake, I’m still strongly inclined to pursue an independent third-party cryptography audit, and attempt to crowd-fund the cost,&#8221; he said.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Feb 2017 23:48:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"BuddyPress: BuddyPress 2.8.0 – “San Matteo”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=263791\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://buddypress.org/2017/02/buddypress-2-8-0-san-matteo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8634:\"<p>BuddyPress 2.8.0 &#8220;San Matteo&#8221; is now available for download from the WordPress.org plugin repository, or right from your WordPress Dashboard. &#8220;San Matteo&#8221; focuses on various improvement for developers, site builders and site managers.</p>\n<h2 class=\"headline-title\">For Developers &amp; Site Builders</h2>\n<h3 class=\"headline-title\">Modernizing the Codebase</h3>\n<p>To continue the migration of legacy code to modern standards and techniques necessary for the <code>BP REST API</code> project and other new features moving forward, <a href=\"https://codex.buddypress.org/getting-started/buddypress-2-8-will-require-php-5-3/\">BuddyPress 2.8 requires at least PHP 5.3</a>. This will allow us to build better, robust, and secure code, benefiting developers and users now and in the future.</p>\n<h3 class=\"feature-title\">More helpful &#8220;Activate Pending Accounts&#8221; screen</h3>\n<p><img class=\"size-full wp-image-263800 aligncenter\" src=\"https://buddypress.org/wp-content/uploads/1/2017/02/pending-accounts.png\" alt=\"\" width=\"800\" height=\"500\" /></p>\n<p>When you click on the username on the &#8220;Users &gt; Manage Signups&#8221; page, you can now view profile data entered by the user at the time of registration.</p>\n<h3 class=\"feature-title\">Support for <code>List-Unsubscribe</code> header in emails</h3>\n<p><img class=\"size-full wp-image-263802 aligncenter\" src=\"https://buddypress.org/wp-content/uploads/1/2017/02/list-unsubscribe.png\" alt=\"\" width=\"800\" height=\"500\" /></p>\n<p>Allow users to unsubscribe from BuddyPress email notifications in some email clients such as Gmail (web), when properly configured.</p>\n<h3 class=\"feature-title\">Twenty Seventeen Companion Style sheet</h3>\n<p><img class=\"size-full wp-image-263803 aligncenter\" src=\"https://buddypress.org/wp-content/uploads/1/2017/02/twenty-seventeen.png\" alt=\"\" width=\"800\" height=\"500\" /></p>\n<p>BuddyPress looks great in WordPress&#8217;s latest default theme with the new Twenty Seventeen companion style sheet.</p>\n<p>To change the default two-column page layout to a full-width layout as seen in the image, add the <a href=\"https://codex.buddypress.org/themes/bp-theme-compatibility-and-the-wordpress-default-themes/twenty-seventeen-theme/\">following code</a> to the <code>functions.php</code> file of your Twenty Seventeen child theme.</p>\n<h4 class=\"feature-title\">More hooks for Messages</h4>\n<p>We&#8217;ve added new filters and actions for different methods throughout the Messages component.</p>\n<h4 class=\"feature-title\">A more flexible Group search</h4>\n<p>The new <code>search_column</code> parameter allows developers to specify which columns should be matched, as well as where wildcard characters should be placed, when searching via <code>BP_Groups_Group::get()</code>.</p>\n<h4 class=\"feature-title\">Alphabetical sorting for Groups widget</h4>\n<p>The groups widget can now be sorted alphabetically, in addition to sorting the results by recently active, popular, and newest groups.</p>\n<h4 class=\"feature-title\">Enable choice of <code>PHPMailer</code></h4>\n<p>Developers can specify which <code>PHPMailer</code> should be used when sending BuddyPress with a new filter.</p>\n<h4 class=\"title\">Localization Improvements</h4>\n<p>We continue to improve our localization internals, making it easier for translation editors to ensure that BuddyPress will be available for everyone in their own language.</p>\n<h4 class=\"title\">Developer Reference</h4>\n<p>Regular updates to inline code documentation make it easier for developers to understand how BuddyPress works.</p>\n<h4 class=\"title\">Accessibility Upgrades</h4>\n<p>Continued improvements for universal access help make BuddyPress back- and front-end screens usable for everyone (and on more devices).</p>\n<p><strong>…and much more!</strong></p>\n<p>Read about all the bug fixes and feature enhancements introduced in BuddyPress 2.8.0 at our <a href=\"https://codex.buddypress.org/releases/version-2-8-0/\">official 2.8.0 changelog</a>.</p>\n<p><strong>Thank You to Our Contributors</strong></p>\n<p>Many, many thanks to all those who contributed during this development cycle. This is a volunteer-run project, and these contributors freely gave of their time and expertise to make BuddyPress better than ever:</p>\n<p><a href=\"https://profiles.wordpress.org/dontdream/\">Andrea Tarantini (dontdream)</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta (ankit-k-gupta)</a>, <a href=\"https://profiles.wordpress.org/angeljs/\">angeljs</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone B Gorges (boonebgorges)</a>, <a href=\"https://profiles.wordpress.org/thebrandonallen/\">Brandon Allen (thebrandonallen)</a>, <a href=\"https://profiles.wordpress.org/bhargavbhandari90/\">Bunty (bhargavbhandari90)</a>,<a href=\"https://profiles.wordpress.org/ketuchetan/\">chetansatasiya (ketuchetan)</a>, <a href=\"https://profiles.wordpress.org/chiragpatel/\">Chirag Patel (chiragpatel)</a>, <a href=\"https://profiles.wordpress.org/danbp/\">danbp</a>, <a href=\"https://profiles.wordpress.org/dcavins/\">David Cavins (dcavins)</a>, <a href=\"https://profiles.wordpress.org/wpdennis/\">Dennis (wpdennis)</a>, <a href=\"https://profiles.wordpress.org/Dianakc/\">Diana K. Cury (Dianakc)</a>, <a href=\"https://profiles.wordpress.org/finzend/\">finzend</a>, <a href=\"https://profiles.wordpress.org/hnla/\">Hugo (hnla)</a>,<a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes (jdgrimes)</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby (johnjamesjacoby)</a>, <a href=\"https://profiles.wordpress.org/jonas-lundman/\">Jonas Lundman (jonas-lundman)</a>, <a href=\"https://profiles.wordpress.org/jonieske/\">jonieske</a>, <a href=\"https://profiles.wordpress.org/jreeve/\">jreeve</a>, <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a>, <a href=\"https://profiles.wordpress.org/Offereins\">Laurens Offereins (Offereins)</a>, <a href=\"https://profiles.wordpress.org/lgreenwoo/\">lgreenwoo</a>,<a href=\"https://profiles.wordpress.org/maccast/\">maccast</a>, <a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet (imath)</a>, <a href=\"https://profiles.wordpress.org/mchansy/\">mchansy</a>, <a href=\"https://profiles.wordpress.org/mercime/\">mercime</a>, <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith (tw2113)</a>, <a href=\"https://profiles.wordpress.org/modemlooper/\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/m_uysl/\">Mustafa Uysal (m_uysl)</a>, <a href=\"https://profiles.wordpress.org/nickmomrik/\">Nick Momrik (nickmomrik)</a>, <a href=\"https://profiles.wordpress.org/DJPaul/\">Paul Gibbs (DJPaul)</a>,<a href=\"https://profiles.wordpress.org/pareshradadiya/\">paresh.radadiya (pareshradadiya)</a>, <a href=\"https://profiles.wordpress.org/petya/\">Petya Raykovska</a>, <a href=\"https://profiles.wordpress.org/r-a-y/\">r-a-y</a>, <a href=\"https://profiles.wordpress.org/rekmla/\">rekmla</a>, <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves (espellcaste)</a>, <a href=\"https://profiles.wordpress.org/rogercoathup/\">Roger Coathup (rogercoathup)</a>, <a href=\"https://profiles.wordpress.org/DarkWolf/\">Salvatore (DarkWolf)</a>,<a href=\"https://profiles.wordpress.org/sanket.parmar/\">Sanket Parmar (sanket.parmar)</a>, <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov (slaffik)</a>, <a href=\"https://profiles.wordpress.org/stagger-lee/\">Stagger Lee (stagger-lee)</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar (netweb)</a>, <a href=\"https://profiles.wordpress.org/mahype/\">Sven Wagener (mahype)</a>, <a href=\"https://profiles.wordpress.org/wordpressrene/\">wordpressrene</a>.</p>\n<h2>PanuozzoPress</h2>\n<p>BuddyPress 2.8 is called &#8220;San Matteo&#8221; after <a href=\"http://www.sanmatteopanuozzo.com/\">a great pizza restaurant</a> in New York City. San Matteo specializes in the &#8220;panuozzo&#8221;, a pizza-sandwich hybrid native to Salerno, Italy. The proprietor of San Matteo is a friendly fellow who insists on speaking Italian even to customers who don&#8217;t understand a word of it. If you find yourself in the neighborhood, be sure to stop by for a great pizza.</p>\n<h2>Time to Go Get 2.8.0!</h2>\n<p>Grab BuddyPress 2.8.0 &#8220;San Matteo&#8221; from the <a href=\"https://wordpress.org/plugins/buddypress/\">wordpress.org plugin repository</a>, or right from your WordPress Dashboard.</p>\n<p><strong>Questions, comments, feature requests, or bug reports?</strong> Please use our <a href=\"https://buddypress.org/support/\">support forums</a> or our <a href=\"https://buddypress.trac.wordpress.org/\">development tracker</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Feb 2017 22:38:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Slava Abakumov\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"HeroPress: Not every hero wears a cape\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1605\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://heropress.com/essays/not-every-hero-wears-cape/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8188:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/02/021517-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Sometimes the biggest heroes are the people who notice that someone else feels out of place, extend their hand, and welcome them in.\" /><h3>I almost didn’t go to my first WordCamp</h3>\n<p>I started working with WordPress in 2010. A client requested I use WordPress and a Revolution theme they’d purchased to build their new site. When I was done, I submitted it to the theme showcase, and Brian Gardner reached out to tell me how much he’d liked it.</p>\n<p>I continued working with Brian and his themes as Revolution became Revolution 2, and then StudioPress and Genesis. That led to me designing and developing Family Tree, one of the first commercial themes targeted at women entrepreneurs. It was released in May of 2011.</p>\n<p>Right around the release of my first theme, Brian asked if I was going to be at WordCamp San Francisco. There was going to be a Genesis Connect event there, and he wanted me to be there. I really wanted to go, but didn’t know how I was going to pull it off.</p>\n<p>See, after a years long struggle I had recently been diagnosed with bipolar disorder.</p>\n<blockquote><p>I was trying to rebuild my design career with WordPress, but I was really struggling.</p></blockquote>\n<p>I felt like flying to San Francisco to see my internet friends was a luxury I couldn’t afford.</p>\n<p>But when I mentioned it to my wife, she told me we’d find a way. She started hitting travel sites and found a cheap airline ticket. Then she went on AirBnB and booked me a couch in the lobby of an art gallery in the Tenderloin&#8211;it was the cheapest thing we could find. I left on August 11, 2011, three days before my 40th birthday.</p>\n<h3>My first day of WordCamp SF was a nightmare</h3>\n<p>I have pretty severe social anxiety, so my plan was to maintain a low profile and keep to myself until I could meet up with some of my Genesis friends. About 20 minutes into the first talk I went to I was totally lost, so I thought I’d sneak out and hit lunch early. It seemed like a solid plan.</p>\n<p>My foot had fallen asleep during the presentation, though, and as I stood up to sneak out my ankle buckled and I fell. Every head in the auditorium whipped around to stare at me slowly rolling down the aisle. It was painfully obvious to me that not only did I not belong, but I had just made a very public ass of myself and was mortified.</p>\n<h3>Then the WordPress Community stepped in</h3>\n<p>There was already a huge crowd in the courtyard when I managed to slink out of the auditorium. I felt like someone had dropped me back into my junior high cafeteria. I stood in the massive line, wanting nothing more than to find a quiet corner to nurse my wounded pride, call my wife, maybe cry a little, and tell her that coming had been a huge waste of time and money.</p>\n<blockquote><p>If that’s how my day had panned out, my WordPress story might have been a lot different. Instead, I ran into my first ambassador of the WordPress community.</p></blockquote>\n<p>This kind of goofy guy in front of me started chatting me up.</p>\n<p>I told him it was my first WordCamp. He asked me where I was from, and we discovered we lived maybe an hour away from each other: me in San Diego, him in Orange County. He invited me to eat lunch with his group. And that’s how I wound up sitting at a table eating lunch with Steve Zehngut and his crew.</p>\n<p>These people were more like me: marketers and designers, theme authors and SEO specialists, food bloggers and digital nomads. I started to feel like I might belong there, after all. The phone call I made to my wife after lunch was about how much fun I was having, and how many cool people I was meeting.</p>\n<p>Later that day I went to dinner with the crew from Genesis and met even more amazing people I’d only known online. After that, there was a huge Genesis Connect happy hour. The more people I met and talked to, the more friends I made. On Sunday, before one of the final presentations, an auditorium of my new friends sang “Happy Birthday” to me. (I won’t lie&#8211;it was cool but also almost as embarrassing as falling down the first day, lol!)</p>\n<h3>One person can make a difference</h3>\n<p>If Steve hadn’t asked me to eat lunch with his group that day, I might have never gone to another WordCamp. Instead, when WordCamp San Diego 2012 came around Dre Armeda encouraged me to submit a speaker application, and I gave my first talk. For six years now I’ve spoken at every local WordCamp that’s accepted my speaker application, trying to inspire other people to get and stay involved in our community.</p>\n<p>I spent some time looking at the 2011 WCSF attendees list when I was writing this essay. Some of my best friends (and best WordCamp stories) can be directly linked to that list. Even the people I may not have met at that event came into my life because of that event.</p>\n<h3>Six degrees of a lunch invitation</h3>\n<p>I don’t remember whether or not I met Alex Vasquez in San Francisco, but he’s one of the people who actually wants an honest answer when he asks how I’ve been. I’m pretty sure I didn’t meet Andy Stratton there, but I eventually travelled to Baltimore to speak at the WordCamp he and Drew Poland organized. I’m positive I didn’t cross paths with Karim Marucchi, but he eventually became my boss, mentor, and go-to puppy picture friend. And those are just the connections from one event that happened 6 years ago.</p>\n<blockquote><p>WordCamp San Francisco taught me that being a hero doesn’t have to be a huge, dramatic thing.</p></blockquote>\n<p>Sometimes the biggest heroes are the people who notice that someone else feels out of place, extend their hand, and welcome them in. Of all of the lessons I’ve learned in WordPress, that’s the most important one. Thanks, Steve!</p>\n<p><em>(P.S. If anyone knows where I can find some adult Superman Underoos in stock, LMK. WordCamp San Diego is coming up at the end of March, and I never got Steve a proper thank you gift.)</em></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Not every hero wears a cape\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Not%20every%20hero%20wears%20a%20cape&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fnot-every-hero-wears-cape%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Not every hero wears a cape\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fnot-every-hero-wears-cape%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fnot-every-hero-wears-cape%2F&title=Not+every+hero+wears+a+cape\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Not every hero wears a cape\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/not-every-hero-wears-cape/&media=https://heropress.com/wp-content/uploads/2017/02/021517-150x150.jpg&description=Not every hero wears a cape\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Not every hero wears a cape\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/not-every-hero-wears-cape/\" title=\"Not every hero wears a cape\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/not-every-hero-wears-cape/\">Not every hero wears a cape</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Feb 2017 12:00:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Chris Ford\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: Open Source Leadership Summit to Live Stream Keynote Sessions February 14-16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/open-source-leadership-summit-to-live-stream-keynote-sessions-february-14-16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1865:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/open-source-leadership-summit.png?ssl=1\"><img /></a></p>\n<p>The Linux Foundation&#8217;s <a href=\"http://events.linuxfoundation.org/events/open-source-leadership-summit\" target=\"_blank\">Open Source Leadership Summit</a> is happening in Lake Tahoe, CA, February 14-16, 2017. The invitation-only event brings together open source technology leaders to collaborate across different projects and share best practices.</p>\n<p>The organizers will be live streaming all of the <a href=\"https://osleadershipsummit2017.sched.com/overview/type/Keynote\" target=\"_blank\">keynote sessions</a> for free throughout the three-day event for a total of 17 presentations. A few sample topics and speakers include:</p>\n<ul>\n<li>State of the Union &#8211; Jim Zemlin, Executive Director of the Linux Foundation</li>\n<li>A Conversation with Linus Torvalds (with Jim Zemlin)</li>\n<li>State of Blockchain &#8211; Christopher Ferris, CTO of Open Technology, IBM</li>\n<li>Security and Privacy in a Hyper-connected World &#8211; Bruce Schneier, Security Expert</li>\n<li>Building and Motivating Engineering Teams &#8211; Camille Fournier, Senior Thinker and Raconteur</li>\n<li>How Cross-Foundation Collaboration is a Win for Open Source &#8211; Abby Kearns, Executive Director, Cloud Foundry Foundation</li>\n</ul>\n<p>Anyone who wants to join the keynote sessions via live stream will need to <a href=\"http://events.linuxfoundation.org/events/open-source-leadership-summit/program/live-video-stream\" target=\"_blank\">sign up</a> ahead of the event. The keynotes will be broadcast in Pacific Daylight Time and viewers can return to the signup page to watch live. Viewers are encouraged to use the event&#8217;s official #lfosls hashtag to tweet about the sessions as they are watching.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Feb 2017 06:32:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: Why Plugins Sometimes Disappear From the WordPress Plugin Directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66033\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4548:\"<p>Nearly 50K publicly available plugins call the <a href=\"https://wordpress.org/plugins/\">WordPress plugin directory</a> home but once in awhile a few of them seem to disappear. There is usually a good reason for why this happens but the only information available to the public is a page that says the plugin cannot be found. If the plugin is popular enough, concerned users will <a href=\"https://wptavern.com/contact-me\">contact us</a> and ask to investigate what happened.</p>\n<p><a href=\"https://profiles.wordpress.org/ipstenu\">Mika Epstein</a>, Plugin Directory Representative, says there are a number of reasons for why a plugin can end up hidden from view, &#8220;The most well-known, but not the most common, is security issues,&#8221; Epstein said.</p>\n<p>&#8220;Plugins are removed and, by default, hidden mostly because we&#8217;re on bbPress 1.0 and there is not as granular a control with post statuses when compared to WordPress itself.&#8221;</p>\n<p>The plugin review team has three options to choose from when altering a plugin&#8217;s visibility, active, closed, and disabled. Although rarely used, when a plugin is disabled, it is hidden from view but updates are able to be pushed out.</p>\n<p>I asked Epstein why there&#8217;s not more detailed information when a plugin is hidden and the answer is complex, &#8220;The lack of information is partly technical as bbPress 1.0 is limited and partly because we can&#8217;t all agree on the <em>right</em> way to disclose, when to disclose, and when <em>not</em> to disclose,&#8221; she said.</p>\n<p>&#8220;Obviously the last thing we want are people getting hacked, but it presents us with a few options and they all have flaws. We&#8217;ve not been able to determine a way to tell people &#8216;This plugin is gone, don&#8217;t use it&#8217; and &#8216;This plugin is gone, but use it if you want.&#8217; without putting users at risk.&#8221;</p>\n<p>Epstein uses WooCommerce and Jetpack as examples, &#8220;Let&#8217;s say I close Jetpack today and tell people &#8216;WordPress decided not to support it anymore.&#8217; But tomorrow I close WooCommerce and tell people &#8216;I can&#8217;t tell you why.&#8217; That means an intelligent person knows that WooCommerce is <em>probably</em> vulnerable.&#8221;</p>\n<p>It&#8217;s a conundrum without an easy solution. The team typically closes plugins which makes the plugin&#8217;s page disappear. This has the added benefit of making it more difficult to determine if the plugin ever existed. Then the team contacts and works with the developer directly.</p>\n<p>Most closures are done with the knowledge of the plugin author as they are often the ones who request that their plugins be closed.</p>\n<h2>The New WordPress Plugin Directory Will Modernize Plugin Administration</h2>\n<p><a href=\"https://wptavern.com/new-wordpress-plugin-directory-now-in-open-beta\">Announced</a> at WordCamp Europe 2016, the WordPress plugin directory redesign has been in <a href=\"https://wordpress.org/plugins-wp/\">open beta</a> for about eight months.</p>\n<img />WordPress Plugin Directory Redesign\n<p>In addition to bringing a fresh new look to plugin pages, the migration away from bbPress to WordPress will help make the plugin review team&#8217;s job easier, &#8220;Like far too many things in Plugin Land, everything depends on modernizing the backend to something that is functional.&#8221; Epstein said.</p>\n<p>&#8220;Once the new directory is out and I have some more people trained to do reviews properly, then we&#8217;ll have the bandwidth to sit down and really figure out a <strong>best</strong> solution.</p>\n<p>&#8220;A stopgap might be making the page say &#8216;This plugin is no longer available.&#8217; But I&#8217;m personally not sure if that would make FUD better or worse.&#8221;</p>\n<p>If you discover that a plugin you rely on has suddenly vanished from the directory, don&#8217;t panic. Depending on the issue, plugins usually reappear within a week unless the author has requested that it be closed.</p>\n<p>To learn what&#8217;s involved and how the plugin review team does its job, listen to <a href=\"https://wptavern.com/wpweekly-episode-231-an-inside-look-at-the-plugin-review-process-with-mika-epstein\">episode 231</a> of WordPress Weekly. I also encourage you to read our <a href=\"https://wptavern.com/behind-the-scenes-in-the-wordpress-plugin-directory-with-mika-epstein\">detailed interview</a> with Epstein published in 2014, in which most of the information is still accurate.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Feb 2017 03:37:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: WordPress REST API Vulnerability Exploits Continue\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66011\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/wordpress-rest-api-vulnerability-exploits-continue\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10607:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/emergency.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://flic.kr/p/dLUWMb\">Code &#038; Martini</a> by <a href=\"https://www.flickr.com/photos/ivanavasilj/\">Ivana Vasilj</a> &#8211; cc license\n<p>It has been nearly two weeks since the WordPress security team <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\" target=\"_blank\">disclosed</a> an unauthenticated privilege escalation vulnerability in a REST API endpoint in 4.7 and 4.7.1. The vulnerability was patched silently and disclosure was delayed for a week to give WordPress site owners a head start on updating to 4.7.2. Last week <a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-is-being-actively-exploited-hundreds-of-thousands-of-sites-defaced\" target=\"_blank\">hundreds of thousands of vulnerable sites had already been defaced</a> and the damage reports are still rolling in.</p>\n<p>Over the weekend the attacks increased and WordPress security firms have seen more attempts blocked by their firewalls. <a href=\"https://sucuri.net/\" target=\"_blank\">Sucuri</a>, the website security firm that reported the vulnerability to WordPress, was tracking the &#8220;Hacked by w4l3XzY3&#8221; campaign last week and estimated 66,000 defacements. That particular campaign has now passed 260,000 pages indexed by Google. It is one of nearly two dozen defacement campaigns targeting the vulnerability.</p>\n<p>&#8220;During the past 24 hours we have seen an average growth in defaced pages per campaign of 44%,&#8221; Wordfence CEO Mark Maunder <a href=\"https://www.wordfence.com/blog/2017/02/rapid-growth-in-rest-api-defacements/\" target=\"_blank\">said</a> on Friday. &#8220;The total number of defaced pages for all these campaigns, as indexed by Google has grown from 1,496,020 to 1,893,690. That is a 26% increase in total defaced pages in just 24 hours.&#8221;</p>\n<p>Maunder referenced a <a href=\"https://www.google.com/trends/explore?date=2017-01-01%202017-12-31&q=%22Hacked%20By%20MuhmadEmad%22,%22Hacked%20By%20SA3D%20HaCk3D%22,%22by%20w4l3XzY3%22,%22Hacked%20By%20Imam%22,%22Hacked%20By%20BALA%20SNIPER%22\" target=\"_blank\">Google Trends chart</a> which he said demonstrates the success the defacement campaigns have had over the past week. The spike began on the day WordPress disclosed the vulnerability.</p>\n<p> &q;</p>\n<p>However, White Fir Design, another company that offers security services, <a href=\"https://www.whitefirdesign.com/blog/2017/02/10/unreliable-claim-that-1-5-million-wordpress-pages-defaced-is-reminder-of-the-terribleness-of-security-companiesjournalists/\" target=\"_blank\">disputes Wordfence&#8217;s claims</a> that 1.8 million pages were hacked. The ~2  million pages figure is cited in reports from <a href=\"http://www.bbc.com/news/technology-38930428\" target=\"_blank\">BBC</a>, <a href=\"http://www.theinquirer.net/inquirer/news/3004423/wordpress-hacking-spree-sees-15-million-web-pages-defaced\" target=\"_blank\">The Enquirer</a>, <a href=\"https://arstechnica.com/security/2017/02/virally-growing-attacks-on-unpatched-wordpress-sites-affects-2m-pages/\" target=\"_blank\">Ars Technica</a>, <a href=\"http://www.cio.com/article/3168761/security/recent-wordpress-vulnerability-used-to-deface-1-5-million-pages.html\" target=\"_blank\">CIO.com</a>, and other publications. White Fir Design contends that the hacked pages that have been indexed by Google are not an accurate representation.</p>\n<p>Sucuri CTO Daniel Cid also does not fully agree with Wordfence&#8217;s assessment of the situation. After doing some research over the weekend, Sucuri estimates more than 50,000 sites hacked with 20-30 pages per site defaced. This would be roughly a million on the lower end of the estimate and ranges up to 1.5 million.</p>\n<p>Sucuri is also starting to see more serious attempts on the REST API vulnerability in the form of <a href=\"https://blog.sucuri.net/2017/02/rce-attempts-against-the-latest-wordpress-rest-api-vulnerability.html\" target=\"_blank\">remote code execution (RCE) attacks</a> on sites using plugins that allow for PHP execution from within posts and pages. One such campaign attempts to inject a PHP include to add content from a compromised site and then inject a backdoor hidden in /wp-content/uploads.</p>\n<p>&#8220;Defacements don’t offer economic returns, so that will likely die soon,&#8221; Cid said. &#8220;What will remain are attempts to execute commands (RCE) as it gives the attackers full control of a site – and offers multiple ways to monetize – and SPAM SEO / affiliate link / ad injections. We are starting to see them being attempted on a few sites, and that will likely be the direction this vulnerability will be misused in the coming days, weeks and possibly months.&#8221;</p>\n<p>Hackers are targeting any sites that haven&#8217;t updated to 4.7.2 &#8211; there doesn&#8217;t seem to be any pattern among them. A quick look at the Google results for the most active campaigns shows that compromised sites include blogs, media, government, education, sports, medical, and technology websites.</p>\n<h3>Why the REST API is Enabled by Default</h3>\n<p>The WordPress REST API is enabled by default, as the plan is for more admin and plugin functionality to rely on the REST API in the future. After the recent attacks, several users <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/#comment-32110\" target=\"_blank\">commented</a> on the vulnerability disclosure to ask why it is enabled by default.</p>\n<p>&#8220;The security issue is in a feature I do not use on any of my sites (REST API) and yet still, this feature is first enabled by default and second since WordPress 4.7 you even need a plugin – which could introduce further security issues – to disable the feature?&#8221; one user (@helios2121) <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/#comment-32123\" target=\"_blank\">commented</a> on the post. &#8220;Please rethink your approach to security. Make features that not everyone needs opt-in. Or <em>at least</em> give a way to opt out without requiring additional plugins.&#8221;</p>\n<p>Morten Rand-Hendriksen opened a trac ticket to discuss <a href=\"https://core.trac.wordpress.org/ticket/39806#ticket\" target=\"_blank\">disabling the REST API by default</a> and only enabling it when the site admin requests it, or a theme or plugin is dependent on it.</p>\n<p>Core Committer Sergey Biryukov confirmed that the plan is to introduce more core functionality that relies on REST API. &#8220;Turning off the REST API is like turning off admin-ajax.php — both will break your site,&#8221; Biryukov said.</p>\n<p>Rand-Hendriksen asked why the content endpoints cannot be protected by default while allowing the REST API to be on by default for admin purposes. Another user asked why the Users endpoint isn&#8217;t protected by default (i.e. <a href=\"https://news.microsoft.com/wp-json/wp/v2/users\" target=\"_blank\">https://news.microsoft.com/wp-json/wp/v2/users</a> or <a href=\"https://www.obama.org/wp-json/wp/v2/users\" target=\"_blank\">https://www.obama.org/wp-json/wp/v2/users</a>), which &#8220;makes it easier than ever to get all the usernames&#8221; on any site using 4.7+.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/users-endpoint.png?ssl=1\"><img /></a></p>\n<p>&#8220;If you really want to disable the REST API on your site(s), this is our current recommendation: restrict it to authenticated users,&#8221; Core Committer James Nylen said. &#8220;However, we want to continue to increase adoption and usage of the REST API, and I expect that even this modification will break more and more WP functionality as time goes on, such as API-driven themes and embeds.&#8221;</p>\n<p>Nylen recommends the <a href=\"https://wordpress.org/plugins/disable-json-api/\" target=\"_blank\">Disable JSON API</a> plugin for those who want to follow that recommendation on sites using WordPress 4.7+. The plugin currently has more than 10,000 active installs.</p>\n<p>The WordPress security team worked diligently to mitigate the attacks by helping hosts and security firms put protections in place before the issue was made public. However, the <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\" target=\"_blank\">full disclosure of the vulnerability</a> was buried on the Make/Core blog, a site that is not widely read among regular WordPress site owners. The link to the disclosure was published as an addendum to <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\" target=\"_blank\">the previous post</a> on the WordPress news blog a week later.</p>\n<p>&#8220;While I appreciate the responsible disclosure of this issue and the effort to resolve it, I hope you consider making future announcements via a new post on the WordPress News site, rather than just appending an update to a previous post,&#8221; user @johnrork <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/#comment-32105\" target=\"_blank\">commented</a> on the official disclosure. &#8220;I am probably not the only one who could have avoided being compromised had this shown up as a new item in my RSS reader on Wednesday.&#8221;</p>\n<p>Those who read the Make blogs had a head start on fixing their own sites and/or their clients&#8217; sites. Those who depend on the WordPress news blog for information on security updates probably read the post when it was initially published and never returned to see the update a week later. An issue this severe warranted WordPress&#8217; transparency in a new post on its news blog. This would have also automatically sent out a tweet to more than half a million followers on the official WordPress account and the Facebook account which has more than a million likes.</p>\n<p>Fortunately, the number of vulnerable sites that also have plugins that could allow attackers to piggyback on this vulnerability is a much smaller number. Defaced sites are embarrassing but easy to fix. In most cases administrators need only update to 4.7.2 and roll back the defaced posts to the most recent revision. Most site owners have no idea how fast exploits begin to pop up after public disclosure, but this situation provided a gentle reminder of the importance of updating WordPress and the benefit of leaving automatic updates on.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Feb 2017 22:59:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: 10up Unveils ElasticPress.io: Elasticsearch as a Service for WordPress Sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65981\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/10up-unveils-elasticpress-io-elasticsearch-as-a-service-for-wordpress-sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7053:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/elasticpress-logo.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://10up.com\" target=\"_blank\">10up</a> launched <a href=\"https://www.elasticpress.io/\" target=\"_blank\">ElasticPress.io</a> this week, its new Elasticsearch SaaS product with plans starting at $299/month. <a href=\"https://github.com/elastic/elasticsearch\" target=\"_blank\">Elasticsearch</a> is an open source, distributed search engine that speeds up searching by using JSON documents to store data in indices. The indices store mapping fields to the corresponding documents and the engine searches the index instead of a site&#8217;s entire database.</p>\n<p>Elasticsearch can perform near-real-time searches and is highly scalable, but the setup is technically demanding. It is used by many large companies, such as GitHub, Soundcloud, Etsy, Netflix, Cisco, and Samsung. It is also one of the most popular enterprise search engines for WordPress sites, as searching WordPress tables with thousands or even millions of records is simply not going to be fast.</p>\n<p>The WordPress plugin directory has a dozen plugins for using and extending Elasticsearch but 10up&#8217;s <a href=\"https://wordpress.org/plugins/elasticpress/\" target=\"_blank\">ElasticPress</a> is by far the most popular with more than a thousand installs. After supporting the plugin for several years, along with many enterprise clients using Elasticsearch, 10up decided to create a hosted service that integrates with ElasticPress.</p>\n<p>&#8220;The reason we created this solution for our clients, and that we’re now making this public, is that we don’t think anyone has provided a super easy, end-to-end (plugin to hosted service) that offers all of the benefits of Elasticsearch and our ElasticPress plugin, while being completely agnostic to your site hosting,&#8221; 10up founder Jake Goldman said.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/elasticpress.png?ssl=1\"><img /></a></p>\n<p>ElasticPress.io is an end-to-end solution that is specifically tailored for those using the ElasticPress plugin. This is one of the key differences between managing your own Elasticsearch infrastructure with a service like AWS. ElasticPress.io controls both the hosting and the plugin, allowing the service to optimize performance for both.</p>\n<p>&#8220;There are a number of really neat use cases for ElasticPress on our roadmap that add either risk (security) or headaches (complicated setup and management procedures) if you can’t control both ends,&#8221; Goldman said. &#8220;For instance, there are optional Elasticsearch modules (just like there are optional Apache and Nginx modules) for features like indexing media that many hosted Elastic services don’t enable by default or support. We also want to be able to index and handle content that isn’t public, and many hosted Elastic services aren’t locked down / secured end-to-end with the website by default.&#8221;</p>\n<h3>How ElasticPress.io&#8217;s Pricing Compares to Competitors</h3>\n<p><a href=\"https://www.elastic.co/\" target=\"_blank\">Elastic</a>, the creators of Elasticsearch were one of the first companies to launch Elasticsearch as a service in 2012. Two years later the company raised $70 million in a Series C funding round. Dozens of other Elasticsearch as a service companies have sprouted up since then, with pricing ranging from under $20 to tens of thousands of dollars depending on the resources offered.</p>\n<p>The ElasticPress.io service is the first of its kind in the WordPress ecosystem. Most hosting companies do not have it built into their enterprise level plans. WordPress.com VIP is one of the few that offers Elasticsearch for sites on its <a href=\"https://vip.wordpress.com/our-services/#hosting-plans\" target=\"_blank\">plans</a> which range from $5,000 &#8211; $25,000 per month. WP Engine has an Elasticsearch solution as part of its <a href=\"https://wpengine-labs.com/\" target=\"_blank\">Labs program</a>, which is based on a fork of ElasticPress. However, the solution has not yet been officially added to the company&#8217;s enterprise plans.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/10up\">@10up</a> <a href=\"https://twitter.com/mgibbs189\">@mgibbs189</a> <a href=\"https://twitter.com/cabgfx\">@cabgfx</a> <a href=\"https://twitter.com/sbangnielsen\">@sbangnielsen</a> <a href=\"https://twitter.com/SearchWP\">@SearchWP</a> ElasticPress plus lower cost providers is still extremely powerful for under $12 a month</p>\n<p>&mdash; Scott Kingsley Clark (@scottkclark) <a href=\"https://twitter.com/scottkclark/status/830165095045033984\">February 10, 2017</a></p></blockquote>\n<p></p>\n<p>For the most part, developers who have to implement Elasticsearch for a WordPress site are faced with hosting their own instance and managing it themselves. This is the most cost effective option but comes with a great deal more responsibility.</p>\n<p>&#8220;Elasticsearch is a quickly evolving platform, and they don’t exactly have the same commitment to infinite backwards compatibility that WordPress has these days,&#8221; Goldman said. &#8220;Major Elasticsearch upgrades can break old integrations. That means the site owner needs to either worry about automatic version upgrades breaking their site, or has to manage their upgrades carefully. By controlling the integration with Elastic on the website site and controlling the hosting, we can carefully handle version upgrades for customers while making sure nothing breaks.&#8221;</p>\n<p>10up is aiming at the higher end of the market where customers are looking for convenience and access to the creators of ElasticPress for support. Goldman anticipates many of those customers will be similar to the product&#8217;s existing customers who simply need a robust keyword search or related content engine that will &#8220;just work.&#8221; ElasticPress.io is also targeting smaller and mid-tier businesses that are experiencing performance bottlenecks with WordPress&#8217; native query engine.</p>\n<p>&#8220;Those customers are typically relying on rather complicated faceting / filtering of content, the classic use-case being a WooCommerce store where customers are constantly filtering on a handful of unique (unique = hard to cache) meta data all the time,&#8221; Goldman said. &#8220;That’s where ElasticPress really shines: our native WooCommerce support and optimization take those very taxing queries and makes them lightning fast.&#8221;</p>\n<p>As the service is fairly unique in the WordPress space, ElasticPress.io&#8217;s <a href=\"https://www.elasticpress.io/#pricing\" target=\"_blank\">pricing</a> has room to evolve as 10up learns from its customers. The plans currently range from $299 &#8211; $999 per month with increasing storage space and tiered support response times. Goldman said they haven&#8217;t ruled out other pricing points and may explore more pricing options in the future.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Feb 2017 06:33:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Post Status: Jason Cohen, founder of WP Engine, on growing your company well — Draft Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=33802\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/jason-cohen-wp-engine-founder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2420:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. In this episode, I interview <a href=\"https://twitter.com/asmartbear\">Jason Cohen</a>, the founder of WP Engine and current CTO.</p>\n<p>I talked to Jason about a whole lot of things, mostly to do with growing well. Whether you&#8217;re growing revenue, company size, or personal development &#8212; this is a conversation about growth, and how to do it well.</p>\n<p>Unlike many entrepreneurs in the WordPress space, WP Engine isn&#8217;t Jason&#8217;s first business. He&#8217;s done this before, and made plenty of mistakes. He talks about what he&#8217;s done differently at WP Engine and how its made him a happier person.</p>\n<p>This interview took place at LoopConf, and <a href=\"https://www.youtube.com/watch?v=b_CmkUT25BE\">Jason was a keynote presenter</a>. His LoopConf talk pairs well with our discussion.</p>\n<p>You can catch the first segment on video, and the entire conversation is on the audio podcast.</p>\n<p></p>\n<a href=\"https://audio.simplecast.com/60233.mp3\">https://audio.simplecast.com/60233.mp3</a>\n<p><a href=\"https://audio.simplecast.com/60233.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://wpengine.com/\">WP Engine</a></li>\n<li><a href=\"https://loopconf.com/\">LoopConf</a></li>\n<li><a href=\"https://blog.asmartbear.com/\">Jason&#8217;s blog</a></li>\n</ul>\n<h3>Sponsor: iThemes</h3>\n<p>This episode is sponsored by <a href=\"https://ithemes.com/?utm_source=post_status&utm_medium=banner&utm_campaign=ps_ads\">iThemes</a>. The team at iThemes offers WordPress plugins, themes and training to help take the guesswork out of building, maintaining and securing WordPress websites. For more information, check out their <a href=\"https://ithemes.com/?utm_source=post_status&utm_medium=banner&utm_campaign=ps_ads\">website</a> and thank you to iThemes for being a Post Status partner.</p>\n<p><em>Photo by Brian Richards for Post Status</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Feb 2017 04:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: In Case You Missed It – Issue 17\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65984&preview=true&preview_id=65984\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wptavern.com/in-case-you-missed-it-issue-17\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8994:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?ssl=1\" rel=\"attachment wp-att-50955\"><img /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>There’s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn’t make it into a full post.</p>\n<h2>Interviewed for WordPress.tv</h2>\n<p>A few weeks ago, Marcus Couch and I were interviewed by John Parkinson. Parkinson is a volunteer moderator and performs community outreach for WordPress.tv. In the interview, we discuss the benefits of WordPress.tv, the WordPress community, WordCamps, and more. I encourage you to check out his <a href=\"https://blog.wordpress.tv/tag/interview/\">other community interviews</a> as well.</p>\n<p></p>\n<h2 class=\"selectionShareable\">WooCommerce and WordPress Used to Sell Stress Cubes</h2>\n<p>CNBC has <a href=\"http://www.cnbc.com/2017/01/30/a-24-year-old-made-345000-by-beating-kickstarters-to-market.html\">an interesting story</a> that features a 24-year-old who made $345K in two months selling <a href=\"https://stresscube.com/\">Stress Cubes</a>, a knock-off of the Fidget Cube. The Fidget Cube raised <a href=\"https://www.kickstarter.com/projects/antsylabs/fidget-cube-a-vinyl-desk-toy\">nearly 6.5M dollars</a> in crowdfunding money.</p>\n<p>The Fidget Cube experienced significant delays in shipping due to manufacturing issues. The 24-year-old contacted suppliers in China, purchased 1,000 plastic cubes, created a similar product, and shipped it to market before the Fidget Cube had a chance to reach backers. He used WordPress and WooCommerce to sell Stress Cubes grossing him nearly $350K in two months.</p>\n<h2>Why WordPress in Education</h2>\n<p>Jared Bennett <a href=\"https://dev.commons.hwdsb.on.ca/2017/02/08/why-wordpress-in-education/\">explains</a> how the <a href=\"http://www.hwdsb.on.ca/\">Hamilton Wentworth District School Board</a> uses WordPress.  &#8220;We run over 100 individual school websites on a WordPress Multisite Network, and back in May of 2011, we launched the HWDSB Commons: a second Multisite Network which now hosts over 8,000 blogs for over 30,000 users,&#8221; Bennett said.</p>\n<p>Bennett <a href=\"https://github.com/hwdsbcommons/\">shares links</a> to plugins the team created to solve specific issues such as comment moderation in BuddyPress and blocking specific modules in Jetpack. Since WordPress is free as in beer, it allows his school board to spend public money in a more responsible way.</p>\n<p>&#8220;In the WordPress ecosystem we operate in, I pay for functionality to be developed, and I share it openly on platforms like the WordPress plugin repository, or on sites like <a href=\"https://github.com/hwdsbcommons/\">Github,</a>&#8221; Bennett said.</p>\n<p>&#8220;The money you would have spent to enable the previously developed functionality, you can now spend on something else, something that I might benefit from. Think about how much more responsible this model is, particularly when we are talking about spending public money.</p>\n<p>&#8220;We are all contributing; and the community benefits from those contributions; and our money — and the functionality of our platforms — improves exponentially faster than if we were all spending our money paying the private company over and over for code that has already been paid for by previous customers.&#8221;</p>\n<p>To learn more about WordPress in education, listen to <a href=\"https://wptavern.com/wpweekly-episode-261-wordpress-for-schools-with-cameron-barrett\">episode 261</a> of WordPress Weekly where we interview Cameron Barrett, founder of <a href=\"http://schoolpress.co/\">SchoolPresser, LLC</a>. Barrett explains how he negotiated and helped migrate Newark New Jersey’s public school system from a proprietary CMS to WordPress.</p>\n<h2>WP101 Plugin Now Has WooCommerce and Jetpack Videos</h2>\n<p>The <a href=\"https://wp101plugin.com/\">WP101 plugin</a> has added Jetpack and WooCommerce training videos. This is in addition to the Yoast SEO and WordPress training videos.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Huge update for our WP101 Plugin! It now includes WooCommerce and Jetpack videos. That’s 90 videos for your clients! <a href=\"https://t.co/6jtzj1JgkC\">https://t.co/6jtzj1JgkC</a> <a href=\"https://t.co/CByYvd61Xi\">pic.twitter.com/CByYvd61Xi</a></p>\n<p>&mdash; WordPress 101 (@WP101) <a href=\"https://twitter.com/WP101/status/829455708802408452\">February 8, 2017</a></p></blockquote>\n<p></p>\n<h1 class=\"entry-title\">Adding Meta Fields to a Widget Sidebar Section</h1>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Example for how to add meta fields/controls to a widget sidebar section in the customizer: <a href=\"https://t.co/aMadLioQn6\">https://t.co/aMadLioQn6</a> <a href=\"https://twitter.com/hashtag/javascript?src=hash\">#javascript</a> <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a></p>\n<p>&mdash; Weston Ruter ⚡ (@westonruter) <a href=\"https://twitter.com/westonruter/status/829799276976828417\">February 9, 2017</a></p></blockquote>\n<p></p>\n<h2>WP Sessions Developer Survey</h2>\n<p>WP Sessions is conducting a <a href=\"http://wpsessions.com/developer-survey/\">developer survey</a> to find out about the tools developers use. Results will be anonymized and shared in aggregate in a few weeks.</p>\n<h2>Widget Logic Has a New Maintainer</h2>\n<p><a href=\"https://wordpress.org/plugins/widget-logic/\">Widget Logic</a>, a popular plugin actively installed on more than 300K sites, has a <a href=\"https://profiles.wordpress.org/wpchefgadget/\">new maintainer</a> named <a href=\"https://profiles.wordpress.org/wpchefgadget/#content-plugins\">WPChef</a>. The plugin was created nine years ago by <a href=\"https://profiles.wordpress.org/alanft/\">Alanft</a>. Prior to WPChef gaining commit access, the last time Widget Logic was updated was <a href=\"https://plugins.trac.wordpress.org/browser/widget-logic/tags/0.57?rev=1592418\">two years ago</a>.</p>\n<p>After gaining access, WPChef released Widget Logic 5.7.0. This version fixed a PHP 7 compatibility issue, a conflict with WPML, added a new default load logic point, and a Ukrainian translation. In addition to bug fixes, a global admin notice to install Limit Login Attempts Reloaded was also added. Limit Login Attempts Reloaded is a separate plugin owned and maintained by WPChef.</p>\n<p><img />Limit Login Attempts Reloaded Admin NoticeThe wording of the notice and appearing globally caused some users to <a href=\"https://wordpress.org/support/topic/incorrect-widget-logic-team-security-recommendation/\">be concerned</a> or upset. Some users responded to the update by <a href=\"https://wordpress.org/support/plugin/widget-logic/reviews/?filter=1\">writing 1-star reviews</a>. After a user <a href=\"https://wordpress.org/support/topic/taking-over-and-forking-this-plugin/#post-8781763\">described the notice</a> as sounding like fake news, WPChef changed it.</p>\n<h2>From SupportPress to Help Scout!</h2>\n<p>The WordPress.org community team is moving away from <a href=\"https://supportpress.com/\">SupportPress</a> to Help Scout. The move opens up a number of possibilities as Help Scout offers a lot of features that are non-existent in SupportPress.</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://make.wordpress.org/community/2017/02/09/moving-from-supportpress-to-help-scout/\">Moving from SupportPress to Help Scout</a></p></blockquote>\n<p></p>\n<h2>Plush Wapuu!</h2>\n<p>In what is a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/hashtag/Wapuu?src=hash\">#Wapuu</a> army is taking over <a href=\"https://twitter.com/hashtag/WordCamp?src=hash\">#WordCamp</a> US <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60d.png\" alt=\"😍\" class=\"wp-smiley\" /><a href=\"https://twitter.com/hashtag/wcus?src=hash\">#wcus</a> <a href=\"https://twitter.com/hashtag/wcus2016?src=hash\">#wcus2016</a> <a href=\"https://t.co/Giyt3KFsnF\">pic.twitter.com/Giyt3KFsnF</a></p>\n<p>&mdash; Musannif (@mzahir) <a href=\"https://twitter.com/mzahir/status/805133225127510016\">December 3, 2016</a></p></blockquote>\n<p></p>\n<p>This plush Wapuu which was given away at WordCamp US 2016 as part of the event&#8217;s swag was a huge hit with attendees and their children. I have one myself and the quality is superb.</p>\n<p>That&#8217;s it for issue seventeen. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Feb 2017 22:16:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"BuddyPress: BuddyPress 2.8.0 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=263679\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://buddypress.org/2017/02/buddypress-2-8-0-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1158:\"<p>BuddyPress 2.8.0 Release Candidate 1 is now available for testing. Please <a href=\"https://downloads.wordpress.org/plugin/buddypress.2.8.0-RC1.zip\">download the 2.8.0-RC1 zip</a> or get a copy via our Subversion repository.</p>\n<p>This is our last chance to find any bugs that slipped through the beta process. So please test with your themes and plugins. We plan to release BuddyPress 2.8.0 next Wednesday, February 15.</p>\n<p>A detailed changelog will be part of our official release notes, but you can get a quick overview by reading the post about the <a href=\"https://buddypress.org/2017/01/buddypress-2-8-0-beta-1/\">2.8.0 Beta 1</a> release.</p>\n<p>Release Candidate means we are in string freeze, so translators should feel confident in finishing their BuddyPress translations in <a href=\"https://translate.wordpress.org/projects/wp-plugins/buddypress\">GlotPress</a>.</p>\n<p>Let us know of any issues you find in <a href=\"https://buddypress.org/support\">the support forums</a> and/or on <a href=\"https://buddypress.trac.wordpress.org\">our development tracker</a>.</p>\n<p>Thanks in advance for giving the release candidate a test drive!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Feb 2017 20:51:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Slava Abakumov\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: Creative Commons’ New Search Tool is Now in Beta, Pulls CC Images from Multiple Sources\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65809\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/creative-commons-new-search-tool-is-now-in-beta-pulls-cc-images-from-multiple-sources\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5467:\"<p>If you&#8217;ve been wearing out Unsplash images on your blog, it&#8217;s time to take another look at Creative Commons. The site has just <a href=\"https://creativecommons.org/2017/02/07/new-cc-search/\" target=\"_blank\">launched the beta</a> of its new multi-source search interface. Unlike the <a href=\"https://search.creativecommons.org/\" target=\"_blank\">current search tool</a>, which will only search one source by sending the visitor offsite, <a href=\"https://ccsearch.creativecommons.org/\" target=\"_blank\">CC Search</a> loads the results from multiple sources onsite.</p>\n<p>The Commons includes approximately 1.1 billion works in various formats &#8211; literary works, videos, photos, audio, scientific research, and other formats. As half of these works are estimated to be images, the prototype for the new search tool focuses on this format.</p>\n<p>&#8220;Our goal is to cover the whole commons, but we wanted to develop something people could test and react to that would be useful at launch,&#8221; Creative Commons CEO Ryan Merkley said. &#8220;To build our beta, we settled on a goal to represent one percent of the known Commons, or about 10 million works, and we chose a vertical slice of images only, to fully explore a purpose-built interface that represented one type but many providers.&#8221;</p>\n<p>CC Search currently pulls CC-licensed images from Rijksmuseum, Flickr, 500px, the New York Public Library, and the Metropolitan Museum of Art. This includes 200,000 new images from the collection of <a href=\"https://creativecommons.org/2017/02/07/met-announcement/\" target=\"_blank\">375,000 digital works that the Met released under CC0</a> this week.</p>\n<p>In addition to the new search interface, the beta includes social tools that allow users to curate and share their own lists, add tags and favorites, and save searches. One-click attribution is built in, making it easy for users to properly attribute the works.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/cc-search.png?ssl=1\"><img /></a></p>\n<p>As Creative Commons is a small organization and fairly lean on resources, the new search was built by a single contractor over seven months. Software engineer Liza Daly was selected to <a href=\"https://hackernoon.com/cc-search-developer-notes-and-reflection-418271194682#.6f8mudh02\" target=\"_blank\">research and build a proof-of-concept for CC Search</a>, a project which she understood to be &#8220;a front door to the universe of openly licensed content.&#8221;</p>\n<p>&#8220;CC Search is meant to make material more discoverable regardless of where it is hosted,&#8221; Daly said. &#8220;For this reason (and for obvious cost-saving objectives), we decided to host only image metadata — title, creator name, any known tags or descriptions — and link directly to the provider for image display and download. A consequence of this is that CC Search only includes images which are currently available on the web; CC is not collecting or archive any images itself.&#8221;</p>\n<p>Daly built the search feature on AWS cloud infrastructure using Python, Django, Postgres, and Elasticsearch. The beta has estimated hosting costs of $1,400/month. She opted for Python, because she was most familiar with it.</p>\n<p>&#8220;As the prototype evolved, we decided the opportunity for an engaging front door to the Commons lay in curation and personalization,&#8221; Daly said. &#8220;Because of its dedicated maintenance team and frequent patch management, I chose Django as the web framework.&#8221; She chose Elasticsearch over Solr (and other options) primarily because of the AWS’s Elasticsearch-as-a-service.</p>\n<p>&#8220;CC Search is not, at this time, a particularly sophisticated search application; image metadata is relatively simple and when dealing with a heterogeneous content set from a diversity of providers, one tends towards a lowest-common-denominator approach — our search can only be as rich as our weakest data source,&#8221; Daly said. &#8220;There is much to be improved here.&#8221;</p>\n<p>Daly also described an interesting idea for adding a blockchain-type architecture that would record licensing transactions, sharing, and gratitude in a distributed way. This idea falls outside of the scope of the MVP but may be something the project&#8217;s future developers will consider when implementing the final version.</p>\n<p>&#8220;A long-term goal of this project is to facilitate not only search and discovery, but also reuse and &#8216;gratitude,\'&#8221; Daly said. &#8220;A frequent complaint about open licenses in general — both for creative works and software code — is that contributing to the commons can be a thankless task. There are always more consumers than contributors, and there’s no open web equivalent to a Facebook &#8216;like.\'&#8221;</p>\n<p>Other future improvements that the team will consider based on user feedback include adding more content partners, more tools for customizing lists, allowing users to search from their own curated material, and giving trusted users the ability to push metadata back into the collection. Search filters may also be expanded to allow for searching by color, drilling down into tags, and searching public lists.</p>\n<p>Check out the beta for the new CC Search at <a href=\"https://ccsearch.creativecommons.org/\" target=\"_blank\">ccsearch.creativecommons.org</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Feb 2017 05:42:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Google Webmaster Tools Fixes Confusing Messages About Updating WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65787\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/google-changes-the-wording-of-its-wordpress-update-notifications\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4148:\"<p>In 2009, <a href=\"https://webmasters.googleblog.com/2009/11/new-software-version-notifications-for.html\">Google announced</a> it would send notifications via <a href=\"https://www.google.com/webmasters/tools/\">Webmaster Tools</a> to site owners that new versions of software are available E.g. Joomla, Drupal, or WordPress.</p>\n<p>WordPress 4.7.2 <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\">was released</a> at the end of January. It patched a critical security vulnerability with the REST API that is <a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-is-being-actively-exploited-hundreds-of-thousands-of-sites-defaced\">being actively exploited</a> in the wild. Site owners who updated to 4.7.2 are <a href=\"https://productforums.google.com/forum/?hl=en#!category-topic/webmasters/QwkXrbyzKBA\">receiving Google Alerts</a> that their sites are out of date.</p>\n<blockquote><p>Recommended WordPress update available for<span dir=\"ltr\"><a>http://www.example.com/</a></span></p>\n<div dir=\"ltr\">\n<div>\n<p>To: Webmaster of <span dir=\"ltr\"><a>http://www.example.com/</a></span>,</p>\n<p>Google has detected that your site is currently running WordPress 4.7.0 or 4.7.1, an older version of WordPress. Outdated or unpatched software can be vulnerable to hacking and malware exploits that harm potential visitors to your site. Therefore, we suggest you update the software on your site as soon as possible.</p>\n<p>Following are one or more example URLs where we found pages that have outdated software. The list is not exhaustive.</p>\n<p dir=\"ltr\"><a href=\"https://www.example.com/123/\" target=\"_blank\" rel=\"nofollow\">https://www.example.com/123/</a></p>\n<p dir=\"ltr\"><a href=\"https://www.example.com/456/\" target=\"_blank\" rel=\"nofollow\">https://www.example.com/456/</a></p>\n<p dir=\"ltr\"><a href=\"https://www.example.com/789/\" target=\"_blank\" rel=\"nofollow\">https://www.example.com/789/</a></p>\n</div>\n</div>\n</blockquote>\n<p dir=\"ltr\">Some of the people who received notices thought the email was a phishing attempt as WordPress is misspelled using a lower-case p. Others <a href=\"https://productforums.google.com/d/msg/webmasters/QwkXrbyzKBA/z_4hg5s5BwAJ\">expressed confusion and anxiety</a> receiving notices despite having already updated their sites.</p>\n<p dir=\"ltr\">WordPress powered sites contain a meta generator that Google uses to detect which version is running.</p>\n<p dir=\"ltr\">&lt; meta name=&#8221;generator&#8221; content=&#8221;WordPress 4.7.1&#8243; /&gt;</p>\n<p dir=\"ltr\">However, Google does not monitor pages in real-time. If a site owner updates to WordPress 4.7.2 but the page indexed by Google is running 4.7.1, they&#8217;ll receive a notice.</p>\n<p dir=\"ltr\">Juan Felipe Rincón, Webmaster Outreach at Google, <a href=\"https://productforums.google.com/d/msg/webmasters/QwkXrbyzKBA/25QwebHfBwAJ\">responded </a>to the forum thread and confirmed the issues reported by users, &#8220;Definitely a problem on our end,&#8221; Rincón said.</p>\n<p dir=\"ltr\">&#8220;We&#8217;re sorry for causing confusion in the messaging and for the swirl this created for many of you and your users or client base.&#8221;</p>\n<p dir=\"ltr\">Google was aware that notices would be sent to site owners who already updated but chose to send them anyway due to the seriousness of the vulnerability.</p>\n<p dir=\"ltr\">&#8220;However, we underestimated the number of sites that had already patched, and our messaging gave no room for interpretation or letting website owners know that if they had already upgraded they could ignore the message safely,&#8221; Rincón said.</p>\n<p dir=\"ltr\">Google has implemented the following changes to improve its update notification system:</p>\n<ul>\n<li dir=\"ltr\">Messages have stopped being delivered for now but will resume shortly.</li>\n<li dir=\"ltr\">The messages have been reworded to be clearer.</li>\n<li dir=\"ltr\">Additional checks have been added to reduce the number of notifications sent to owners who already updated.</li>\n</ul>\n<p>If you&#8217;ve updated WordPress to 4.7.2, you can safely disregard the notices.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 23:55:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: WordCamp Miami 2017 to Host JavaScript Track, AMA Spots, and 2-Day Kids’ Camp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65831\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/wordcamp-miami-2017-to-host-javascript-track-ama-spots-and-2-day-kids-camp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4451:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/wordcamp-miami-2017.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://2017.miami.wordcamp.org/\" target=\"_blank\">WordCamp Miami</a> is sporting an 80&#8217;s theme this year for its 9th year running. The team of 12 organizers is expecting more than 800 attendees and will host 60+ local and global speakers, including new speakers from India, Australia, Poland, Canada, and other international locations.</p>\n<p>As in previous years, WordCamp Miami is a multi-day smorgasbord of WordPress networking and educational opportunities with workshops for all ages. The event is bringing back the two-day Kids&#8217; Camp and Kids&#8217; Panel it hosted last year. David Bisset, one of the organizers, is expecting approximately 50 attendees and said the team is seeing an even greater increase of parents and kids than previous years, based on more kids&#8217; tickets being purchased earlier.</p>\n<p>This year the Kids&#8217; Camp will focus on blogging and coding and children will even get their own attendee bags. Kids will also receive free hosting and a free domain name, thanks to a donation from a sponsor. The <a href=\"https://2017.miami.wordcamp.org/2017/01/17/speaker-call-opening-for-kids/\" target=\"_blank\">call for speakers for kids</a> aged 7-18 is now open.</p>\n<p>WordCamp Miami will be hosting three workshops on the Friday leading up to the main event: a Beginner&#8217;s workshop, a Freelance workshop, and the WP REST API / BuddyCamp workshop. This is the fifth consecutive year for BuddyCamp and attendees will have the opportunity to learn more about building mobile applications with BuddyPress and the WordPress REST API.</p>\n<p>The &#8220;Learn JavaScript Deeply&#8221; track is returning in 2017, featuring local and international JS developers. So far WordCamp Miami is the only camp to have an entire track devoted to JavaScript. Organizers have designed the format of the track to be duplicated by other camps that want to include more JS content.</p>\n<p>The event&#8217;s organizers usually attempt to get &#8220;<a href=\"https://2017.miami.wordcamp.org/2017/02/03/why-its-important-for-outside-the-bubble-perspectives-at-wordcamps/\" target=\"_blank\">outside the WordPress bubble</a>&#8221; by inviting speakers with experience in other platforms to share with attendees. This year&#8217;s lineup includes two sessions from members of the Drupal and Joomla communities. Mike Herchel, a front-end web developer at Lullabot, will present a session titled “WordPress &amp; Drupal: Community and Contribution Differences and Lessons.” Aleksander Kuczek, CEO of Perfect Dashboard and a Joomla Extension Directory team member, will be speaking about how Joomla handles plugin contributions.</p>\n<p>Other focus topics during the main event include customizing/extending WordPress, e-commerce, mental health, content marketing, and building a better business (from freelancers to agencies). Organizers have also reduced the time for speakers a little in order to introduce some &#8220;AMA&#8221; spots. The new format will feature prominent people in the community who will be available to simply answer questions from attendees. The guests for the AMA spots are still being finalized, but Bisset said one example is a representative from Sucuri and will be available to answer any questions regarding security.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/rate-my-talk.gif?ssl=1\"><img /></a>WordCamp Miami will also debut the &#8220;<a href=\"http://davidbisset.com/results-of-my-live-rate-my-talk-with-emoji-at-wpcampus/\" target=\"_blank\">Rate My Talk With Emoji</a>&#8221; app that Bisset developed for attendees to give &#8220;live speaker feedback&#8221; while sessions are happening. He said the team is hoping to have the speakers decide on which emoji should be available, but if there are problems with pre-event testing they will pre-select emoji. At this time they are not planning on including any negative ones. Speakers will have access to their results after the conference.</p>\n<p>WordCamp Miami would not be possible without the event&#8217;s army of volunteers. Bisset said organizers are still looking for <a href=\"http://davidbisset.us6.list-manage2.com/subscribe?u=8f9242549d66d09eceb714b54&id=046ea0475e\" target=\"_blank\">volunteers</a> to help out before and during the event.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 20:22:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: OSTraining Partners with GoDaddy to Launch Free WordPress Beginner Course on YouTube\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65805\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/ostraining-partners-with-godaddy-to-launch-free-wordpress-beginner-course-on-youtube\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4409:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/ostraining-logo.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://www.ostraining.com\" target=\"_blank\">OSTraining</a> has launched a free <a href=\"https://www.youtube.com/playlist?list=PLtaXuX0nEZk-rRfsl8lclMY5TncDmAUBm\" target=\"_blank\">40-video WordPress Beginner course</a> on YouTube, thanks to a sponsorship from GoDaddy. The open source software education site has created more than 3,000 videos for PHP platforms like WordPress, Joomla, Magento, and Drupal. This particular course, which has all new information for WordPress 4.7, was inspired by the company&#8217;s success in launching a free Drupal 8 course in 2016.</p>\n<p>&#8220;The original idea was a happy accident,&#8221; CEO Steve Burge said. &#8220;We did a <a href=\"https://www.kickstarter.com/projects/stevebure/drupal-8-training-videos-help-us-make-drupal-magic\" target=\"_blank\">Kickstarter project</a> based around the launch of Drupal 8. That involved about 200 free videos, spread over several classes. The main class was &#8216;The Drupal 8 Beginner class&#8217; and it went viral, getting over <a href=\"https://www.ostraining.com/blog/news/1-million/\" target=\"_blank\">1 million views in a year</a>.&#8221;</p>\n<p>The Kickstarter campaign raised more than $12K towards its $10K funding goal. It was the first time OSTraining produced a free course. Once the videos were released, Burge and his team were amazed by how popular the course became.</p>\n<p>&#8220;It led us to re-think our business approach,&#8221; Burge said. &#8220;Rather than putting everything behind a paywall, we realized the power of giving away our best beginner material. From a business perspective, that made sense so long as we could find a sponsor.&#8221;</p>\n<p>OSTraining worked with Topher DeRosia to film the WordPress Beginner course after securing a sponsorship from GoDaddy. Although the company has done multiple versions of its beginner class over the years, with updates for changes in each release, WordPress 4.7 presents a new opportunity for content longevity.</p>\n<p>&#8220;We hope that by targeting 4.7 this class will last longer than most, because the new release cycle means a new version won&#8217;t be here in a couple of months,&#8221; Burge said.</p>\n<p>In addition to beginner topics like how to install WordPress, write posts, and use the media library, the course also includes information on getting started with WordPress plugins like NinjaForms and Jetpack. The last few videos cover more advanced topics like security, spam, staging, and performance.</p>\n<p>Although the <a href=\"https://www.youtube.com/channel/UCpJf6LGZ0a4n9Lj4aVt9spg/\" target=\"_blank\">official WordPress YouTube channel</a> doesn&#8217;t have much educational content for beginners, the WordPress community in general is gaining a stronger presence on YouTube. Searching for &#8220;WordPress&#8221; turns up more than five million videos in many different languages. Educational topics like &#8220;How to make a WordPress website&#8221; and other tutorials are the most popular.</p>\n<p>WordPress businesses are also starting to see the value of having a solid presence on YouTube. Last year Automattic started beefing up its <a href=\"https://www.youtube.com/channel/UCvP5cfpfIgkb0Dt8o7Qt21A\" target=\"_blank\">channel</a> with a steady stream of new videos, including ads and tutorials for WordPress.com. Other large WordPress companies like <a href=\"https://www.youtube.com/user/iThemescom\" target=\"_blank\">iThemes</a>, <a href=\"https://www.youtube.com/user/wpbeginner/\" target=\"_blank\">WPBeginner</a>, and <a href=\"https://www.youtube.com/user/yoastcom/\" target=\"_blank\">Yoast</a> are publishing hundreds of free videos to YouTube, generating millions of views and thousands of subscribers.</p>\n<p>After finding success on YouTube with the free Drupal 8 videos, OSTraining has also launched a free <a href=\"https://www.youtube.com/playlist?list=PLtaXuX0nEZk9eL59JGE3ny-_GAU-z5X5D\" target=\"_blank\">Magento 2</a> course and has a free Joomla course on the way.</p>\n<p>&#8220;Getting more than 1 million views of the Drupal class really opened our eyes,&#8221; Burge said. &#8220;It&#8217;s almost like the difference between free, open source software and expensive, closed source software. You can reach so many more people by giving it away free.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 05:48:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Dougal Campbell: Good Breakdown of Recent WordPress Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"http://dougal.gunters.org/?p=81297\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://dougal.gunters.org/blog/2017/02/08/good-breakdown-of-recent-wordpress-vulnerability/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2977:\"<div class=\"featured-image align-right\"><img width=\"150\" height=\"150\" src=\"http://dougal.gunters.org/wordpress/wp-content/uploads/2008/10/wordpress-wednesday-150x150.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" /></div><p>The <a href=\"https://blog.sucuri.net/\">Sucuri Blog</a> has a good dissection of the recent critical <a href=\"https://blog.sucuri.net/2017/02/content-injection-vulnerability-wordpress-rest-api.html\">WordPress REST API vulnerability</a>. I won&#8217;t rehash the details here, but I did want to point out that this is why developers should remember to follow these two rules of defensive programming:</p>\n<ol>\n<li>Sanitize inputs as early as possible</li>\n<li>Sanitize outputs as late as possible</li>\n</ol>\n<p>In this case, there was a failure to follow the first rule. There are a couple of different places where this could have been handled better.</p>\n<p>For one, unless there is a good reason to allow <strong><code>GET</code></strong> or <strong><code>POST</code></strong> variables to override a URL placeholder parameter, then that should be handled appropriately. If there is a reason for it, then those values should be forced to comply with the regular expression or data type that is expected.</p>\n<p>The other failure, beyond simple sanitizing, is that the logic of the <strong><code>update_item_permission_check()</code></strong> method simply didn&#8217;t properly account for the failure to retrieve a valid result from <strong><code>get_post()</code></strong>. This function will return post data either as an object or an array (depending on parameters), or <strong><code>null</code></strong> upon failure. The logic of the first conditional was looking for a valid post <em>and</em> invalid permissions on the post as an error condition:</p>\n<pre><code>if ( $post &amp;&amp; ! $this-&gt;check_update_permission( $post ) ) {\n    return new WP_Error( \'rest_cannot_edit\', \n        __( \'Sorry, you are not allowed to edit this post.\' ), \n        array( \'status\' =&gt; rest_authorization_required_code() ) );\n}</code></pre>\n<p>Instead, it should have reversed the valid post logic, and looked for <em>not</em> a valid post, <em>or</em> invalid permissions:</p>\n<pre><code>if ( <strong>! $post ||</strong> ! $this-&gt;check_update_permission( $post ) ) {\n    return new WP_Error( \'rest_cannot_edit\', \n        __( \'Sorry, you are not allowed to edit this post.\' ), \n        array( \'status\' =&gt; rest_authorization_required_code() ) );\n}</code></pre>\n<p>And for good measure, it should probably check whether the return value was an instance of <strong><code>WP_Error</code></strong>, for future-proofing. This small change would have detected an invalid post ID, and still performed a valid permissions check for existing posts.</p>\n<p>Okay boys and girls, let&#8217;s say it all together now&#8230; &#8220;Security is hard.&#8221;</p>\n<p>&nbsp;</p>\n<div class=\"yarpp-related-rss yarpp-related-none\">\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 01:46:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Dougal Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: WPWeekly Episode 262 – Interview With Morten Rand-Hendriksen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65818&preview=true&preview_id=65818\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/wpweekly-episode-262-interview-with-morten-rand-hendriksen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2668:\"<p>On this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://mor10.com/\">Morten Rand-Hendriksen</a> to discuss his <a href=\"https://mor10.com/the-case-for-wordpress-telemetry/\">WordPress Telemetry proposal</a>. We discuss the potential benefits of having an opt-in usage data collection system that could help core developers and others make informed decisions. Rand-Hendriksen also shares what he&#8217;s learned from <a href=\"https://www.lynda.com/Morten-Rand-Hendriksen/725535-1.html\">teaching WordPress</a> at Lynda.com, on how difficult it is for new users to grasp WordPress.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/blogvault-security-breach-infects-customers-sites-with-malware\">BlogVault Security Breach Infects Customers’ Sites With Malware</a><br />\n<a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-is-being-actively-exploited-hundreds-of-thousands-of-sites-defaced\">WordPress REST API Vulnerability is Being Actively Exploited, Hundreds of Thousands of Sites Defaced</a><br />\n<a href=\"https://wptavern.com/wp-super-cache-1-4-9-patches-multiple-xss-vulnerabilities\">WP Super Cache 1.4.9 Patches Multiple XSS Vulnerabilities</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/content-locker/\">Content Locker</a> is a tool that allows you to configure content to be behind a paywall. Visitors can pay for content by liking, sharing, or registering an account.</p>\n<p><a href=\"https://wordpress.org/plugins/wp-jump/\">WP Jump</a> allows you to bookmark your site in the admin bar. This plugin is useful if you have several, local or online, WordPress installations.</p>\n<p><a href=\"https://wordpress.org/plugins/sidebar-content-clone/\">Sidebar Content Clone</a> is a handy solution for easily duplicating or cloning all widgets from one sidebar to another sidebar. It can also clear all widgets from a sidebar with a single click.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, February 15th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #262:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 01:03:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WP Super Cache 1.4.9 Patches Multiple XSS Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65664\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wp-super-cache-1-4-9-patches-multiple-xss-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2318:\"<p><a href=\"https://wordpress.org/plugins/wp-super-cache/\">WP Super Cache</a> is a <a href=\"https://odd.blog/2007/11/05/wordpress-super-cache-01/\">nearly 10-year-old</a> plugin that is maintained by <a href=\"https://odd.blog/\">Donncha Ó Caoimh</a> and is actively installed on more than a million sites. Releases have been far and few between, but Ó Caoimh <a href=\"https://odd.blog/2017/02/03/wp-super-cache-1-4-9/\">has released</a> WP Super Cache 1.4.9 that patches cross-site-scripting vulnerabilities on the settings page.</p>\n<p>&#8220;Those pages are only accessible by admin users so an anonymous visitor to your site can’t come along and enable it to steal your login cookies but along with those fixes come many bug fixes so it’s worth upgrading if you’re using an old version,&#8221; Ó Caoimh said.</p>\n<p>In addition to patching security vulnerabilities, this release also contains a number of bug fixes. There&#8217;s <a href=\"https://github.com/Automattic/wp-super-cache/pull/174\">also a fix</a> in this version for those who host a lot of sites that use WP Super Cache and are running into issues with semaphores due to the possibility of users using file locking.</p>\n<p>If you&#8217;re running into this issue and need to disable file locking completely, Ó Caoimh suggests setting the WPSC_DISABLE_LOCKING constant in a global config file. &#8220;The file locking simply slowed down how fast cache files were created and is a hold-over from WP Cache when that plugin used to write directly to the cache files,&#8221; Ó Caoimh said.</p>\n<p>&#8220;This plugin writes to temporary files before moving to the final cache files so that locking isn’t really needed, but some sites still use it which is why it’s still around.&#8221;</p>\n<p>Ó Caoimh is already hard at work on the next version of WP Super Cache with an effort towards <a href=\"https://github.com/Automattic/wp-super-cache/pull/177\">moving legacy cache files</a> into supercache directories. This will improve performance and make the files easier to maintain.</p>\n<p>Users are encouraged to update to 1.4.9 as soon as possible. To see a detailed list of changes and bug fixes, visit the <a href=\"https://wordpress.org/plugins/wp-super-cache/changelog/\">plugin&#8217;s changelog</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Feb 2017 04:26:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 05 Mar 2017 08:51:07 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Sun, 05 Mar 2017 08:30:09 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130910221710\";}", "no");
INSERT INTO `wp_options` VALUES("755", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1488747069", "no");
INSERT INTO `wp_options` VALUES("756", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1488703869", "no");
INSERT INTO `wp_options` VALUES("757", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1488747073", "no");
INSERT INTO `wp_options` VALUES("758", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Mar 2017 08:41:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29832@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"Secure your website with the most comprehensive WordPress security plugin. Firewall, malware scan, blocking, live traffic, login security &#38; more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"5790@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"38058@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"8321@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"15@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Akismet checks your comments and contact form submissions against our global database of spam to protect you and your site from malicious content.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"12073@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Search Engine (SEO) &#38; Performance Optimization (WPO) via caching. Integrated caching: CDN, Minify, Page, Object, Fragment, Database support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"6743@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2572@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2646@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"9542@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"363@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2141@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"47509@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"18101@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"29860@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"51888@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"NextGEN Gallery - WordPress Gallery Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"1169@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 16.5 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Google Analytics for WordPress by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2316@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"The best Google Analytics plugin for WordPress. See how visitors find and use your website, so you can keep them coming back.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"2082@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Extends and enhances TinyMCE, the WordPress Visual Editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"25254@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"23862@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"The one plugin you need for stats, related posts, search engine optimization, social sharing, protection, backups, speed, and email list management.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"132@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"753@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"The original SEO plugin for WordPress, downloaded over 30,000,000 times since 2007.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"50539@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"Displays Google Analytics stats in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26607@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"26907@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly. Provides tool t\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"28395@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"31973@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"SiteOrigin Widgets Bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/so-widgets-bundle/#post-67824\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 May 2014 14:27:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"67824@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"A collection of all widgets, neatly bundled into a single plugin. It&#039;s also a framework to code your own widgets on top of.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"21738@http://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 05 Mar 2017 08:51:13 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Sun, 04 Sep 2011 03:13:51 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130910221710\";}", "no");
INSERT INTO `wp_options` VALUES("759", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1488747073", "no");
INSERT INTO `wp_options` VALUES("760", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1488703873", "no");
INSERT INTO `wp_options` VALUES("761", "_transient_timeout_dash_88ae138922fe95674369b1cb3d215a2b", "1488747073", "no");
INSERT INTO `wp_options` VALUES("762", "_transient_dash_88ae138922fe95674369b1cb3d215a2b", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\'>WordPress 4.7.2 Security Release</a> <span class=\"rss-date\">January 26, 2017</span><div class=\"rssSummary\">WordPress 4.7.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.7.1 and earlier are affected by three security issues: The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/web-annotations-are-now-a-w3c-standard-paving-the-way-for-decentralized-annotation-infrastructure\'>WPTavern: Web Annotations are Now a W3C Standard, Paving the Way for Decentralized Annotation Infrastructure</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/wpcampus-2017-to-take-place-july-14-15-in-buffalo-ny\'>WPTavern: WPCampus 2017 to Take Place July 14-15 in Buffalo, NY</a></li><li><a class=\'rsswidget\' href=\'https://ma.tt/2017/03/henry-crown-fellowship/\'>Matt: Henry Crown Fellowship</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>Popular Plugin:</span> Page Builder by SiteOrigin&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=siteorigin-panels&amp;_wpnonce=ff5a426457&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Install Page Builder by SiteOrigin\">(Install)</a></li></ul></div>", "no");
INSERT INTO `wp_options` VALUES("765", "_site_transient_timeout_available_translations", "1488714971", "no");
INSERT INTO `wp_options` VALUES("766", "_site_transient_available_translations", "a:108:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:38:06\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:49:08\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-22 18:59:07\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-01 08:27:29\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:53:38\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-04 16:58:43\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-05 09:44:12\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-04 20:20:28\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-22 09:36:15\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 08:46:26\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:12:\"Čeština‎\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:49:29\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-28 00:33:54\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:39:59\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/4.7.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-18 10:45:41\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-18 10:54:37\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-21 10:37:42\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 00:40:28\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:53:43\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:49:34\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-28 03:10:25\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:30\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:07\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-28 20:09:49\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:41:31\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:42:28\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-17 15:41:04\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:53:56\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_GT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 16:37:11\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:33\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-02 15:21:03\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:42:25\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:32\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-03 21:08:25\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-19 21:32:45\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:27\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-07 18:47:03\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-29 21:21:10\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-03-03 12:18:25\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-29 13:53:21\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:39\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-03-05 03:12:35\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-16 13:36:46\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-03-04 15:41:03\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-03 01:42:19\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:24\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:39:13\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-07 02:07:59\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:39:53\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:25\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:34\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-27 07:51:28\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:41\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:42:37\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:49\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.15\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.15/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:42:31\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:31\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:49:13\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-16 13:24:21\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-03-03 13:02:03\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:57\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-02 13:47:38\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-09 22:44:40\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.15\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.15/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-17 03:35:07\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-20 18:48:35\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:42:11\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-03-03 06:09:17\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-03-02 14:28:53\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-08 17:57:45\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-29 18:17:50\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:41:03\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:55\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:43\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-30 02:38:08\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-17 11:46:52\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-05 09:23:39\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-21 17:42:28\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-30 07:08:17\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-15 15:45:53\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-27 02:33:07\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:54:45\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-02-14 16:53:54\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:55:14\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `wp_options` VALUES("778", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1488775398", "no");
INSERT INTO `wp_options` VALUES("779", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"6205\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3809\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3808\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"3337\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2904\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2633\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"2300\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2256\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"2178\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"2151\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"2114\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"2080\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"2019\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1975\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1811\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1707\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1684\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1502\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1419\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1331\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1314\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1183\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1156\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:4:\"1110\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:4:\"1046\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:4:\"1037\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:4:\"1006\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:4:\"1002\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"996\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"978\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"948\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"920\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"896\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"883\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"881\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"847\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"805\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"804\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"797\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"789\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"783\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"781\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"781\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"770\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"766\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"759\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"750\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"744\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"741\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"734\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"718\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"664\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"663\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"662\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"654\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"643\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"642\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"638\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"629\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"624\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"609\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"607\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"602\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"599\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"598\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"592\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"578\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"568\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"567\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"564\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"558\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"557\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"547\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"545\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"545\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"530\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"525\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"518\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"497\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"493\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"475\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"473\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"473\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"467\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"463\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"459\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"452\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"449\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"448\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"447\";}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";s:3:\"439\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"437\";}s:6:\"paypal\";a:3:{s:4:\"name\";s:6:\"paypal\";s:4:\"slug\";s:6:\"paypal\";s:5:\"count\";s:3:\"437\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"436\";}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";s:3:\"436\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"431\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"431\";}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";s:3:\"428\";}s:8:\"linkedin\";a:3:{s:4:\"name\";s:8:\"linkedin\";s:4:\"slug\";s:8:\"linkedin\";s:5:\"count\";s:3:\"427\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"424\";}}", "no");
INSERT INTO `wp_options` VALUES("783", "widget_paypal_donations", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("787", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.1.34\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("788", "duplicator_version_plugin", "1.1.34", "yes");
INSERT INTO `wp_options` VALUES("790", "options_partners_0_name", "AIF", "no");
INSERT INTO `wp_options` VALUES("791", "_options_partners_0_name", "field_58bcc8b599f7e", "no");
INSERT INTO `wp_options` VALUES("792", "options_partners_0_image", "210", "no");
INSERT INTO `wp_options` VALUES("793", "_options_partners_0_image", "field_58bcc8d299f7f", "no");
INSERT INTO `wp_options` VALUES("794", "options_partners_1_name", "Lumbini Development Trust", "no");
INSERT INTO `wp_options` VALUES("795", "_options_partners_1_name", "field_58bcc8b599f7e", "no");
INSERT INTO `wp_options` VALUES("796", "options_partners_1_image", "211", "no");
INSERT INTO `wp_options` VALUES("797", "_options_partners_1_image", "field_58bcc8d299f7f", "no");
INSERT INTO `wp_options` VALUES("798", "options_partners", "2", "no");
INSERT INTO `wp_options` VALUES("799", "_options_partners", "field_58bcc89e99f7d", "no");
INSERT INTO `wp_options` VALUES("800", "_transient_is_multi_author", "0", "yes");
INSERT INTO `wp_options` VALUES("803", "_site_transient_timeout_theme_roots", "1488770085", "no");
INSERT INTO `wp_options` VALUES("804", "_site_transient_theme_roots", "a:4:{s:13:\"lumbini-theme\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("805", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1488768295;s:8:\"response\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";O:8:\"stdClass\":5:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:5:\"5.5.9\";s:3:\"url\";s:37:\"https://www.advancedcustomfields.com/\";s:7:\"package\";s:0:\"\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:8:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"3.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.3.3.zip\";}s:79:\"automatic-featured-images-from-videos/automatic-featured-images-from-videos.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"52102\";s:4:\"slug\";s:37:\"automatic-featured-images-from-videos\";s:6:\"plugin\";s:79:\"automatic-featured-images-from-videos/automatic-featured-images-from-videos.php\";s:11:\"new_version\";s:5:\"1.0.3\";s:3:\"url\";s:68:\"https://wordpress.org/plugins/automatic-featured-images-from-videos/\";s:7:\"package\";s:86:\"https://downloads.wordpress.org/plugin/automatic-featured-images-from-videos.1.0.3.zip\";}s:43:\"custom-post-type-ui/custom-post-type-ui.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"13183\";s:4:\"slug\";s:19:\"custom-post-type-ui\";s:6:\"plugin\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"new_version\";s:5:\"1.5.2\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/custom-post-type-ui/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/custom-post-type-ui.1.5.2.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.1.34\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.1.34.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:37:\"paypal-donations/paypal-donations.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"7964\";s:4:\"slug\";s:16:\"paypal-donations\";s:6:\"plugin\";s:37:\"paypal-donations/paypal-donations.php\";s:11:\"new_version\";s:5:\"1.9.3\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/paypal-donations/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/paypal-donations.zip\";}s:35:\"wordpress-reset/wordpress-reset.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"7057\";s:4:\"slug\";s:15:\"wordpress-reset\";s:6:\"plugin\";s:35:\"wordpress-reset/wordpress-reset.php\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wordpress-reset/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-reset.1.4.zip\";}s:27:\"wp-pagenavi/wp-pagenavi.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"363\";s:4:\"slug\";s:11:\"wp-pagenavi\";s:6:\"plugin\";s:27:\"wp-pagenavi/wp-pagenavi.php\";s:11:\"new_version\";s:4:\"2.91\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/wp-pagenavi/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wp-pagenavi.2.91.zip\";}}}", "no");
INSERT INTO `wp_options` VALUES("806", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-06 02:51:49\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.21\";s:10:\"VersionPHP\";s:5:\"5.6.3\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20170306_lumbinikapilvastu\";s:4:\"Hash\";s:29:\"58bccec53403f7614170306025149\";s:8:\"NameHash\";s:56:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/Applications/XAMPP/xamppfiles/htdocs/lumbini/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://localhost/lumbini/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/Applications/XAMPP/xamppfiles/htdocs/lumbini\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-06 02:51:49\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.21\";s:10:\"VersionPHP\";s:5:\"5.6.3\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20170306_lumbinikapilvastu\";s:4:\"Hash\";s:29:\"58bccec53403f7614170306025149\";s:8:\"NameHash\";s:56:\"20170306_lumbinikapilvastu_58bccec53403f7614170306025149\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/Applications/XAMPP/xamppfiles/htdocs/lumbini/wp-snapshots/tmp\";s:8:\"StoreURL\";s:38:\"http://localhost/lumbini/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:19:\"Source distribution\";s:10:\"\0*\0Package\";r:52;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}", "yes");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "4", "_wp_attached_file", "2017/02/site-logo-1.png");
INSERT INTO `wp_postmeta` VALUES("3", "4", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:268;s:6:\"height\";i:268;s:4:\"file\";s:23:\"2017/02/site-logo-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"site-logo-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("4", "5", "_wp_attached_file", "2017/02/cropped-site-logo-1-1.png");
INSERT INTO `wp_postmeta` VALUES("5", "5", "_wp_attachment_context", "custom-logo");
INSERT INTO `wp_postmeta` VALUES("6", "5", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:250;s:4:\"file\";s:33:\"2017/02/cropped-site-logo-1-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"cropped-site-logo-1-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("7", "6", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("8", "6", "_wp_trash_meta_time", "1488033991");
INSERT INTO `wp_postmeta` VALUES("9", "7", "_wp_attached_file", "2017/02/lumbini1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("10", "7", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1720;s:6:\"height\";i:300;s:4:\"file\";s:22:\"2017/02/lumbini1-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"lumbini1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"lumbini1-1-300x52.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:52;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"lumbini1-1-768x134.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:134;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"lumbini1-1-1024x179.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("11", "7", "_wp_attachment_custom_header_last_used_lumbini-theme", "1488034041");
INSERT INTO `wp_postmeta` VALUES("12", "7", "_wp_attachment_is_custom_header", "lumbini-theme");
INSERT INTO `wp_postmeta` VALUES("13", "8", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("14", "8", "_wp_trash_meta_time", "1488034041");
INSERT INTO `wp_postmeta` VALUES("15", "9", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("16", "9", "_wp_trash_meta_time", "1488034060");
INSERT INTO `wp_postmeta` VALUES("17", "10", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("18", "10", "_edit_lock", "1488033936:1");
INSERT INTO `wp_postmeta` VALUES("19", "12", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("20", "13", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("21", "14", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("22", "15", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("23", "16", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("24", "17", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("25", "17", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("26", "17", "_edit_lock", "1488767066:1");
INSERT INTO `wp_postmeta` VALUES("27", "18", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("28", "19", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("29", "20", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("30", "21", "_wp_attached_file", "2017/02/1280px-The_Monastery_of_World_Peace_Lumbini-1.jpg");
INSERT INTO `wp_postmeta` VALUES("31", "21", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1280;s:6:\"height\";i:857;s:4:\"file\";s:57:\"2017/02/1280px-The_Monastery_of_World_Peace_Lumbini-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:57:\"1280px-The_Monastery_of_World_Peace_Lumbini-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:57:\"1280px-The_Monastery_of_World_Peace_Lumbini-1-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:57:\"1280px-The_Monastery_of_World_Peace_Lumbini-1-768x514.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:514;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:58:\"1280px-The_Monastery_of_World_Peace_Lumbini-1-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("32", "22", "_wp_attached_file", "2017/02/20121101-DSC06664-4-1.jpg");
INSERT INTO `wp_postmeta` VALUES("33", "22", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:800;s:6:\"height\";i:600;s:4:\"file\";s:33:\"2017/02/20121101-DSC06664-4-1.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"20121101-DSC06664-4-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"20121101-DSC06664-4-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"20121101-DSC06664-4-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"DSC-HX9V\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1351767600\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:5:\"33.32\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:9:\"0.0015625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("34", "23", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("35", "23", "_wp_trash_meta_time", "1488034588");
INSERT INTO `wp_postmeta` VALUES("36", "23", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("37", "24", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("38", "24", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("39", "24", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("40", "24", "_menu_item_object_id", "10");
INSERT INTO `wp_postmeta` VALUES("41", "24", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("42", "24", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("43", "24", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("44", "24", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("45", "24", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("47", "25", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("48", "25", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("49", "25", "_edit_lock", "1488037842:1");
INSERT INTO `wp_postmeta` VALUES("50", "27", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("51", "27", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("52", "27", "_edit_lock", "1488685081:1");
INSERT INTO `wp_postmeta` VALUES("53", "29", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("54", "29", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("55", "29", "_edit_lock", "1488220195:1");
INSERT INTO `wp_postmeta` VALUES("56", "31", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("57", "31", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("58", "31", "_edit_lock", "1488037753:1");
INSERT INTO `wp_postmeta` VALUES("59", "33", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("60", "33", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("61", "33", "_edit_lock", "1488037856:1");
INSERT INTO `wp_postmeta` VALUES("62", "35", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("63", "35", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("64", "35", "_edit_lock", "1488035046:1");
INSERT INTO `wp_postmeta` VALUES("65", "37", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("66", "37", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("67", "37", "_edit_lock", "1488035328:1");
INSERT INTO `wp_postmeta` VALUES("68", "37", "_thumbnail_id", "22");
INSERT INTO `wp_postmeta` VALUES("70", "39", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("71", "39", "_oembed_7b09888fe58e5659066972e600c3138d", "<iframe width=\"500\" height=\"375\" src=\"https://www.youtube.com/embed/OA2-rWsOw7M?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("72", "39", "_oembed_time_7b09888fe58e5659066972e600c3138d", "1488035421");
INSERT INTO `wp_postmeta` VALUES("73", "39", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("74", "39", "_edit_lock", "1488220140:1");
INSERT INTO `wp_postmeta` VALUES("76", "41", "_wp_attached_file", "2017/02/world-peace-city-lumbini-nepal-international-conference-01.jpg");
INSERT INTO `wp_postmeta` VALUES("77", "41", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:360;s:4:\"file\";s:70:\"2017/02/world-peace-city-lumbini-nepal-international-conference-01.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:70:\"world-peace-city-lumbini-nepal-international-conference-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:70:\"world-peace-city-lumbini-nepal-international-conference-01-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("78", "39", "_thumbnail_id", "41");
INSERT INTO `wp_postmeta` VALUES("79", "42", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("80", "42", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("81", "42", "_edit_lock", "1488216488:1");
INSERT INTO `wp_postmeta` VALUES("82", "43", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("83", "43", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("84", "43", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("85", "43", "_menu_item_object_id", "35");
INSERT INTO `wp_postmeta` VALUES("86", "43", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("87", "43", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("88", "43", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("89", "43", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("90", "43", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("112", "46", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("113", "46", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("114", "46", "_menu_item_menu_item_parent", "132");
INSERT INTO `wp_postmeta` VALUES("115", "46", "_menu_item_object_id", "29");
INSERT INTO `wp_postmeta` VALUES("116", "46", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("117", "46", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("118", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("119", "46", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("120", "46", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("122", "47", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("123", "47", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("124", "47", "_menu_item_menu_item_parent", "132");
INSERT INTO `wp_postmeta` VALUES("125", "47", "_menu_item_object_id", "27");
INSERT INTO `wp_postmeta` VALUES("126", "47", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("127", "47", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("128", "47", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("129", "47", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("130", "47", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("142", "49", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("143", "49", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("144", "49", "_menu_item_menu_item_parent", "50");
INSERT INTO `wp_postmeta` VALUES("145", "49", "_menu_item_object_id", "12");
INSERT INTO `wp_postmeta` VALUES("146", "49", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("147", "49", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("148", "49", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("149", "49", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("150", "49", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("152", "50", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("153", "50", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("154", "50", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("155", "50", "_menu_item_object_id", "3");
INSERT INTO `wp_postmeta` VALUES("156", "50", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("157", "50", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("158", "50", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("159", "50", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("160", "50", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("162", "51", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("163", "51", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("164", "51", "_menu_item_menu_item_parent", "50");
INSERT INTO `wp_postmeta` VALUES("165", "51", "_menu_item_object_id", "4");
INSERT INTO `wp_postmeta` VALUES("166", "51", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("167", "51", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("168", "51", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("169", "51", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("170", "51", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("172", "52", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("173", "52", "_menu_item_type", "taxonomy");
INSERT INTO `wp_postmeta` VALUES("174", "52", "_menu_item_menu_item_parent", "50");
INSERT INTO `wp_postmeta` VALUES("175", "52", "_menu_item_object_id", "5");
INSERT INTO `wp_postmeta` VALUES("176", "52", "_menu_item_object", "category");
INSERT INTO `wp_postmeta` VALUES("177", "52", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("178", "52", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("179", "52", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("180", "52", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("182", "42", "_thumbnail_id", "21");
INSERT INTO `wp_postmeta` VALUES("184", "54", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("185", "55", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("186", "56", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("187", "56", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("188", "56", "_edit_lock", "1488618183:1");
INSERT INTO `wp_postmeta` VALUES("189", "58", "_wp_attached_file", "2017/02/damodar-1.jpg");
INSERT INTO `wp_postmeta` VALUES("190", "58", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:738;s:6:\"height\";i:738;s:4:\"file\";s:21:\"2017/02/damodar-1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"damodar-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"damodar-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("191", "29", "_thumbnail_id", "58");
INSERT INTO `wp_postmeta` VALUES("409", "73", "_wp_attached_file", "2017/02/lumbini1-1-1.jpg");
INSERT INTO `wp_postmeta` VALUES("410", "73", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1720;s:6:\"height\";i:300;s:4:\"file\";s:24:\"2017/02/lumbini1-1-1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"lumbini1-1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"lumbini1-1-1-300x52.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:52;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"lumbini1-1-1-768x134.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:134;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"lumbini1-1-1-1024x179.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("412", "14", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("413", "14", "_wp_trash_meta_time", "1488042708");
INSERT INTO `wp_postmeta` VALUES("414", "14", "_wp_desired_post_slug", "categories");
INSERT INTO `wp_postmeta` VALUES("415", "13", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("416", "13", "_wp_trash_meta_time", "1488042708");
INSERT INTO `wp_postmeta` VALUES("417", "13", "_wp_desired_post_slug", "locations");
INSERT INTO `wp_postmeta` VALUES("418", "16", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("419", "16", "_wp_trash_meta_time", "1488042708");
INSERT INTO `wp_postmeta` VALUES("420", "16", "_wp_desired_post_slug", "my-bookings");
INSERT INTO `wp_postmeta` VALUES("421", "15", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("422", "15", "_wp_trash_meta_time", "1488042708");
INSERT INTO `wp_postmeta` VALUES("423", "15", "_wp_desired_post_slug", "tags");
INSERT INTO `wp_postmeta` VALUES("424", "78", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("425", "78", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("426", "79", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("428", "81", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("429", "78", "_edit_lock", "1488763732:1");
INSERT INTO `wp_postmeta` VALUES("430", "82", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("431", "82", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("432", "82", "_edit_lock", "1488088306:1");
INSERT INTO `wp_postmeta` VALUES("433", "82", "_thumbnail_id", "73");
INSERT INTO `wp_postmeta` VALUES("434", "82", "start_date_and_time", "2017-02-25 00:21:00");
INSERT INTO `wp_postmeta` VALUES("435", "82", "_start_date_and_time", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("436", "82", "end_date_and_time", "");
INSERT INTO `wp_postmeta` VALUES("437", "82", "_end_date_and_time", "field_58b1bff741d5e");
INSERT INTO `wp_postmeta` VALUES("438", "82", "location", "a:3:{s:7:\"address\";s:70:\"Bedford Hotel & Congress Centre, Zuidstraat 135 1000 Brussels, Belgium\";s:3:\"lat\";s:10:\"50.8442574\";s:3:\"lng\";s:18:\"4.3473986000000195\";}");
INSERT INTO `wp_postmeta` VALUES("439", "82", "_location", "field_58b1c03541d5f");
INSERT INTO `wp_postmeta` VALUES("442", "85", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("443", "85", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("444", "85", "_edit_lock", "1488079281:1");
INSERT INTO `wp_postmeta` VALUES("445", "85", "_thumbnail_id", "21");
INSERT INTO `wp_postmeta` VALUES("446", "85", "start_date_and_time", "2016-12-20 00:00:00");
INSERT INTO `wp_postmeta` VALUES("447", "85", "_start_date_and_time", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("448", "85", "location", "a:3:{s:7:\"address\";s:62:\"Chaussée de Bruxelles 192-306, 6210 Les Bons Villers, Belgium\";s:3:\"lat\";s:18:\"50.509605806029455\";s:3:\"lng\";s:17:\"4.459590911865234\";}");
INSERT INTO `wp_postmeta` VALUES("449", "85", "_location", "field_58b1c03541d5f");
INSERT INTO `wp_postmeta` VALUES("450", "86", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("451", "86", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("452", "86", "_edit_lock", "1488711735:1");
INSERT INTO `wp_postmeta` VALUES("453", "87", "_wp_attached_file", "2017/02/0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full.jpg");
INSERT INTO `wp_postmeta` VALUES("454", "87", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:551;s:6:\"height\";i:1280;s:4:\"file\";s:89:\"2017/02/0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:89:\"0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:89:\"0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full-129x300.jpg\";s:5:\"width\";i:129;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:90:\"0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full-441x1024.jpg\";s:5:\"width\";i:441;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("455", "86", "_thumbnail_id", "87");
INSERT INTO `wp_postmeta` VALUES("456", "86", "start_date_and_time", "2017-02-28 00:00:00");
INSERT INTO `wp_postmeta` VALUES("457", "86", "_start_date_and_time", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("458", "86", "location", "a:3:{s:7:\"address\";s:41:\"Banepa, Central Development Region, Nepal\";s:3:\"lat\";s:10:\"27.6332252\";s:3:\"lng\";s:17:\"85.52774879999993\";}");
INSERT INTO `wp_postmeta` VALUES("459", "86", "_location", "field_58b1c03541d5f");
INSERT INTO `wp_postmeta` VALUES("461", "85", "start_date", "2016-11-15 00:00:00");
INSERT INTO `wp_postmeta` VALUES("462", "85", "_start_date", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("463", "82", "start_date", "2017-02-17 00:00:00");
INSERT INTO `wp_postmeta` VALUES("464", "82", "_start_date", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("465", "86", "start_date", "2017-03-12 00:00:00");
INSERT INTO `wp_postmeta` VALUES("466", "86", "_start_date", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("467", "89", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("489", "92", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("490", "92", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("491", "92", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("492", "92", "_menu_item_object_id", "29");
INSERT INTO `wp_postmeta` VALUES("493", "92", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("494", "92", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("495", "92", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("496", "92", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("497", "92", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("499", "93", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("500", "93", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("501", "93", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("502", "93", "_menu_item_object_id", "27");
INSERT INTO `wp_postmeta` VALUES("503", "93", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("504", "93", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("505", "93", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("506", "93", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("507", "93", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("519", "95", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("520", "95", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("521", "95", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("522", "95", "_menu_item_object_id", "95");
INSERT INTO `wp_postmeta` VALUES("523", "95", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("524", "95", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("525", "95", "_menu_item_classes", "a:1:{i:0;s:8:\"facebook\";}");
INSERT INTO `wp_postmeta` VALUES("526", "95", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("527", "95", "_menu_item_url", "http://#");
INSERT INTO `wp_postmeta` VALUES("529", "96", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("530", "96", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("531", "96", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("532", "96", "_menu_item_object_id", "96");
INSERT INTO `wp_postmeta` VALUES("533", "96", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("534", "96", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("535", "96", "_menu_item_classes", "a:1:{i:0;s:7:\"twitter\";}");
INSERT INTO `wp_postmeta` VALUES("536", "96", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("537", "96", "_menu_item_url", "http://#");
INSERT INTO `wp_postmeta` VALUES("539", "97", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("540", "97", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("541", "97", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("542", "97", "_menu_item_object_id", "97");
INSERT INTO `wp_postmeta` VALUES("543", "97", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("544", "97", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("545", "97", "_menu_item_classes", "a:1:{i:0;s:9:\"instagram\";}");
INSERT INTO `wp_postmeta` VALUES("546", "97", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("547", "97", "_menu_item_url", "http://#");
INSERT INTO `wp_postmeta` VALUES("549", "98", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("550", "98", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("551", "98", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("552", "98", "_menu_item_object_id", "98");
INSERT INTO `wp_postmeta` VALUES("553", "98", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("554", "98", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("555", "98", "_menu_item_classes", "a:1:{i:0;s:7:\"youtube\";}");
INSERT INTO `wp_postmeta` VALUES("556", "98", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("557", "98", "_menu_item_url", "http://#");
INSERT INTO `wp_postmeta` VALUES("559", "99", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("560", "99", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("561", "99", "_edit_lock", "1488220210:1");
INSERT INTO `wp_postmeta` VALUES("562", "100", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("563", "101", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("564", "102", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("565", "103", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("566", "103", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("567", "103", "_edit_lock", "1488697749:1");
INSERT INTO `wp_postmeta` VALUES("568", "104", "_wp_attached_file", "2017/02/0e5b87554e.jpg");
INSERT INTO `wp_postmeta` VALUES("569", "104", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:240;s:6:\"height\";i:104;s:4:\"file\";s:22:\"2017/02/0e5b87554e.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"0e5b87554e-150x104.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:104;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:13:\"Masson, Marie\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1480614552\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("570", "105", "_wp_attached_file", "2017/02/logo_en.gif");
INSERT INTO `wp_postmeta` VALUES("571", "105", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:135;s:6:\"height\";i:110;s:4:\"file\";s:19:\"2017/02/logo_en.gif\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("572", "103", "_thumbnail_id", "104");
INSERT INTO `wp_postmeta` VALUES("574", "103", "source", "UNESCO");
INSERT INTO `wp_postmeta` VALUES("575", "103", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("576", "103", "source_url", "http://www.unesco.org/new/en/brussels/about-this-office/single-view/news/unesco_brussels_office_takes_part_in_the_international_confe/");
INSERT INTO `wp_postmeta` VALUES("577", "103", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("578", "103", "source_logo", "105");
INSERT INTO `wp_postmeta` VALUES("579", "103", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("580", "106", "source", "UNESCO");
INSERT INTO `wp_postmeta` VALUES("581", "106", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("582", "106", "source_url", "http://www.unesco.org/new/en/brussels/about-this-office/single-view/news/unesco_brussels_office_takes_part_in_the_international_confe/");
INSERT INTO `wp_postmeta` VALUES("583", "106", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("584", "106", "source_logo", "105");
INSERT INTO `wp_postmeta` VALUES("585", "106", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("587", "107", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("588", "108", "_wp_attached_file", "2017/02/logo_international_conference-on-Lumbini.jpg");
INSERT INTO `wp_postmeta` VALUES("589", "108", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:292;s:6:\"height\";i:395;s:4:\"file\";s:52:\"2017/02/logo_international_conference-on-Lumbini.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"logo_international_conference-on-Lumbini-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"logo_international_conference-on-Lumbini-222x300.jpg\";s:5:\"width\";i:222;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("590", "109", "_wp_attached_file", "2017/02/gopa-logo-one.png");
INSERT INTO `wp_postmeta` VALUES("591", "109", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:590;s:6:\"height\";i:87;s:4:\"file\";s:25:\"2017/02/gopa-logo-one.png\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"gopa-logo-one-150x87.png\";s:5:\"width\";i:150;s:6:\"height\";i:87;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"gopa-logo-one-300x44.png\";s:5:\"width\";i:300;s:6:\"height\";i:44;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("592", "107", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("593", "107", "_edit_lock", "1488216309:1");
INSERT INTO `wp_postmeta` VALUES("594", "107", "_thumbnail_id", "108");
INSERT INTO `wp_postmeta` VALUES("596", "107", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("597", "107", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("598", "107", "source_url", "http://therisingnepal.org.np/news/2082");
INSERT INTO `wp_postmeta` VALUES("599", "107", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("600", "107", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("601", "107", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("602", "110", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("603", "110", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("604", "110", "source_url", "http://therisingnepal.org.np/news/2082");
INSERT INTO `wp_postmeta` VALUES("605", "110", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("606", "110", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("607", "110", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("608", "111", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("609", "1", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("610", "1", "_wp_trash_meta_time", "1488216489");
INSERT INTO `wp_postmeta` VALUES("611", "1", "_wp_desired_post_slug", "hello-world");
INSERT INTO `wp_postmeta` VALUES("612", "1", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("613", "1", "_wp_trash_meta_comments_status", "a:1:{i:1;s:1:\"1\";}");
INSERT INTO `wp_postmeta` VALUES("615", "42", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("616", "42", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("617", "42", "source_url", "http://therisingnepal.org.np/news/11615");
INSERT INTO `wp_postmeta` VALUES("618", "42", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("619", "42", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("620", "42", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("621", "113", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("622", "113", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("623", "113", "source_url", "http://therisingnepal.org.np/news/11615");
INSERT INTO `wp_postmeta` VALUES("624", "113", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("625", "113", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("626", "113", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("627", "114", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("628", "114", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("629", "114", "_edit_lock", "1488216566:1");
INSERT INTO `wp_postmeta` VALUES("630", "115", "_wp_attached_file", "2017/02/Logo-of-Lumbini-Kapilvastu.jpg");
INSERT INTO `wp_postmeta` VALUES("631", "115", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:385;s:6:\"height\";i:368;s:4:\"file\";s:38:\"2017/02/Logo-of-Lumbini-Kapilvastu.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"Logo-of-Lumbini-Kapilvastu-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"Logo-of-Lumbini-Kapilvastu-300x287.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:287;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("632", "114", "_thumbnail_id", "115");
INSERT INTO `wp_postmeta` VALUES("634", "114", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("635", "114", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("636", "114", "source_url", "http://therisingnepal.org.np/news/13312");
INSERT INTO `wp_postmeta` VALUES("637", "114", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("638", "114", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("639", "114", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("640", "116", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("641", "116", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("642", "116", "source_url", "http://therisingnepal.org.np/news/13312");
INSERT INTO `wp_postmeta` VALUES("643", "116", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("644", "116", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("645", "116", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("646", "117", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("647", "117", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("648", "117", "_edit_lock", "1488216627:1");
INSERT INTO `wp_postmeta` VALUES("650", "117", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("651", "117", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("652", "117", "source_url", "http://therisingnepal.org.np/news/6722");
INSERT INTO `wp_postmeta` VALUES("653", "117", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("654", "117", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("655", "117", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("656", "118", "source", "The Rising Nepal");
INSERT INTO `wp_postmeta` VALUES("657", "118", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("658", "118", "source_url", "http://therisingnepal.org.np/news/6722");
INSERT INTO `wp_postmeta` VALUES("659", "118", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("660", "118", "source_logo", "109");
INSERT INTO `wp_postmeta` VALUES("661", "118", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("662", "119", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("663", "119", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("664", "119", "_edit_lock", "1488696947:1");
INSERT INTO `wp_postmeta` VALUES("666", "119", "source", "Sopannews");
INSERT INTO `wp_postmeta` VALUES("667", "119", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("668", "119", "source_url", "http://sopannews.com/lumbini-kapilvastu-day-movement-submits-memo-to-pm-koirala/");
INSERT INTO `wp_postmeta` VALUES("669", "119", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("670", "119", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("671", "119", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("672", "120", "source", "Sopannews");
INSERT INTO `wp_postmeta` VALUES("673", "120", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("674", "120", "source_url", "http://sopannews.com/lumbini-kapilvastu-day-movement-submits-memo-to-pm-koirala/");
INSERT INTO `wp_postmeta` VALUES("675", "120", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("676", "120", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("677", "120", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("678", "121", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("679", "121", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("681", "121", "source", "Rebuplica");
INSERT INTO `wp_postmeta` VALUES("682", "121", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("683", "121", "source_url", "http://admin.myrepublica.com/politics/story/26377/int-l-conference-on-lumbini-to-be-organized-in-brussels.html");
INSERT INTO `wp_postmeta` VALUES("684", "121", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("685", "121", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("686", "121", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("687", "122", "source", "Rebuplica");
INSERT INTO `wp_postmeta` VALUES("688", "122", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("689", "122", "source_url", "http://admin.myrepublica.com/politics/story/26377/int-l-conference-on-lumbini-to-be-organized-in-brussels.html");
INSERT INTO `wp_postmeta` VALUES("690", "122", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("691", "122", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("692", "122", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("693", "121", "_edit_lock", "1488216799:1");
INSERT INTO `wp_postmeta` VALUES("694", "123", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("695", "123", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("696", "123", "_edit_lock", "1488216954:1");
INSERT INTO `wp_postmeta` VALUES("697", "124", "_wp_attached_file", "2017/02/main-logo.gif");
INSERT INTO `wp_postmeta` VALUES("698", "124", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:554;s:6:\"height\";i:110;s:4:\"file\";s:21:\"2017/02/main-logo.gif\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"main-logo-150x110.gif\";s:5:\"width\";i:150;s:6:\"height\";i:110;s:9:\"mime-type\";s:9:\"image/gif\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"main-logo-300x60.gif\";s:5:\"width\";i:300;s:6:\"height\";i:60;s:9:\"mime-type\";s:9:\"image/gif\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("699", "125", "_wp_attached_file", "2017/02/0702201612005020150216teriya-rocks-bardiya-600x0-1000x0.jpg");
INSERT INTO `wp_postmeta` VALUES("700", "125", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:450;s:4:\"file\";s:67:\"2017/02/0702201612005020150216teriya-rocks-bardiya-600x0-1000x0.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:67:\"0702201612005020150216teriya-rocks-bardiya-600x0-1000x0-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:67:\"0702201612005020150216teriya-rocks-bardiya-600x0-1000x0-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("701", "123", "_thumbnail_id", "125");
INSERT INTO `wp_postmeta` VALUES("703", "123", "source", "The Kathmandu Post");
INSERT INTO `wp_postmeta` VALUES("704", "123", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("705", "123", "source_url", "http://kathmandupost.ekantipur.com/news/2016-02-07/teria-magar-honoured-in-belgium.html");
INSERT INTO `wp_postmeta` VALUES("706", "123", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("707", "123", "source_logo", "124");
INSERT INTO `wp_postmeta` VALUES("708", "123", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("709", "126", "source", "The Kathmandu Post");
INSERT INTO `wp_postmeta` VALUES("710", "126", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("711", "126", "source_url", "http://kathmandupost.ekantipur.com/news/2016-02-07/teria-magar-honoured-in-belgium.html");
INSERT INTO `wp_postmeta` VALUES("712", "126", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("713", "126", "source_logo", "124");
INSERT INTO `wp_postmeta` VALUES("714", "126", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("715", "127", "_wp_attached_file", "2017/02/Group_pic_in_Intl_Conference.jpg");
INSERT INTO `wp_postmeta` VALUES("716", "127", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:4912;s:6:\"height\";i:2760;s:4:\"file\";s:40:\"2017/02/Group_pic_in_Intl_Conference.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"Group_pic_in_Intl_Conference-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"Group_pic_in_Intl_Conference-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:40:\"Group_pic_in_Intl_Conference-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:41:\"Group_pic_in_Intl_Conference-1024x575.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"SLT-A55V\";s:7:\"caption\";s:8:\"SONY DSC\";s:17:\"created_timestamp\";s:10:\"1480267400\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"18\";s:3:\"iso\";s:3:\"160\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:8:\"SONY DSC\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("717", "128", "_wp_attached_file", "2017/02/Presenting_a_letter_to_the_director_of_UNESCO_Benelux_Salvatore_Mineo.jpg");
INSERT INTO `wp_postmeta` VALUES("718", "128", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:705;s:4:\"file\";s:81:\"2017/02/Presenting_a_letter_to_the_director_of_UNESCO_Benelux_Salvatore_Mineo.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:81:\"Presenting_a_letter_to_the_director_of_UNESCO_Benelux_Salvatore_Mineo-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:81:\"Presenting_a_letter_to_the_director_of_UNESCO_Benelux_Salvatore_Mineo-300x220.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:81:\"Presenting_a_letter_to_the_director_of_UNESCO_Benelux_Salvatore_Mineo-768x564.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:564;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("719", "129", "_wp_attached_file", "2017/02/Presenting_memorandom_letter_to_that_time_prime_minister_Sushil_Koirala.jpg");
INSERT INTO `wp_postmeta` VALUES("720", "129", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:720;s:4:\"file\";s:83:\"2017/02/Presenting_memorandom_letter_to_that_time_prime_minister_Sushil_Koirala.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:83:\"Presenting_memorandom_letter_to_that_time_prime_minister_Sushil_Koirala-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:83:\"Presenting_memorandom_letter_to_that_time_prime_minister_Sushil_Koirala-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:83:\"Presenting_memorandom_letter_to_that_time_prime_minister_Sushil_Koirala-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("721", "130", "_wp_attached_file", "2017/02/Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute.jpg");
INSERT INTO `wp_postmeta` VALUES("722", "130", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1536;s:4:\"file\";s:80:\"2017/02/Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:80:\"Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:80:\"Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:80:\"Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:81:\"Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:7:\"DSC-T90\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1392219320\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"6.18\";s:3:\"iso\";s:3:\"500\";s:13:\"shutter_speed\";s:4:\"0.25\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("723", "25", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("724", "25", "_wp_trash_meta_time", "1488217359");
INSERT INTO `wp_postmeta` VALUES("725", "25", "_wp_desired_post_slug", "about-us");
INSERT INTO `wp_postmeta` VALUES("726", "33", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("727", "33", "_wp_trash_meta_time", "1488217359");
INSERT INTO `wp_postmeta` VALUES("728", "33", "_wp_desired_post_slug", "achivement");
INSERT INTO `wp_postmeta` VALUES("729", "31", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("730", "31", "_wp_trash_meta_time", "1488217359");
INSERT INTO `wp_postmeta` VALUES("731", "31", "_wp_desired_post_slug", "vision-and-mission");
INSERT INTO `wp_postmeta` VALUES("732", "132", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("733", "132", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("734", "132", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("735", "132", "_menu_item_object_id", "56");
INSERT INTO `wp_postmeta` VALUES("736", "132", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("737", "132", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("738", "132", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("739", "132", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("740", "132", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("742", "133", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("743", "133", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("744", "133", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("745", "133", "_menu_item_object_id", "29");
INSERT INTO `wp_postmeta` VALUES("746", "133", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("747", "133", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("748", "133", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("749", "133", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("750", "133", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("751", "133", "_menu_item_orphaned", "1488217394");
INSERT INTO `wp_postmeta` VALUES("752", "134", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("753", "134", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("754", "134", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("755", "134", "_menu_item_object_id", "27");
INSERT INTO `wp_postmeta` VALUES("756", "134", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("757", "134", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("758", "134", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("759", "134", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("760", "134", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("761", "134", "_menu_item_orphaned", "1488217394");
INSERT INTO `wp_postmeta` VALUES("762", "135", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("763", "135", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("764", "136", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("765", "137", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("766", "138", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("767", "139", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("769", "135", "_edit_lock", "1488646165:1");
INSERT INTO `wp_postmeta` VALUES("770", "27", "member_info_0_name", "Mr. Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("771", "27", "_member_info_0_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("772", "27", "member_info_0_designation", "President");
INSERT INTO `wp_postmeta` VALUES("773", "27", "_member_info_0_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("774", "27", "member_info_0_image", "147");
INSERT INTO `wp_postmeta` VALUES("775", "27", "_member_info_0_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("776", "27", "member_info_0_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("777", "27", "_member_info_0_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("778", "27", "member_info", "28");
INSERT INTO `wp_postmeta` VALUES("779", "27", "_member_info", "field_58b4664885603");
INSERT INTO `wp_postmeta` VALUES("780", "141", "member_info_0_name", "Mr. Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("781", "141", "_member_info_0_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("782", "141", "member_info_0_designation", "President");
INSERT INTO `wp_postmeta` VALUES("783", "141", "_member_info_0_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("784", "141", "member_info_0_image", "");
INSERT INTO `wp_postmeta` VALUES("785", "141", "_member_info_0_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("786", "141", "member_info_0_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("787", "141", "_member_info_0_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("788", "141", "member_info", "1");
INSERT INTO `wp_postmeta` VALUES("789", "141", "_member_info", "field_58b4664885603");
INSERT INTO `wp_postmeta` VALUES("790", "142", "_wp_attached_file", "2017/02/02-Vice-President-Ms-Anita-Lama.jpg");
INSERT INTO `wp_postmeta` VALUES("791", "142", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:225;s:6:\"height\";i:270;s:4:\"file\";s:43:\"2017/02/02-Vice-President-Ms-Anita-Lama.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"02-Vice-President-Ms-Anita-Lama-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("792", "143", "_wp_attached_file", "2017/02/03-General-Secretary-Mr.-Nanda-Raj-Ghale.jpg");
INSERT INTO `wp_postmeta` VALUES("793", "143", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:531;s:6:\"height\";i:569;s:4:\"file\";s:52:\"2017/02/03-General-Secretary-Mr.-Nanda-Raj-Ghale.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:52:\"03-General-Secretary-Mr.-Nanda-Raj-Ghale-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:52:\"03-General-Secretary-Mr.-Nanda-Raj-Ghale-280x300.jpg\";s:5:\"width\";i:280;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("794", "144", "_wp_attached_file", "2017/02/04-Secretary-Mr.-Geert-Catrysse.jpg");
INSERT INTO `wp_postmeta` VALUES("795", "144", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:869;s:6:\"height\";i:1280;s:4:\"file\";s:43:\"2017/02/04-Secretary-Mr.-Geert-Catrysse.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"04-Secretary-Mr.-Geert-Catrysse-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"04-Secretary-Mr.-Geert-Catrysse-204x300.jpg\";s:5:\"width\";i:204;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"04-Secretary-Mr.-Geert-Catrysse-768x1131.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1131;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"04-Secretary-Mr.-Geert-Catrysse-695x1024.jpg\";s:5:\"width\";i:695;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("796", "145", "_wp_attached_file", "2017/02/05-Treasurer-Mr.-Baburam-Sharma.jpg");
INSERT INTO `wp_postmeta` VALUES("797", "145", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:677;s:6:\"height\";i:887;s:4:\"file\";s:43:\"2017/02/05-Treasurer-Mr.-Baburam-Sharma.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"05-Treasurer-Mr.-Baburam-Sharma-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"05-Treasurer-Mr.-Baburam-Sharma-229x300.jpg\";s:5:\"width\";i:229;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:17:\"Nokia Imaging SDK\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("798", "146", "_wp_attached_file", "2017/02/06-Executive-Member-Ms-Seema-Subedi.jpg");
INSERT INTO `wp_postmeta` VALUES("799", "146", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:478;s:6:\"height\";i:620;s:4:\"file\";s:47:\"2017/02/06-Executive-Member-Ms-Seema-Subedi.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"06-Executive-Member-Ms-Seema-Subedi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"06-Executive-Member-Ms-Seema-Subedi-231x300.jpg\";s:5:\"width\";i:231;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:17:\"Nokia Imaging SDK\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("800", "147", "_wp_attached_file", "2017/02/01-President-Mr.-Damodar-Prasad-Acharya.jpg");
INSERT INTO `wp_postmeta` VALUES("801", "147", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:627;s:6:\"height\";i:627;s:4:\"file\";s:51:\"2017/02/01-President-Mr.-Damodar-Prasad-Acharya.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:51:\"01-President-Mr.-Damodar-Prasad-Acharya-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:51:\"01-President-Mr.-Damodar-Prasad-Acharya-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("802", "27", "member_info_1_name", "Ms. Anita Lama");
INSERT INTO `wp_postmeta` VALUES("803", "27", "_member_info_1_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("804", "27", "member_info_1_designation", "Vice- President");
INSERT INTO `wp_postmeta` VALUES("805", "27", "_member_info_1_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("806", "27", "member_info_1_image", "142");
INSERT INTO `wp_postmeta` VALUES("807", "27", "_member_info_1_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("808", "27", "member_info_1_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("809", "27", "_member_info_1_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("810", "27", "member_info_2_name", "Mr. Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("811", "27", "_member_info_2_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("812", "27", "member_info_2_designation", "General Secretary");
INSERT INTO `wp_postmeta` VALUES("813", "27", "_member_info_2_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("814", "27", "member_info_2_image", "143");
INSERT INTO `wp_postmeta` VALUES("815", "27", "_member_info_2_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("816", "27", "member_info_2_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("817", "27", "_member_info_2_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("818", "27", "member_info_3_name", "Mr.Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("819", "27", "_member_info_3_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("820", "27", "member_info_3_designation", "Secretary");
INSERT INTO `wp_postmeta` VALUES("821", "27", "_member_info_3_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("822", "27", "member_info_3_image", "144");
INSERT INTO `wp_postmeta` VALUES("823", "27", "_member_info_3_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("824", "27", "member_info_3_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("825", "27", "_member_info_3_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("826", "27", "member_info_4_name", "Mr. Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("827", "27", "_member_info_4_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("828", "27", "member_info_4_designation", "Treasurer");
INSERT INTO `wp_postmeta` VALUES("829", "27", "_member_info_4_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("830", "27", "member_info_4_image", "145");
INSERT INTO `wp_postmeta` VALUES("831", "27", "_member_info_4_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("832", "27", "member_info_4_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("833", "27", "_member_info_4_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("834", "27", "member_info_5_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("835", "27", "_member_info_5_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("836", "27", "member_info_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("837", "27", "_member_info_5_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("838", "27", "member_info_5_image", "146");
INSERT INTO `wp_postmeta` VALUES("839", "27", "_member_info_5_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("840", "27", "member_info_5_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("841", "27", "_member_info_5_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("842", "27", "member_info_6_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("843", "27", "_member_info_6_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("844", "27", "member_info_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("845", "27", "_member_info_6_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("846", "27", "member_info_6_image", "");
INSERT INTO `wp_postmeta` VALUES("847", "27", "_member_info_6_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("848", "27", "member_info_6_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("849", "27", "_member_info_6_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("850", "27", "member_info_7_name", "Ms Sita Sapkota");
INSERT INTO `wp_postmeta` VALUES("851", "27", "_member_info_7_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("852", "27", "member_info_7_designation", "");
INSERT INTO `wp_postmeta` VALUES("853", "27", "_member_info_7_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("854", "27", "member_info_7_image", "");
INSERT INTO `wp_postmeta` VALUES("855", "27", "_member_info_7_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("856", "27", "member_info_7_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("857", "27", "_member_info_7_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("858", "27", "member_info_8_name", "Ms Kalpana Magar");
INSERT INTO `wp_postmeta` VALUES("859", "27", "_member_info_8_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("860", "27", "member_info_8_designation", "");
INSERT INTO `wp_postmeta` VALUES("861", "27", "_member_info_8_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("862", "27", "member_info_8_image", "");
INSERT INTO `wp_postmeta` VALUES("863", "27", "_member_info_8_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("864", "27", "member_info_8_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("865", "27", "_member_info_8_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("866", "27", "member_info_9_name", "Ms Durga Bhattarai");
INSERT INTO `wp_postmeta` VALUES("867", "27", "_member_info_9_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("868", "27", "member_info_9_designation", "");
INSERT INTO `wp_postmeta` VALUES("869", "27", "_member_info_9_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("870", "27", "member_info_9_image", "");
INSERT INTO `wp_postmeta` VALUES("871", "27", "_member_info_9_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("872", "27", "member_info_9_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("873", "27", "_member_info_9_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("874", "27", "member_info_10_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("875", "27", "_member_info_10_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("876", "27", "member_info_10_designation", "");
INSERT INTO `wp_postmeta` VALUES("877", "27", "_member_info_10_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("878", "27", "member_info_10_image", "");
INSERT INTO `wp_postmeta` VALUES("879", "27", "_member_info_10_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("880", "27", "member_info_10_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("881", "27", "_member_info_10_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("882", "27", "member_info_11_name", "Mr Bernrad Braem");
INSERT INTO `wp_postmeta` VALUES("883", "27", "_member_info_11_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("884", "27", "member_info_11_designation", "");
INSERT INTO `wp_postmeta` VALUES("885", "27", "_member_info_11_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("886", "27", "member_info_11_image", "");
INSERT INTO `wp_postmeta` VALUES("887", "27", "_member_info_11_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("888", "27", "member_info_11_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("889", "27", "_member_info_11_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("890", "27", "member_info_12_name", "Mr Jogman Tamang");
INSERT INTO `wp_postmeta` VALUES("891", "27", "_member_info_12_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("892", "27", "member_info_12_designation", "");
INSERT INTO `wp_postmeta` VALUES("893", "27", "_member_info_12_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("894", "27", "member_info_12_image", "");
INSERT INTO `wp_postmeta` VALUES("895", "27", "_member_info_12_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("896", "27", "member_info_12_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("897", "27", "_member_info_12_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("898", "27", "member_info_13_name", "Mr Shreeram Prasain");
INSERT INTO `wp_postmeta` VALUES("899", "27", "_member_info_13_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("900", "27", "member_info_13_designation", "");
INSERT INTO `wp_postmeta` VALUES("901", "27", "_member_info_13_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("902", "27", "member_info_13_image", "");
INSERT INTO `wp_postmeta` VALUES("903", "27", "_member_info_13_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("904", "27", "member_info_13_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("905", "27", "_member_info_13_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("906", "27", "member_info_14_name", "Mr Saurab Karanjit");
INSERT INTO `wp_postmeta` VALUES("907", "27", "_member_info_14_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("908", "27", "member_info_14_designation", "");
INSERT INTO `wp_postmeta` VALUES("909", "27", "_member_info_14_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("910", "27", "member_info_14_image", "");
INSERT INTO `wp_postmeta` VALUES("911", "27", "_member_info_14_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("912", "27", "member_info_14_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("913", "27", "_member_info_14_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("914", "27", "member_info_15_name", "Mr Ram Chandra Subedi");
INSERT INTO `wp_postmeta` VALUES("915", "27", "_member_info_15_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("916", "27", "member_info_15_designation", "");
INSERT INTO `wp_postmeta` VALUES("917", "27", "_member_info_15_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("918", "27", "member_info_15_image", "");
INSERT INTO `wp_postmeta` VALUES("919", "27", "_member_info_15_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("920", "27", "member_info_15_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("921", "27", "_member_info_15_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("922", "27", "member_info_16_name", "Mr Pemba Dorje Sherpa");
INSERT INTO `wp_postmeta` VALUES("923", "27", "_member_info_16_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("924", "27", "member_info_16_designation", "");
INSERT INTO `wp_postmeta` VALUES("925", "27", "_member_info_16_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("926", "27", "member_info_16_image", "");
INSERT INTO `wp_postmeta` VALUES("927", "27", "_member_info_16_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("928", "27", "member_info_16_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("929", "27", "_member_info_16_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("930", "27", "member_info_17_name", "Ms Janakee Gurung");
INSERT INTO `wp_postmeta` VALUES("931", "27", "_member_info_17_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("932", "27", "member_info_17_designation", "");
INSERT INTO `wp_postmeta` VALUES("933", "27", "_member_info_17_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("934", "27", "member_info_17_image", "");
INSERT INTO `wp_postmeta` VALUES("935", "27", "_member_info_17_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("936", "27", "member_info_17_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("937", "27", "_member_info_17_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("938", "27", "member_info_18_name", "Mr Surenda Bhusal");
INSERT INTO `wp_postmeta` VALUES("939", "27", "_member_info_18_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("940", "27", "member_info_18_designation", "");
INSERT INTO `wp_postmeta` VALUES("941", "27", "_member_info_18_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("942", "27", "member_info_18_image", "");
INSERT INTO `wp_postmeta` VALUES("943", "27", "_member_info_18_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("944", "27", "member_info_18_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("945", "27", "_member_info_18_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("946", "27", "member_info_19_name", "Mr Gangadhar Gautam");
INSERT INTO `wp_postmeta` VALUES("947", "27", "_member_info_19_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("948", "27", "member_info_19_designation", "");
INSERT INTO `wp_postmeta` VALUES("949", "27", "_member_info_19_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("950", "27", "member_info_19_image", "");
INSERT INTO `wp_postmeta` VALUES("951", "27", "_member_info_19_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("952", "27", "member_info_19_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("953", "27", "_member_info_19_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("954", "27", "member_info_20_name", "Mr Baburaja Lama");
INSERT INTO `wp_postmeta` VALUES("955", "27", "_member_info_20_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("956", "27", "member_info_20_designation", "");
INSERT INTO `wp_postmeta` VALUES("957", "27", "_member_info_20_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("958", "27", "member_info_20_image", "");
INSERT INTO `wp_postmeta` VALUES("959", "27", "_member_info_20_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("960", "27", "member_info_20_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("961", "27", "_member_info_20_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("962", "27", "member_info_21_name", "Mr Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("963", "27", "_member_info_21_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("964", "27", "member_info_21_designation", "");
INSERT INTO `wp_postmeta` VALUES("965", "27", "_member_info_21_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("966", "27", "member_info_21_image", "");
INSERT INTO `wp_postmeta` VALUES("967", "27", "_member_info_21_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("968", "27", "member_info_21_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("969", "27", "_member_info_21_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("970", "27", "member_info_22_name", "Ms Anita Lama");
INSERT INTO `wp_postmeta` VALUES("971", "27", "_member_info_22_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("972", "27", "member_info_22_designation", "");
INSERT INTO `wp_postmeta` VALUES("973", "27", "_member_info_22_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("974", "27", "member_info_22_image", "");
INSERT INTO `wp_postmeta` VALUES("975", "27", "_member_info_22_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("976", "27", "member_info_22_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("977", "27", "_member_info_22_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("978", "27", "member_info_23_name", "Mr Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("979", "27", "_member_info_23_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("980", "27", "member_info_23_designation", "");
INSERT INTO `wp_postmeta` VALUES("981", "27", "_member_info_23_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("982", "27", "member_info_23_image", "");
INSERT INTO `wp_postmeta` VALUES("983", "27", "_member_info_23_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("984", "27", "member_info_23_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("985", "27", "_member_info_23_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("986", "27", "member_info_24_name", "Mr Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("987", "27", "_member_info_24_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("988", "27", "member_info_24_designation", "");
INSERT INTO `wp_postmeta` VALUES("989", "27", "_member_info_24_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("990", "27", "member_info_24_image", "");
INSERT INTO `wp_postmeta` VALUES("991", "27", "_member_info_24_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("992", "27", "member_info_24_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("993", "27", "_member_info_24_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("994", "27", "member_info_25_name", "Mr Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("995", "27", "_member_info_25_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("996", "27", "member_info_25_designation", "");
INSERT INTO `wp_postmeta` VALUES("997", "27", "_member_info_25_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("998", "27", "member_info_25_image", "");
INSERT INTO `wp_postmeta` VALUES("999", "27", "_member_info_25_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1000", "27", "member_info_25_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1001", "27", "_member_info_25_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1002", "27", "member_info_26_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("1003", "27", "_member_info_26_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1004", "27", "member_info_26_designation", "");
INSERT INTO `wp_postmeta` VALUES("1005", "27", "_member_info_26_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1006", "27", "member_info_26_image", "");
INSERT INTO `wp_postmeta` VALUES("1007", "27", "_member_info_26_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1008", "27", "member_info_26_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1009", "27", "_member_info_26_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1010", "27", "member_info_27_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1011", "27", "_member_info_27_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1012", "27", "member_info_27_designation", "");
INSERT INTO `wp_postmeta` VALUES("1013", "27", "_member_info_27_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1014", "27", "member_info_27_image", "");
INSERT INTO `wp_postmeta` VALUES("1015", "27", "_member_info_27_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1016", "27", "member_info_27_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1017", "27", "_member_info_27_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1018", "148", "member_info_0_name", "Mr. Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1019", "148", "_member_info_0_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1020", "148", "member_info_0_designation", "President");
INSERT INTO `wp_postmeta` VALUES("1021", "148", "_member_info_0_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1022", "148", "member_info_0_image", "147");
INSERT INTO `wp_postmeta` VALUES("1023", "148", "_member_info_0_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1024", "148", "member_info_0_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1025", "148", "_member_info_0_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1026", "148", "member_info", "28");
INSERT INTO `wp_postmeta` VALUES("1027", "148", "_member_info", "field_58b4664885603");
INSERT INTO `wp_postmeta` VALUES("1028", "148", "member_info_1_name", "Ms. Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1029", "148", "_member_info_1_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1030", "148", "member_info_1_designation", "Vice- President");
INSERT INTO `wp_postmeta` VALUES("1031", "148", "_member_info_1_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1032", "148", "member_info_1_image", "142");
INSERT INTO `wp_postmeta` VALUES("1033", "148", "_member_info_1_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1034", "148", "member_info_1_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1035", "148", "_member_info_1_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1036", "148", "member_info_2_name", "Mr. Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1037", "148", "_member_info_2_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1038", "148", "member_info_2_designation", "General Secretary");
INSERT INTO `wp_postmeta` VALUES("1039", "148", "_member_info_2_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1040", "148", "member_info_2_image", "143");
INSERT INTO `wp_postmeta` VALUES("1041", "148", "_member_info_2_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1042", "148", "member_info_2_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1043", "148", "_member_info_2_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1044", "148", "member_info_3_name", "Mr.Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1045", "148", "_member_info_3_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1046", "148", "member_info_3_designation", "Secretary");
INSERT INTO `wp_postmeta` VALUES("1047", "148", "_member_info_3_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1048", "148", "member_info_3_image", "144");
INSERT INTO `wp_postmeta` VALUES("1049", "148", "_member_info_3_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1050", "148", "member_info_3_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1051", "148", "_member_info_3_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1052", "148", "member_info_4_name", "Mr. Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1053", "148", "_member_info_4_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1054", "148", "member_info_4_designation", "Treasurer");
INSERT INTO `wp_postmeta` VALUES("1055", "148", "_member_info_4_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1056", "148", "member_info_4_image", "145");
INSERT INTO `wp_postmeta` VALUES("1057", "148", "_member_info_4_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1058", "148", "member_info_4_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1059", "148", "_member_info_4_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1060", "148", "member_info_5_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("1061", "148", "_member_info_5_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1062", "148", "member_info_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("1063", "148", "_member_info_5_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1064", "148", "member_info_5_image", "146");
INSERT INTO `wp_postmeta` VALUES("1065", "148", "_member_info_5_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1066", "148", "member_info_5_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1067", "148", "_member_info_5_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1068", "148", "member_info_6_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("1069", "148", "_member_info_6_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1070", "148", "member_info_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("1071", "148", "_member_info_6_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1072", "148", "member_info_6_image", "");
INSERT INTO `wp_postmeta` VALUES("1073", "148", "_member_info_6_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1074", "148", "member_info_6_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1075", "148", "_member_info_6_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1076", "148", "member_info_7_name", "Ms Sita Sapkota");
INSERT INTO `wp_postmeta` VALUES("1077", "148", "_member_info_7_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1078", "148", "member_info_7_designation", "");
INSERT INTO `wp_postmeta` VALUES("1079", "148", "_member_info_7_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1080", "148", "member_info_7_image", "");
INSERT INTO `wp_postmeta` VALUES("1081", "148", "_member_info_7_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1082", "148", "member_info_7_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1083", "148", "_member_info_7_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1084", "148", "member_info_8_name", "Ms Kalpana Magar");
INSERT INTO `wp_postmeta` VALUES("1085", "148", "_member_info_8_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1086", "148", "member_info_8_designation", "");
INSERT INTO `wp_postmeta` VALUES("1087", "148", "_member_info_8_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1088", "148", "member_info_8_image", "");
INSERT INTO `wp_postmeta` VALUES("1089", "148", "_member_info_8_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1090", "148", "member_info_8_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1091", "148", "_member_info_8_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1092", "148", "member_info_9_name", "Ms Durga Bhattarai");
INSERT INTO `wp_postmeta` VALUES("1093", "148", "_member_info_9_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1094", "148", "member_info_9_designation", "");
INSERT INTO `wp_postmeta` VALUES("1095", "148", "_member_info_9_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1096", "148", "member_info_9_image", "");
INSERT INTO `wp_postmeta` VALUES("1097", "148", "_member_info_9_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1098", "148", "member_info_9_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1099", "148", "_member_info_9_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1100", "148", "member_info_10_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1101", "148", "_member_info_10_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1102", "148", "member_info_10_designation", "");
INSERT INTO `wp_postmeta` VALUES("1103", "148", "_member_info_10_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1104", "148", "member_info_10_image", "");
INSERT INTO `wp_postmeta` VALUES("1105", "148", "_member_info_10_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1106", "148", "member_info_10_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1107", "148", "_member_info_10_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1108", "148", "member_info_11_name", "Mr Bernrad Braem");
INSERT INTO `wp_postmeta` VALUES("1109", "148", "_member_info_11_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1110", "148", "member_info_11_designation", "");
INSERT INTO `wp_postmeta` VALUES("1111", "148", "_member_info_11_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1112", "148", "member_info_11_image", "");
INSERT INTO `wp_postmeta` VALUES("1113", "148", "_member_info_11_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1114", "148", "member_info_11_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1115", "148", "_member_info_11_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1116", "148", "member_info_12_name", "Mr Jogman Tamang");
INSERT INTO `wp_postmeta` VALUES("1117", "148", "_member_info_12_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1118", "148", "member_info_12_designation", "");
INSERT INTO `wp_postmeta` VALUES("1119", "148", "_member_info_12_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1120", "148", "member_info_12_image", "");
INSERT INTO `wp_postmeta` VALUES("1121", "148", "_member_info_12_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1122", "148", "member_info_12_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1123", "148", "_member_info_12_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1124", "148", "member_info_13_name", "Mr Shreeram Prasain");
INSERT INTO `wp_postmeta` VALUES("1125", "148", "_member_info_13_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1126", "148", "member_info_13_designation", "");
INSERT INTO `wp_postmeta` VALUES("1127", "148", "_member_info_13_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1128", "148", "member_info_13_image", "");
INSERT INTO `wp_postmeta` VALUES("1129", "148", "_member_info_13_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1130", "148", "member_info_13_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1131", "148", "_member_info_13_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1132", "148", "member_info_14_name", "Mr Saurab Karanjit");
INSERT INTO `wp_postmeta` VALUES("1133", "148", "_member_info_14_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1134", "148", "member_info_14_designation", "");
INSERT INTO `wp_postmeta` VALUES("1135", "148", "_member_info_14_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1136", "148", "member_info_14_image", "");
INSERT INTO `wp_postmeta` VALUES("1137", "148", "_member_info_14_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1138", "148", "member_info_14_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1139", "148", "_member_info_14_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1140", "148", "member_info_15_name", "Mr Ram Chandra Subedi");
INSERT INTO `wp_postmeta` VALUES("1141", "148", "_member_info_15_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1142", "148", "member_info_15_designation", "");
INSERT INTO `wp_postmeta` VALUES("1143", "148", "_member_info_15_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1144", "148", "member_info_15_image", "");
INSERT INTO `wp_postmeta` VALUES("1145", "148", "_member_info_15_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1146", "148", "member_info_15_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1147", "148", "_member_info_15_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1148", "148", "member_info_16_name", "Mr Pemba Dorje Sherpa");
INSERT INTO `wp_postmeta` VALUES("1149", "148", "_member_info_16_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1150", "148", "member_info_16_designation", "");
INSERT INTO `wp_postmeta` VALUES("1151", "148", "_member_info_16_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1152", "148", "member_info_16_image", "");
INSERT INTO `wp_postmeta` VALUES("1153", "148", "_member_info_16_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1154", "148", "member_info_16_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1155", "148", "_member_info_16_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1156", "148", "member_info_17_name", "Ms Janakee Gurung");
INSERT INTO `wp_postmeta` VALUES("1157", "148", "_member_info_17_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1158", "148", "member_info_17_designation", "");
INSERT INTO `wp_postmeta` VALUES("1159", "148", "_member_info_17_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1160", "148", "member_info_17_image", "");
INSERT INTO `wp_postmeta` VALUES("1161", "148", "_member_info_17_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1162", "148", "member_info_17_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1163", "148", "_member_info_17_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1164", "148", "member_info_18_name", "Mr Surenda Bhusal");
INSERT INTO `wp_postmeta` VALUES("1165", "148", "_member_info_18_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1166", "148", "member_info_18_designation", "");
INSERT INTO `wp_postmeta` VALUES("1167", "148", "_member_info_18_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1168", "148", "member_info_18_image", "");
INSERT INTO `wp_postmeta` VALUES("1169", "148", "_member_info_18_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1170", "148", "member_info_18_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1171", "148", "_member_info_18_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1172", "148", "member_info_19_name", "Mr Gangadhar Gautam");
INSERT INTO `wp_postmeta` VALUES("1173", "148", "_member_info_19_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1174", "148", "member_info_19_designation", "");
INSERT INTO `wp_postmeta` VALUES("1175", "148", "_member_info_19_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1176", "148", "member_info_19_image", "");
INSERT INTO `wp_postmeta` VALUES("1177", "148", "_member_info_19_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1178", "148", "member_info_19_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1179", "148", "_member_info_19_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1180", "148", "member_info_20_name", "Mr Baburaja Lama");
INSERT INTO `wp_postmeta` VALUES("1181", "148", "_member_info_20_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1182", "148", "member_info_20_designation", "");
INSERT INTO `wp_postmeta` VALUES("1183", "148", "_member_info_20_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1184", "148", "member_info_20_image", "");
INSERT INTO `wp_postmeta` VALUES("1185", "148", "_member_info_20_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1186", "148", "member_info_20_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1187", "148", "_member_info_20_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1188", "148", "member_info_21_name", "Mr Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1189", "148", "_member_info_21_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1190", "148", "member_info_21_designation", "");
INSERT INTO `wp_postmeta` VALUES("1191", "148", "_member_info_21_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1192", "148", "member_info_21_image", "");
INSERT INTO `wp_postmeta` VALUES("1193", "148", "_member_info_21_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1194", "148", "member_info_21_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1195", "148", "_member_info_21_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1196", "148", "member_info_22_name", "Ms Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1197", "148", "_member_info_22_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1198", "148", "member_info_22_designation", "");
INSERT INTO `wp_postmeta` VALUES("1199", "148", "_member_info_22_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1200", "148", "member_info_22_image", "");
INSERT INTO `wp_postmeta` VALUES("1201", "148", "_member_info_22_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1202", "148", "member_info_22_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1203", "148", "_member_info_22_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1204", "148", "member_info_23_name", "Mr Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1205", "148", "_member_info_23_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1206", "148", "member_info_23_designation", "");
INSERT INTO `wp_postmeta` VALUES("1207", "148", "_member_info_23_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1208", "148", "member_info_23_image", "");
INSERT INTO `wp_postmeta` VALUES("1209", "148", "_member_info_23_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1210", "148", "member_info_23_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1211", "148", "_member_info_23_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1212", "148", "member_info_24_name", "Mr Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1213", "148", "_member_info_24_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1214", "148", "member_info_24_designation", "");
INSERT INTO `wp_postmeta` VALUES("1215", "148", "_member_info_24_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1216", "148", "member_info_24_image", "");
INSERT INTO `wp_postmeta` VALUES("1217", "148", "_member_info_24_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1218", "148", "member_info_24_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1219", "148", "_member_info_24_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1220", "148", "member_info_25_name", "Mr Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1221", "148", "_member_info_25_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1222", "148", "member_info_25_designation", "");
INSERT INTO `wp_postmeta` VALUES("1223", "148", "_member_info_25_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1224", "148", "member_info_25_image", "");
INSERT INTO `wp_postmeta` VALUES("1225", "148", "_member_info_25_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1226", "148", "member_info_25_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1227", "148", "_member_info_25_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1228", "148", "member_info_26_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("1229", "148", "_member_info_26_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1230", "148", "member_info_26_designation", "");
INSERT INTO `wp_postmeta` VALUES("1231", "148", "_member_info_26_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1232", "148", "member_info_26_image", "");
INSERT INTO `wp_postmeta` VALUES("1233", "148", "_member_info_26_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1234", "148", "member_info_26_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1235", "148", "_member_info_26_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1236", "148", "member_info_27_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1237", "148", "_member_info_27_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1238", "148", "member_info_27_designation", "");
INSERT INTO `wp_postmeta` VALUES("1239", "148", "_member_info_27_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1240", "148", "member_info_27_image", "");
INSERT INTO `wp_postmeta` VALUES("1241", "148", "_member_info_27_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1242", "148", "member_info_27_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1243", "148", "_member_info_27_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1244", "149", "_is_video", "1");
INSERT INTO `wp_postmeta` VALUES("1245", "149", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1246", "149", "_edit_lock", "1488218745:1");
INSERT INTO `wp_postmeta` VALUES("1247", "149", "_oembed_b0fd11fe3247da39543a1bc83f5df5db", "<iframe width=\"500\" height=\"375\" src=\"https://www.youtube.com/embed/QDkT-sYUGvw?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1248", "149", "_oembed_time_b0fd11fe3247da39543a1bc83f5df5db", "1488218844");
INSERT INTO `wp_postmeta` VALUES("1250", "149", "source", "");
INSERT INTO `wp_postmeta` VALUES("1251", "149", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("1252", "149", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("1253", "149", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("1254", "149", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("1255", "149", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("1256", "150", "source", "");
INSERT INTO `wp_postmeta` VALUES("1257", "150", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("1258", "150", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("1259", "150", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("1260", "150", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("1261", "150", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("1262", "151", "_wp_attached_file", "2017/02/https-www-youtube-com-watch-v-qdkt-syugvw.jpg");
INSERT INTO `wp_postmeta` VALUES("1263", "151", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:360;s:4:\"file\";s:53:\"2017/02/https-www-youtube-com-watch-v-qdkt-syugvw.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:53:\"https-www-youtube-com-watch-v-qdkt-syugvw-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:53:\"https-www-youtube-com-watch-v-qdkt-syugvw-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1264", "149", "_thumbnail_id", "151");
INSERT INTO `wp_postmeta` VALUES("1265", "152", "_is_video", "1");
INSERT INTO `wp_postmeta` VALUES("1266", "152", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1267", "152", "_edit_lock", "1488218800:1");
INSERT INTO `wp_postmeta` VALUES("1268", "152", "_oembed_24ed73b15bdce277f39fc69828098631", "<iframe width=\"500\" height=\"375\" src=\"https://www.youtube.com/embed/R3ogqFUjYQo?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1269", "152", "_oembed_time_24ed73b15bdce277f39fc69828098631", "1488218921");
INSERT INTO `wp_postmeta` VALUES("1271", "152", "source", "");
INSERT INTO `wp_postmeta` VALUES("1272", "152", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("1273", "152", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("1274", "152", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("1275", "152", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("1276", "152", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("1277", "153", "source", "");
INSERT INTO `wp_postmeta` VALUES("1278", "153", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("1279", "153", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("1280", "153", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("1281", "153", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("1282", "153", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("1283", "154", "_wp_attached_file", "2017/02/world-peace-city-lumbini-nepal-8211-international-conference-07.jpg");
INSERT INTO `wp_postmeta` VALUES("1284", "154", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:360;s:4:\"file\";s:75:\"2017/02/world-peace-city-lumbini-nepal-8211-international-conference-07.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:75:\"world-peace-city-lumbini-nepal-8211-international-conference-07-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:75:\"world-peace-city-lumbini-nepal-8211-international-conference-07-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1285", "152", "_thumbnail_id", "154");
INSERT INTO `wp_postmeta` VALUES("1286", "155", "_is_video", "1");
INSERT INTO `wp_postmeta` VALUES("1287", "155", "_oembed_047b0c5dd1a41b3919e63002de6439f3", "<iframe width=\"500\" height=\"375\" src=\"https://www.youtube.com/embed/QDkT-sYUGvw?start=7&feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1288", "155", "_oembed_time_047b0c5dd1a41b3919e63002de6439f3", "1488218954");
INSERT INTO `wp_postmeta` VALUES("1289", "155", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1291", "155", "source", "");
INSERT INTO `wp_postmeta` VALUES("1292", "155", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("1293", "155", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("1294", "155", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("1295", "155", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("1296", "155", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("1297", "156", "source", "");
INSERT INTO `wp_postmeta` VALUES("1298", "156", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("1299", "156", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("1300", "156", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("1301", "156", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("1302", "156", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("1303", "157", "_wp_attached_file", "2017/02/auto-draft.jpg");
INSERT INTO `wp_postmeta` VALUES("1304", "157", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:360;s:4:\"file\";s:22:\"2017/02/auto-draft.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"auto-draft-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"auto-draft-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1306", "155", "_edit_lock", "1488218975:1");
INSERT INTO `wp_postmeta` VALUES("1307", "155", "_oembed_4ba843d2e654f133c87e6405957525dc", "<iframe width=\"500\" height=\"375\" src=\"https://www.youtube.com/embed/7Y_KH4VtSgk?feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("1308", "155", "_oembed_time_4ba843d2e654f133c87e6405957525dc", "1488219037");
INSERT INTO `wp_postmeta` VALUES("1310", "158", "source", "");
INSERT INTO `wp_postmeta` VALUES("1311", "158", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("1312", "158", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("1313", "158", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("1314", "158", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("1315", "158", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("1317", "155", "_wp_old_slug", "world-peace-city-lumbini-nepal-international-conference-06-2");
INSERT INTO `wp_postmeta` VALUES("1319", "159", "_wp_attached_file", "2017/02/world-peace-city-lumbini-nepal-8211-international-conference-08.jpg");
INSERT INTO `wp_postmeta` VALUES("1320", "159", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:480;s:6:\"height\";i:360;s:4:\"file\";s:75:\"2017/02/world-peace-city-lumbini-nepal-8211-international-conference-08.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:75:\"world-peace-city-lumbini-nepal-8211-international-conference-08-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:75:\"world-peace-city-lumbini-nepal-8211-international-conference-08-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1321", "155", "_thumbnail_id", "159");
INSERT INTO `wp_postmeta` VALUES("1322", "160", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1323", "161", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1324", "161", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1325", "161", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1326", "161", "_menu_item_object_id", "56");
INSERT INTO `wp_postmeta` VALUES("1327", "161", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1328", "161", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1329", "161", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1330", "161", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1331", "161", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1332", "162", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1333", "162", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1334", "162", "_edit_lock", "1488296843:1");
INSERT INTO `wp_postmeta` VALUES("1335", "163", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1336", "164", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1337", "165", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1338", "166", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1339", "167", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1340", "167", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1341", "167", "_edit_lock", "1488421165:1");
INSERT INTO `wp_postmeta` VALUES("1342", "167", "testimonial", "When you summarize multiple case studies into a video presentation or brochure, your readers/viewers will get a better sense of the breadth of your offering.");
INSERT INTO `wp_postmeta` VALUES("1343", "167", "_testimonial", "field_58b59bd9f69a9");
INSERT INTO `wp_postmeta` VALUES("1344", "167", "image", "147");
INSERT INTO `wp_postmeta` VALUES("1345", "167", "_image", "field_58b59be6f69aa");
INSERT INTO `wp_postmeta` VALUES("1346", "167", "name", "Mr. Damodar Prasad Acharya ");
INSERT INTO `wp_postmeta` VALUES("1347", "167", "_name", "field_58b59bf7f69ab");
INSERT INTO `wp_postmeta` VALUES("1348", "167", "designation", "LKGCB");
INSERT INTO `wp_postmeta` VALUES("1349", "167", "_designation", "field_58b59c06f69ac");
INSERT INTO `wp_postmeta` VALUES("1350", "168", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1351", "168", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1352", "168", "_edit_lock", "1488422249:1");
INSERT INTO `wp_postmeta` VALUES("1353", "168", "testimonial", "At the E-Board and throughout our nation, we – as individuals, members of various groups, holders of myriad ideologies, residents of this nations, citizens of the world – are trying to figure out how to make this country work for all … in peacebuilding terminology, how to we bring together all stakeholders?  In spiritual terminology, …");
INSERT INTO `wp_postmeta` VALUES("1354", "168", "_testimonial", "field_58b59bd9f69a9");
INSERT INTO `wp_postmeta` VALUES("1355", "168", "image", "144");
INSERT INTO `wp_postmeta` VALUES("1356", "168", "_image", "field_58b59be6f69aa");
INSERT INTO `wp_postmeta` VALUES("1357", "168", "name", "Lax Lama");
INSERT INTO `wp_postmeta` VALUES("1358", "168", "_name", "field_58b59bf7f69ab");
INSERT INTO `wp_postmeta` VALUES("1359", "168", "designation", "Ok thi");
INSERT INTO `wp_postmeta` VALUES("1360", "168", "_designation", "field_58b59c06f69ac");
INSERT INTO `wp_postmeta` VALUES("1361", "169", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1362", "169", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1363", "169", "_edit_lock", "1488595955:1");
INSERT INTO `wp_postmeta` VALUES("1364", "169", "_wp_trash_meta_status", "draft");
INSERT INTO `wp_postmeta` VALUES("1365", "169", "_wp_trash_meta_time", "1488599430");
INSERT INTO `wp_postmeta` VALUES("1366", "169", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("1367", "168", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1368", "168", "_wp_trash_meta_time", "1488599432");
INSERT INTO `wp_postmeta` VALUES("1369", "168", "_wp_desired_post_slug", "testi-2");
INSERT INTO `wp_postmeta` VALUES("1370", "167", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1371", "167", "_wp_trash_meta_time", "1488599434");
INSERT INTO `wp_postmeta` VALUES("1372", "167", "_wp_desired_post_slug", "testi-one");
INSERT INTO `wp_postmeta` VALUES("1373", "170", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1374", "171", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1375", "172", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1377", "27", "_wp_page_template", "page-members.php");
INSERT INTO `wp_postmeta` VALUES("1378", "177", "member_info_0_name", "Mr. Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1379", "177", "_member_info_0_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1380", "177", "member_info_0_designation", "President");
INSERT INTO `wp_postmeta` VALUES("1381", "177", "_member_info_0_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1382", "177", "member_info_0_image", "147");
INSERT INTO `wp_postmeta` VALUES("1383", "177", "_member_info_0_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1384", "177", "member_info_0_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1385", "177", "_member_info_0_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1386", "177", "member_info", "28");
INSERT INTO `wp_postmeta` VALUES("1387", "177", "_member_info", "field_58b4664885603");
INSERT INTO `wp_postmeta` VALUES("1388", "177", "member_info_1_name", "Ms. Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1389", "177", "_member_info_1_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1390", "177", "member_info_1_designation", "Vice- President");
INSERT INTO `wp_postmeta` VALUES("1391", "177", "_member_info_1_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1392", "177", "member_info_1_image", "142");
INSERT INTO `wp_postmeta` VALUES("1393", "177", "_member_info_1_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1394", "177", "member_info_1_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1395", "177", "_member_info_1_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1396", "177", "member_info_2_name", "Mr. Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1397", "177", "_member_info_2_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1398", "177", "member_info_2_designation", "General Secretary");
INSERT INTO `wp_postmeta` VALUES("1399", "177", "_member_info_2_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1400", "177", "member_info_2_image", "143");
INSERT INTO `wp_postmeta` VALUES("1401", "177", "_member_info_2_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1402", "177", "member_info_2_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1403", "177", "_member_info_2_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1404", "177", "member_info_3_name", "Mr.Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1405", "177", "_member_info_3_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1406", "177", "member_info_3_designation", "Secretary");
INSERT INTO `wp_postmeta` VALUES("1407", "177", "_member_info_3_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1408", "177", "member_info_3_image", "144");
INSERT INTO `wp_postmeta` VALUES("1409", "177", "_member_info_3_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1410", "177", "member_info_3_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1411", "177", "_member_info_3_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1412", "177", "member_info_4_name", "Mr. Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1413", "177", "_member_info_4_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1414", "177", "member_info_4_designation", "Treasurer");
INSERT INTO `wp_postmeta` VALUES("1415", "177", "_member_info_4_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1416", "177", "member_info_4_image", "145");
INSERT INTO `wp_postmeta` VALUES("1417", "177", "_member_info_4_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1418", "177", "member_info_4_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1419", "177", "_member_info_4_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1420", "177", "member_info_5_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("1421", "177", "_member_info_5_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1422", "177", "member_info_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("1423", "177", "_member_info_5_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1424", "177", "member_info_5_image", "146");
INSERT INTO `wp_postmeta` VALUES("1425", "177", "_member_info_5_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1426", "177", "member_info_5_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1427", "177", "_member_info_5_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1428", "177", "member_info_6_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("1429", "177", "_member_info_6_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1430", "177", "member_info_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("1431", "177", "_member_info_6_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1432", "177", "member_info_6_image", "");
INSERT INTO `wp_postmeta` VALUES("1433", "177", "_member_info_6_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1434", "177", "member_info_6_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1435", "177", "_member_info_6_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1436", "177", "member_info_7_name", "Ms Sita Sapkota");
INSERT INTO `wp_postmeta` VALUES("1437", "177", "_member_info_7_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1438", "177", "member_info_7_designation", "");
INSERT INTO `wp_postmeta` VALUES("1439", "177", "_member_info_7_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1440", "177", "member_info_7_image", "");
INSERT INTO `wp_postmeta` VALUES("1441", "177", "_member_info_7_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1442", "177", "member_info_7_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1443", "177", "_member_info_7_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1444", "177", "member_info_8_name", "Ms Kalpana Magar");
INSERT INTO `wp_postmeta` VALUES("1445", "177", "_member_info_8_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1446", "177", "member_info_8_designation", "");
INSERT INTO `wp_postmeta` VALUES("1447", "177", "_member_info_8_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1448", "177", "member_info_8_image", "");
INSERT INTO `wp_postmeta` VALUES("1449", "177", "_member_info_8_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1450", "177", "member_info_8_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1451", "177", "_member_info_8_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1452", "177", "member_info_9_name", "Ms Durga Bhattarai");
INSERT INTO `wp_postmeta` VALUES("1453", "177", "_member_info_9_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1454", "177", "member_info_9_designation", "");
INSERT INTO `wp_postmeta` VALUES("1455", "177", "_member_info_9_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1456", "177", "member_info_9_image", "");
INSERT INTO `wp_postmeta` VALUES("1457", "177", "_member_info_9_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1458", "177", "member_info_9_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1459", "177", "_member_info_9_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1460", "177", "member_info_10_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1461", "177", "_member_info_10_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1462", "177", "member_info_10_designation", "");
INSERT INTO `wp_postmeta` VALUES("1463", "177", "_member_info_10_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1464", "177", "member_info_10_image", "");
INSERT INTO `wp_postmeta` VALUES("1465", "177", "_member_info_10_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1466", "177", "member_info_10_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1467", "177", "_member_info_10_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1468", "177", "member_info_11_name", "Mr Bernrad Braem");
INSERT INTO `wp_postmeta` VALUES("1469", "177", "_member_info_11_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1470", "177", "member_info_11_designation", "");
INSERT INTO `wp_postmeta` VALUES("1471", "177", "_member_info_11_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1472", "177", "member_info_11_image", "");
INSERT INTO `wp_postmeta` VALUES("1473", "177", "_member_info_11_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1474", "177", "member_info_11_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1475", "177", "_member_info_11_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1476", "177", "member_info_12_name", "Mr Jogman Tamang");
INSERT INTO `wp_postmeta` VALUES("1477", "177", "_member_info_12_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1478", "177", "member_info_12_designation", "");
INSERT INTO `wp_postmeta` VALUES("1479", "177", "_member_info_12_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1480", "177", "member_info_12_image", "");
INSERT INTO `wp_postmeta` VALUES("1481", "177", "_member_info_12_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1482", "177", "member_info_12_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1483", "177", "_member_info_12_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1484", "177", "member_info_13_name", "Mr Shreeram Prasain");
INSERT INTO `wp_postmeta` VALUES("1485", "177", "_member_info_13_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1486", "177", "member_info_13_designation", "");
INSERT INTO `wp_postmeta` VALUES("1487", "177", "_member_info_13_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1488", "177", "member_info_13_image", "");
INSERT INTO `wp_postmeta` VALUES("1489", "177", "_member_info_13_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1490", "177", "member_info_13_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1491", "177", "_member_info_13_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1492", "177", "member_info_14_name", "Mr Saurab Karanjit");
INSERT INTO `wp_postmeta` VALUES("1493", "177", "_member_info_14_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1494", "177", "member_info_14_designation", "");
INSERT INTO `wp_postmeta` VALUES("1495", "177", "_member_info_14_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1496", "177", "member_info_14_image", "");
INSERT INTO `wp_postmeta` VALUES("1497", "177", "_member_info_14_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1498", "177", "member_info_14_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1499", "177", "_member_info_14_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1500", "177", "member_info_15_name", "Mr Ram Chandra Subedi");
INSERT INTO `wp_postmeta` VALUES("1501", "177", "_member_info_15_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1502", "177", "member_info_15_designation", "");
INSERT INTO `wp_postmeta` VALUES("1503", "177", "_member_info_15_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1504", "177", "member_info_15_image", "");
INSERT INTO `wp_postmeta` VALUES("1505", "177", "_member_info_15_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1506", "177", "member_info_15_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1507", "177", "_member_info_15_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1508", "177", "member_info_16_name", "Mr Pemba Dorje Sherpa");
INSERT INTO `wp_postmeta` VALUES("1509", "177", "_member_info_16_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1510", "177", "member_info_16_designation", "");
INSERT INTO `wp_postmeta` VALUES("1511", "177", "_member_info_16_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1512", "177", "member_info_16_image", "");
INSERT INTO `wp_postmeta` VALUES("1513", "177", "_member_info_16_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1514", "177", "member_info_16_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1515", "177", "_member_info_16_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1516", "177", "member_info_17_name", "Ms Janakee Gurung");
INSERT INTO `wp_postmeta` VALUES("1517", "177", "_member_info_17_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1518", "177", "member_info_17_designation", "");
INSERT INTO `wp_postmeta` VALUES("1519", "177", "_member_info_17_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1520", "177", "member_info_17_image", "");
INSERT INTO `wp_postmeta` VALUES("1521", "177", "_member_info_17_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1522", "177", "member_info_17_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1523", "177", "_member_info_17_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1524", "177", "member_info_18_name", "Mr Surenda Bhusal");
INSERT INTO `wp_postmeta` VALUES("1525", "177", "_member_info_18_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1526", "177", "member_info_18_designation", "");
INSERT INTO `wp_postmeta` VALUES("1527", "177", "_member_info_18_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1528", "177", "member_info_18_image", "");
INSERT INTO `wp_postmeta` VALUES("1529", "177", "_member_info_18_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1530", "177", "member_info_18_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1531", "177", "_member_info_18_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1532", "177", "member_info_19_name", "Mr Gangadhar Gautam");
INSERT INTO `wp_postmeta` VALUES("1533", "177", "_member_info_19_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1534", "177", "member_info_19_designation", "");
INSERT INTO `wp_postmeta` VALUES("1535", "177", "_member_info_19_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1536", "177", "member_info_19_image", "");
INSERT INTO `wp_postmeta` VALUES("1537", "177", "_member_info_19_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1538", "177", "member_info_19_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1539", "177", "_member_info_19_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1540", "177", "member_info_20_name", "Mr Baburaja Lama");
INSERT INTO `wp_postmeta` VALUES("1541", "177", "_member_info_20_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1542", "177", "member_info_20_designation", "");
INSERT INTO `wp_postmeta` VALUES("1543", "177", "_member_info_20_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1544", "177", "member_info_20_image", "");
INSERT INTO `wp_postmeta` VALUES("1545", "177", "_member_info_20_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1546", "177", "member_info_20_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1547", "177", "_member_info_20_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1548", "177", "member_info_21_name", "Mr Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1549", "177", "_member_info_21_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1550", "177", "member_info_21_designation", "");
INSERT INTO `wp_postmeta` VALUES("1551", "177", "_member_info_21_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1552", "177", "member_info_21_image", "");
INSERT INTO `wp_postmeta` VALUES("1553", "177", "_member_info_21_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1554", "177", "member_info_21_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1555", "177", "_member_info_21_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1556", "177", "member_info_22_name", "Ms Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1557", "177", "_member_info_22_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1558", "177", "member_info_22_designation", "");
INSERT INTO `wp_postmeta` VALUES("1559", "177", "_member_info_22_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1560", "177", "member_info_22_image", "");
INSERT INTO `wp_postmeta` VALUES("1561", "177", "_member_info_22_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1562", "177", "member_info_22_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1563", "177", "_member_info_22_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1564", "177", "member_info_23_name", "Mr Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1565", "177", "_member_info_23_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1566", "177", "member_info_23_designation", "");
INSERT INTO `wp_postmeta` VALUES("1567", "177", "_member_info_23_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1568", "177", "member_info_23_image", "");
INSERT INTO `wp_postmeta` VALUES("1569", "177", "_member_info_23_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1570", "177", "member_info_23_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1571", "177", "_member_info_23_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1572", "177", "member_info_24_name", "Mr Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1573", "177", "_member_info_24_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1574", "177", "member_info_24_designation", "");
INSERT INTO `wp_postmeta` VALUES("1575", "177", "_member_info_24_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1576", "177", "member_info_24_image", "");
INSERT INTO `wp_postmeta` VALUES("1577", "177", "_member_info_24_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1578", "177", "member_info_24_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1579", "177", "_member_info_24_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1580", "177", "member_info_25_name", "Mr Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1581", "177", "_member_info_25_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1582", "177", "member_info_25_designation", "");
INSERT INTO `wp_postmeta` VALUES("1583", "177", "_member_info_25_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1584", "177", "member_info_25_image", "");
INSERT INTO `wp_postmeta` VALUES("1585", "177", "_member_info_25_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1586", "177", "member_info_25_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1587", "177", "_member_info_25_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1588", "177", "member_info_26_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("1589", "177", "_member_info_26_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1590", "177", "member_info_26_designation", "");
INSERT INTO `wp_postmeta` VALUES("1591", "177", "_member_info_26_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1592", "177", "member_info_26_image", "");
INSERT INTO `wp_postmeta` VALUES("1593", "177", "_member_info_26_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1594", "177", "member_info_26_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1595", "177", "_member_info_26_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1596", "177", "member_info_27_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1597", "177", "_member_info_27_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1598", "177", "member_info_27_designation", "");
INSERT INTO `wp_postmeta` VALUES("1599", "177", "_member_info_27_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1600", "177", "member_info_27_image", "");
INSERT INTO `wp_postmeta` VALUES("1601", "177", "_member_info_27_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1602", "177", "member_info_27_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1603", "177", "_member_info_27_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1604", "178", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1605", "179", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1606", "180", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1607", "181", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1608", "182", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1609", "183", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1610", "184", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1611", "185", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1612", "186", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1613", "187", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1614", "188", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1615", "189", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1616", "190", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1617", "191", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1618", "192", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1619", "193", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("1620", "27", "executive_board_0_name", "Mr. Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1621", "27", "_executive_board_0_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1622", "27", "executive_board_0_designation", "President");
INSERT INTO `wp_postmeta` VALUES("1623", "27", "_executive_board_0_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1624", "27", "executive_board_0_image", "147");
INSERT INTO `wp_postmeta` VALUES("1625", "27", "_executive_board_0_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1626", "27", "executive_board_1_name", "Ms. Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1627", "27", "_executive_board_1_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1628", "27", "executive_board_1_designation", "Vice- President");
INSERT INTO `wp_postmeta` VALUES("1629", "27", "_executive_board_1_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1630", "27", "executive_board_1_image", "142");
INSERT INTO `wp_postmeta` VALUES("1631", "27", "_executive_board_1_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1632", "27", "executive_board_2_name", "Mr. Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1633", "27", "_executive_board_2_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1634", "27", "executive_board_2_designation", "General Secretary");
INSERT INTO `wp_postmeta` VALUES("1635", "27", "_executive_board_2_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1636", "27", "executive_board_2_image", "143");
INSERT INTO `wp_postmeta` VALUES("1637", "27", "_executive_board_2_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1638", "27", "executive_board_3_name", "Mr.Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1639", "27", "_executive_board_3_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1640", "27", "executive_board_3_designation", "Secretary");
INSERT INTO `wp_postmeta` VALUES("1641", "27", "_executive_board_3_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1642", "27", "executive_board_3_image", "144");
INSERT INTO `wp_postmeta` VALUES("1643", "27", "_executive_board_3_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1644", "27", "executive_board_4_name", "Mr. Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1645", "27", "_executive_board_4_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1646", "27", "executive_board_4_designation", "Treasurer");
INSERT INTO `wp_postmeta` VALUES("1647", "27", "_executive_board_4_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1648", "27", "executive_board_4_image", "145");
INSERT INTO `wp_postmeta` VALUES("1649", "27", "_executive_board_4_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1650", "27", "executive_board", "5");
INSERT INTO `wp_postmeta` VALUES("1651", "27", "_executive_board", "field_58b4664885603");
INSERT INTO `wp_postmeta` VALUES("1652", "27", "member_0_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("1653", "27", "_member_0_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1654", "27", "member_0_designation", "");
INSERT INTO `wp_postmeta` VALUES("1655", "27", "_member_0_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1656", "27", "member_0_image", "");
INSERT INTO `wp_postmeta` VALUES("1657", "27", "_member_0_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1658", "27", "member_1_name", "Ms Sita Sapkota");
INSERT INTO `wp_postmeta` VALUES("1659", "27", "_member_1_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1660", "27", "member_1_designation", "");
INSERT INTO `wp_postmeta` VALUES("1661", "27", "_member_1_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1662", "27", "member_1_image", "");
INSERT INTO `wp_postmeta` VALUES("1663", "27", "_member_1_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1664", "27", "member_2_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("1665", "27", "_member_2_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1666", "27", "member_2_designation", "");
INSERT INTO `wp_postmeta` VALUES("1667", "27", "_member_2_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1668", "27", "member_2_image", "");
INSERT INTO `wp_postmeta` VALUES("1669", "27", "_member_2_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1670", "27", "member_3_name", "Ms Kalpana Magar");
INSERT INTO `wp_postmeta` VALUES("1671", "27", "_member_3_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1672", "27", "member_3_designation", "");
INSERT INTO `wp_postmeta` VALUES("1673", "27", "_member_3_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1674", "27", "member_3_image", "");
INSERT INTO `wp_postmeta` VALUES("1675", "27", "_member_3_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1676", "27", "member_4_name", "Ms Durga Bhattarai");
INSERT INTO `wp_postmeta` VALUES("1677", "27", "_member_4_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1678", "27", "member_4_designation", "");
INSERT INTO `wp_postmeta` VALUES("1679", "27", "_member_4_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1680", "27", "member_4_image", "");
INSERT INTO `wp_postmeta` VALUES("1681", "27", "_member_4_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1682", "27", "member_5_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1683", "27", "_member_5_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1684", "27", "member_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("1685", "27", "_member_5_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1686", "27", "member_5_image", "");
INSERT INTO `wp_postmeta` VALUES("1687", "27", "_member_5_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1688", "27", "member_6_name", "Mr Bernrad Braem");
INSERT INTO `wp_postmeta` VALUES("1689", "27", "_member_6_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1690", "27", "member_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("1691", "27", "_member_6_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1692", "27", "member_6_image", "");
INSERT INTO `wp_postmeta` VALUES("1693", "27", "_member_6_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1694", "27", "member_7_name", "Mr Jogman Tamang");
INSERT INTO `wp_postmeta` VALUES("1695", "27", "_member_7_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1696", "27", "member_7_designation", "");
INSERT INTO `wp_postmeta` VALUES("1697", "27", "_member_7_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1698", "27", "member_7_image", "");
INSERT INTO `wp_postmeta` VALUES("1699", "27", "_member_7_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1700", "27", "member_8_name", "Mr Shreeram Prasain");
INSERT INTO `wp_postmeta` VALUES("1701", "27", "_member_8_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1702", "27", "member_8_designation", "");
INSERT INTO `wp_postmeta` VALUES("1703", "27", "_member_8_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1704", "27", "member_8_image", "");
INSERT INTO `wp_postmeta` VALUES("1705", "27", "_member_8_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1706", "27", "member_9_name", "Mr Saurab Karanjit");
INSERT INTO `wp_postmeta` VALUES("1707", "27", "_member_9_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1708", "27", "member_9_designation", "");
INSERT INTO `wp_postmeta` VALUES("1709", "27", "_member_9_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1710", "27", "member_9_image", "");
INSERT INTO `wp_postmeta` VALUES("1711", "27", "_member_9_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1712", "27", "member_10_name", "Mr Ram Chandra Subedi");
INSERT INTO `wp_postmeta` VALUES("1713", "27", "_member_10_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1714", "27", "member_10_designation", "");
INSERT INTO `wp_postmeta` VALUES("1715", "27", "_member_10_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1716", "27", "member_10_image", "");
INSERT INTO `wp_postmeta` VALUES("1717", "27", "_member_10_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1718", "27", "member_11_name", "Mr Pemba Dorje Sherpa ");
INSERT INTO `wp_postmeta` VALUES("1719", "27", "_member_11_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("1720", "27", "member_11_designation", "");
INSERT INTO `wp_postmeta` VALUES("1721", "27", "_member_11_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("1722", "27", "member_11_image", "");
INSERT INTO `wp_postmeta` VALUES("1723", "27", "_member_11_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("1724", "27", "member", "12");
INSERT INTO `wp_postmeta` VALUES("1725", "27", "_member", "field_58baacd6ddd35");
INSERT INTO `wp_postmeta` VALUES("1726", "27", "advisory_board_0_name", "Ms Janakee Gurung");
INSERT INTO `wp_postmeta` VALUES("1727", "27", "_advisory_board_0_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("1728", "27", "advisory_board_0_designation", "");
INSERT INTO `wp_postmeta` VALUES("1729", "27", "_advisory_board_0_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("1730", "27", "advisory_board_0_image", "");
INSERT INTO `wp_postmeta` VALUES("1731", "27", "_advisory_board_0_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("1732", "27", "advisory_board_1_name", "Mr Surenda Bhusal");
INSERT INTO `wp_postmeta` VALUES("1733", "27", "_advisory_board_1_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("1734", "27", "advisory_board_1_designation", "");
INSERT INTO `wp_postmeta` VALUES("1735", "27", "_advisory_board_1_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("1736", "27", "advisory_board_1_image", "");
INSERT INTO `wp_postmeta` VALUES("1737", "27", "_advisory_board_1_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("1738", "27", "advisory_board_2_name", "Mr Gangadhar Gautam");
INSERT INTO `wp_postmeta` VALUES("1739", "27", "_advisory_board_2_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("1740", "27", "advisory_board_2_designation", "");
INSERT INTO `wp_postmeta` VALUES("1741", "27", "_advisory_board_2_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("1742", "27", "advisory_board_2_image", "");
INSERT INTO `wp_postmeta` VALUES("1743", "27", "_advisory_board_2_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("1744", "27", "advisory_board_3_name", "Mr Baburaja Lama");
INSERT INTO `wp_postmeta` VALUES("1745", "27", "_advisory_board_3_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("1746", "27", "advisory_board_3_designation", "");
INSERT INTO `wp_postmeta` VALUES("1747", "27", "_advisory_board_3_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("1748", "27", "advisory_board_3_image", "");
INSERT INTO `wp_postmeta` VALUES("1749", "27", "_advisory_board_3_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("1750", "27", "advisory_board", "4");
INSERT INTO `wp_postmeta` VALUES("1751", "27", "_advisory_board", "field_58baad59ddd3b");
INSERT INTO `wp_postmeta` VALUES("1752", "27", "secretariat_0_name", "Mr Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1753", "27", "_secretariat_0_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("1754", "27", "secretariat_0_designation", "");
INSERT INTO `wp_postmeta` VALUES("1755", "27", "_secretariat_0_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("1756", "27", "secretariat_0_image", "");
INSERT INTO `wp_postmeta` VALUES("1757", "27", "_secretariat_0_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("1758", "27", "secretariat_1_name", "Ms Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1759", "27", "_secretariat_1_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("1760", "27", "secretariat_1_designation", "");
INSERT INTO `wp_postmeta` VALUES("1761", "27", "_secretariat_1_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("1762", "27", "secretariat_1_image", "");
INSERT INTO `wp_postmeta` VALUES("1763", "27", "_secretariat_1_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("1764", "27", "secretariat_2_name", "Mr Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1765", "27", "_secretariat_2_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("1766", "27", "secretariat_2_designation", "");
INSERT INTO `wp_postmeta` VALUES("1767", "27", "_secretariat_2_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("1768", "27", "secretariat_2_image", "");
INSERT INTO `wp_postmeta` VALUES("1769", "27", "_secretariat_2_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("1770", "27", "secretariat_3_name", "Mr Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1771", "27", "_secretariat_3_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("1772", "27", "secretariat_3_designation", "");
INSERT INTO `wp_postmeta` VALUES("1773", "27", "_secretariat_3_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("1774", "27", "secretariat_3_image", "");
INSERT INTO `wp_postmeta` VALUES("1775", "27", "_secretariat_3_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("1776", "27", "secretariat_4_name", "Mr Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1777", "27", "_secretariat_4_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("1778", "27", "secretariat_4_designation", "");
INSERT INTO `wp_postmeta` VALUES("1779", "27", "_secretariat_4_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("1780", "27", "secretariat_4_image", "");
INSERT INTO `wp_postmeta` VALUES("1781", "27", "_secretariat_4_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("1782", "27", "secretariat_5_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("1783", "27", "_secretariat_5_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("1784", "27", "secretariat_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("1785", "27", "_secretariat_5_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("1786", "27", "secretariat_5_image", "");
INSERT INTO `wp_postmeta` VALUES("1787", "27", "_secretariat_5_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("1788", "27", "secretariat_6_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1789", "27", "_secretariat_6_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("1790", "27", "secretariat_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("1791", "27", "_secretariat_6_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("1792", "27", "secretariat_6_image", "");
INSERT INTO `wp_postmeta` VALUES("1793", "27", "_secretariat_6_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("1794", "27", "secretariat", "7");
INSERT INTO `wp_postmeta` VALUES("1795", "27", "_secretariat", "field_58baadb0ddd40");
INSERT INTO `wp_postmeta` VALUES("1796", "194", "member_info_0_name", "Mr. Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1797", "194", "_member_info_0_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1798", "194", "member_info_0_designation", "President");
INSERT INTO `wp_postmeta` VALUES("1799", "194", "_member_info_0_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1800", "194", "member_info_0_image", "147");
INSERT INTO `wp_postmeta` VALUES("1801", "194", "_member_info_0_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1802", "194", "member_info_0_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1803", "194", "_member_info_0_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1804", "194", "member_info", "28");
INSERT INTO `wp_postmeta` VALUES("1805", "194", "_member_info", "field_58b4664885603");
INSERT INTO `wp_postmeta` VALUES("1806", "194", "member_info_1_name", "Ms. Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1807", "194", "_member_info_1_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1808", "194", "member_info_1_designation", "Vice- President");
INSERT INTO `wp_postmeta` VALUES("1809", "194", "_member_info_1_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1810", "194", "member_info_1_image", "142");
INSERT INTO `wp_postmeta` VALUES("1811", "194", "_member_info_1_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1812", "194", "member_info_1_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1813", "194", "_member_info_1_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1814", "194", "member_info_2_name", "Mr. Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1815", "194", "_member_info_2_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1816", "194", "member_info_2_designation", "General Secretary");
INSERT INTO `wp_postmeta` VALUES("1817", "194", "_member_info_2_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1818", "194", "member_info_2_image", "143");
INSERT INTO `wp_postmeta` VALUES("1819", "194", "_member_info_2_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1820", "194", "member_info_2_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1821", "194", "_member_info_2_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1822", "194", "member_info_3_name", "Mr.Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1823", "194", "_member_info_3_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1824", "194", "member_info_3_designation", "Secretary");
INSERT INTO `wp_postmeta` VALUES("1825", "194", "_member_info_3_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1826", "194", "member_info_3_image", "144");
INSERT INTO `wp_postmeta` VALUES("1827", "194", "_member_info_3_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1828", "194", "member_info_3_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1829", "194", "_member_info_3_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1830", "194", "member_info_4_name", "Mr. Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1831", "194", "_member_info_4_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1832", "194", "member_info_4_designation", "Treasurer");
INSERT INTO `wp_postmeta` VALUES("1833", "194", "_member_info_4_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1834", "194", "member_info_4_image", "145");
INSERT INTO `wp_postmeta` VALUES("1835", "194", "_member_info_4_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1836", "194", "member_info_4_member_type", "Executive Board");
INSERT INTO `wp_postmeta` VALUES("1837", "194", "_member_info_4_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1838", "194", "member_info_5_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("1839", "194", "_member_info_5_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1840", "194", "member_info_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("1841", "194", "_member_info_5_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1842", "194", "member_info_5_image", "146");
INSERT INTO `wp_postmeta` VALUES("1843", "194", "_member_info_5_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1844", "194", "member_info_5_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1845", "194", "_member_info_5_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1846", "194", "member_info_6_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("1847", "194", "_member_info_6_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1848", "194", "member_info_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("1849", "194", "_member_info_6_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1850", "194", "member_info_6_image", "");
INSERT INTO `wp_postmeta` VALUES("1851", "194", "_member_info_6_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1852", "194", "member_info_6_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1853", "194", "_member_info_6_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1854", "194", "member_info_7_name", "Ms Sita Sapkota");
INSERT INTO `wp_postmeta` VALUES("1855", "194", "_member_info_7_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1856", "194", "member_info_7_designation", "");
INSERT INTO `wp_postmeta` VALUES("1857", "194", "_member_info_7_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1858", "194", "member_info_7_image", "");
INSERT INTO `wp_postmeta` VALUES("1859", "194", "_member_info_7_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1860", "194", "member_info_7_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1861", "194", "_member_info_7_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1862", "194", "member_info_8_name", "Ms Kalpana Magar");
INSERT INTO `wp_postmeta` VALUES("1863", "194", "_member_info_8_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1864", "194", "member_info_8_designation", "");
INSERT INTO `wp_postmeta` VALUES("1865", "194", "_member_info_8_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1866", "194", "member_info_8_image", "");
INSERT INTO `wp_postmeta` VALUES("1867", "194", "_member_info_8_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1868", "194", "member_info_8_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1869", "194", "_member_info_8_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1870", "194", "member_info_9_name", "Ms Durga Bhattarai");
INSERT INTO `wp_postmeta` VALUES("1871", "194", "_member_info_9_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1872", "194", "member_info_9_designation", "");
INSERT INTO `wp_postmeta` VALUES("1873", "194", "_member_info_9_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1874", "194", "member_info_9_image", "");
INSERT INTO `wp_postmeta` VALUES("1875", "194", "_member_info_9_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1876", "194", "member_info_9_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1877", "194", "_member_info_9_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1878", "194", "member_info_10_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("1879", "194", "_member_info_10_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1880", "194", "member_info_10_designation", "");
INSERT INTO `wp_postmeta` VALUES("1881", "194", "_member_info_10_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1882", "194", "member_info_10_image", "");
INSERT INTO `wp_postmeta` VALUES("1883", "194", "_member_info_10_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1884", "194", "member_info_10_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1885", "194", "_member_info_10_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1886", "194", "member_info_11_name", "Mr Bernrad Braem");
INSERT INTO `wp_postmeta` VALUES("1887", "194", "_member_info_11_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1888", "194", "member_info_11_designation", "");
INSERT INTO `wp_postmeta` VALUES("1889", "194", "_member_info_11_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1890", "194", "member_info_11_image", "");
INSERT INTO `wp_postmeta` VALUES("1891", "194", "_member_info_11_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1892", "194", "member_info_11_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1893", "194", "_member_info_11_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1894", "194", "member_info_12_name", "Mr Jogman Tamang");
INSERT INTO `wp_postmeta` VALUES("1895", "194", "_member_info_12_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1896", "194", "member_info_12_designation", "");
INSERT INTO `wp_postmeta` VALUES("1897", "194", "_member_info_12_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1898", "194", "member_info_12_image", "");
INSERT INTO `wp_postmeta` VALUES("1899", "194", "_member_info_12_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1900", "194", "member_info_12_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1901", "194", "_member_info_12_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1902", "194", "member_info_13_name", "Mr Shreeram Prasain");
INSERT INTO `wp_postmeta` VALUES("1903", "194", "_member_info_13_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1904", "194", "member_info_13_designation", "");
INSERT INTO `wp_postmeta` VALUES("1905", "194", "_member_info_13_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1906", "194", "member_info_13_image", "");
INSERT INTO `wp_postmeta` VALUES("1907", "194", "_member_info_13_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1908", "194", "member_info_13_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1909", "194", "_member_info_13_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1910", "194", "member_info_14_name", "Mr Saurab Karanjit");
INSERT INTO `wp_postmeta` VALUES("1911", "194", "_member_info_14_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1912", "194", "member_info_14_designation", "");
INSERT INTO `wp_postmeta` VALUES("1913", "194", "_member_info_14_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1914", "194", "member_info_14_image", "");
INSERT INTO `wp_postmeta` VALUES("1915", "194", "_member_info_14_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1916", "194", "member_info_14_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1917", "194", "_member_info_14_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1918", "194", "member_info_15_name", "Mr Ram Chandra Subedi");
INSERT INTO `wp_postmeta` VALUES("1919", "194", "_member_info_15_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1920", "194", "member_info_15_designation", "");
INSERT INTO `wp_postmeta` VALUES("1921", "194", "_member_info_15_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1922", "194", "member_info_15_image", "");
INSERT INTO `wp_postmeta` VALUES("1923", "194", "_member_info_15_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1924", "194", "member_info_15_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1925", "194", "_member_info_15_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1926", "194", "member_info_16_name", "Mr Pemba Dorje Sherpa");
INSERT INTO `wp_postmeta` VALUES("1927", "194", "_member_info_16_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1928", "194", "member_info_16_designation", "");
INSERT INTO `wp_postmeta` VALUES("1929", "194", "_member_info_16_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1930", "194", "member_info_16_image", "");
INSERT INTO `wp_postmeta` VALUES("1931", "194", "_member_info_16_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1932", "194", "member_info_16_member_type", "Members");
INSERT INTO `wp_postmeta` VALUES("1933", "194", "_member_info_16_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1934", "194", "member_info_17_name", "Ms Janakee Gurung");
INSERT INTO `wp_postmeta` VALUES("1935", "194", "_member_info_17_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1936", "194", "member_info_17_designation", "");
INSERT INTO `wp_postmeta` VALUES("1937", "194", "_member_info_17_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1938", "194", "member_info_17_image", "");
INSERT INTO `wp_postmeta` VALUES("1939", "194", "_member_info_17_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1940", "194", "member_info_17_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1941", "194", "_member_info_17_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1942", "194", "member_info_18_name", "Mr Surenda Bhusal");
INSERT INTO `wp_postmeta` VALUES("1943", "194", "_member_info_18_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1944", "194", "member_info_18_designation", "");
INSERT INTO `wp_postmeta` VALUES("1945", "194", "_member_info_18_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1946", "194", "member_info_18_image", "");
INSERT INTO `wp_postmeta` VALUES("1947", "194", "_member_info_18_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1948", "194", "member_info_18_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1949", "194", "_member_info_18_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1950", "194", "member_info_19_name", "Mr Gangadhar Gautam");
INSERT INTO `wp_postmeta` VALUES("1951", "194", "_member_info_19_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1952", "194", "member_info_19_designation", "");
INSERT INTO `wp_postmeta` VALUES("1953", "194", "_member_info_19_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1954", "194", "member_info_19_image", "");
INSERT INTO `wp_postmeta` VALUES("1955", "194", "_member_info_19_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1956", "194", "member_info_19_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1957", "194", "_member_info_19_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1958", "194", "member_info_20_name", "Mr Baburaja Lama");
INSERT INTO `wp_postmeta` VALUES("1959", "194", "_member_info_20_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1960", "194", "member_info_20_designation", "");
INSERT INTO `wp_postmeta` VALUES("1961", "194", "_member_info_20_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1962", "194", "member_info_20_image", "");
INSERT INTO `wp_postmeta` VALUES("1963", "194", "_member_info_20_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1964", "194", "member_info_20_member_type", "Advisory Board");
INSERT INTO `wp_postmeta` VALUES("1965", "194", "_member_info_20_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1966", "194", "member_info_21_name", "Mr Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("1967", "194", "_member_info_21_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1968", "194", "member_info_21_designation", "");
INSERT INTO `wp_postmeta` VALUES("1969", "194", "_member_info_21_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1970", "194", "member_info_21_image", "");
INSERT INTO `wp_postmeta` VALUES("1971", "194", "_member_info_21_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1972", "194", "member_info_21_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1973", "194", "_member_info_21_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1974", "194", "member_info_22_name", "Ms Anita Lama");
INSERT INTO `wp_postmeta` VALUES("1975", "194", "_member_info_22_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1976", "194", "member_info_22_designation", "");
INSERT INTO `wp_postmeta` VALUES("1977", "194", "_member_info_22_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1978", "194", "member_info_22_image", "");
INSERT INTO `wp_postmeta` VALUES("1979", "194", "_member_info_22_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1980", "194", "member_info_22_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1981", "194", "_member_info_22_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1982", "194", "member_info_23_name", "Mr Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("1983", "194", "_member_info_23_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1984", "194", "member_info_23_designation", "");
INSERT INTO `wp_postmeta` VALUES("1985", "194", "_member_info_23_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1986", "194", "member_info_23_image", "");
INSERT INTO `wp_postmeta` VALUES("1987", "194", "_member_info_23_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1988", "194", "member_info_23_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1989", "194", "_member_info_23_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1990", "194", "member_info_24_name", "Mr Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("1991", "194", "_member_info_24_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("1992", "194", "member_info_24_designation", "");
INSERT INTO `wp_postmeta` VALUES("1993", "194", "_member_info_24_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("1994", "194", "member_info_24_image", "");
INSERT INTO `wp_postmeta` VALUES("1995", "194", "_member_info_24_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("1996", "194", "member_info_24_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("1997", "194", "_member_info_24_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("1998", "194", "member_info_25_name", "Mr Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("1999", "194", "_member_info_25_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2000", "194", "member_info_25_designation", "");
INSERT INTO `wp_postmeta` VALUES("2001", "194", "_member_info_25_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2002", "194", "member_info_25_image", "");
INSERT INTO `wp_postmeta` VALUES("2003", "194", "_member_info_25_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2004", "194", "member_info_25_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("2005", "194", "_member_info_25_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("2006", "194", "member_info_26_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("2007", "194", "_member_info_26_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2008", "194", "member_info_26_designation", "");
INSERT INTO `wp_postmeta` VALUES("2009", "194", "_member_info_26_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2010", "194", "member_info_26_image", "");
INSERT INTO `wp_postmeta` VALUES("2011", "194", "_member_info_26_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2012", "194", "member_info_26_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("2013", "194", "_member_info_26_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("2014", "194", "member_info_27_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("2015", "194", "_member_info_27_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2016", "194", "member_info_27_designation", "");
INSERT INTO `wp_postmeta` VALUES("2017", "194", "_member_info_27_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2018", "194", "member_info_27_image", "");
INSERT INTO `wp_postmeta` VALUES("2019", "194", "_member_info_27_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2020", "194", "member_info_27_member_type", "Secretariat");
INSERT INTO `wp_postmeta` VALUES("2021", "194", "_member_info_27_member_type", "field_58b4672f8560f");
INSERT INTO `wp_postmeta` VALUES("2022", "194", "executive_board_0_name", "Mr. Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("2023", "194", "_executive_board_0_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2024", "194", "executive_board_0_designation", "President");
INSERT INTO `wp_postmeta` VALUES("2025", "194", "_executive_board_0_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2026", "194", "executive_board_0_image", "147");
INSERT INTO `wp_postmeta` VALUES("2027", "194", "_executive_board_0_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2028", "194", "executive_board_1_name", "Ms. Anita Lama");
INSERT INTO `wp_postmeta` VALUES("2029", "194", "_executive_board_1_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2030", "194", "executive_board_1_designation", "Vice- President");
INSERT INTO `wp_postmeta` VALUES("2031", "194", "_executive_board_1_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2032", "194", "executive_board_1_image", "142");
INSERT INTO `wp_postmeta` VALUES("2033", "194", "_executive_board_1_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2034", "194", "executive_board_2_name", "Mr. Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("2035", "194", "_executive_board_2_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2036", "194", "executive_board_2_designation", "General Secretary");
INSERT INTO `wp_postmeta` VALUES("2037", "194", "_executive_board_2_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2038", "194", "executive_board_2_image", "143");
INSERT INTO `wp_postmeta` VALUES("2039", "194", "_executive_board_2_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2040", "194", "executive_board_3_name", "Mr.Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("2041", "194", "_executive_board_3_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2042", "194", "executive_board_3_designation", "Secretary");
INSERT INTO `wp_postmeta` VALUES("2043", "194", "_executive_board_3_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2044", "194", "executive_board_3_image", "144");
INSERT INTO `wp_postmeta` VALUES("2045", "194", "_executive_board_3_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2046", "194", "executive_board_4_name", "Mr. Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("2047", "194", "_executive_board_4_name", "field_58b466ad85607");
INSERT INTO `wp_postmeta` VALUES("2048", "194", "executive_board_4_designation", "Treasurer");
INSERT INTO `wp_postmeta` VALUES("2049", "194", "_executive_board_4_designation", "field_58b466b285608");
INSERT INTO `wp_postmeta` VALUES("2050", "194", "executive_board_4_image", "145");
INSERT INTO `wp_postmeta` VALUES("2051", "194", "_executive_board_4_image", "field_58b466b985609");
INSERT INTO `wp_postmeta` VALUES("2052", "194", "executive_board", "5");
INSERT INTO `wp_postmeta` VALUES("2053", "194", "_executive_board", "field_58b4664885603");
INSERT INTO `wp_postmeta` VALUES("2054", "194", "member_0_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("2055", "194", "_member_0_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2056", "194", "member_0_designation", "");
INSERT INTO `wp_postmeta` VALUES("2057", "194", "_member_0_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2058", "194", "member_0_image", "");
INSERT INTO `wp_postmeta` VALUES("2059", "194", "_member_0_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2060", "194", "member_1_name", "Ms Sita Sapkota");
INSERT INTO `wp_postmeta` VALUES("2061", "194", "_member_1_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2062", "194", "member_1_designation", "");
INSERT INTO `wp_postmeta` VALUES("2063", "194", "_member_1_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2064", "194", "member_1_image", "");
INSERT INTO `wp_postmeta` VALUES("2065", "194", "_member_1_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2066", "194", "member_2_name", "Ms Seema Subedi");
INSERT INTO `wp_postmeta` VALUES("2067", "194", "_member_2_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2068", "194", "member_2_designation", "");
INSERT INTO `wp_postmeta` VALUES("2069", "194", "_member_2_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2070", "194", "member_2_image", "");
INSERT INTO `wp_postmeta` VALUES("2071", "194", "_member_2_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2072", "194", "member_3_name", "Ms Kalpana Magar");
INSERT INTO `wp_postmeta` VALUES("2073", "194", "_member_3_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2074", "194", "member_3_designation", "");
INSERT INTO `wp_postmeta` VALUES("2075", "194", "_member_3_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2076", "194", "member_3_image", "");
INSERT INTO `wp_postmeta` VALUES("2077", "194", "_member_3_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2078", "194", "member_4_name", "Ms Durga Bhattarai");
INSERT INTO `wp_postmeta` VALUES("2079", "194", "_member_4_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2080", "194", "member_4_designation", "");
INSERT INTO `wp_postmeta` VALUES("2081", "194", "_member_4_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2082", "194", "member_4_image", "");
INSERT INTO `wp_postmeta` VALUES("2083", "194", "_member_4_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2084", "194", "member_5_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("2085", "194", "_member_5_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2086", "194", "member_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("2087", "194", "_member_5_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2088", "194", "member_5_image", "");
INSERT INTO `wp_postmeta` VALUES("2089", "194", "_member_5_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2090", "194", "member_6_name", "Mr Bernrad Braem");
INSERT INTO `wp_postmeta` VALUES("2091", "194", "_member_6_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2092", "194", "member_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("2093", "194", "_member_6_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2094", "194", "member_6_image", "");
INSERT INTO `wp_postmeta` VALUES("2095", "194", "_member_6_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2096", "194", "member_7_name", "Mr Jogman Tamang");
INSERT INTO `wp_postmeta` VALUES("2097", "194", "_member_7_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2098", "194", "member_7_designation", "");
INSERT INTO `wp_postmeta` VALUES("2099", "194", "_member_7_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2100", "194", "member_7_image", "");
INSERT INTO `wp_postmeta` VALUES("2101", "194", "_member_7_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2102", "194", "member_8_name", "Mr Shreeram Prasain");
INSERT INTO `wp_postmeta` VALUES("2103", "194", "_member_8_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2104", "194", "member_8_designation", "");
INSERT INTO `wp_postmeta` VALUES("2105", "194", "_member_8_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2106", "194", "member_8_image", "");
INSERT INTO `wp_postmeta` VALUES("2107", "194", "_member_8_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2108", "194", "member_9_name", "Mr Saurab Karanjit");
INSERT INTO `wp_postmeta` VALUES("2109", "194", "_member_9_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2110", "194", "member_9_designation", "");
INSERT INTO `wp_postmeta` VALUES("2111", "194", "_member_9_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2112", "194", "member_9_image", "");
INSERT INTO `wp_postmeta` VALUES("2113", "194", "_member_9_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2114", "194", "member_10_name", "Mr Ram Chandra Subedi");
INSERT INTO `wp_postmeta` VALUES("2115", "194", "_member_10_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2116", "194", "member_10_designation", "");
INSERT INTO `wp_postmeta` VALUES("2117", "194", "_member_10_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2118", "194", "member_10_image", "");
INSERT INTO `wp_postmeta` VALUES("2119", "194", "_member_10_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2120", "194", "member_11_name", "Mr Pemba Dorje Sherpa ");
INSERT INTO `wp_postmeta` VALUES("2121", "194", "_member_11_name", "field_58baacd6ddd36");
INSERT INTO `wp_postmeta` VALUES("2122", "194", "member_11_designation", "");
INSERT INTO `wp_postmeta` VALUES("2123", "194", "_member_11_designation", "field_58baacd6ddd37");
INSERT INTO `wp_postmeta` VALUES("2124", "194", "member_11_image", "");
INSERT INTO `wp_postmeta` VALUES("2125", "194", "_member_11_image", "field_58baacd6ddd38");
INSERT INTO `wp_postmeta` VALUES("2126", "194", "member", "12");
INSERT INTO `wp_postmeta` VALUES("2127", "194", "_member", "field_58baacd6ddd35");
INSERT INTO `wp_postmeta` VALUES("2128", "194", "advisory_board_0_name", "Ms Janakee Gurung");
INSERT INTO `wp_postmeta` VALUES("2129", "194", "_advisory_board_0_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("2130", "194", "advisory_board_0_designation", "");
INSERT INTO `wp_postmeta` VALUES("2131", "194", "_advisory_board_0_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("2132", "194", "advisory_board_0_image", "");
INSERT INTO `wp_postmeta` VALUES("2133", "194", "_advisory_board_0_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("2134", "194", "advisory_board_1_name", "Mr Surenda Bhusal");
INSERT INTO `wp_postmeta` VALUES("2135", "194", "_advisory_board_1_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("2136", "194", "advisory_board_1_designation", "");
INSERT INTO `wp_postmeta` VALUES("2137", "194", "_advisory_board_1_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("2138", "194", "advisory_board_1_image", "");
INSERT INTO `wp_postmeta` VALUES("2139", "194", "_advisory_board_1_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("2140", "194", "advisory_board_2_name", "Mr Gangadhar Gautam");
INSERT INTO `wp_postmeta` VALUES("2141", "194", "_advisory_board_2_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("2142", "194", "advisory_board_2_designation", "");
INSERT INTO `wp_postmeta` VALUES("2143", "194", "_advisory_board_2_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("2144", "194", "advisory_board_2_image", "");
INSERT INTO `wp_postmeta` VALUES("2145", "194", "_advisory_board_2_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("2146", "194", "advisory_board_3_name", "Mr Baburaja Lama");
INSERT INTO `wp_postmeta` VALUES("2147", "194", "_advisory_board_3_name", "field_58baad59ddd3c");
INSERT INTO `wp_postmeta` VALUES("2148", "194", "advisory_board_3_designation", "");
INSERT INTO `wp_postmeta` VALUES("2149", "194", "_advisory_board_3_designation", "field_58baad59ddd3d");
INSERT INTO `wp_postmeta` VALUES("2150", "194", "advisory_board_3_image", "");
INSERT INTO `wp_postmeta` VALUES("2151", "194", "_advisory_board_3_image", "field_58baad59ddd3e");
INSERT INTO `wp_postmeta` VALUES("2152", "194", "advisory_board", "4");
INSERT INTO `wp_postmeta` VALUES("2153", "194", "_advisory_board", "field_58baad59ddd3b");
INSERT INTO `wp_postmeta` VALUES("2154", "194", "secretariat_0_name", "Mr Damodar Prasad Acharya");
INSERT INTO `wp_postmeta` VALUES("2155", "194", "_secretariat_0_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("2156", "194", "secretariat_0_designation", "");
INSERT INTO `wp_postmeta` VALUES("2157", "194", "_secretariat_0_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("2158", "194", "secretariat_0_image", "");
INSERT INTO `wp_postmeta` VALUES("2159", "194", "_secretariat_0_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("2160", "194", "secretariat_1_name", "Ms Anita Lama");
INSERT INTO `wp_postmeta` VALUES("2161", "194", "_secretariat_1_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("2162", "194", "secretariat_1_designation", "");
INSERT INTO `wp_postmeta` VALUES("2163", "194", "_secretariat_1_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("2164", "194", "secretariat_1_image", "");
INSERT INTO `wp_postmeta` VALUES("2165", "194", "_secretariat_1_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("2166", "194", "secretariat_2_name", "Mr Nanda Raj Ghale");
INSERT INTO `wp_postmeta` VALUES("2167", "194", "_secretariat_2_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("2168", "194", "secretariat_2_designation", "");
INSERT INTO `wp_postmeta` VALUES("2169", "194", "_secretariat_2_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("2170", "194", "secretariat_2_image", "");
INSERT INTO `wp_postmeta` VALUES("2171", "194", "_secretariat_2_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("2172", "194", "secretariat_3_name", "Mr Geert Catrysse");
INSERT INTO `wp_postmeta` VALUES("2173", "194", "_secretariat_3_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("2174", "194", "secretariat_3_designation", "");
INSERT INTO `wp_postmeta` VALUES("2175", "194", "_secretariat_3_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("2176", "194", "secretariat_3_image", "");
INSERT INTO `wp_postmeta` VALUES("2177", "194", "_secretariat_3_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("2178", "194", "secretariat_4_name", "Mr Baburam Sharma");
INSERT INTO `wp_postmeta` VALUES("2179", "194", "_secretariat_4_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("2180", "194", "secretariat_4_designation", "");
INSERT INTO `wp_postmeta` VALUES("2181", "194", "_secretariat_4_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("2182", "194", "secretariat_4_image", "");
INSERT INTO `wp_postmeta` VALUES("2183", "194", "_secretariat_4_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("2184", "194", "secretariat_5_name", "Ms Rajani Pradhan");
INSERT INTO `wp_postmeta` VALUES("2185", "194", "_secretariat_5_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("2186", "194", "secretariat_5_designation", "");
INSERT INTO `wp_postmeta` VALUES("2187", "194", "_secretariat_5_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("2188", "194", "secretariat_5_image", "");
INSERT INTO `wp_postmeta` VALUES("2189", "194", "_secretariat_5_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("2190", "194", "secretariat_6_name", "Mr Yubaraj Gurung");
INSERT INTO `wp_postmeta` VALUES("2191", "194", "_secretariat_6_name", "field_58baadb0ddd41");
INSERT INTO `wp_postmeta` VALUES("2192", "194", "secretariat_6_designation", "");
INSERT INTO `wp_postmeta` VALUES("2193", "194", "_secretariat_6_designation", "field_58baadb0ddd42");
INSERT INTO `wp_postmeta` VALUES("2194", "194", "secretariat_6_image", "");
INSERT INTO `wp_postmeta` VALUES("2195", "194", "_secretariat_6_image", "field_58baadb0ddd43");
INSERT INTO `wp_postmeta` VALUES("2196", "194", "secretariat", "7");
INSERT INTO `wp_postmeta` VALUES("2197", "194", "_secretariat", "field_58baadb0ddd40");
INSERT INTO `wp_postmeta` VALUES("2198", "12", "_edit_lock", "1488649601:1");
INSERT INTO `wp_postmeta` VALUES("2199", "12", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2200", "12", "_wp_page_template", "page-events.php");
INSERT INTO `wp_postmeta` VALUES("2201", "197", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2202", "197", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2203", "197", "_edit_lock", "1488696935:1");
INSERT INTO `wp_postmeta` VALUES("2204", "197", "_thumbnail_id", "129");
INSERT INTO `wp_postmeta` VALUES("2206", "197", "source", "");
INSERT INTO `wp_postmeta` VALUES("2207", "197", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("2208", "197", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("2209", "197", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("2210", "197", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("2211", "197", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("2212", "198", "source", "");
INSERT INTO `wp_postmeta` VALUES("2213", "198", "_source", "field_58b45fd3f9d6b");
INSERT INTO `wp_postmeta` VALUES("2214", "198", "source_url", "");
INSERT INTO `wp_postmeta` VALUES("2215", "198", "_source_url", "field_58b45fdff9d6c");
INSERT INTO `wp_postmeta` VALUES("2216", "198", "source_logo", "");
INSERT INTO `wp_postmeta` VALUES("2217", "198", "_source_logo", "field_58b46005f9d6d");
INSERT INTO `wp_postmeta` VALUES("2219", "199", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2220", "199", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2221", "199", "_edit_lock", "1488698485:1");
INSERT INTO `wp_postmeta` VALUES("2222", "199", "_thumbnail_id", "130");
INSERT INTO `wp_postmeta` VALUES("2223", "199", "start_date", "2017-03-02 00:00:00");
INSERT INTO `wp_postmeta` VALUES("2224", "199", "_start_date", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("2225", "199", "location", "");
INSERT INTO `wp_postmeta` VALUES("2226", "199", "_location", "field_58b1c03541d5f");
INSERT INTO `wp_postmeta` VALUES("2227", "199", "end_date", "");
INSERT INTO `wp_postmeta` VALUES("2228", "199", "_end_date", "field_58b24b5dd44ca");
INSERT INTO `wp_postmeta` VALUES("2229", "200", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2230", "200", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2231", "200", "_edit_lock", "1488698565:1");
INSERT INTO `wp_postmeta` VALUES("2232", "200", "_thumbnail_id", "109");
INSERT INTO `wp_postmeta` VALUES("2233", "200", "start_date", "2017-03-01 00:00:00");
INSERT INTO `wp_postmeta` VALUES("2234", "200", "_start_date", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("2235", "200", "location", "");
INSERT INTO `wp_postmeta` VALUES("2236", "200", "_location", "field_58b1c03541d5f");
INSERT INTO `wp_postmeta` VALUES("2237", "200", "end_date", "");
INSERT INTO `wp_postmeta` VALUES("2238", "200", "_end_date", "field_58b24b5dd44ca");
INSERT INTO `wp_postmeta` VALUES("2239", "201", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2240", "201", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2241", "201", "_edit_lock", "1488699102:1");
INSERT INTO `wp_postmeta` VALUES("2242", "201", "start_date", "2017-03-01 00:00:00");
INSERT INTO `wp_postmeta` VALUES("2243", "201", "_start_date", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("2244", "201", "location", "");
INSERT INTO `wp_postmeta` VALUES("2245", "201", "_location", "field_58b1c03541d5f");
INSERT INTO `wp_postmeta` VALUES("2246", "201", "end_date", "");
INSERT INTO `wp_postmeta` VALUES("2247", "201", "_end_date", "field_58b24b5dd44ca");
INSERT INTO `wp_postmeta` VALUES("2248", "202", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2249", "202", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2250", "202", "start_date", "2017-03-01 00:00:00");
INSERT INTO `wp_postmeta` VALUES("2251", "202", "_start_date", "field_58b1bf9f41d5d");
INSERT INTO `wp_postmeta` VALUES("2252", "202", "location", "");
INSERT INTO `wp_postmeta` VALUES("2253", "202", "_location", "field_58b1c03541d5f");
INSERT INTO `wp_postmeta` VALUES("2254", "202", "end_date", "");
INSERT INTO `wp_postmeta` VALUES("2255", "202", "_end_date", "field_58b24b5dd44ca");
INSERT INTO `wp_postmeta` VALUES("2256", "202", "_edit_lock", "1488699732:1");
INSERT INTO `wp_postmeta` VALUES("2257", "203", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2258", "86", "end_date", "");
INSERT INTO `wp_postmeta` VALUES("2259", "86", "_end_date", "field_58b24b5dd44ca");
INSERT INTO `wp_postmeta` VALUES("2260", "202", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("2261", "202", "_wp_trash_meta_time", "1488704213");
INSERT INTO `wp_postmeta` VALUES("2262", "202", "_wp_desired_post_slug", "hflkashd");
INSERT INTO `wp_postmeta` VALUES("2263", "201", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("2264", "201", "_wp_trash_meta_time", "1488704213");
INSERT INTO `wp_postmeta` VALUES("2265", "201", "_wp_desired_post_slug", "new-event-add");
INSERT INTO `wp_postmeta` VALUES("2266", "200", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("2267", "200", "_wp_trash_meta_time", "1488704213");
INSERT INTO `wp_postmeta` VALUES("2268", "200", "_wp_desired_post_slug", "new-event-3");
INSERT INTO `wp_postmeta` VALUES("2269", "199", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("2270", "199", "_wp_trash_meta_time", "1488704213");
INSERT INTO `wp_postmeta` VALUES("2271", "199", "_wp_desired_post_slug", "new-event");
INSERT INTO `wp_postmeta` VALUES("2272", "204", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2273", "204", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("2274", "204", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2275", "204", "_edit_lock", "1488764451:1");
INSERT INTO `wp_postmeta` VALUES("2278", "207", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2279", "208", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2280", "209", "_is_video", "");
INSERT INTO `wp_postmeta` VALUES("2281", "210", "_wp_attached_file", "2017/03/0-02-05-2139d67f952b0f556638344dd428c8649a8ace708c68ddfc142639853a2a7af8_full.jpg");
INSERT INTO `wp_postmeta` VALUES("2282", "210", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:245;s:6:\"height\";i:187;s:4:\"file\";s:89:\"2017/03/0-02-05-2139d67f952b0f556638344dd428c8649a8ace708c68ddfc142639853a2a7af8_full.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:89:\"0-02-05-2139d67f952b0f556638344dd428c8649a8ace708c68ddfc142639853a2a7af8_full-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("2283", "211", "_wp_attached_file", "2017/03/0-02-05-b85e357dc1007d024997ee89c1c1ccdd0c0fc3fed5d3150aaec4fc3fcb57d4ad_full.jpg");
INSERT INTO `wp_postmeta` VALUES("2284", "211", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:279;s:6:\"height\";i:211;s:4:\"file\";s:89:\"2017/03/0-02-05-b85e357dc1007d024997ee89c1c1ccdd0c0fc3fed5d3150aaec4fc3fcb57d4ad_full.jpg\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:89:\"0-02-05-b85e357dc1007d024997ee89c1c1ccdd0c0fc3fed5d3150aaec4fc3fcb57d4ad_full-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2017-02-25 14:43:35", "2017-02-25 14:43:35", "Welcome to WordPress. This is your first post. Edit or delete it, then start writing!", "Hello world!", "", "trash", "open", "open", "", "hello-world__trashed", "", "", "2017-02-27 17:28:09", "2017-02-27 17:28:09", "", "0", "http://localhost/lumbini/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("2", "1", "2017-02-25 14:43:35", "2017-02-25 14:43:35", "This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://localhost/lumbini/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!", "Sample Page", "", "publish", "closed", "open", "", "sample-page", "", "", "2017-02-25 14:43:35", "2017-02-25 14:43:35", "", "0", "http://localhost/lumbini/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("4", "1", "2017-02-25 14:44:53", "2017-02-25 14:44:53", "", "site-logo", "", "inherit", "open", "closed", "", "site-logo", "", "", "2017-02-25 14:44:53", "2017-02-25 14:44:53", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/site-logo-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("5", "1", "2017-02-25 14:44:56", "2017-02-25 14:44:56", "http://localhost/lumbini/wp-content/uploads/2017/02/cropped-site-logo-1-1.png", "cropped-site-logo-1-1.png", "", "inherit", "open", "closed", "", "cropped-site-logo-1-1-png", "", "", "2017-02-25 14:44:56", "2017-02-25 14:44:56", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/cropped-site-logo-1-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2017-02-25 14:46:31", "2017-02-25 14:46:31", "{\n    \"lumbini-theme::custom_logo\": {\n        \"value\": 5,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"blogdescription\": {\n        \"value\": \"Global Campaign, Belgium  v.w.z\",\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"lumbini-theme::bolgsubtitle\": {\n        \"value\": \"World Peace through love, passion and reinforced approach\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "a6b6038c-7f56-4c35-9f43-6fe828541667", "", "", "2017-02-25 14:46:31", "2017-02-25 14:46:31", "", "0", "http://localhost/lumbini/?p=6", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2017-02-25 14:47:14", "2017-02-25 14:47:14", "", "lumbini1", "", "inherit", "open", "closed", "", "lumbini1", "", "", "2017-02-25 14:47:14", "2017-02-25 14:47:14", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2017-02-25 14:47:21", "2017-02-25 14:47:21", "{\n    \"lumbini-theme::header_image\": {\n        \"value\": \"http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1.jpg\",\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    },\n    \"lumbini-theme::header_image_data\": {\n        \"value\": {\n            \"url\": \"http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1.jpg\",\n            \"thumbnail_url\": \"http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1.jpg\",\n            \"timestamp\": 1488034037198,\n            \"attachment_id\": 7,\n            \"width\": 1720,\n            \"height\": 300\n        },\n        \"type\": \"theme_mod\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "9d723e55-4537-4d8a-afe3-2b8033fb6203", "", "", "2017-02-25 14:47:21", "2017-02-25 14:47:21", "", "0", "http://localhost/lumbini/?p=8", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2017-02-25 14:47:40", "2017-02-25 14:47:40", "{\n    \"show_on_front\": {\n        \"value\": \"page\",\n        \"type\": \"option\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "3d3d1c95-e8c1-42a8-b109-d93835f20c52", "", "", "2017-02-25 14:47:40", "2017-02-25 14:47:40", "", "0", "http://localhost/lumbini/?p=9", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2017-02-25 14:47:55", "2017-02-25 14:47:55", "", "Front Page", "", "publish", "closed", "closed", "", "front-page", "", "", "2017-02-25 14:47:55", "2017-02-25 14:47:55", "", "0", "http://localhost/lumbini/?page_id=10", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2017-02-25 14:47:55", "2017-02-25 14:47:55", "", "Front Page", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2017-02-25 14:47:55", "2017-02-25 14:47:55", "", "10", "http://localhost/lumbini/?p=11", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2017-02-25 14:49:05", "2017-02-25 14:49:05", "", "Events", "CONTENTS", "publish", "closed", "open", "", "events", "", "", "2017-03-04 16:52:31", "2017-03-04 16:52:31", "", "0", "http://localhost/lumbini/events/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2017-02-25 14:49:05", "2017-02-25 14:49:05", "CONTENTS", "Locations", "", "trash", "closed", "open", "", "locations__trashed", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "12", "http://localhost/lumbini/events/locations/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2017-02-25 14:49:05", "2017-02-25 14:49:05", "CONTENTS", "Categories", "", "trash", "closed", "open", "", "categories__trashed", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "12", "http://localhost/lumbini/events/categories/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2017-02-25 14:49:05", "2017-02-25 14:49:05", "CONTENTS", "Tags", "", "trash", "closed", "open", "", "tags__trashed", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "12", "http://localhost/lumbini/events/tags/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2017-02-25 14:49:05", "2017-02-25 14:49:05", "CONTENTS", "My Bookings", "", "trash", "closed", "open", "", "my-bookings__trashed", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "12", "http://localhost/lumbini/events/my-bookings/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2017-02-25 14:49:50", "2017-02-25 14:49:50", "a:7:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:12:\"options_page\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:13:\"theme-options\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";s:0:\"\";s:11:\"description\";s:0:\"\";}", "Option Page", "option-page", "publish", "closed", "closed", "", "group_58b1997230cff", "", "", "2017-03-06 02:26:41", "2017-03-06 02:26:41", "", "0", "http://localhost/lumbini/?post_type=acf-field-group&#038;p=17", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2017-02-25 14:51:37", "2017-02-25 14:51:37", "a:10:{s:4:\"type\";s:8:\"repeater\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"collapsed\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"layout\";s:5:\"table\";s:12:\"button_label\";s:0:\"\";}", "Slider", "slider", "publish", "closed", "closed", "", "field_58b199c11a428", "", "", "2017-02-27 18:34:20", "2017-02-27 18:34:20", "", "17", "http://localhost/lumbini/?post_type=acf-field&#038;p=18", "1", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2017-02-25 14:51:37", "2017-02-25 14:51:37", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:3:\"url\";s:12:\"preview_size\";s:12:\"medium_large\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "Image", "image", "publish", "closed", "closed", "", "field_58b199d31a429", "", "", "2017-02-27 18:34:20", "2017-02-27 18:34:20", "", "18", "http://localhost/lumbini/?post_type=acf-field&#038;p=19", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2017-02-25 14:51:37", "2017-02-25 14:51:37", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Title", "title", "publish", "closed", "closed", "", "field_58b199e31a42a", "", "", "2017-02-25 14:51:37", "2017-02-25 14:51:37", "", "18", "http://localhost/lumbini/?post_type=acf-field&p=20", "1", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2017-02-25 14:53:28", "2017-02-25 14:53:28", "", "1280px-The_Monastery_of_World_Peace_Lumbini", "", "inherit", "open", "closed", "", "1280px-the_monastery_of_world_peace_lumbini", "", "", "2017-02-27 17:40:30", "2017-02-27 17:40:30", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/1280px-The_Monastery_of_World_Peace_Lumbini-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2017-02-25 14:54:44", "2017-02-25 14:54:44", "", "20121101-DSC06664-4", "", "inherit", "open", "closed", "", "20121101-dsc06664-4", "", "", "2017-02-25 14:54:45", "2017-02-25 14:54:45", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/20121101-DSC06664-4-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2017-02-25 14:56:28", "2017-02-25 14:56:28", "{\n    \"show_on_front\": {\n        \"value\": \"page\",\n        \"type\": \"option\",\n        \"user_id\": 1\n    },\n    \"page_on_front\": {\n        \"value\": \"10\",\n        \"type\": \"option\",\n        \"user_id\": 1\n    }\n}", "", "", "trash", "closed", "closed", "", "ab37f3eb-5daa-4e48-9faf-21e2d7688d8b", "", "", "2017-02-25 14:56:28", "2017-02-25 14:56:28", "", "0", "http://localhost/lumbini/ab37f3eb-5daa-4e48-9faf-21e2d7688d8b/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2017-02-25 15:03:17", "2017-02-25 15:03:17", "", "Home", "", "publish", "closed", "closed", "", "home", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "0", "http://localhost/lumbini/?p=24", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2017-02-25 15:04:33", "2017-02-25 15:04:33", "", "About Us", "", "trash", "closed", "closed", "", "about-us__trashed", "", "", "2017-02-27 17:42:39", "2017-02-27 17:42:39", "", "56", "http://localhost/lumbini/?page_id=25", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2017-02-25 15:04:33", "2017-02-25 15:04:33", "", "About Us", "", "inherit", "closed", "closed", "", "25-revision-v1", "", "", "2017-02-25 15:04:33", "2017-02-25 15:04:33", "", "25", "http://localhost/lumbini/25-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2017-02-25 15:04:50", "2017-02-25 15:04:50", "lkjhflhslfhs", "Board of Directors", "", "publish", "closed", "closed", "", "board-of-directors", "", "", "2017-03-04 12:12:33", "2017-03-04 12:12:33", "", "56", "http://localhost/lumbini/?page_id=27", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2017-02-25 15:04:50", "2017-02-25 15:04:50", "", "Board of Directors", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2017-02-25 15:04:50", "2017-02-25 15:04:50", "", "27", "http://localhost/lumbini/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2017-02-25 15:05:06", "2017-02-25 15:05:06", "At the E-Board and throughout our nation, we – as individuals, members of various groups, holders of myriad ideologies, residents of this nations, citizens of the world – are <strong>trying to figure out how to make this country work for all </strong>… in peacebuilding terminology, how to we bring together all stakeholders?  In spiritual terminology, how do we operate out of compassion?  In restorative terminology, how do we breakdown down the thinking of us/ them, of “the other”? Can we be/ should we be bipartisan/ non-partisan/ multi-partisan?  How do we deal with unfairness or perceived unfairness?  How do we bring about equality?  How do we get out of the blame/ shame/ disdain game?  How do we stop the hate and violence?  How do we call out what is unacceptable and hold ourselves to acceptance of all of humanity?  How do we move out of grief and the comfort of our own silos and on to inclusion? How do we stay true to our values of nonviolence and peace in these most trying and evocative of times?  How do we move to reconciliation and peacebuilding?\r\n\r\nOne poignant comment was that we need to get over our stance that we (whichever “we”) have the best intellectual analysis of problems and get on with connecting to the feelings of others.  One picture circulating on the internet is a photo of a child, with closed eyes, one hand on a tree, the other on the heart and the caption: <strong>“See with your heart</strong>\r\n\r\nIn the center of our booth we placed words from Dr. Martin Luther King, Jr., “Hatred paralyzes life; love releases it.  Hatred confuses life; love harmonizes it.  <strong>Hatred darkens life; love illuminates it</strong>.”\r\n\r\n<strong>At the E-Board, we went back to basics: our children, respect, kindness, compassion and hope. </strong>One of the most important faces we put on peacebuilding was bringing to the CDP forum the San Diego Kids for Peace<strong>,</strong> who have been leading the way in building peace and community in SE San Diego since 2007 and who have been supported in their work by the San Diego Department of Peacebuilding group (Americans for a Department of Peace(building) or AFDoP).  The kids, in all of their glitter glory, spread messages of kindness and were a breath of fresh air in our hope for a future where all are our best selves.", "Message from President", "", "publish", "closed", "closed", "", "message-from-president", "", "", "2017-02-25 15:52:45", "2017-02-25 15:52:45", "", "56", "http://localhost/lumbini/?page_id=29", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2017-02-25 15:05:06", "2017-02-25 15:05:06", "", "Message from President", "", "inherit", "closed", "closed", "", "29-revision-v1", "", "", "2017-02-25 15:05:06", "2017-02-25 15:05:06", "", "29", "http://localhost/lumbini/29-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2017-02-25 15:05:22", "2017-02-25 15:05:22", "", "Vision and Mission", "", "trash", "closed", "closed", "", "vision-and-mission__trashed", "", "", "2017-02-27 17:42:39", "2017-02-27 17:42:39", "", "56", "http://localhost/lumbini/?page_id=31", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2017-02-25 15:05:22", "2017-02-25 15:05:22", "", "Vision and Mission", "", "inherit", "closed", "closed", "", "31-revision-v1", "", "", "2017-02-25 15:05:22", "2017-02-25 15:05:22", "", "31", "http://localhost/lumbini/31-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2017-02-25 15:06:06", "2017-02-25 15:06:06", "", "Achivement", "", "trash", "closed", "closed", "", "achivement__trashed", "", "", "2017-02-27 17:42:39", "2017-02-27 17:42:39", "", "56", "http://localhost/lumbini/?page_id=33", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2017-02-25 15:06:06", "2017-02-25 15:06:06", "", "Achivement", "", "inherit", "closed", "closed", "", "33-revision-v1", "", "", "2017-02-25 15:06:06", "2017-02-25 15:06:06", "", "33", "http://localhost/lumbini/33-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2017-02-25 15:06:28", "2017-02-25 15:06:28", "", "Contact Us", "", "publish", "closed", "closed", "", "contact-us", "", "", "2017-02-25 15:06:28", "2017-02-25 15:06:28", "", "0", "http://localhost/lumbini/?page_id=35", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2017-02-25 15:06:28", "2017-02-25 15:06:28", "", "Contact Us", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2017-02-25 15:06:28", "2017-02-25 15:06:28", "", "35", "http://localhost/lumbini/35-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2017-02-25 15:08:44", "2017-02-25 15:08:44", "In the aftershock of the 2016 presidential election, the CA Democratic Party (CDP) held its pre-scheduled Executive Board (E-Board) meeting where Democratic Party officials and grassroots activists came together to assess who the Party is and wants to be.  The CA Peace Alliance/ Campaign for a US Department of Peacebuilding (DoP/ HR 1111), together with the San Diego Kids for Peace, was there as <strong>voice for peace and peacebuilding</strong>, <strong>which were rarely mentioned in the 2016 elections.</strong>  This meeting took place on November 18-20, 2016 – mere days after the election – and feelings were pretty raw … incredulity, anger, grief, blame, hopelessness, uncertainty.\r\n\r\n<strong>A.  OVERVIEW</strong>\r\n\r\nAt the E-Board and throughout our nation, we – as individuals, members of various groups, holders of myriad ideologies, residents of this nations, citizens of the world – are <strong>trying to figure out how to make this country work for all </strong>… in peacebuilding terminology, how to we bring together all stakeholders?  In spiritual terminology, how do we operate out of compassion?  In restorative terminology, how do we breakdown down the thinking of us/ them, of “the other”? Can we be/ should we be bipartisan/ non-partisan/ multi-partisan?  How do we deal with unfairness or perceived unfairness?  How do we bring about equality?  How do we get out of the blame/ shame/ disdain game?  How do we stop the hate and violence?  How do we call out what is unacceptable and hold ourselves to acceptance of all of humanity?  How do we move out of grief and the comfort of our own silos and on to inclusion? How do we stay true to our values of nonviolence and peace in these most trying and evocative of times?  How do we move to reconciliation and peacebuilding?\r\n\r\nOne poignant comment was that we need to get over our stance that we (whichever “we”) have the best intellectual analysis of problems and get on with connecting to the feelings of others.  One picture circulating on the internet is a photo of a child, with closed eyes, one hand on a tree, the other on the heart and the caption: <strong>“See with your heart</strong>\r\n\r\nIn the center of our booth we placed words from Dr. Martin Luther King, Jr., “Hatred paralyzes life; love releases it.  Hatred confuses life; love harmonizes it.  <strong>Hatred darkens life; love illuminates it</strong>.”\r\n\r\n<strong>At the E-Board, we went back to basics: our children, respect, kindness, compassion and hope. </strong>One of the most important faces we put on peacebuilding was bringing to the CDP forum the San Diego Kids for Peace<strong>,</strong> who have been leading the way in building peace and community in SE San Diego since 2007 and who have been supported in their work by the San Diego Department of Peacebuilding group (Americans for a Department of Peace(building) or AFDoP).  The kids, in all of their glitter glory, spread messages of kindness and were a breath of fresh air in our hope for a future where all are our best selves.\r\n\r\n<strong>Our actions</strong> included:  <strong>1) partnering with San Diego Kids for Peace</strong> through on-site art poster and banner projects and conversations about the “Great Kindness Challenge”;  <strong>2)</strong>  asking people to <strong>sign three petitions</strong> (for DoP cosponsor, for civil political discourse, in support of anti-bullying); <strong>3)</strong> asking people to <strong>call for a vote in the Senate on the Juvenile Justice and Delinquency Prevention Act </strong>(JJDPA) by contacting Senator Dianne Feinstein (D-CA); <strong>4)</strong> <strong>presenting to the Chair and the Veterans Caucus a certificate of appreciation</strong> for their support of the DoP legislation and for testifying before the CDP legislation committee on our behalf, which resulted in the Party endorsing DoP as one of its five endorsed pieces of federal legislation; and 5) <strong>connecting and dialoguing</strong> about our collective future as Americans.\r\n\r\nWe also had many conversation and attended caucus and standing committee meetings.\r\n\r\nThe CDP adopted a resolution submitted by Jerilyn Stapleton, So. CA Peace Alliance State Coordinator and President of CA NOW, “Resolution for an Executive Order Directing the California Attorney General to Investigate, Manage, Interpret, Prosecute or Inquire About Matters Relating to Sexual Misconduct of Law Enforcement Officers.”  <strong>The CDP also adopted a resolution defending California’s accomplishments against policies that would increase inequality and embolden bigotry and misogyny in our communities and schools.</strong>\r\n\r\nCongressman Keith Ellison (D-MN), who is a cosponsor of the legislation to create a U.S. Department of Peacebuilding, was a keynote speaker.  He is running to Chair the Democratic National Committee (DNC).  He is also the first Muslim American member of Congress and chair of the Congressional Progressive caucus.  <strong>One of our DoP leads asked the Congressman to put peacebuilding in the national party agenda</strong>.\r\n\r\nThank you to Northern and Southern CA Peace Alliance/ Department of Peacebuilding committee members and those who donated ideas, time and money, including folks from the National Department of Peacebuilding Committee.  Thank you to the San Diego Peace Alliance and San Diego Kids (and adults) for Peace.  You all made this happen.", "Election Post Mortem – CA DoP & Kids for Peace at State Democratic Party Meeting", "", "publish", "open", "open", "", "election-post-mortem-ca-dop-kids-for-peace-at-state-democratic-party-meeting", "", "", "2017-02-25 15:08:44", "2017-02-25 15:08:44", "", "0", "http://localhost/lumbini/?p=37", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2017-02-25 15:08:44", "2017-02-25 15:08:44", "In the aftershock of the 2016 presidential election, the CA Democratic Party (CDP) held its pre-scheduled Executive Board (E-Board) meeting where Democratic Party officials and grassroots activists came together to assess who the Party is and wants to be.  The CA Peace Alliance/ Campaign for a US Department of Peacebuilding (DoP/ HR 1111), together with the San Diego Kids for Peace, was there as <strong>voice for peace and peacebuilding</strong>, <strong>which were rarely mentioned in the 2016 elections.</strong>  This meeting took place on November 18-20, 2016 – mere days after the election – and feelings were pretty raw … incredulity, anger, grief, blame, hopelessness, uncertainty.\r\n\r\n<strong>A.  OVERVIEW</strong>\r\n\r\nAt the E-Board and throughout our nation, we – as individuals, members of various groups, holders of myriad ideologies, residents of this nations, citizens of the world – are <strong>trying to figure out how to make this country work for all </strong>… in peacebuilding terminology, how to we bring together all stakeholders?  In spiritual terminology, how do we operate out of compassion?  In restorative terminology, how do we breakdown down the thinking of us/ them, of “the other”? Can we be/ should we be bipartisan/ non-partisan/ multi-partisan?  How do we deal with unfairness or perceived unfairness?  How do we bring about equality?  How do we get out of the blame/ shame/ disdain game?  How do we stop the hate and violence?  How do we call out what is unacceptable and hold ourselves to acceptance of all of humanity?  How do we move out of grief and the comfort of our own silos and on to inclusion? How do we stay true to our values of nonviolence and peace in these most trying and evocative of times?  How do we move to reconciliation and peacebuilding?\r\n\r\nOne poignant comment was that we need to get over our stance that we (whichever “we”) have the best intellectual analysis of problems and get on with connecting to the feelings of others.  One picture circulating on the internet is a photo of a child, with closed eyes, one hand on a tree, the other on the heart and the caption: <strong>“See with your heart</strong>\r\n\r\nIn the center of our booth we placed words from Dr. Martin Luther King, Jr., “Hatred paralyzes life; love releases it.  Hatred confuses life; love harmonizes it.  <strong>Hatred darkens life; love illuminates it</strong>.”\r\n\r\n<strong>At the E-Board, we went back to basics: our children, respect, kindness, compassion and hope. </strong>One of the most important faces we put on peacebuilding was bringing to the CDP forum the San Diego Kids for Peace<strong>,</strong> who have been leading the way in building peace and community in SE San Diego since 2007 and who have been supported in their work by the San Diego Department of Peacebuilding group (Americans for a Department of Peace(building) or AFDoP).  The kids, in all of their glitter glory, spread messages of kindness and were a breath of fresh air in our hope for a future where all are our best selves.\r\n\r\n<strong>Our actions</strong> included:  <strong>1) partnering with San Diego Kids for Peace</strong> through on-site art poster and banner projects and conversations about the “Great Kindness Challenge”;  <strong>2)</strong>  asking people to <strong>sign three petitions</strong> (for DoP cosponsor, for civil political discourse, in support of anti-bullying); <strong>3)</strong> asking people to <strong>call for a vote in the Senate on the Juvenile Justice and Delinquency Prevention Act </strong>(JJDPA) by contacting Senator Dianne Feinstein (D-CA); <strong>4)</strong> <strong>presenting to the Chair and the Veterans Caucus a certificate of appreciation</strong> for their support of the DoP legislation and for testifying before the CDP legislation committee on our behalf, which resulted in the Party endorsing DoP as one of its five endorsed pieces of federal legislation; and 5) <strong>connecting and dialoguing</strong> about our collective future as Americans.\r\n\r\nWe also had many conversation and attended caucus and standing committee meetings.\r\n\r\nThe CDP adopted a resolution submitted by Jerilyn Stapleton, So. CA Peace Alliance State Coordinator and President of CA NOW, “Resolution for an Executive Order Directing the California Attorney General to Investigate, Manage, Interpret, Prosecute or Inquire About Matters Relating to Sexual Misconduct of Law Enforcement Officers.”  <strong>The CDP also adopted a resolution defending California’s accomplishments against policies that would increase inequality and embolden bigotry and misogyny in our communities and schools.</strong>\r\n\r\nCongressman Keith Ellison (D-MN), who is a cosponsor of the legislation to create a U.S. Department of Peacebuilding, was a keynote speaker.  He is running to Chair the Democratic National Committee (DNC).  He is also the first Muslim American member of Congress and chair of the Congressional Progressive caucus.  <strong>One of our DoP leads asked the Congressman to put peacebuilding in the national party agenda</strong>.\r\n\r\nThank you to Northern and Southern CA Peace Alliance/ Department of Peacebuilding committee members and those who donated ideas, time and money, including folks from the National Department of Peacebuilding Committee.  Thank you to the San Diego Peace Alliance and San Diego Kids (and adults) for Peace.  You all made this happen.", "Election Post Mortem – CA DoP & Kids for Peace at State Democratic Party Meeting", "", "inherit", "closed", "closed", "", "37-revision-v1", "", "", "2017-02-25 15:08:44", "2017-02-25 15:08:44", "", "37", "http://localhost/lumbini/37-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2017-02-25 15:10:48", "2017-02-25 15:10:48", "https://www.youtube.com/watch?v=OA2-rWsOw7M\r\n\r\n&nbsp;", "World Peace City Lumbini, Nepal International Conference 01", "", "publish", "open", "open", "", "world-peace-city-lumbini-nepal-international-conference-01", "", "", "2017-02-26 05:54:54", "2017-02-26 05:54:54", "", "0", "http://localhost/lumbini/?p=39", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2017-02-25 15:10:48", "2017-02-25 15:10:48", "https://www.youtube.com/watch?v=OA2-rWsOw7M\r\n\r\n&nbsp;", "World Peace City Lumbini, Nepal International Conference 01", "", "inherit", "closed", "closed", "", "39-revision-v1", "", "", "2017-02-25 15:10:48", "2017-02-25 15:10:48", "", "39", "http://localhost/lumbini/uncategorized/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2017-02-25 15:10:50", "2017-02-25 15:10:50", "", "World Peace City Lumbini, Nepal International Conference 01", "", "inherit", "open", "closed", "", "world-peace-city-lumbini-nepal-international-conference-01-2", "", "", "2017-02-25 15:10:50", "2017-02-25 15:10:50", "", "39", "http://localhost/lumbini/wp-content/uploads/2017/02/world-peace-city-lumbini-nepal-international-conference-01.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2017-02-25 15:47:29", "2017-02-25 15:47:29", "<p class=\"p1\"><span class=\"s1\">Kathmandu, May 25:  Damodar Prasad Acharya has been elected unanimously as the chairman of the Lumbini-Kapilvastu Global Campaign (LKGC), Belgium.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">The first general assembly of the LKGC, Belgium, elected Acharya as the chairman.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">Established on December 1, 2009, the Campaign has been carrying out activities to spread message of peace and non-violence of Gautam Buddha. It has also spread factual and truthful information about Lumbini, Nepal, the birthplace of Gautam Buddha by making clear about the misinformation.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">The first convention of the LKGC, Belgium, held in Belgian city, Luven, on May 22, also elected a 17-member executive committee and a 3-member advisory committee in the leadership of Acharya. The convention elected Anita Lama as the vice-chairperson, Nanda Raj Ghale as general secretary, Geert Catrysse as secretary and Baburam Sharma as the treasurer.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">Similarly, elected members are Rajani Pradhan, Yuvaraj Gurung, Bernard Braem, Sita Sapkota, Kalpana Magar, Seema Subedi, Durga Bhattarai, Ram Chandra Subedi, Shriram Prasai, Saurav Karjit, Jogman Tamang and PD Sherpa. Janaki Gurung and Surendra Bhusal have been elected as advisors while Gangadhar Gautam, NRN Belgium chair, has been appointed as advisor.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">The first convention of the LKGC, Belgium was inaugurated jointly by CPN-UML leader and MP, Bikash Lamsal and officiating Nepalese ambassador to Belgium, Ghanashyam Bhandari, by lighting traditional lamp, Panas, a press release of the LKGC read.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">Addressing the programme, UML leader Lamsal viewed that the programme like this would help tourism promotion of Nepal while officiating ambassador Bhandari dwelt on Buddhist philosophy and said that Lumbini is the source of world peace. </span></p>\r\n<p class=\"p4\"><span class=\"s1\">As the special guests, Axel Goethals, CEO at European Institute for Asian Studies, Wendy Slanders, Director at Active International Federation, Belgium, Arjun Kumar Shrestha, NRN secretary, Gangadhar Gautam, NRN Belgium chair, Leela Sharma Manandhar, Belgium Asia Forum chair also addressed the programme.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">In the programme, Europe advisor for Lumbini Kapilvastu Day Global Campaign and coordinator of the convention, Damodar Prasad Acharya highlighted on the activities of the Campaign and its achievement as well as it upcoming activities. He also briefed about the reasons, such as earth quake in Nepal and terrorist attack in France, for postponing the World Conference and informed that the Conference would be held coinciding with the 8</span><span class=\"s2\"><sup>th</sup></span><span class=\"s1\"> anniversary of the Campaign on 27 November 2016 in Brussels, Belgium in collaboration with Lumbini Development Trust.</span></p>", "Acharya elected as chairman of LKGC, Belgium", "", "publish", "open", "open", "", "acharya-elected-as-chairman-of-lkgc-belgium", "", "", "2017-02-27 17:30:14", "2017-02-27 17:30:14", "", "0", "http://localhost/lumbini/?p=42", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2017-02-25 15:15:13", "2017-02-25 15:15:13", " ", "", "", "publish", "closed", "closed", "", "43", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "0", "http://localhost/lumbini/?p=43", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2017-02-25 15:15:12", "2017-02-25 15:15:12", " ", "", "", "publish", "closed", "closed", "", "46", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "56", "http://localhost/lumbini/?p=46", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2017-02-25 15:15:13", "2017-02-25 15:15:13", " ", "", "", "publish", "closed", "closed", "", "47", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "56", "http://localhost/lumbini/?p=47", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2017-02-25 15:15:13", "2017-02-25 15:15:13", " ", "", "", "publish", "closed", "closed", "", "49", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "0", "http://localhost/lumbini/?p=49", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2017-02-25 15:15:13", "2017-02-25 15:15:13", " ", "", "", "publish", "closed", "closed", "", "50", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "0", "http://localhost/lumbini/?p=50", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2017-02-25 15:15:13", "2017-02-25 15:15:13", " ", "", "", "publish", "closed", "closed", "", "51", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "0", "http://localhost/lumbini/?p=51", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2017-02-25 15:15:13", "2017-02-25 15:15:13", " ", "", "", "publish", "closed", "closed", "", "52", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "0", "http://localhost/lumbini/?p=52", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2017-02-25 15:47:29", "2017-02-25 15:47:29", "Kathmandu, May 25:  Damodar Prasad Acharya has been elected unanimously as the chairman of the Lumbini-Kapilvastu Global Campaign (LKGC), Belgium.\r\n\r\nThe first general assembly of the LKGC, Belgium, elected Acharya as the chairman.\r\n\r\nEstablished on December 1, 2009, the Campaign has been carrying out activities to spread message of peace and non-violence of Gautam Buddha. It has also spread factual and truthful information about Lumbini, Nepal, the birthplace of Gautam Buddha by making clear about the misinformation.\r\n\r\nThe first convention of the LKGC, Belgium, held in Belgian city, Luven, on May 22, also elected a 17-member executive committee and a 3-member advisory committee in the leadership of Acharya. The convention elected Anita Lama as the vice-chairperson, Nanda Raj Ghale as general secretary, Geert Catrysse as secretary and Baburam Sharma as the treasurer.\r\n\r\nSimilarly, elected members are Rajani Pradhan, Yuvaraj Gurung, Bernard Braem, Sita Sapkota, Kalpana Magar, Seema Subedi, Durga Bhattarai, Ram Chandra Subedi, Shriram Prasai, Saurav Karjit, Jogman Tamang and PD Sherpa. Janaki Gurung and Surendra Bhusal have been elected as advisors while Gangadhar Gautam, NRN Belgium chair, has been appointed as advisor.\r\n\r\nThe first convention of the LKGC, Belgium was inaugurated jointly by CPN-UML leader and MP, Bikash Lamsal and officiating Nepalese ambassador to Belgium, Ghanashyam Bhandari, by lighting traditional lamp, Panas, a press release of the LKGC read.\r\n\r\nAddressing the programme, UML leader Lamsal viewed that the programme like this would help tourism promotion of Nepal while officiating ambassador Bhandari dwelt on Buddhist philosophy and said that Lumbini is the source of world peace.", "Acharya elected as chairman of LKGC, Belgium", "", "inherit", "closed", "closed", "", "42-revision-v1", "", "", "2017-02-25 15:47:29", "2017-02-25 15:47:29", "", "42", "http://localhost/lumbini/uncategorized/42-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2017-02-25 15:50:09", "2017-02-25 15:50:09", "a:7:{s:4:\"type\";s:3:\"tab\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"placement\";s:3:\"top\";s:8:\"endpoint\";i:0;}", "Front page setting", "", "publish", "closed", "closed", "", "field_58b1a73e53156", "", "", "2017-02-25 15:50:09", "2017-02-25 15:50:09", "", "17", "http://localhost/lumbini/?post_type=acf-field&p=54", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2017-02-25 15:50:09", "2017-02-25 15:50:09", "a:11:{s:4:\"type\";s:11:\"post_object\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"post_type\";a:1:{i:0;s:4:\"page\";}s:8:\"taxonomy\";a:0:{}s:10:\"allow_null\";i:0;s:8:\"multiple\";i:0;s:13:\"return_format\";s:6:\"object\";s:2:\"ui\";i:1;}", "Message from President Page Link", "message", "publish", "closed", "closed", "", "field_58b1a76d53157", "", "", "2017-02-27 18:37:11", "2017-02-27 18:37:11", "", "17", "http://localhost/lumbini/?post_type=acf-field&#038;p=55", "2", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2017-02-25 15:50:23", "2017-02-25 15:50:23", "<p class=\"p1\"><span class=\"s1\">Since its inceptionin 2009, Lumbini-Kapilvastu Global Campaign is a global movement of more than 19 national level committees in 19 countries and 21 members global committee with 9 prominent advisers. Lumbini-Kapilvastu Global Campaign, Belgium is one of among 19 national level committees.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The national committee is an independent body to act in national level for social and cultural activities; and it does not belong to any political and religious believes. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">We are campaigning for a world where peace and harmony are enjoyed by all.<span class=\"Apple-converted-space\">  </span>All views, thoughts, opinions and materials published are purely for information purposes only and we intend to remain fair and balanced for a better world.</span></p>\r\n\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\">Vision and Mission</span></h2>\r\n<ul>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote the peace and non-violence message of Buddha for world peace.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote and highlight Lumbini, Nepal the birth place of Buddha worldwide toprovide truthful information regarding the misinformation on Buddha’s birth place for betterment of Nepal.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">Humanitarian help in the emergency.</span></li>\r\n</ul>\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\">What we do</span></h2>\r\n<p class=\"p1\"><span class=\"s1\">To promote peace and non-violence message of Buddha and highlight Lumbini, Nepal as World Peace City, we are organizing conference, seminar, interaction program, info stall, street demonstration, and peace march.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">We also organize social and cultural activities to raise the fund for humanitarian help in emergency situation caused by natural disaster.</span></p>\r\n\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\">Working with</span></h2>\r\n<p class=\"p1\"><span class=\"s1\">Lumbini Development Trust, the government of Nepal</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Active Intercultural Federation, Belgium VZW</span></p>", "Who we are", "", "publish", "closed", "closed", "", "who-we-are", "", "", "2017-03-04 08:45:57", "2017-03-04 08:45:57", "", "0", "http://localhost/lumbini/?page_id=56", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2017-02-25 15:50:23", "2017-02-25 15:50:23", "", "Who we are", "", "inherit", "closed", "closed", "", "56-revision-v1", "", "", "2017-02-25 15:50:23", "2017-02-25 15:50:23", "", "56", "http://localhost/lumbini/uncategorized/56-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2017-02-25 15:52:27", "2017-02-25 15:52:27", "", "damodar", "", "inherit", "open", "closed", "", "damodar", "", "", "2017-02-25 15:52:27", "2017-02-25 15:52:27", "", "29", "http://localhost/lumbini/wp-content/uploads/2017/02/damodar-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2017-02-25 15:52:45", "2017-02-25 15:52:45", "At the E-Board and throughout our nation, we – as individuals, members of various groups, holders of myriad ideologies, residents of this nations, citizens of the world – are <strong>trying to figure out how to make this country work for all </strong>… in peacebuilding terminology, how to we bring together all stakeholders?  In spiritual terminology, how do we operate out of compassion?  In restorative terminology, how do we breakdown down the thinking of us/ them, of “the other”? Can we be/ should we be bipartisan/ non-partisan/ multi-partisan?  How do we deal with unfairness or perceived unfairness?  How do we bring about equality?  How do we get out of the blame/ shame/ disdain game?  How do we stop the hate and violence?  How do we call out what is unacceptable and hold ourselves to acceptance of all of humanity?  How do we move out of grief and the comfort of our own silos and on to inclusion? How do we stay true to our values of nonviolence and peace in these most trying and evocative of times?  How do we move to reconciliation and peacebuilding?\r\n\r\nOne poignant comment was that we need to get over our stance that we (whichever “we”) have the best intellectual analysis of problems and get on with connecting to the feelings of others.  One picture circulating on the internet is a photo of a child, with closed eyes, one hand on a tree, the other on the heart and the caption: <strong>“See with your heart</strong>\r\n\r\nIn the center of our booth we placed words from Dr. Martin Luther King, Jr., “Hatred paralyzes life; love releases it.  Hatred confuses life; love harmonizes it.  <strong>Hatred darkens life; love illuminates it</strong>.”\r\n\r\n<strong>At the E-Board, we went back to basics: our children, respect, kindness, compassion and hope. </strong>One of the most important faces we put on peacebuilding was bringing to the CDP forum the San Diego Kids for Peace<strong>,</strong> who have been leading the way in building peace and community in SE San Diego since 2007 and who have been supported in their work by the San Diego Department of Peacebuilding group (Americans for a Department of Peace(building) or AFDoP).  The kids, in all of their glitter glory, spread messages of kindness and were a breath of fresh air in our hope for a future where all are our best selves.", "Message from President", "", "inherit", "closed", "closed", "", "29-revision-v1", "", "", "2017-02-25 15:52:45", "2017-02-25 15:52:45", "", "29", "http://localhost/lumbini/uncategorized/29-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("73", "1", "2017-02-25 16:54:33", "2017-02-25 16:54:33", "", "lumbini1-1", "", "inherit", "open", "closed", "", "lumbini1-1", "", "", "2017-02-25 16:54:33", "2017-02-25 16:54:33", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/lumbini1-1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "CONTENTS", "Categories", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "14", "http://localhost/lumbini/uncategorized/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("75", "1", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "CONTENTS", "Locations", "", "inherit", "closed", "closed", "", "13-revision-v1", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "13", "http://localhost/lumbini/uncategorized/13-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("76", "1", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "CONTENTS", "My Bookings", "", "inherit", "closed", "closed", "", "16-revision-v1", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "16", "http://localhost/lumbini/uncategorized/16-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("77", "1", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "CONTENTS", "Tags", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2017-02-25 17:11:48", "2017-02-25 17:11:48", "", "15", "http://localhost/lumbini/uncategorized/15-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("78", "1", "2017-02-25 17:35:31", "2017-02-25 17:35:31", "a:7:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"event\";}}}s:8:\"position\";s:4:\"side\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";s:0:\"\";s:11:\"description\";s:0:\"\";}", "Events", "events", "publish", "closed", "closed", "", "group_58b1bf341531d", "", "", "2017-03-05 11:05:14", "2017-03-05 11:05:14", "", "0", "http://localhost/lumbini/?post_type=acf-field-group&#038;p=78", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("79", "1", "2017-02-25 17:35:31", "2017-02-25 17:35:31", "a:8:{s:4:\"type\";s:16:\"date_time_picker\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:1;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:14:\"display_format\";s:12:\"F j, Y g:i a\";s:13:\"return_format\";s:12:\"F j, Y g:i a\";s:9:\"first_day\";i:1;}", "Start Date and Time", "start_date", "publish", "closed", "closed", "", "field_58b1bf9f41d5d", "", "", "2017-02-26 03:23:29", "2017-02-26 03:23:29", "", "78", "http://localhost/lumbini/?post_type=acf-field&#038;p=79", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("81", "1", "2017-02-25 17:35:31", "2017-02-25 17:35:31", "a:9:{s:4:\"type\";s:10:\"google_map\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"center_lat\";s:0:\"\";s:10:\"center_lng\";s:0:\"\";s:4:\"zoom\";s:0:\"\";s:6:\"height\";s:0:\"\";}", "Location", "location", "publish", "closed", "closed", "", "field_58b1c03541d5f", "", "", "2017-03-05 11:05:14", "2017-03-05 11:05:14", "", "78", "http://localhost/lumbini/?post_type=acf-field&#038;p=81", "2", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2017-02-25 17:37:27", "2017-02-25 17:37:27", "To promote peace and non-violence message of Buddha and promote Lumbini, Nepal-the birth place of Buddha in international arena.\r\nThe international conference will be held at 9:00 am, and will last untill 5:30 pm. The world renowned speakers professor Young Hoon Kwaak, professor Robin Coningham and highly regarded Buddhist scholar will present their research paper in the conference.\r\nDelegate admission will be counted as contribution for the conferrence and handed over an appreciation certificate to the delegates from the organizer.", "World Peace City Lumbini-Int\'l Conference", "", "publish", "closed", "closed", "", "world-peace-city-lumbini-intl-conference", "", "", "2017-02-26 03:23:53", "2017-02-26 03:23:53", "", "0", "http://localhost/lumbini/?post_type=event&#038;p=82", "0", "event", "", "0");
INSERT INTO `wp_posts` VALUES("85", "1", "2017-02-26 03:14:35", "2017-02-26 03:14:35", "Lumbini has a number of temples, including the <a title=\"Maya Devi Temple, Lumbini\" href=\"https://en.wikipedia.org/wiki/Maya_Devi_Temple,_Lumbini\">Mayadevi Temple</a> and several others which are still under construction. Many monuments, <a title=\"Buddhist monasticism\" href=\"https://en.wikipedia.org/wiki/Buddhist_monasticism\">monasteries</a> and a museum, the Lumbini International Research Institute, are also within the holy site. Also there is the Puskarini, or Holy Pond, where the Buddha\'s mother took the ritual dip prior to his birth and where he had his first bath. At other sites near Lumbini, earlier Buddhas were, according to tradition, born, then achieved ultimate Enlightenment and finally relinquished their earthly forms.", "Lumbini-Kapilvastu Day", "", "publish", "closed", "closed", "", "lumbini-kapilvastu-day", "", "", "2017-02-26 03:23:43", "2017-02-26 03:23:43", "", "0", "http://localhost/lumbini/?post_type=event&#038;p=85", "0", "event", "", "0");
INSERT INTO `wp_posts` VALUES("86", "1", "2017-02-26 03:15:52", "2017-02-26 03:15:52", "In 1896, Nepalese archaeologists (led by Khadga Samsher Rana and assisted by <a title=\"Alois Anton Führer\" href=\"https://en.wikipedia.org/wiki/Alois_Anton_F%C3%BChrer\">Alois Anton Führer</a>) discovered a great <a title=\"Pillars of Ashoka\" href=\"https://en.wikipedia.org/wiki/Pillars_of_Ashoka\">stone pillar</a> at Lumbini. Führer postulated that the pillar was placed at the site by <a title=\"Ashoka\" href=\"https://en.wikipedia.org/wiki/Ashoka\">Ashoka</a> (emperor of the <a title=\"Maurya Empire\" href=\"https://en.wikipedia.org/wiki/Maurya_Empire\">Maurya Empire</a>) circa 245 BCE. Records made by the Chinese pilgrim <a title=\"Faxian\" href=\"https://en.wikipedia.org/wiki/Faxian\">Faxian</a> in the early fifth century <a title=\"Common Era\" href=\"https://en.wikipedia.org/wiki/Common_Era\">CE</a> were also used in the process of identifying this religiously acclaimed site.\r\n\r\nRecent excavations beneath existing brick structures at the Mayadevi Temple at Lumbini have uncovered evidence for an older timber structure beneath the walls of the newer brick Buddhist shrine, which was constructed during the Ashokan era. The layout of the Ashokan shrine closely follows that of the earlier timber structure, which suggests a continuity of worship at the site. The pre-Mauryan timber structure appears to be an ancient <a class=\"mw-redirect\" title=\"Tree worship\" href=\"https://en.wikipedia.org/wiki/Tree_worship\">bodhigara</a> (tree shrine), consisting of postholes and a wooden railing surrounding a clay floor containing mineralized tree roots that appears to have been worn smooth by visitors. Radiocarbon dating of charcoal from the wooden postholes and optically stimulated luminescence dating of elements in the soil suggests human activity (possibly pre-Buddhist tree worship) began at the site around 1000 BCE, followed by the development of a Buddhist monastery-like community by approximately 550 BCE.<sup id=\"cite_ref-Coningham2013_14-0\" class=\"reference\"><a href=\"https://en.wikipedia.org/wiki/Lumbini#cite_note-Coningham2013-14\">[14]</a></sup>", "Website Launch", "", "publish", "closed", "closed", "", "website-launch", "", "", "2017-03-05 08:51:49", "2017-03-05 08:51:49", "", "0", "http://localhost/lumbini/?post_type=event&#038;p=86", "0", "event", "", "0");
INSERT INTO `wp_posts` VALUES("87", "1", "2017-02-26 03:15:19", "2017-02-26 03:15:19", "", "0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full", "", "inherit", "open", "closed", "", "0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full", "", "", "2017-02-26 03:15:19", "2017-02-26 03:15:19", "", "86", "http://localhost/lumbini/wp-content/uploads/2017/02/0-02-06-8c6a2423f393c9ff39bfd2d9ef514bcb73e62381b87993018c188102c8e9dd62_full.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("89", "1", "2017-02-26 03:28:41", "2017-02-26 03:28:41", "a:8:{s:4:\"type\";s:16:\"date_time_picker\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:14:\"display_format\";s:12:\"F j, Y g:i a\";s:13:\"return_format\";s:12:\"F j, Y g:i a\";s:9:\"first_day\";i:1;}", "End Date and Time", "end_date", "publish", "closed", "closed", "", "field_58b24b5dd44ca", "", "", "2017-03-05 11:05:14", "2017-03-05 11:05:14", "", "78", "http://localhost/lumbini/?post_type=acf-field&#038;p=89", "1", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("92", "1", "2017-02-26 06:11:02", "2017-02-26 06:11:02", " ", "", "", "publish", "closed", "closed", "", "92", "", "", "2017-02-27 18:54:46", "2017-02-27 18:54:46", "", "56", "http://localhost/lumbini/?p=92", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("93", "1", "2017-02-26 06:11:02", "2017-02-26 06:11:02", " ", "", "", "publish", "closed", "closed", "", "93", "", "", "2017-02-27 18:54:46", "2017-02-27 18:54:46", "", "56", "http://localhost/lumbini/?p=93", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2017-02-26 06:24:45", "2017-02-26 06:24:45", "", "Facebook", "", "publish", "closed", "closed", "", "facebook", "", "", "2017-02-28 03:15:52", "2017-02-28 03:15:52", "", "0", "http://localhost/lumbini/?p=95", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("96", "1", "2017-02-26 06:25:09", "2017-02-26 06:25:09", "", "Twitter", "", "publish", "closed", "closed", "", "twitter", "", "", "2017-02-28 03:15:52", "2017-02-28 03:15:52", "", "0", "http://localhost/lumbini/?p=96", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("97", "1", "2017-02-26 06:25:56", "2017-02-26 06:25:56", "", "Instagram", "", "publish", "closed", "closed", "", "instagram", "", "", "2017-02-28 03:15:52", "2017-02-28 03:15:52", "", "0", "http://localhost/lumbini/?p=97", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2017-02-26 06:26:25", "2017-02-26 06:26:25", "", "Youtube", "", "publish", "closed", "closed", "", "youtube", "", "", "2017-02-28 03:15:52", "2017-02-28 03:15:52", "", "0", "http://localhost/lumbini/?p=98", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("99", "1", "2017-02-27 17:20:17", "2017-02-27 17:20:17", "a:7:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"post\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";s:0:\"\";s:11:\"description\";s:0:\"\";}", "Post Fields", "post-fields", "publish", "closed", "closed", "", "group_58b45fcb9862b", "", "", "2017-02-27 17:21:31", "2017-02-27 17:21:31", "", "0", "http://localhost/lumbini/?post_type=acf-field-group&#038;p=99", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2017-02-27 17:21:31", "2017-02-27 17:21:31", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Source", "source", "publish", "closed", "closed", "", "field_58b45fd3f9d6b", "", "", "2017-02-27 17:21:31", "2017-02-27 17:21:31", "", "99", "http://localhost/lumbini/?post_type=acf-field&p=100", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2017-02-27 17:21:31", "2017-02-27 17:21:31", "a:7:{s:4:\"type\";s:3:\"url\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";}", "Source url", "source_url", "publish", "closed", "closed", "", "field_58b45fdff9d6c", "", "", "2017-02-27 17:21:31", "2017-02-27 17:21:31", "", "99", "http://localhost/lumbini/?post_type=acf-field&p=101", "1", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("102", "1", "2017-02-27 17:21:31", "2017-02-27 17:21:31", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:3:\"url\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "Source Logo", "source_logo", "publish", "closed", "closed", "", "field_58b46005f9d6d", "", "", "2017-02-27 17:21:31", "2017-02-27 17:21:31", "", "99", "http://localhost/lumbini/?post_type=acf-field&p=102", "2", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("103", "1", "2016-12-16 17:22:02", "2016-12-16 17:22:02", "<p class=\"p1\"><span class=\"s1\"><b><i>UNESCO Liaison Office in Brussels Director Paolo Fontani attended the International Conference World Peace City Lumbini on November 27 and drew participants’ attention to UNESCO’s conservation efforts.</i></b></span></p>\r\n<p class=\"p2\"><span class=\"s1\">On November 27, the Director of the UNESCO Liaison Office in Brussels, Paolo Fontani, addressed the International Conference World Peace City Lumbini (Nepal), held to promote the peace and non-violence message of Buddha and promote Lumbini, the birth place of Buddha. Featured in the above picture, the Ambassador of Nepal to Benelux and the European Union and the organizer of the conference, M. Damodar Prasad Acharya, President of Lumbini-Kapilvastu Global Campaign.</span></p>\r\n<p class=\"p2\"><span class=\"s1\">During his keynote, M. Fontani underlined the relevance of World Heritage Site (1997) of Lumbini as symbol of peace and a testimony to a rich spiritual and cultural life since ancient times. Various events and activities, including Lumbini’s population growth and rapid industrialization, are adding pressure to the UNESCO World Heritage site and will need to be managed in order to balance heritage, development and the spirituality of the site. UNESCO, in cooperation with Nepal’s Department of Archeology and the Lumbini Development Trust, is implementing a programme to strengthen the conservation of Lumbini. Particularly following the devastating earthquake of 2015, conservation management efforts have become of paramount importance in order to safeguard Nepali World Heritage Site.</span></p>\r\n<p class=\"p2\"><span class=\"s1\">M. Fontani concluded by encouraging to harness the heritage power and energy of Lumbini to foster sustainable development, decent jobs and livelihoods for all: ‘Heritage can be a driver to learn new skills and knowledge, developing new capacities for the whole population.’</span></p>", "UNESCO Brussels Office takes part in the International Conference World Peace City Lumbini", "", "publish", "open", "open", "", "unesco-brussels-office-takes-part-in-the-international-conference-world-peace-city-lumbini", "", "", "2017-02-27 17:24:40", "2017-02-27 17:24:40", "", "0", "http://localhost/lumbini/?p=103", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("104", "1", "2017-02-27 17:23:49", "2017-02-27 17:23:49", "", "0e5b87554e", "", "inherit", "open", "closed", "", "0e5b87554e", "", "", "2017-02-27 17:23:49", "2017-02-27 17:23:49", "", "103", "http://localhost/lumbini/wp-content/uploads/2017/02/0e5b87554e.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2017-02-27 17:24:27", "2017-02-27 17:24:27", "", "logo_en", "", "inherit", "open", "closed", "", "logo_en", "", "", "2017-02-27 17:24:27", "2017-02-27 17:24:27", "", "103", "http://localhost/lumbini/wp-content/uploads/2017/02/logo_en.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("106", "1", "2017-02-27 17:24:32", "2017-02-27 17:24:32", "<p class=\"p1\"><span class=\"s1\"><b><i>UNESCO Liaison Office in Brussels Director Paolo Fontani attended the International Conference World Peace City Lumbini on November 27 and drew participants’ attention to UNESCO’s conservation efforts.</i></b></span></p>\r\n<p class=\"p2\"><span class=\"s1\">On November 27, the Director of the UNESCO Liaison Office in Brussels, Paolo Fontani, addressed the International Conference World Peace City Lumbini (Nepal), held to promote the peace and non-violence message of Buddha and promote Lumbini, the birth place of Buddha. Featured in the above picture, the Ambassador of Nepal to Benelux and the European Union and the organizer of the conference, M. Damodar Prasad Acharya, President of Lumbini-Kapilvastu Global Campaign.</span></p>\r\n<p class=\"p2\"><span class=\"s1\">During his keynote, M. Fontani underlined the relevance of World Heritage Site (1997) of Lumbini as symbol of peace and a testimony to a rich spiritual and cultural life since ancient times. Various events and activities, including Lumbini’s population growth and rapid industrialization, are adding pressure to the UNESCO World Heritage site and will need to be managed in order to balance heritage, development and the spirituality of the site. UNESCO, in cooperation with Nepal’s Department of Archeology and the Lumbini Development Trust, is implementing a programme to strengthen the conservation of Lumbini. Particularly following the devastating earthquake of 2015, conservation management efforts have become of paramount importance in order to safeguard Nepali World Heritage Site.</span></p>\r\n<p class=\"p2\"><span class=\"s1\">M. Fontani concluded by encouraging to harness the heritage power and energy of Lumbini to foster sustainable development, decent jobs and livelihoods for all: ‘Heritage can be a driver to learn new skills and knowledge, developing new capacities for the whole population.’</span></p>", "UNESCO Brussels Office takes part in the International Conference World Peace City Lumbini", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2017-02-27 17:24:32", "2017-02-27 17:24:32", "", "103", "http://localhost/lumbini/uncategorized/103-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2016-03-08 17:25:17", "2016-03-08 17:25:17", "<p class=\"p1\"><span class=\"s1\">Kathmandu, March 8: Lumbini-Kapilvastu Day World Campaign, an initiative of the non-resident Nepalese to publicise and promote the birthplace of Lord Gautam, Lumbini, Nepal, has asked the government for the assistance to the two-day international conference on Lumbini to be held on May 4-5 in Brussels, Belgium.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Member of the main organising committee of the international conference, Damodar Acharya, who is also the Europe advisor of Lumbini-Kapilvastu Day World Campaign, recently made a phone conversation with Finance Minister Dr Ram Sharan Mahat and the Minister for Culture, Tourism and Civil Aviation, Dipak Chandra Amatya, to this effect.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Ram Kumar Shrestha, coordinator of the Campaign and the main organising committee of the conference, had written to the Finance Minister on January 29 for the cooperation and the financial support. Shrestha\'s email letter was also sent as notification to Foreign Ministry and Tourism Ministry with recommendation from the Nepalese embassy in Belgium.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">According to a press release, a hard copy of the letters has again been sent to the Finance Ministry and others concerned as the ministers seemed to have not received the emailed letters.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Similarly, Acharya also requested Nepalese permanent representative to UNESCO and Nepalese ambassador to France, Ambika Devi Luitel, for follow up and provide other necessary helps to ensure participation of UNESCO director general, Irina Bokova. The Campaign has already invited Bokova for the participation in the global conference to be held on the occasion Buddha Jayanti (birth anniversary).</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The campaign had earlier, briefed Prime Minister Sushil Koirala during his visit to Belgium while returning from the 69 General Assembly of the UN in New York in October. PM Koirala had assured the Campaign for necessary assistance.</span></p>", "Global Campaign to promote Lumbini asks Govt. for assistance", "", "publish", "open", "open", "", "global-campaign-to-promote-lumbini-asks-govt-for-assistance", "", "", "2017-02-27 17:27:30", "2017-02-27 17:27:30", "", "0", "http://localhost/lumbini/?p=107", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("108", "1", "2017-02-27 17:26:08", "2017-02-27 17:26:08", "", "logo_international_conference on Lumbini", "", "inherit", "open", "closed", "", "logo_international_conference-on-lumbini", "", "", "2017-02-27 17:26:08", "2017-02-27 17:26:08", "", "107", "http://localhost/lumbini/wp-content/uploads/2017/02/logo_international_conference-on-Lumbini.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("109", "1", "2017-02-27 17:26:56", "2017-02-27 17:26:56", "", "gopa-logo-one", "", "inherit", "open", "closed", "", "gopa-logo-one", "", "", "2017-02-27 17:32:18", "2017-02-27 17:32:18", "", "107", "http://localhost/lumbini/wp-content/uploads/2017/02/gopa-logo-one.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("110", "1", "2017-02-27 17:27:30", "2017-02-27 17:27:30", "<p class=\"p1\"><span class=\"s1\">Kathmandu, March 8: Lumbini-Kapilvastu Day World Campaign, an initiative of the non-resident Nepalese to publicise and promote the birthplace of Lord Gautam, Lumbini, Nepal, has asked the government for the assistance to the two-day international conference on Lumbini to be held on May 4-5 in Brussels, Belgium.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Member of the main organising committee of the international conference, Damodar Acharya, who is also the Europe advisor of Lumbini-Kapilvastu Day World Campaign, recently made a phone conversation with Finance Minister Dr Ram Sharan Mahat and the Minister for Culture, Tourism and Civil Aviation, Dipak Chandra Amatya, to this effect.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Ram Kumar Shrestha, coordinator of the Campaign and the main organising committee of the conference, had written to the Finance Minister on January 29 for the cooperation and the financial support. Shrestha\'s email letter was also sent as notification to Foreign Ministry and Tourism Ministry with recommendation from the Nepalese embassy in Belgium.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">According to a press release, a hard copy of the letters has again been sent to the Finance Ministry and others concerned as the ministers seemed to have not received the emailed letters.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Similarly, Acharya also requested Nepalese permanent representative to UNESCO and Nepalese ambassador to France, Ambika Devi Luitel, for follow up and provide other necessary helps to ensure participation of UNESCO director general, Irina Bokova. The Campaign has already invited Bokova for the participation in the global conference to be held on the occasion Buddha Jayanti (birth anniversary).</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The campaign had earlier, briefed Prime Minister Sushil Koirala during his visit to Belgium while returning from the 69 General Assembly of the UN in New York in October. PM Koirala had assured the Campaign for necessary assistance.</span></p>", "Global Campaign to promote Lumbini asks Govt. for assistance", "", "inherit", "closed", "closed", "", "107-revision-v1", "", "", "2017-02-27 17:27:30", "2017-02-27 17:27:30", "", "107", "http://localhost/lumbini/uncategorized/107-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("111", "1", "2017-02-27 17:27:34", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "open", "open", "", "", "", "", "2017-02-27 17:27:34", "0000-00-00 00:00:00", "", "0", "http://localhost/lumbini/?p=111", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("112", "1", "2017-02-27 17:28:09", "2017-02-27 17:28:09", "Welcome to WordPress. This is your first post. Edit or delete it, then start writing!", "Hello world!", "", "inherit", "closed", "closed", "", "1-revision-v1", "", "", "2017-02-27 17:28:09", "2017-02-27 17:28:09", "", "1", "http://localhost/lumbini/uncategorized/1-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("113", "1", "2017-02-27 17:30:14", "2017-02-27 17:30:14", "<p class=\"p1\"><span class=\"s1\">Kathmandu, May 25:  Damodar Prasad Acharya has been elected unanimously as the chairman of the Lumbini-Kapilvastu Global Campaign (LKGC), Belgium.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">The first general assembly of the LKGC, Belgium, elected Acharya as the chairman.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">Established on December 1, 2009, the Campaign has been carrying out activities to spread message of peace and non-violence of Gautam Buddha. It has also spread factual and truthful information about Lumbini, Nepal, the birthplace of Gautam Buddha by making clear about the misinformation.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">The first convention of the LKGC, Belgium, held in Belgian city, Luven, on May 22, also elected a 17-member executive committee and a 3-member advisory committee in the leadership of Acharya. The convention elected Anita Lama as the vice-chairperson, Nanda Raj Ghale as general secretary, Geert Catrysse as secretary and Baburam Sharma as the treasurer.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">Similarly, elected members are Rajani Pradhan, Yuvaraj Gurung, Bernard Braem, Sita Sapkota, Kalpana Magar, Seema Subedi, Durga Bhattarai, Ram Chandra Subedi, Shriram Prasai, Saurav Karjit, Jogman Tamang and PD Sherpa. Janaki Gurung and Surendra Bhusal have been elected as advisors while Gangadhar Gautam, NRN Belgium chair, has been appointed as advisor.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">The first convention of the LKGC, Belgium was inaugurated jointly by CPN-UML leader and MP, Bikash Lamsal and officiating Nepalese ambassador to Belgium, Ghanashyam Bhandari, by lighting traditional lamp, Panas, a press release of the LKGC read.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">Addressing the programme, UML leader Lamsal viewed that the programme like this would help tourism promotion of Nepal while officiating ambassador Bhandari dwelt on Buddhist philosophy and said that Lumbini is the source of world peace. </span></p>\r\n<p class=\"p4\"><span class=\"s1\">As the special guests, Axel Goethals, CEO at European Institute for Asian Studies, Wendy Slanders, Director at Active International Federation, Belgium, Arjun Kumar Shrestha, NRN secretary, Gangadhar Gautam, NRN Belgium chair, Leela Sharma Manandhar, Belgium Asia Forum chair also addressed the programme.</span></p>\r\n<p class=\"p4\"><span class=\"s1\">In the programme, Europe advisor for Lumbini Kapilvastu Day Global Campaign and coordinator of the convention, Damodar Prasad Acharya highlighted on the activities of the Campaign and its achievement as well as it upcoming activities. He also briefed about the reasons, such as earth quake in Nepal and terrorist attack in France, for postponing the World Conference and informed that the Conference would be held coinciding with the 8</span><span class=\"s2\"><sup>th</sup></span><span class=\"s1\"> anniversary of the Campaign on 27 November 2016 in Brussels, Belgium in collaboration with Lumbini Development Trust.</span></p>", "Acharya elected as chairman of LKGC, Belgium", "", "inherit", "closed", "closed", "", "42-revision-v1", "", "", "2017-02-27 17:30:14", "2017-02-27 17:30:14", "", "42", "http://localhost/lumbini/uncategorized/42-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("114", "1", "2016-07-29 17:30:33", "2016-07-29 17:30:33", "<p class=\"p1\"><span class=\"s1\">Kathmandu, July 29: With a view to promoting Nepal\'s tourism, Lumbini-Kapilvastu Global Campaign, Belgium (LKGCB) has decided to set up an info stall at the Manifiesta, a yearly solidarity festival being held in Bredene of Belgium, to be held from September 16-18.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">According to the press statement of the LKGCB issued today, materials to promote Nepal\'s tourism including teachings of peace and non-violence of Gautam Buddha, display of documentary on Lumbini will be some special features of the info stall.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">There will also be a food stall so as to create fund for the non-profit organisation, LKGCB.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Thousands of people from around the world visit the Manifiesta.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Damodar Prasad Acharya, chairman of LKGCB, informed that Ministry of Culture, Tourism and Civil Aviation has instructed Tourism Board to provide necessary materials to be displayed at the stall for promoting tourism in Nepal. \"I have a regular contact with Minister Ananda Prasad Pokharel and he has assured me of providing necessary materials for promoting tourism. I also have contact with Tourism Secretary Prem Kumar Rai and he has informed me that Tourism Board has been instructed to arrange for sending the materials here in Belgium in time,\" Acharya told the TRN online on Friday in a phone conversation.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Belgium government has on July 8, 2016, recognized LKGCB as a non-profit organisation.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">LKGC has been organizing different programs to promote Lumbini, birthplace of Gautam Buddha, and tourism in Nepal.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">To work together for social and cultural activities in Belgium, Lumbini-Kapilvastu Global Campaign, Belgium and Active Intercultural Federation have agreed and both have signed in a contract on 04 June 2016.</span></p>", "LKGCB to promote Nepal tourism in Belgium", "", "publish", "open", "open", "", "lkgcb-to-promote-nepal-tourism-in-belgium", "", "", "2017-02-27 17:31:35", "2017-02-27 17:31:35", "", "0", "http://localhost/lumbini/?p=114", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("115", "1", "2017-02-27 17:31:16", "2017-02-27 17:31:16", "", "Logo of Lumbini Kapilvastu", "", "inherit", "open", "closed", "", "logo-of-lumbini-kapilvastu", "", "", "2017-02-27 17:31:16", "2017-02-27 17:31:16", "", "114", "http://localhost/lumbini/wp-content/uploads/2017/02/Logo-of-Lumbini-Kapilvastu.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("116", "1", "2017-02-27 17:31:35", "2017-02-27 17:31:35", "<p class=\"p1\"><span class=\"s1\">Kathmandu, July 29: With a view to promoting Nepal\'s tourism, Lumbini-Kapilvastu Global Campaign, Belgium (LKGCB) has decided to set up an info stall at the Manifiesta, a yearly solidarity festival being held in Bredene of Belgium, to be held from September 16-18.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">According to the press statement of the LKGCB issued today, materials to promote Nepal\'s tourism including teachings of peace and non-violence of Gautam Buddha, display of documentary on Lumbini will be some special features of the info stall.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">There will also be a food stall so as to create fund for the non-profit organisation, LKGCB.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Thousands of people from around the world visit the Manifiesta.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Damodar Prasad Acharya, chairman of LKGCB, informed that Ministry of Culture, Tourism and Civil Aviation has instructed Tourism Board to provide necessary materials to be displayed at the stall for promoting tourism in Nepal. \"I have a regular contact with Minister Ananda Prasad Pokharel and he has assured me of providing necessary materials for promoting tourism. I also have contact with Tourism Secretary Prem Kumar Rai and he has informed me that Tourism Board has been instructed to arrange for sending the materials here in Belgium in time,\" Acharya told the TRN online on Friday in a phone conversation.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Belgium government has on July 8, 2016, recognized LKGCB as a non-profit organisation.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">LKGC has been organizing different programs to promote Lumbini, birthplace of Gautam Buddha, and tourism in Nepal.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">To work together for social and cultural activities in Belgium, Lumbini-Kapilvastu Global Campaign, Belgium and Active Intercultural Federation have agreed and both have signed in a contract on 04 June 2016.</span></p>", "LKGCB to promote Nepal tourism in Belgium", "", "inherit", "closed", "closed", "", "114-revision-v1", "", "", "2017-02-27 17:31:35", "2017-02-27 17:31:35", "", "114", "http://localhost/lumbini/uncategorized/114-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("117", "1", "2016-09-23 17:31:51", "2016-09-23 17:31:51", "<p class=\"p1\"><span class=\"s1\">Kathmandu, Sept. 23: Preparations for the international conference on Lumbini to be organised in Brussels of Belgium on November 30 and December 1 are moving ahead on a war footing manner, the organising committee said.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The Lumbini-Kapilvastu Day Global Movement, an initiative formed at the people’s level, is going to organise the mega event on its seventh anniversary of establishment for promotion of Lumbini and to quash the rumours spread against the birthplace of Lord Buddha.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The movement has believed that successful completion of the conference would also help contribute to Nepal’s economy at large through tourism promotion.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The movement organised a discussions programme on Sunday in Brussels for launching the fundraising steps in an effective way as the total cost of the conference is estimated to be high, member of the conference main organising committee and Europe advisor of movement Damodar Prasad Acharya told RSS. Total cost of the seminar is estimated to be as high as 50,000 Euro.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">On the occasion, Advisor of the Non Resident Nepalis Association (NRNA) International Coordination Council Yubraj Gurung said that success of the conference refers to pride of Nepal and Nepalis living in Belgium.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Europe coordinator of NRNA International Coordination Council Arjun Kumar Shrestha, chairman of NRNA Belgium Gangadhar Gautam, chairman of Nepali People’s Progressive Forum Chitra Subedi, chairman of Nepali Samaj in Belgium Krishna Prasad Regmi, executive member of Belgium-Nepal Chamber of Commerce CP Bhatta, Jiban Gurung of Tamu Society Belgium and others attended the programme.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Acharya added that some Belgians would also be included in the main organising committee. A 23-member main organising committee under the leadership of Ram Kumar Shrestha (Australia) had already been formed by expanding the nine-member main organising committee formed earlier. RSS</span></p>", "Preparations for Int’l Conference on Lumbini on war footing", "", "publish", "open", "open", "", "preparations-for-intl-conference-on-lumbini-on-war-footing", "", "", "2017-02-27 17:32:49", "2017-02-27 17:32:49", "", "0", "http://localhost/lumbini/?p=117", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("118", "1", "2017-02-27 17:32:49", "2017-02-27 17:32:49", "<p class=\"p1\"><span class=\"s1\">Kathmandu, Sept. 23: Preparations for the international conference on Lumbini to be organised in Brussels of Belgium on November 30 and December 1 are moving ahead on a war footing manner, the organising committee said.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The Lumbini-Kapilvastu Day Global Movement, an initiative formed at the people’s level, is going to organise the mega event on its seventh anniversary of establishment for promotion of Lumbini and to quash the rumours spread against the birthplace of Lord Buddha.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The movement has believed that successful completion of the conference would also help contribute to Nepal’s economy at large through tourism promotion.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The movement organised a discussions programme on Sunday in Brussels for launching the fundraising steps in an effective way as the total cost of the conference is estimated to be high, member of the conference main organising committee and Europe advisor of movement Damodar Prasad Acharya told RSS. Total cost of the seminar is estimated to be as high as 50,000 Euro.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">On the occasion, Advisor of the Non Resident Nepalis Association (NRNA) International Coordination Council Yubraj Gurung said that success of the conference refers to pride of Nepal and Nepalis living in Belgium.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Europe coordinator of NRNA International Coordination Council Arjun Kumar Shrestha, chairman of NRNA Belgium Gangadhar Gautam, chairman of Nepali People’s Progressive Forum Chitra Subedi, chairman of Nepali Samaj in Belgium Krishna Prasad Regmi, executive member of Belgium-Nepal Chamber of Commerce CP Bhatta, Jiban Gurung of Tamu Society Belgium and others attended the programme.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Acharya added that some Belgians would also be included in the main organising committee. A 23-member main organising committee under the leadership of Ram Kumar Shrestha (Australia) had already been formed by expanding the nine-member main organising committee formed earlier. RSS</span></p>", "Preparations for Int’l Conference on Lumbini on war footing", "", "inherit", "closed", "closed", "", "117-revision-v1", "", "", "2017-02-27 17:32:49", "2017-02-27 17:32:49", "", "117", "http://localhost/lumbini/uncategorized/117-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("119", "1", "2017-02-27 17:34:14", "2017-02-27 17:34:14", "<p class=\"p1\"><span class=\"s1\">Brussels: The Lumbini-Kapilvastu Day Movement has submitted a memorandum to Prime Minister Sushil Koirala to inform the activities of the Movement.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Europe Advisor of the Lumbini-Kapilvastu Day Movement Damodar Prasad Acharya submitted the memorandum to Prime Minister Koirala in Brussels of Belgium last week on the PM\'s wat to home after addressing the United Nations 69th General Assembly.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">According to Acharya, the memorandum includes activities of the Movement for promotion of Lumbini, Nepal the birthplace of Gautam Buddha as well as attempts made for correcting misinformation disseminated in textbooks in different countries regarding the birthplace of Gautam Buddha.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">In the memorandum, coordination and cooperation of Nepal government had been sought for the success of the international conference which is going to be held in Brussels on the day of coming Buddha Purnima for the publicity and promotion of Lumbini.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">On the occasion, the Prime Minister was given a booklet that covers the major achievements of the Movement made so far.</span></p>", "Lumbini-Kapilvastu Day Movement submits memo to PM Koirala", "", "publish", "open", "open", "", "lumbini-kapilvastu-day-movement-submits-memo-to-pm-koirala", "", "", "2017-02-27 17:34:14", "2017-02-27 17:34:14", "", "0", "http://localhost/lumbini/?p=119", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("120", "1", "2017-02-27 17:34:14", "2017-02-27 17:34:14", "<p class=\"p1\"><span class=\"s1\">Brussels: The Lumbini-Kapilvastu Day Movement has submitted a memorandum to Prime Minister Sushil Koirala to inform the activities of the Movement.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Europe Advisor of the Lumbini-Kapilvastu Day Movement Damodar Prasad Acharya submitted the memorandum to Prime Minister Koirala in Brussels of Belgium last week on the PM\'s wat to home after addressing the United Nations 69th General Assembly.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">According to Acharya, the memorandum includes activities of the Movement for promotion of Lumbini, Nepal the birthplace of Gautam Buddha as well as attempts made for correcting misinformation disseminated in textbooks in different countries regarding the birthplace of Gautam Buddha.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">In the memorandum, coordination and cooperation of Nepal government had been sought for the success of the international conference which is going to be held in Brussels on the day of coming Buddha Purnima for the publicity and promotion of Lumbini.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">On the occasion, the Prime Minister was given a booklet that covers the major achievements of the Movement made so far.</span></p>", "Lumbini-Kapilvastu Day Movement submits memo to PM Koirala", "", "inherit", "closed", "closed", "", "119-revision-v1", "", "", "2017-02-27 17:34:14", "2017-02-27 17:34:14", "", "119", "http://localhost/lumbini/uncategorized/119-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2016-08-14 17:34:30", "2016-08-14 17:34:30", "<p class=\"p1\"><span class=\"s1\">KATHMANDU, Aug 14: The Lumbini-Kapilvastu Day Global Movement, an initiative formed at the people\'s level for the promotion of Lumbini, the birthplace of Lord Buddha, is going to organize an international-level conference in Brussels of Belgium on November 30 and December 1, 2015.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">A 23-member main organizing committee under the leadership of Ram Kumar Shrestha (Australia) has been formed by expanding the nine-member main organizing committee formed earlier, according to Damodar Prasad Acharya, a member of the Main Organizing Committee and Europe Advisor of the Movement.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The expanded committee comprises Nepalis living in Belgium and other European countries including Associate Professor Dr Bal Gopal Shrestha (Netherlands), Hari Prasad Poudel (Netherlands), Dr Yagya Adhikari (Germany) and Yubaraj Gurung (Belgium), among others.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">Likewise, Harihar Aryal (France), Hemanta Upadhyay (France), Dr Maheshwor Rupakheti (Germany), Dr Rabi Panta (UK), Dr Krishna Aryal (Norway), Prof Dr Krishna Panth (Norway) and Prof Dr Miroz Shakya (USA), among others are in the Main Organizing Committee.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">Acharya told RSS from Belgium that the European Commission\'s European Institution for Asian Studies based in Brussels has also pledged to support through sponsorship and sending delegates to attend the conference.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">Earlier, the proposed International Conference on Gautam Buddha to be held in Brussels on May 4-5 was called off due to the April 25 \'Gorkha Earthquake\' in Nepal. RSS</span></p>", "Int\'l conference on Lumbini to be organized in Brussels", "", "publish", "open", "open", "", "intl-conference-on-lumbini-to-be-organized-in-brussels", "", "", "2017-02-27 17:35:18", "2017-02-27 17:35:18", "", "0", "http://localhost/lumbini/?p=121", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("122", "1", "2017-02-27 17:35:18", "2017-02-27 17:35:18", "<p class=\"p1\"><span class=\"s1\">KATHMANDU, Aug 14: The Lumbini-Kapilvastu Day Global Movement, an initiative formed at the people\'s level for the promotion of Lumbini, the birthplace of Lord Buddha, is going to organize an international-level conference in Brussels of Belgium on November 30 and December 1, 2015.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">A 23-member main organizing committee under the leadership of Ram Kumar Shrestha (Australia) has been formed by expanding the nine-member main organizing committee formed earlier, according to Damodar Prasad Acharya, a member of the Main Organizing Committee and Europe Advisor of the Movement.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The expanded committee comprises Nepalis living in Belgium and other European countries including Associate Professor Dr Bal Gopal Shrestha (Netherlands), Hari Prasad Poudel (Netherlands), Dr Yagya Adhikari (Germany) and Yubaraj Gurung (Belgium), among others.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">Likewise, Harihar Aryal (France), Hemanta Upadhyay (France), Dr Maheshwor Rupakheti (Germany), Dr Rabi Panta (UK), Dr Krishna Aryal (Norway), Prof Dr Krishna Panth (Norway) and Prof Dr Miroz Shakya (USA), among others are in the Main Organizing Committee.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">Acharya told RSS from Belgium that the European Commission\'s European Institution for Asian Studies based in Brussels has also pledged to support through sponsorship and sending delegates to attend the conference.</span><span class=\"s2\">\r\n\r\n</span><span class=\"s1\">Earlier, the proposed International Conference on Gautam Buddha to be held in Brussels on May 4-5 was called off due to the April 25 \'Gorkha Earthquake\' in Nepal. RSS</span></p>", "Int\'l conference on Lumbini to be organized in Brussels", "", "inherit", "closed", "closed", "", "121-revision-v1", "", "", "2017-02-27 17:35:18", "2017-02-27 17:35:18", "", "121", "http://localhost/lumbini/uncategorized/121-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("123", "1", "2016-02-07 17:35:43", "2016-02-07 17:35:43", "<p class=\"p1\"><span class=\"s1\">Feb 7, 2016- Teria Phauja Magar, an exceptionally brilliant Nepali dancer and winner of the ‘Dance India Dance Little Master-2014’ was felicitated in Belgium recently. </span><span class=\"s2\">\r\n</span><span class=\"s1\">Magar, who reached Belgium at the invitation of the World Magar Association, Belgium chapter, is also the peace ambassador of the Lumbini-Kapilvastu Day Movement. </span><span class=\"s2\">\r\n</span><span class=\"s1\">Europe Advisor of the Movement, Damodar Prasad Acharya, honoured Magar at a special cultural programme organised by the Association at Leuven in Belgium. </span><span class=\"s2\">\r\n</span><span class=\"s1\">On the occasion, Magar handed over a Buddha statute to Chairman of World Magar Association, Belgium, Marke Magar. </span><span class=\"s2\">\r\n</span><span class=\"s1\">Chief of social works and students department at Leuven Municipality Bike Borlinden, Chairman of Himalayan Project Paul Vann, Secretary of NRN Arjun Kumar Shrestha, NRN ICC members Chij Kumar Shrestha, Netra Magar, Janaki Gurung and representatives of different social organisations of Nepalis based in Belgium were present during the event. </span><span class=\"s2\">\r\n</span><span class=\"s1\">The Association has said that the amount collected in the cultural programme would be provided to the earthquake survivors in Gorkha district. RSS</span></p>", "Teria Magar honored in Belgium", "", "publish", "open", "open", "", "teria-magar-honored-in-belgium", "", "", "2017-02-27 17:37:20", "2017-02-27 17:37:20", "", "0", "http://localhost/lumbini/?p=123", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2017-02-27 17:36:50", "2017-02-27 17:36:50", "", "main-logo", "", "inherit", "open", "closed", "", "main-logo", "", "", "2017-02-27 17:36:52", "2017-02-27 17:36:52", "", "123", "http://localhost/lumbini/wp-content/uploads/2017/02/main-logo.gif", "0", "attachment", "image/gif", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2017-02-27 17:37:00", "2017-02-27 17:37:00", "", "0702201612005020150216teriya-rocks-bardiya-600x0-1000x0", "", "inherit", "open", "closed", "", "0702201612005020150216teriya-rocks-bardiya-600x0-1000x0", "", "", "2017-02-27 17:37:00", "2017-02-27 17:37:00", "", "123", "http://localhost/lumbini/wp-content/uploads/2017/02/0702201612005020150216teriya-rocks-bardiya-600x0-1000x0.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("126", "1", "2017-02-27 17:37:20", "2017-02-27 17:37:20", "<p class=\"p1\"><span class=\"s1\">Feb 7, 2016- Teria Phauja Magar, an exceptionally brilliant Nepali dancer and winner of the ‘Dance India Dance Little Master-2014’ was felicitated in Belgium recently. </span><span class=\"s2\">\r\n</span><span class=\"s1\">Magar, who reached Belgium at the invitation of the World Magar Association, Belgium chapter, is also the peace ambassador of the Lumbini-Kapilvastu Day Movement. </span><span class=\"s2\">\r\n</span><span class=\"s1\">Europe Advisor of the Movement, Damodar Prasad Acharya, honoured Magar at a special cultural programme organised by the Association at Leuven in Belgium. </span><span class=\"s2\">\r\n</span><span class=\"s1\">On the occasion, Magar handed over a Buddha statute to Chairman of World Magar Association, Belgium, Marke Magar. </span><span class=\"s2\">\r\n</span><span class=\"s1\">Chief of social works and students department at Leuven Municipality Bike Borlinden, Chairman of Himalayan Project Paul Vann, Secretary of NRN Arjun Kumar Shrestha, NRN ICC members Chij Kumar Shrestha, Netra Magar, Janaki Gurung and representatives of different social organisations of Nepalis based in Belgium were present during the event. </span><span class=\"s2\">\r\n</span><span class=\"s1\">The Association has said that the amount collected in the cultural programme would be provided to the earthquake survivors in Gorkha district. RSS</span></p>", "Teria Magar honored in Belgium", "", "inherit", "closed", "closed", "", "123-revision-v1", "", "", "2017-02-27 17:37:20", "2017-02-27 17:37:20", "", "123", "http://localhost/lumbini/uncategorized/123-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("127", "1", "2017-02-27 17:38:49", "2017-02-27 17:38:49", "", "SONY DSC", "SONY DSC", "inherit", "open", "closed", "", "sony-dsc", "", "", "2017-02-27 17:38:55", "2017-02-27 17:38:55", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/Group_pic_in_Intl_Conference.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2017-02-27 17:38:50", "2017-02-27 17:38:50", "", "Presenting_a_letter_to_the_director_of_UNESCO_Benelux_Salvatore_Mineo", "", "inherit", "open", "closed", "", "presenting_a_letter_to_the_director_of_unesco_benelux_salvatore_mineo", "", "", "2017-02-27 17:38:50", "2017-02-27 17:38:50", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/Presenting_a_letter_to_the_director_of_UNESCO_Benelux_Salvatore_Mineo.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("129", "1", "2017-02-27 17:38:51", "2017-02-27 17:38:51", "", "Presenting_memorandom_letter_to_that_time_prime_minister_Sushil_Koirala", "", "inherit", "open", "closed", "", "presenting_memorandom_letter_to_that_time_prime_minister_sushil_koirala", "", "", "2017-02-27 17:38:51", "2017-02-27 17:38:51", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/Presenting_memorandom_letter_to_that_time_prime_minister_Sushil_Koirala.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2017-02-27 17:38:51", "2017-02-27 17:38:51", "", "Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute", "", "inherit", "open", "closed", "", "prsenting_buddha-statue_to_the_director_of_norwegian_nobel_institute", "", "", "2017-02-27 17:38:51", "2017-02-27 17:38:51", "", "0", "http://localhost/lumbini/wp-content/uploads/2017/02/Prsenting_Buddha-statue_to_the_director_of_Norwegian_Nobel_Institute.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("131", "1", "2017-02-27 17:42:09", "2017-02-27 17:42:09", "<p class=\"p1\"><span class=\"s1\">Since its inceptionin 2009, Lumbini-Kapilvastu Global Campaign is a global movement of more than 19 national level committees in 19 countries and 21 members global committee with 9 prominent advisers. Lumbini-Kapilvastu Global Campaign, Belgium is one of among 19 national level committees.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The national committee is an independent body to act in national level for social and cultural activities; and it does not belong to any political and religious believes. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">We are campaigning for a world where peace and harmony are enjoyed by all.<span class=\"Apple-converted-space\">  </span>All views, thoughts, opinions and materials published are purely for information purposes only and we intend to remain fair and balanced for a better world.</span></p>\r\n<p class=\"p1\"><span class=\"s1\"><b>Vision and Mission: </b></span></p>\r\n\r\n<ul>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote the peace and non-violence message of Buddha for world peace.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote and highlight Lumbini, Nepal the birth place of Buddha worldwide toprovide truthful information regarding the misinformation on Buddha’s birth place for betterment of Nepal.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">Humanitarian help in the emergency.</span></li>\r\n</ul>\r\n<p class=\"p1\"><span class=\"s1\"><b>What we do:</b></span></p>\r\n<p class=\"p1\"><span class=\"s1\">To promote peace and non-violence message of Buddha and highlight Lumbini, Nepal as World Peace City, we are organizing conference, seminar, interaction program, info stall, street demonstration, and peace march.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">We also organize social and cultural activities to raise the fund for humanitarian help in emergency situation caused by natural disaster.</span></p>\r\n<p class=\"p1\"><span class=\"s1\"><b>Working with:</b></span></p>\r\n<p class=\"p1\"><span class=\"s1\">Lumbini Development Trust, the government of Nepal</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Active Intercultural Federation, Belgium VZW</span></p>", "Who we are", "", "inherit", "closed", "closed", "", "56-revision-v1", "", "", "2017-02-27 17:42:09", "2017-02-27 17:42:09", "", "56", "http://localhost/lumbini/uncategorized/56-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("132", "1", "2017-02-27 17:43:51", "2017-02-27 17:43:51", " ", "", "", "publish", "closed", "closed", "", "132", "", "", "2017-02-27 17:43:51", "2017-02-27 17:43:51", "", "0", "http://localhost/lumbini/?p=132", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("133", "1", "2017-02-27 17:43:14", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2017-02-27 17:43:14", "0000-00-00 00:00:00", "", "56", "http://localhost/lumbini/?p=133", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("134", "1", "2017-02-27 17:43:14", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2017-02-27 17:43:14", "0000-00-00 00:00:00", "", "56", "http://localhost/lumbini/?p=134", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("135", "1", "2017-02-27 17:52:59", "2017-02-27 17:52:59", "a:7:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:4:\"page\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:2:\"27\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";a:1:{i:0;s:11:\"the_content\";}s:11:\"description\";s:0:\"\";}", "Members", "members", "publish", "closed", "closed", "", "group_58b465fed2213", "", "", "2017-03-04 12:07:07", "2017-03-04 12:07:07", "", "0", "http://localhost/lumbini/?post_type=acf-field-group&#038;p=135", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2017-02-27 17:52:59", "2017-02-27 17:52:59", "a:10:{s:4:\"type\";s:8:\"repeater\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"collapsed\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"layout\";s:5:\"table\";s:12:\"button_label\";s:0:\"\";}", "Executive Board", "executive_board", "publish", "closed", "closed", "", "field_58b4664885603", "", "", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "", "135", "http://localhost/lumbini/?post_type=acf-field&#038;p=136", "1", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("137", "1", "2017-02-27 17:52:59", "2017-02-27 17:52:59", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Name", "name", "publish", "closed", "closed", "", "field_58b466ad85607", "", "", "2017-02-27 17:52:59", "2017-02-27 17:52:59", "", "136", "http://localhost/lumbini/?post_type=acf-field&p=137", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("138", "1", "2017-02-27 17:52:59", "2017-02-27 17:52:59", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Designation", "designation", "publish", "closed", "closed", "", "field_58b466b285608", "", "", "2017-02-27 17:52:59", "2017-02-27 17:52:59", "", "136", "http://localhost/lumbini/?post_type=acf-field&p=138", "1", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("139", "1", "2017-02-27 17:52:59", "2017-02-27 17:52:59", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:3:\"url\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "Image", "image", "publish", "closed", "closed", "", "field_58b466b985609", "", "", "2017-02-27 17:53:56", "2017-02-27 17:53:56", "", "136", "http://localhost/lumbini/?post_type=acf-field&#038;p=139", "2", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("141", "1", "2017-02-27 17:53:32", "2017-02-27 17:53:32", "", "Board of Directors", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2017-02-27 17:53:32", "2017-02-27 17:53:32", "", "27", "http://localhost/lumbini/uncategorized/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("142", "1", "2017-02-27 17:54:27", "2017-02-27 17:54:27", "", "02 Vice-President, Ms Anita Lama", "", "inherit", "open", "closed", "", "02-vice-president-ms-anita-lama", "", "", "2017-03-04 12:07:24", "2017-03-04 12:07:24", "", "27", "http://localhost/lumbini/wp-content/uploads/2017/02/02-Vice-President-Ms-Anita-Lama.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("143", "1", "2017-02-27 17:54:27", "2017-02-27 17:54:27", "", "03 General Secretary, Mr. Nanda Raj Ghale", "", "inherit", "open", "closed", "", "03-general-secretary-mr-nanda-raj-ghale", "", "", "2017-02-27 17:54:27", "2017-02-27 17:54:27", "", "27", "http://localhost/lumbini/wp-content/uploads/2017/02/03-General-Secretary-Mr.-Nanda-Raj-Ghale.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("144", "1", "2017-02-27 17:54:27", "2017-02-27 17:54:27", "", "04 Secretary, Mr. Geert Catrysse", "", "inherit", "open", "closed", "", "04-secretary-mr-geert-catrysse", "", "", "2017-03-02 02:22:17", "2017-03-02 02:22:17", "", "27", "http://localhost/lumbini/wp-content/uploads/2017/02/04-Secretary-Mr.-Geert-Catrysse.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("145", "1", "2017-02-27 17:54:28", "2017-02-27 17:54:28", "", "05 Treasurer, Mr. Baburam Sharma", "", "inherit", "open", "closed", "", "05-treasurer-mr-baburam-sharma", "", "", "2017-02-27 17:54:28", "2017-02-27 17:54:28", "", "27", "http://localhost/lumbini/wp-content/uploads/2017/02/05-Treasurer-Mr.-Baburam-Sharma.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("146", "1", "2017-02-27 17:54:29", "2017-02-27 17:54:29", "", "06 Executive Member, Ms Seema Subedi", "", "inherit", "open", "closed", "", "06-executive-member-ms-seema-subedi", "", "", "2017-03-04 02:52:42", "2017-03-04 02:52:42", "", "27", "http://localhost/lumbini/wp-content/uploads/2017/02/06-Executive-Member-Ms-Seema-Subedi.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("147", "1", "2017-02-27 17:54:29", "2017-02-27 17:54:29", "", "01 President Mr. Damodar Prasad Acharya", "", "inherit", "open", "closed", "", "01-president-mr-damodar-prasad-acharya", "", "", "2017-02-28 16:15:24", "2017-02-28 16:15:24", "", "27", "http://localhost/lumbini/wp-content/uploads/2017/02/01-President-Mr.-Damodar-Prasad-Acharya.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("148", "1", "2017-02-27 18:01:15", "2017-02-27 18:01:15", "", "Board of Directors", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2017-02-27 18:01:15", "2017-02-27 18:01:15", "", "27", "http://localhost/lumbini/uncategorized/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("149", "1", "2017-02-27 18:08:06", "2017-02-27 18:08:06", "https://www.youtube.com/watch?v=QDkT-sYUGvw", "World Peace City Lumbini, Nepal - International Conference 06", "", "publish", "open", "open", "", "world-peace-city-lumbini-nepal-international-conference-06", "", "", "2017-02-27 18:08:06", "2017-02-27 18:08:06", "", "0", "http://localhost/lumbini/?p=149", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("150", "1", "2017-02-27 18:08:06", "2017-02-27 18:08:06", "https://www.youtube.com/watch?v=QDkT-sYUGvw", "World Peace City Lumbini, Nepal - International Conference 06", "", "inherit", "closed", "closed", "", "149-revision-v1", "", "", "2017-02-27 18:08:06", "2017-02-27 18:08:06", "", "149", "http://localhost/lumbini/uncategorized/149-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("151", "1", "2017-02-27 18:08:07", "2017-02-27 18:08:07", "", "World Peace City Lumbini, Nepal &#8211; International Conference 06", "", "inherit", "open", "closed", "", "world-peace-city-lumbini-nepal-international-conference-06-2", "", "", "2017-02-27 18:08:07", "2017-02-27 18:08:07", "", "149", "http://localhost/lumbini/wp-content/uploads/2017/02/https-www-youtube-com-watch-v-qdkt-syugvw.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("152", "1", "2017-02-27 18:08:47", "2017-02-27 18:08:47", "https://www.youtube.com/watch?v=R3ogqFUjYQo", "World Peace City Lumbini, Nepal - International Conference 07", "", "publish", "open", "open", "", "world-peace-city-lumbini-nepal-international-conference-07", "", "", "2017-02-27 18:08:47", "2017-02-27 18:08:47", "", "0", "http://localhost/lumbini/?p=152", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("153", "1", "2017-02-27 18:08:47", "2017-02-27 18:08:47", "https://www.youtube.com/watch?v=R3ogqFUjYQo", "World Peace City Lumbini, Nepal - International Conference 07", "", "inherit", "closed", "closed", "", "152-revision-v1", "", "", "2017-02-27 18:08:47", "2017-02-27 18:08:47", "", "152", "http://localhost/lumbini/uncategorized/152-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("154", "1", "2017-02-27 18:08:50", "2017-02-27 18:08:50", "", "World Peace City Lumbini, Nepal &#8211; International Conference 07", "", "inherit", "open", "closed", "", "world-peace-city-lumbini-nepal-international-conference-07-2", "", "", "2017-02-27 18:08:50", "2017-02-27 18:08:50", "", "152", "http://localhost/lumbini/wp-content/uploads/2017/02/world-peace-city-lumbini-nepal-8211-international-conference-07.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("155", "1", "2017-02-27 18:09:18", "2017-02-27 18:09:18", "https://www.youtube.com/watch?v=7Y_KH4VtSgk", "World Peace City Lumbini, Nepal - International Conference 08", "", "publish", "open", "open", "", "world-peace-city-lumbini-nepal-international-conference-08", "", "", "2017-02-27 18:11:13", "2017-02-27 18:11:13", "", "0", "http://localhost/lumbini/?p=155", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("156", "1", "2017-02-27 18:09:18", "2017-02-27 18:09:18", "https://www.youtube.com/watch?v=QDkT-sYUGvw&t=7s", "World Peace City Lumbini, Nepal - International Conference 06", "", "inherit", "closed", "closed", "", "155-revision-v1", "", "", "2017-02-27 18:09:18", "2017-02-27 18:09:18", "", "155", "http://localhost/lumbini/uncategorized/155-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("157", "1", "2017-02-27 18:09:19", "2017-02-27 18:09:19", "", "World Peace City Lumbini, Nepal &#8211; International Conference 06", "", "inherit", "open", "closed", "", "world-peace-city-lumbini-nepal-international-conference-06-3", "", "", "2017-02-27 18:09:19", "2017-02-27 18:09:19", "", "155", "http://localhost/lumbini/wp-content/uploads/2017/02/auto-draft.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("158", "1", "2017-02-27 18:10:39", "2017-02-27 18:10:39", "https://www.youtube.com/watch?v=7Y_KH4VtSgk", "World Peace City Lumbini, Nepal - International Conference 08", "", "inherit", "closed", "closed", "", "155-revision-v1", "", "", "2017-02-27 18:10:39", "2017-02-27 18:10:39", "", "155", "http://localhost/lumbini/uncategorized/155-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("159", "1", "2017-02-27 18:11:15", "2017-02-27 18:11:15", "", "World Peace City Lumbini, Nepal &#8211; International Conference 08", "", "inherit", "open", "closed", "", "world-peace-city-lumbini-nepal-international-conference-08-2", "", "", "2017-02-27 18:11:15", "2017-02-27 18:11:15", "", "155", "http://localhost/lumbini/wp-content/uploads/2017/02/world-peace-city-lumbini-nepal-8211-international-conference-08.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("160", "1", "2017-02-27 18:48:48", "2017-02-27 18:48:48", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Image Caption", "image_caption", "publish", "closed", "closed", "", "field_58b4748644190", "", "", "2017-02-27 18:48:48", "2017-02-27 18:48:48", "", "17", "http://localhost/lumbini/?post_type=acf-field&p=160", "3", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("161", "1", "2017-02-27 18:54:46", "2017-02-27 18:54:46", " ", "", "", "publish", "closed", "closed", "", "161", "", "", "2017-02-27 18:54:46", "2017-02-27 18:54:46", "", "0", "http://localhost/lumbini/?p=161", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("162", "1", "2017-02-28 15:48:35", "2017-02-28 15:48:35", "a:7:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:11:\"testimonial\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";a:14:{i:0;s:11:\"the_content\";i:1;s:7:\"excerpt\";i:2;s:13:\"custom_fields\";i:3;s:10:\"discussion\";i:4;s:8:\"comments\";i:5;s:9:\"revisions\";i:6;s:4:\"slug\";i:7;s:6:\"author\";i:8;s:6:\"format\";i:9;s:15:\"page_attributes\";i:10;s:14:\"featured_image\";i:11;s:10:\"categories\";i:12;s:4:\"tags\";i:13;s:15:\"send-trackbacks\";}s:11:\"description\";s:0:\"\";}", "Testimonial", "testimonial", "publish", "closed", "closed", "", "group_58b59bcb90daf", "", "", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "", "0", "http://localhost/lumbini/?post_type=acf-field-group&#038;p=162", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("163", "1", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "a:10:{s:4:\"type\";s:8:\"textarea\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";s:4:\"rows\";s:0:\"\";s:9:\"new_lines\";s:7:\"wpautop\";}", "Testimonial", "testimonial", "publish", "closed", "closed", "", "field_58b59bd9f69a9", "", "", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "", "162", "http://localhost/lumbini/?post_type=acf-field&p=163", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("164", "1", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "a:15:{s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:3:\"url\";s:12:\"preview_size\";s:9:\"thumbnail\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";}", "Image", "image", "publish", "closed", "closed", "", "field_58b59be6f69aa", "", "", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "", "162", "http://localhost/lumbini/?post_type=acf-field&p=164", "1", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("165", "1", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Name", "name", "publish", "closed", "closed", "", "field_58b59bf7f69ab", "", "", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "", "162", "http://localhost/lumbini/?post_type=acf-field&p=165", "2", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("166", "1", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Designation", "designation", "publish", "closed", "closed", "", "field_58b59c06f69ac", "", "", "2017-02-28 15:49:46", "2017-02-28 15:49:46", "", "162", "http://localhost/lumbini/?post_type=acf-field&p=166", "3", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("167", "1", "2017-02-28 16:35:35", "2017-02-28 16:35:35", "", "Testi One", "", "trash", "closed", "closed", "", "testi-one__trashed", "", "", "2017-03-04 03:50:34", "2017-03-04 03:50:34", "", "0", "http://localhost/lumbini/?post_type=testimonial&#038;p=167", "0", "testimonial", "", "0");
INSERT INTO `wp_posts` VALUES("168", "1", "2017-03-02 02:22:46", "2017-03-02 02:22:46", "", "Testi 2", "", "trash", "closed", "closed", "", "testi-2__trashed", "", "", "2017-03-04 03:50:32", "2017-03-04 03:50:32", "", "0", "http://localhost/lumbini/?post_type=testimonial&#038;p=168", "0", "testimonial", "", "0");
INSERT INTO `wp_posts` VALUES("169", "1", "2017-03-04 02:52:35", "2017-03-04 02:52:35", "", "Ned thehnd", "", "trash", "closed", "closed", "", "__trashed", "", "", "2017-03-04 03:50:30", "2017-03-04 03:50:30", "", "0", "http://localhost/lumbini/?post_type=testimonial&#038;p=169", "0", "testimonial", "", "0");
INSERT INTO `wp_posts` VALUES("170", "1", "2017-03-04 04:01:42", "2017-03-04 04:01:42", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Donate Now Text", "donate_now_text", "publish", "closed", "closed", "", "field_58ba3bebe3168", "", "", "2017-03-04 04:01:42", "2017-03-04 04:01:42", "", "17", "http://localhost/lumbini/?post_type=acf-field&p=170", "4", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("171", "1", "2017-03-04 04:01:42", "2017-03-04 04:01:42", "a:10:{s:4:\"type\";s:9:\"page_link\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"post_type\";a:1:{i:0;s:4:\"page\";}s:8:\"taxonomy\";a:0:{}s:10:\"allow_null\";i:0;s:14:\"allow_archives\";i:1;s:8:\"multiple\";i:0;}", "Donate now link", "donate_now_link", "publish", "closed", "closed", "", "field_58ba3bf7e3169", "", "", "2017-03-04 04:01:42", "2017-03-04 04:01:42", "", "17", "http://localhost/lumbini/?post_type=acf-field&p=171", "5", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("172", "1", "2017-03-04 05:30:03", "2017-03-04 05:30:03", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Donate Now Subtext", "donate_now_subtext", "publish", "closed", "closed", "", "field_58ba50d331754", "", "", "2017-03-04 05:32:07", "2017-03-04 05:32:07", "", "17", "http://localhost/lumbini/?post_type=acf-field&#038;p=172", "6", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("173", "1", "2017-03-04 08:41:05", "2017-03-04 08:41:05", "<p class=\"p1\"><span class=\"s1\">Since its inceptionin 2009, Lumbini-Kapilvastu Global Campaign is a global movement of more than 19 national level committees in 19 countries and 21 members global committee with 9 prominent advisers. Lumbini-Kapilvastu Global Campaign, Belgium is one of among 19 national level committees.</span></p>\n<p class=\"p1\"><span class=\"s1\">The national committee is an independent body to act in national level for social and cultural activities; and it does not belong to any political and religious believes. </span></p>\n<p class=\"p1\"><span class=\"s1\">We are campaigning for a world where peace and harmony are enjoyed by all.<span class=\"Apple-converted-space\">  </span>All views, thoughts, opinions and materials published are purely for information purposes only and we intend to remain fair and balanced for a better world.</span></p>\n\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\"><b>Vision and Mission</b></span></h2>\n<ul>\n 	<li class=\"li1\"><span class=\"s1\">To promote the peace and non-violence message of Buddha for world peace.</span></li>\n 	<li class=\"li1\"><span class=\"s1\">To promote and highlight Lumbini, Nepal the birth place of Buddha worldwide toprovide truthful information regarding the misinformation on Buddha’s birth place for betterment of Nepal.</span></li>\n 	<li class=\"li1\"><span class=\"s1\">Humanitarian help in the emergency.</span></li>\n</ul>\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\"><b>What we do</b></span></h2>\n<p class=\"p1\"><span class=\"s1\">To promote peace and non-violence message of Buddha and highlight Lumbini, Nepal as World Peace City, we are organizing conference, seminar, interaction program, info stall, street demonstration, and peace march.</span></p>\n<p class=\"p1\"><span class=\"s1\">We also organize social and cultural activities to raise the fund for humanitarian help in emergency situation caused by natural disaster.</span></p>\n\n<h2 class=\"p1\"><span class=\"s1\"><b>Working with</b></span></h2>\n<p class=\"p1\"><span class=\"s1\">Lumbini Development Trust, the government of Nepal</span></p>\n<p class=\"p1\"><span class=\"s1\">Active Intercultural Federation, Belgium VZW</span></p>", "Who we are", "", "inherit", "closed", "closed", "", "56-autosave-v1", "", "", "2017-03-04 08:41:05", "2017-03-04 08:41:05", "", "56", "http://localhost/lumbini/uncategorized/56-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("174", "1", "2017-03-04 08:38:02", "2017-03-04 08:38:02", "<p class=\"p1\"><span class=\"s1\">Since its inceptionin 2009, Lumbini-Kapilvastu Global Campaign is a global movement of more than 19 national level committees in 19 countries and 21 members global committee with 9 prominent advisers. Lumbini-Kapilvastu Global Campaign, Belgium is one of among 19 national level committees.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The national committee is an independent body to act in national level for social and cultural activities; and it does not belong to any political and religious believes. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">We are campaigning for a world where peace and harmony are enjoyed by all.<span class=\"Apple-converted-space\">  </span>All views, thoughts, opinions and materials published are purely for information purposes only and we intend to remain fair and balanced for a better world.</span></p>\r\n\r\n<h2 class=\"p1\"><span class=\"s1\"><b>Vision and Mission: </b></span></h2>\r\n<ul>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote the peace and non-violence message of Buddha for world peace.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote and highlight Lumbini, Nepal the birth place of Buddha worldwide toprovide truthful information regarding the misinformation on Buddha’s birth place for betterment of Nepal.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">Humanitarian help in the emergency.</span></li>\r\n</ul>\r\n<h2 class=\"p1\"><span class=\"s1\"><b>What we do:</b></span></h2>\r\n<p class=\"p1\"><span class=\"s1\">To promote peace and non-violence message of Buddha and highlight Lumbini, Nepal as World Peace City, we are organizing conference, seminar, interaction program, info stall, street demonstration, and peace march.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">We also organize social and cultural activities to raise the fund for humanitarian help in emergency situation caused by natural disaster.</span></p>\r\n\r\n<h2 class=\"p1\"><span class=\"s1\"><b>Working with:</b></span></h2>\r\n<p class=\"p1\"><span class=\"s1\">Lumbini Development Trust, the government of Nepal</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Active Intercultural Federation, Belgium VZW</span></p>", "Who we are", "", "inherit", "closed", "closed", "", "56-revision-v1", "", "", "2017-03-04 08:38:02", "2017-03-04 08:38:02", "", "56", "http://localhost/lumbini/uncategorized/56-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("175", "1", "2017-03-04 08:41:06", "2017-03-04 08:41:06", "<p class=\"p1\"><span class=\"s1\">Since its inceptionin 2009, Lumbini-Kapilvastu Global Campaign is a global movement of more than 19 national level committees in 19 countries and 21 members global committee with 9 prominent advisers. Lumbini-Kapilvastu Global Campaign, Belgium is one of among 19 national level committees.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The national committee is an independent body to act in national level for social and cultural activities; and it does not belong to any political and religious believes. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">We are campaigning for a world where peace and harmony are enjoyed by all.<span class=\"Apple-converted-space\">  </span>All views, thoughts, opinions and materials published are purely for information purposes only and we intend to remain fair and balanced for a better world.</span></p>\r\n\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\"><b>Vision and Mission</b></span></h2>\r\n<ul>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote the peace and non-violence message of Buddha for world peace.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote and highlight Lumbini, Nepal the birth place of Buddha worldwide toprovide truthful information regarding the misinformation on Buddha’s birth place for betterment of Nepal.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">Humanitarian help in the emergency.</span></li>\r\n</ul>\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\"><b>What we do</b></span></h2>\r\n<p class=\"p1\"><span class=\"s1\">To promote peace and non-violence message of Buddha and highlight Lumbini, Nepal as World Peace City, we are organizing conference, seminar, interaction program, info stall, street demonstration, and peace march.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">We also organize social and cultural activities to raise the fund for humanitarian help in emergency situation caused by natural disaster.</span></p>\r\n\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\"><b>Working with</b></span></h2>\r\n<p class=\"p1\"><span class=\"s1\">Lumbini Development Trust, the government of Nepal</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Active Intercultural Federation, Belgium VZW</span></p>", "Who we are", "", "inherit", "closed", "closed", "", "56-revision-v1", "", "", "2017-03-04 08:41:06", "2017-03-04 08:41:06", "", "56", "http://localhost/lumbini/uncategorized/56-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("176", "1", "2017-03-04 08:45:57", "2017-03-04 08:45:57", "<p class=\"p1\"><span class=\"s1\">Since its inceptionin 2009, Lumbini-Kapilvastu Global Campaign is a global movement of more than 19 national level committees in 19 countries and 21 members global committee with 9 prominent advisers. Lumbini-Kapilvastu Global Campaign, Belgium is one of among 19 national level committees.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">The national committee is an independent body to act in national level for social and cultural activities; and it does not belong to any political and religious believes. </span></p>\r\n<p class=\"p1\"><span class=\"s1\">We are campaigning for a world where peace and harmony are enjoyed by all.<span class=\"Apple-converted-space\">  </span>All views, thoughts, opinions and materials published are purely for information purposes only and we intend to remain fair and balanced for a better world.</span></p>\r\n\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\">Vision and Mission</span></h2>\r\n<ul>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote the peace and non-violence message of Buddha for world peace.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">To promote and highlight Lumbini, Nepal the birth place of Buddha worldwide toprovide truthful information regarding the misinformation on Buddha’s birth place for betterment of Nepal.</span></li>\r\n 	<li class=\"li1\"><span class=\"s1\">Humanitarian help in the emergency.</span></li>\r\n</ul>\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\">What we do</span></h2>\r\n<p class=\"p1\"><span class=\"s1\">To promote peace and non-violence message of Buddha and highlight Lumbini, Nepal as World Peace City, we are organizing conference, seminar, interaction program, info stall, street demonstration, and peace march.</span></p>\r\n<p class=\"p1\"><span class=\"s1\">We also organize social and cultural activities to raise the fund for humanitarian help in emergency situation caused by natural disaster.</span></p>\r\n\r\n<h2 class=\"p1\" style=\"text-align: center;\"><span class=\"s1\">Working with</span></h2>\r\n<p class=\"p1\"><span class=\"s1\">Lumbini Development Trust, the government of Nepal</span></p>\r\n<p class=\"p1\"><span class=\"s1\">Active Intercultural Federation, Belgium VZW</span></p>", "Who we are", "", "inherit", "closed", "closed", "", "56-revision-v1", "", "", "2017-03-04 08:45:57", "2017-03-04 08:45:57", "", "56", "http://localhost/lumbini/uncategorized/56-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("177", "1", "2017-03-04 09:58:50", "2017-03-04 09:58:50", "lkjhflhslfhs", "Board of Directors", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2017-03-04 09:58:50", "2017-03-04 09:58:50", "", "27", "http://localhost/lumbini/uncategorized/27-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("178", "1", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "a:7:{s:4:\"type\";s:3:\"tab\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"placement\";s:3:\"top\";s:8:\"endpoint\";i:0;}", "Executive Board", "", "publish", "closed", "closed", "", "field_58baac58ddd34", "", "", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "", "135", "http://localhost/lumbini/?post_type=acf-field&p=178", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("179", "1", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "a:7:{s:4:\"type\";s:3:\"tab\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"placement\";s:3:\"top\";s:8:\"endpoint\";i:0;}", "Member", "", "publish", "closed", "closed", "", "field_58baaceeddd39", "", "", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "", "135", "http://localhost/lumbini/?post_type=acf-field&p=179", "2", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("180", "1", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "a:10:{s:4:\"type\";s:8:\"repeater\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"collapsed\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"layout\";s:5:\"table\";s:12:\"button_label\";s:0:\"\";}", "Member", "member", "publish", "closed", "closed", "", "field_58baacd6ddd35", "", "", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "", "135", "http://localhost/lumbini/?post_type=acf-field&p=180", "3", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("181", "1", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}", "Name", "name", "publish", "closed", "closed", "", "field_58baacd6ddd36", "", "", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "", "180", "http://localhost/lumbini/?post_type=acf-field&p=181", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("182", "1", "2017-03-04 12:06:37", "2017-03-04 12:06:37", "a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\