<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?>

<footer id="colophon" class="site-footer" role="contentinfo">
	<div class="row">
		<div class="medium-3 column">
			<div class="block-title">About Us</div>

			<nav class="footer-menu" aria-label="<?php _e( 'About Menu', 'lumbini' ); ?>">
				<?php wp_nav_menu( array(
					'menu'        => 'About Menu',
					'menu_class'	 => 'vertical menu white-text'
				) ); ?>
			</nav>
		</div>


		
	<div class="medium-3 column">

		<?php if ( has_nav_menu( 'social' ) ) : ?>
			<nav class="social-navigation" role="navigation" aria-label="<?php _e( 'Footer Social Links Menu', 'lumbini' ); ?>">
				<?php
					wp_nav_menu( array(
						'theme_location' => 'social',
						'menu_class'     => 'social-links-menu menu',
						'depth'          => 1,
						'link_before'    => '<span class="show-for-sr">',
						'link_after'     => '</span>',
					) );
				?>
			</nav><!-- .social-navigation -->
		<?php endif;?>
	</div>
	<div class="clearfix"></div> 
	
	<?php $partners = [ 'image','name'];
	// check if the repeater field has rows of data

	if( have_rows('partners','option') ):?>
	        <?php

	        // loop through the rows of data
	        while ( have_rows('partners','option') ) : the_row();
	            foreach ($partners as $v) {
	                $$v = get_sub_field( $v, 'option' );
	            }?>

	            <div class="medium-3 column end partner-org">
	            	
	                	<div class="partner-org__img small-4 float-left"><img src="<?php echo $image;?>" alt=""></div>
	                	<div class="small-8 float-left"><p><?php echo $name;?></p></div>
	             
	            </div>
	        <?php endwhile;?>
	  
	<?php else :

	    // no rows found

	endif;?>

	<?php get_template_part( 'template-parts/footer/site', 'info' );?>

	</div>
</footer>
<!-- Go to www.addthis.com/dashboard to customize your tools --> 
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-58bbc1fd50eb0208"></script> 
<?php wp_footer(); ?>

</body>
</html>
