<?php
/**
 * The front page template file
 *
 */

get_header(); ?>

<section class="section--front-page">
	<div class="row">

		<div class="column medium-8">
			<?php get_template_part( 'template-parts/page/content', 'slider' );?>
		</div>
		<div class="column medium-4">

			<?php

			$post_object = get_field('message', 'option');

			if( $post_object ): 

				$post = $post_object;
				setup_postdata( $post ); 

				get_template_part( 'template-parts/page/content', 'front-page' );

				wp_reset_postdata();
			endif;?>
		</div>
	</div>
</section>

<section>
	<div class="row">

		<div class="column medium-4">

			<?php 
				$cat = "news-and-updates";
				query_posts( 'category_name='.$cat.'&posts_per_page=3' ); ?>
			<?php // Show the selected frontpage content.
			if ( have_posts() ) :?>
				 <div class="block-title"><a href="<?php echo get_bloginfo('url'). '/' . $cat;?>">News and Updates</a></div>
				<?php while ( have_posts() ) : the_post();
					get_template_part( 'template-parts/post/content', 'list' );
				endwhile;
			else : // I'm not sure it's possible to have no posts when this page is shown, but WTH.
				get_template_part( 'template-parts/post/content', 'none' );
			endif; ?>
			<?php wp_reset_query();?>
		</div>

		<div class="column medium-4">
			<?php

			$past_events = get_event_post('3','<');
			query_posts($past_events);
			if( have_posts() ): ?>
				<div class="block-title">Past Events</div>
				<?php while( have_posts()) : the_post();
					get_template_part( 'template-parts/post/content', 'event' );
				endwhile; 
			endif; 
			wp_reset_query(); ?>
			
		</div>
		
		<div class="column medium-4">
			<?php

			$future_events = get_event_post('1','>');
			query_posts($future_events);
			$event = [ 'start_date','end_date', 'location'];
			if( have_posts() ): ?>
				<div class="block-title">Upcoming Event</div>
				<?php while( have_posts() ): the_post();
					
					foreach ($event as $v) {
					    $$v = get_field( $v);
					}?>
					<div class="post-list">
						<a href="<?php the_permalink(); ?>" class="post-list__img post-list__img--block"><?php the_post_thumbnail( 'lumbini-featured-image' ); ?></a>
						
							
						<p class="post-list__title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></p>
						<div class="clearfix"></div>
						<span class="dim small bold capitalize"><strong>Starting Date: </strong><?php echo $start_date;?></span>
						<?php if ($end_date):?>
							<span class="dim small bold capitalize"><strong>Till: </strong><?php echo $end_date;?></span>
						<?php endif;?>
						<div class="clearfix"></div>
						<span class="small"><i class="material-icons small">place</i> <?php echo $location['address'];?></span>	
								
					</div>

				<?php endwhile;?>
				
			<?php endif; ?>
			
		</div>

	</div>
</section>

<section>
	<div class="row">
		<?php 
			$media = "media-coverage";
			query_posts( 'category_name='.$media.'&posts_per_page=3' ); ?>
		<div class="block-title column"><?php echo '<a href="'. get_bloginfo('url') .'/'. $media .'">'?>Media Coverage</a></div>
		<?php // Show the selected frontpage content.
		if ( have_posts() ) :?>
			<div class="medium-up-3">
			 
				<?php while ( have_posts() ) : the_post();?>
					<div class="columns"> 
						<?php get_template_part( 'template-parts/post/content', 'list' );?>
					</div>
				<?php endwhile;?>
			</div>
			<div class="column small-12 text-center">
				<a href="<?php echo get_bloginfo('url') .'/'. $media;?>" class="button radius hallow medium"> View all Media Coverage </a>
			</div>
		<?php else : // I'm not sure it's possible to have no posts when this page is shown, but WTH.
			get_template_part( 'template-parts/post/content', 'none' );
		endif; ?>
		<?php wp_reset_query();?>
		
	</div>
</section>


<section>
	<div class="row front-page-videos">
		<?php 
			$videos = "videos";
			query_posts( 'category_name='.$videos.'&posts_per_page=3' ); ?>
		<div class="block-title column"><?php echo '<a href="'. get_bloginfo('url') .'/'. $videos .'">'?>Videos</a></div>
		
		<?php // Show the selected frontpage content.
		if ( have_posts() ) :?>
			
			 
				<?php while ( have_posts() ) : the_post();?>
				
						<?php get_template_part( 'template-parts/post/content', get_post_format() );?>
				
				<?php endwhile;?>
			
			<div class="column small-12 text-center">
				<a href="<?php echo get_bloginfo('url') .'/'. $videos;?>" class="button radius hallow medium"> View all Videos </a>
			</div>
		<?php else : // I'm not sure it's possible to have no posts when this page is shown, but WTH.
			get_template_part( 'template-parts/post/content', 'none' );
		endif; ?>
	
		<?php wp_reset_query();?>
		
	</div>
</section>


<?php $posts = get_posts(array(
			'posts_per_page'	=> '4',
			'post_type'			=> 'testimonial',
		)); 

		
	if( $posts ): ?>

		<section>
			<div class="row"> 
		
				<div class="block-title column text-center">Testimonials</div>
				<div class="clearfix"></div>	
				<div id="testi_slider" class="owl-carousel owl-theme testi-slider">
				<?php $testi = [ 'testimonial','image', 'name', 'designation'];?>
					<?php foreach( $posts  as $post ): setup_postdata( $post );
						

							foreach ($testi as $v) {
							    $$v = get_field( $v);
							}?>
						<div class="item testi-slider__item medium-8 column medium-centered"> 
							<div class="float-left medium-3 text-center">
				                <div class="testi-slider__img-container profile-img"><img src="<?php echo $image;?>" alt="" class="testi-slider__img"></div>
				                <p><small class="bold"><?php echo $name;?></small><br><small><?php echo $designation;?></small></p>
				            </div>

				                <div class="float-left testi-slider__content medium-9">
					                <p class="quote-mark text-center"></p><?php echo $testimonial;?>
					            </div>
					        
		            	</div>
		            <?php endforeach; ?>
		        </div>
			</div>
		</section>

	<?php endif;?>
<?php wp_reset_postdata();?>

<section class="section--blue">
	<div class="row"> 
		<div class="medium-12 column text-center">
		<?php $donate_now_link = get_field('donate_now_link', 'option');
				$donate_now = $donate_now_link ? $donate_now_link : '#';
				$donate_now_text = get_field('donate_now_text', 'option');
				$donate_now_subtext = get_field('donate_now_subtext', 'option');
				?>
				<?php if($donate_now_text):?>
					<h1 class="block-title black-text"><?php echo $donate_now_text;?></h1>
				<?php endif;?>
			<div class="medium-4 medium-centered">
				<a href="<?php echo $donate_now;?>" class="radius button hollow large donate-now__btn"> Donate Now </a>
				<?php if($donate_now_subtext):?>
					<div class="small dim"><?php echo $donate_now_subtext;?></div>
				<?php endif;?>

			</div>
		</div>
	</div>
</section>


<?php get_footer();

