var cssFiles = './app/sass/style.sass';
var cssdeFiles = './app/css/default/**/*.css';
var sassFiles = './app/sass/**/*.sass';
var jsFiles = './app/js/**/*.js';
var jsdeFiles = './app/js/default/**/*.js';
var jsIndex = './app/js/index.html';
var fontFiles = './app/fonts/**/*';
var imgFiles = './app/images/*.+(png|jpg|gif|svg)';

//destination folder
var cssDest = './';
var cssdeDest = './assets/css';
var jsDest = './assets/js';
var imgDest = './assets/images';
var fontDest = './assets/font';
var mapsDest = './';

//Gulp plugin
var gulp = require('gulp');
// Requires the gulp-sass plugin
var sass = require('gulp-sass');
//Other requires
var useref = require('gulp-useref');
var uglify = require('gulp-uglify');
var gulpIf = require('gulp-if');
var cssnano = require('gulp-cssnano');
//Image Plugind
var imagemin = require('gulp-imagemin');
var cache = require('gulp-cache');

// Utility Plugins
var sourcemaps = require('gulp-sourcemaps');
var autoprefixer = require('gulp-autoprefixer');
//helps cleaning
var del = require('del');

gulp.task('sass', function(){
	return gulp.src( cssFiles )
		// Compile SASS
    .pipe(sourcemaps.init())
      .pipe( sass({
        outputStyle : 'expanded'
      })).on('error', sass.logError)
      .pipe(cssnano())
      .pipe(autoprefixer())
    .pipe(sourcemaps.write())
		.pipe(gulp.dest( cssDest ))
});

gulp.task('useref', function(){
  return gulp.src(jsIndex)
    .pipe(useref())
    // Minifies only if it's a JavaScript file
    .pipe(gulpIf(jsFiles, uglify()))
    .pipe(gulp.dest( jsDest ))
});

gulp.task('images', function(){
  return gulp.src(imgFiles)
  .pipe(cache(imagemin({
  	interlaced: true
  })))
  .pipe(gulp.dest( imgDest ))
});

gulp.task('javascripts', function(){
  return gulp.src(jsdeFiles)
  .pipe(gulp.dest( jsDest ))
});

gulp.task('css', function(){
  return gulp.src( cssdeFiles )
  .pipe(gulp.dest( cssdeDest ))
});

gulp.task('fonts', function() {
  return gulp.src( fontFiles )
  .pipe(gulp.dest( fontDest ))
})

gulp.task('clean', function() {
  return del.sync('./assets');
})
gulp.task('default', [ 'sass', 'useref'], function(){
  gulp.watch( sassFiles, ['sass']); 
  // gulp.watch( jsFiles, ['useref']); 
  // Other watchers
})
gulp.task('build', [ 'clean', 'sass', 'useref', 'images', 'fonts', 'javascripts', 'css' ], function(){
  console.log('Building Files');
})
