<?php
/**
 * The header for our theme
 *
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<a class="skip-link show-for-sr" href="#content"><?php _e( 'Skip to content', 'lumbini' ); ?></a>

	<header id="header">

		<?php get_template_part( 'template-parts/header/header', 'image' ); ?>

		<div class="row header__content">
			<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>

			<div class="clearfix"></div>

			<?php if ( has_nav_menu( 'top' ) ) : ?>
				<?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
			<?php endif; ?>
		</div>
		

	</header>


