<?php
/**
 * Prevent switching to Lumbini Themw on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since Twenty Seventeen 1.0
 */
function lumbini_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'lumbini_upgrade_notice' );
}
add_action( 'after_switch_theme', 'lumbini_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * Lumbini Theme on WordPress versions prior to 4.7.
 *
 * @since Twenty Seventeen 1.0
 *
 * @global string $wp_version WordPress version.
 */
function lumbini_upgrade_notice() {
	$message = sprintf( __( 'Lumbini Theme requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'lumbini' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.7.
 *
 * @since Twenty Seventeen 1.0
 *
 * @global string $wp_version WordPress version.
 */
function lumbini_customize() {
	wp_die( sprintf( __( 'Lumbini Theme requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'lumbini' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'lumbini_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.7.
 *
 * @since Twenty Seventeen 1.0
 *
 * @global string $wp_version WordPress version.
 */
function lumbini_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( __( 'Lumbini Theme requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'lumbini' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'lumbini_preview' );
