<?php
/**
 * Custom header implementation
 *
 */

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses lumbini_header_style()
 */
function lumbini_custom_header_setup() {

	/**
	 * Filter Twenty Seventeen custom-header support arguments.
	 *
	 * @since Twenty Seventeen 1.0
	 *
	 * @param array $args {
	 *     An array of custom-header support arguments.
	 *
	 *     @type string $default-image     		Default image of the header.
	 *     @type string $default_text_color     Default color of the header text.
	 *     @type int    $width                  Width in pixels of the custom header image. Default 954.
	 *     @type int    $height                 Height in pixels of the custom header image. Default 1300.
	 *     @type string $wp-head-callback       Callback function used to styles the header image and text
	 *                                          displayed on the blog.
	 *     @type string $flex-height     		Flex support for height of header.
	 * }
	 */
	add_theme_support( 'custom-header', apply_filters( 'lumbini_custom_header_args', array(
		'default-image'      => get_parent_theme_file_uri( '/assets/images/header.jpg' ),
		'width'              => 2000,
		'height'             => 1200,
		'flex-height'        => true,
		'video'              => true,
		'wp-head-callback'   => 'lumbini_header_style',
	) ) );

	register_default_headers( array(
		'default-image' => array(
			'url'           => '%s/assets/images/header.jpg',
			'thumbnail_url' => '%s/assets/images/header.jpg',
			'description'   => __( 'Default Header Image', 'lumbini' ),
		),
	) );
}
add_action( 'after_setup_theme', 'lumbini_custom_header_setup' );

if ( ! function_exists( 'lumbini_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog.
 *
 * @see lumbini_custom_header_setup().
 */
function lumbini_header_style() {
}
endif; // End of lumbini_header_style.

/**
 * Customize video play/pause button in the custom header.
 */
function lumbini_video_controls( $settings ) {
	$settings['l10n']['play'] = '<span class="show-for-sr">' . __( 'Play background video', 'lumbini' ) . '</span>';
	$settings['l10n']['pause'] = '<span class="show-for-sr">' . __( 'Pause background video', 'lumbini' ) . '</span>';
	return $settings;
}
add_filter( 'header_video_settings', 'lumbini_video_controls' );
