<?php
/**
 * Custom template tags for this theme
 *
 */

if ( ! function_exists( 'lumbini_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function lumbini_posted_on() {
	$cat = get_the_category();
	$tag = get_the_tags();
	if (get_field('source')){
		$author= get_field('source');
	}else{
		$author= get_the_author();
	}

	// Get the author name; wrap it in a link.
	$byline = sprintf(
		/* translators: %s: post author */
		__( 'By %s', 'lumbini' ),
		'<span class="author vcard">'.$author.'</span>'
	);

	// Finally, let's write all of this to the page.
	echo '<span class="posted-on">' . lumbini_time_link() . '</span>';
	if($tag){
		echo '<span class="delimiter"> / </span> ';
		foreach($tag as $tag_list){ 
			echo "<a href=". esc_url( get_tag_link( $tag_list->term_id ) )." class='cat-label'>".$tag_list->name."</a>";
		}
	}
	if($cat){
		echo '<span class="delimiter"> / </span> ';
		foreach($cat as $cat_list){ 
			echo "<a href=". esc_url( get_category_link( $cat_list->term_id ) )." class='cat-label'>".$cat_list->name."</a>";
		}
	}
	echo ' <span class="delimiter"> / </span> ' . $byline ;
}
endif;


if ( ! function_exists( 'lumbini_time_link' ) ) :
/**
 * Gets a nicely formatted string for the published date.
 */
function lumbini_time_link() {
	$time_string = '<time class="entry-date published updated small" datetime="%1$s">%2$s</time>';
	// if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
	// 	$time_string = '<time class="entry-date published small" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	// }

	$time_string = sprintf( $time_string,
		get_the_date( DATE_W3C ),
		get_the_date(),
		get_the_modified_date( DATE_W3C ),
		get_the_modified_date()
	);

	// Wrap the time string in a link, and preface it with 'Posted on'.
	return sprintf(
		/* translators: %s: post date */
		__( '<span class="show-for-sr">Posted on</span> %s', 'lumbini' ),
		'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark" class="dim small bold capitalize">' . $time_string . '</a>'
	);
}
endif;


if ( ! function_exists( 'lumbini_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function lumbini_entry_footer() {

	/* translators: used between list items, there is a space after the comma */
	$separate_meta = __( ', ', 'lumbini' );

	// Get Categories for posts.
	$categories_list = get_the_category_list( $separate_meta );

	// Get Tags for posts.
	$tags_list = get_the_tag_list( '', $separate_meta );

	// We don't want to output .entry-footer if it will be empty, so make sure its not.
	if ( ( ( lumbini_categorized_blog() && $categories_list ) || $tags_list ) || get_edit_post_link() ) {

		echo '<footer class="entry-footer">';

			if ( 'post' === get_post_type() ) {
				if ( ( $categories_list && lumbini_categorized_blog() ) || $tags_list ) {
					echo '<span class="cat-tags-links">';

						// Make sure there's more than one category before displaying.
						if ( $categories_list && lumbini_categorized_blog() ) {
							echo '<span class="cat-links">' . lumbini_get_svg( array( 'icon' => 'folder-open' ) ) . '<span class="screen-reader-text">' . __( 'Categories', 'lumbini' ) . '</span>' . $categories_list . '</span>';
						}

						if ( $tags_list ) {
							echo '<span class="tags-links">' . lumbini_get_svg( array( 'icon' => 'hashtag' ) ) . '<span class="screen-reader-text">' . __( 'Tags', 'lumbini' ) . '</span>' . $tags_list . '</span>';
						}

					echo '</span>';
				}
			}

			lumbini_edit_link();

		echo '</footer> <!-- .entry-footer -->';
	}
}
endif;


if ( ! function_exists( 'lumbini_edit_link' ) ) :
/**
 * Returns an accessibility-friendly link to edit a post or page.
 *
 * This also gives us a little context about what exactly we're editing
 * (post or page?) so that users understand a bit more where they are in terms
 * of the template hierarchy and their content. Helpful when/if the single-page
 * layout with multiple posts/pages shown gets confusing.
 */
function lumbini_edit_link() {

	$link = edit_post_link(
		sprintf(
			/* translators: %s: Name of current post */
			__( 'Edit<span class="screen-reader-text"> "%s"</span>', 'lumbini' ),
			get_the_title()
		),
		'<span class="edit-link">',
		'</span>'
	);

	return $link;
}
endif;

/**
 * Display a front page section.
 *
 * @param $partial WP_Customize_Partial Partial associated with a selective refresh request.
 * @param $id integer Front page section to display.
 */
function lumbini_front_page_section( $partial = null, $id = 0 ) {
	if ( is_a( $partial, 'WP_Customize_Partial' ) ) {
		// Find out the id and set it up during a selective refresh.
		global $lumbinicounter;
		$id = str_replace( 'panel_', '', $partial->id );
		$lumbinicounter = $id;
	}

	global $post; // Modify the global post object before setting up post data.
	if ( get_theme_mod( 'panel_' . $id ) ) {
		global $post;
		$post = get_post( get_theme_mod( 'panel_' . $id ) );
		setup_postdata( $post );
		set_query_var( 'panel', $id );

		get_template_part( 'template-parts/page/content', 'front-page-panels' );

		wp_reset_postdata();
	} elseif ( is_customize_preview() ) {
		// The output placeholder anchor.
		echo '<article class="panel-placeholder panel lumbini-panel lumbini-panel' . $id . '" id="panel' . $id . '"><span class="lumbini-panel-title">' . sprintf( __( 'Front Page Section %1$s Placeholder', 'lumbini' ), $id ) . '</span></article>';
	}
}

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function lumbini_categorized_blog() {
	$category_count = get_transient( 'lumbini_categories' );

	if ( false === $category_count ) {
		// Create an array of all the categories that are attached to posts.
		$categories = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$category_count = count( $categories );

		set_transient( 'lumbini_categories', $category_count );
	}

	return $category_count > 1;
}


/**
 * Flush out the transients used in lumbini_categorized_blog.
 */
function lumbini_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'lumbini_categories' );
}
add_action( 'edit_category', 'lumbini_category_transient_flusher' );
add_action( 'save_post',     'lumbini_category_transient_flusher' );
