<?php
/**
 * Template Name: Events
 *
 */

get_header(); ?>

<section>
	<div class="row">
		<div class="medium-12 column">

			<div class="page-title capitalize bold text-center"><?php the_title( '<h1 class="bold">', '</h1>' ); ?></div>

			<?php $future_events = get_event_post('','>');
			query_posts($future_events);
			$event = [ 'start_date','end_date', 'location'];
			if( have_posts() ): ?>
				<h2 class="block-title h2-title text-center">Upcoming Event</h2>
				<div class="row medium-up-3">
					<?php while( have_posts() ): the_post();

						foreach ($event as $v) {
							$$v = get_field( $v);
						}?>
						<div class="column post-block">
							<a href="<?php the_permalink(); ?>" class="post-list__img post-list__img--block"><?php the_post_thumbnail( 'lumbini-featured-image' ); ?></a>


							<h3 class="post-block__title no-margin"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
							<div class="clearfix"></div>
							<span class="dim small bold capitalize"><strong>Starting Date: </strong><?php echo $start_date;?></span>
							<?php if ($end_date):?>
								<span class="dim small bold capitalize"><strong>Till: </strong><?php echo $end_date;?></span>
							<?php endif;?>
							<div class="clearfix"></div>
							<?php if($location):?><span class="small"><i class="material-icons small">place</i> <?php echo $location['address'];?></span>	<?php endif;?>

						</div>
					<?php endwhile; ?>
					<div class="column text-center"><?php echo wp_pagenavi();?></div>
				</div>
				<?php  
			endif; 
			wp_reset_query();?>


			<?php $past_events = get_event_post('','<');
			query_posts($past_events);
			if( have_posts() ): ?>

				<h2 class="block-title h2-title text-center">Past Events</h2>

				<div class="row medium-up-3">
					<?php while( have_posts() ): the_post();
						$event = [ 'start_date','end_date', 'location'];
						foreach ($event as $v) {
							$$v = get_field( $v);
						}?>
						<div class="column post-block">
							<a href="<?php the_permalink(); ?>" class="post-list__img post-list__img--block"><?php the_post_thumbnail( 'lumbini-featured-image' ); ?></a>


							<h3 class="post-block__title no-margin"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
							<span class="dim small bold capitalize"><?php echo $start_date;?> <?php if ($end_date) { echo " - ".$end_date; }?></span>	

						</div>
					<?php endwhile; ?>


				</div>
				<div class="text-center medium-12 column"><?php echo wp_pagenavi();?></div>
					<?php 

			endif;   wp_reset_query();?>
			
	
		</div>
	</div>
</section>

<?php get_footer();
