<?php
/**
 * Template for displaying search forms in Twenty Seventeen
 *
 */
?>

<?php $unique_id = esc_attr( uniqid( 'search-form-' ) ); ?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label for="<?php echo $unique_id; ?>">
		<span class="show-for-sr"><?php echo _x( 'Search for:', 'label', 'lumbini' ); ?></span>
	</label>
	<input type="search" id="<?php echo $unique_id; ?>" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'lumbini' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	<button type="submit" class="search-submit"><span class="show-for-sr"><?php echo _x( 'Search', 'submit button', 'lumbini' ); ?></span></button>
</form>
