<?php
/**
 * The sidebar containing the main widget area
 *
 */

if ( ! is_active_sidebar( 'sidebar-1' ) ) {
	return;
}
?>

	

<div class="block-title hide-for-small-only">Most Recent Updates</div>
<div class="sep"></div>
<div class="hide-for-small-only">
	<?php query_posts('posts_per_page=5');?>
	
	<?php
	if ( have_posts() ) :
		/* Start the Loop */
		while ( have_posts() ) : the_post();
			$cat = get_the_category();
			$block = has_post_thumbnail()?'small-8':'small-12 post-list--no-thumb';?>
			<div class="post-list">
				<div class="row">
					<?php if(has_post_thumbnail()):?>
						<div class="column small-4">
							<a href="<?php the_permalink(); ?>" class="post-list__img"><?php the_post_thumbnail( 'lumbini-featured-image' ); ?></a>
						</div>
					<?php endif;?>

					<div class="column <?php echo $block;?>">
						<div class="post-list__content">
							
							<p class="post-list__title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></p>
							<?php echo lumbini_time_link();?><br>
							<?php foreach($cat as $cat_list):?>
					        	<small><a href="<?php echo esc_url( get_category_link( $cat_list->term_id ) )?>" class="underline"><?php echo $cat_list->name;?></a> </small> 
					        <?php endforeach;?>
						</div>
					</div>
				</div>
			</div>	
		    
 		<?php endwhile;?>

	<?php endif;?>

</div>



