<?php
/**
 * Displays header site branding
 *
 */

?>
	<div class="column small-12">
		<?php $subtitle = get_theme_mod( 'bolgsubtitle' );?>
		<small class="site-slogan white-text">
		<?php echo $subtitle;?></small>
	</div>
	<div class="column small-12 flex-container">
		<div class="site-logo">
		    <span data-responsive-toggle="responsive-menu" data-hide-for="medium">
		      <button class="menu-icon dark" type="button" data-toggle></button>
		    </span>
			<?php the_custom_logo(); ?>
		</div>
		<div class="site-info">
			<?php if ( is_front_page() ) : ?>
				<h1 class="site-title white-text"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<?php else : ?>
				<p class="site-title white-text"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
			<?php endif; ?>

			<?php 
				$description = get_bloginfo( 'description', 'display' );
				if ( $description || is_customize_preview() ) : ?>
					<p class="site-desc white-text capitalize"><?php echo $description; ?></p>
				<?php endif; ?>
				<small class="white-text">Non-Profit Organization</small>
		</div>
	</div>