<?php
/**
 * Template part for displaying page content in page.php
 *
 */

?>


<div class="text-center">

	<div class="page-title capitalize bold"><?php the_title( '<h1 class="bold">', '</h1>' ); ?></div>
	<div class="row">

		<?php $member = [ 'name','designation', 'image', 'member_type'];?>

		<?php if( have_rows('executive_board') ): ?>
			<h2 class="h2-title">Executive Board</h2>

			<?php while( have_rows('executive_board') ): the_row();
			foreach ($member as $v) {
				$$v = get_sub_field( $v );
			}
			?>

			<div class="column medium-4 end">
				<?php if ($image):?><div class="profile-img"><img src="<?php echo $image;?>" alt=""></div><?php endif;?>
				<h3><span class="bold"><?php echo $name;?></span><br><small class="capitalize dim"><?php echo $designation;?></small></h3>
			</div>
		<?php endwhile;?>

	<?php endif; ?>

	<div class="clearfix"></div>
	<?php if( have_rows('member') ): ?>
		<h2 class="h2-title">Members</h2>

		<?php while( have_rows('member') ): the_row();
		foreach ($member as $v) {
			$$v = get_sub_field( $v );
		}
		?>

		<div class="column medium-3 end">
			<?php if ($image):?><div class="profile-img"><img src="<?php echo $image;?>" alt=""></div><?php endif;?>
			<h3><?php echo $name;?><?php if($designation):?><br><small class="capitalize"><?php echo $designation;?></small><?php endif;?></p>
		</div>
	<?php endwhile;?>

<?php endif; ?>

<div class="clearfix"></div>

<?php if( have_rows('advisory_board') ): ?>
	<h2 class="h2-title">Advisory Board</h2>

	<?php while( have_rows('advisory_board') ): the_row();
	foreach ($member as $v) {
		$$v = get_sub_field( $v );
	}
	?>

	<div class="column medium-3 end">
		<?php if ($image):?><div class="profile-img"><img src="<?php echo $image;?>" alt=""></div><?php endif;?>
		<h3><?php echo $name;?></h3><?php if($designation):?><br><small class="capitalize"><?php echo $designation;?></small><?php endif;?></p>
	</div>
<?php endwhile;?>

<?php endif; ?>

<div class="clearfix"></div>

<?php if( have_rows('secretariat') ): ?>
	<h2 class="h2-title">Secretariat</h2>

	<?php while( have_rows('secretariat') ): the_row();
	foreach ($member as $v) {
		$$v = get_sub_field( $v );
	}
	?>

	<div class="column medium-3 end">
		<?php if ($image):?><div class="profile-img"><img src="<?php echo $image;?>" alt=""></div><?php endif;?>
		<h3><?php echo $name;?></h3><?php if($designation):?><br><small class="capitalize"><?php echo $designation;?></small><?php endif;?></p>
	</div>
<?php endwhile;?>

<?php endif; ?>

</div>


</div>
