<?php
/**
 * Template part for displaying audio posts
 *
 */

?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php
			if ( 'post' === get_post_type() ) :
				echo '<div>';
					if ( is_single() ) :
						lumbini_posted_on();
					else :
						echo lumbini_time_link();
					endif;
				echo '</div>';
			endif;

			if ( is_single() ) {
				the_title( '<h1>', '</h1>' );
			} else {
				the_title( '<h2><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			}
		?>


	<?php
		$content = apply_filters( 'the_content', get_the_content() );
		$audio = false;

		// Only get audio from the content if a playlist isn't present.
		if ( false === strpos( $content, 'wp-playlist-script' ) ) {
			$audio = get_media_embedded_in_content( $content, array( 'audio' ) );
		}

	?>

	<?php if ( '' !== get_the_post_thumbnail() && ! is_single() ) : ?>
		
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( 'lumbini-featured-image' ); ?>
			</a>
	<?php endif; ?>



		<?php if ( ! is_single() ) :

			// If not a single post, highlight the audio file.
			if ( ! empty( $audio ) ) :
				foreach ( $audio as $audio_html ) {
					echo '<div>';
						echo $audio_html;
					echo '</div>';
				}
			endif;

		endif;

		if ( is_single() || empty( $audio ) ) :

			/* translators: %s: Name of current post */
			the_content( sprintf(
				__( 'Continue reading<span class="show-for-sr"> "%s"</span>', 'lumbini' ),
				get_the_title()
			) );

		endif; ?>

</div><!-- #post-## -->
