<?php
/**
 * Template part for displaying image posts
 *
 */
?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

		<?php
			if ( 'post' === get_post_type() ) :
				echo '<div>';
					if ( is_single() ) :
						lumbini_posted_on();
					else :
						echo lumbini_time_link();
					endif;
				echo '</div>';
			endif;

			if ( is_single() ) {
				the_title( '<h1>', '</h1>' );
			} else {
				the_title( '<h2><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			}
		?>

	<?php if ( '' !== get_the_post_thumbnail() && ! is_single() ) : ?>
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( 'lumbini-featured-image' ); ?>
			</a>
	<?php endif; ?>


		<?php if ( is_single() || '' === get_the_post_thumbnail() ) :

			// Only show content if is a single post, or if there's no featured image.
			/* translators: %s: Name of current post */
			the_content( sprintf(
				__( 'Continue reading<span class="show-for-sr"> "%s"</span>', 'lumbini' ),
				get_the_title()
			) );


		endif; ?>

	<?php if ( is_single() ) : ?>
		<?php lumbini_entry_footer(); ?>
	<?php endif; ?>

</div><!-- #post-## -->
