<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 */

?>

<div class="column">

		<h1><?php _e( 'No posts yet', 'lumbini' ); ?></h1>

		<?php
		if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'lumbini' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php else : ?>

			<p><?php _e( 'We will post soon. Please visit for new content', 'lumbini' ); ?></p>
			<?php
				

		endif; ?>

</div>
