<?php
/**
 * Template part for displaying video posts
 *
 */
?>


	<?php
		$content = apply_filters( 'the_content', get_the_content() );
		$video = false;

		// Only get video from the content if a playlist isn't present.
		if ( false === strpos( $content, 'wp-playlist-script' ) ) {
			$video = get_media_embedded_in_content( $content, array( 'video', 'object', 'embed', 'iframe' ) );
		}
	?>
<?php 
	if ( is_single() ) :?>
		<?php 
			the_title( '<h1>', '</h1>' );
				/* translators: %s: Name of current post */
			the_post_thumbnail( 'lumbini-featured-image' ); 
			the_content( sprintf(
				__( 'Continue reading<span class="show-for-sr"> "%s"</span>', 'lumbini' ),
				get_the_title()
			) );
		?>
	<?php else :?>
		<div class="post-block end medium-4 column">
			<a href="<?php the_permalink(); ?>" class="post-list__img post-list__img--block"><?php the_post_thumbnail( 'lumbini-featured-image' ); ?></a>
			<?php 
			// if ( ! empty( $video ) ) :
			// 	foreach ( $video as $video_html ) {
			// 		echo '<div>';
			// 			echo $video_html;
			// 		echo '</div>';
			// 	}
			// endif;
				?>
			<p class="post-list__title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></p>
			<div class="clearfix"></div>
			<?php echo lumbini_time_link();?>			
		</div>
	<?php endif;?>